/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.util.parser;

import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Expression;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ExpressionBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.parser.GrammarBuildContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.NamePropertiesBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.parser.NamedExpression;
import oracle.dbtools.raptor.newscriptrunner.util.parser.NamedExpressionVisitor;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Node;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Syntax;
import oracle.dbtools.raptor.newscriptrunner.util.tokenizer.Token;

public class LiteralBuilder
extends ExpressionBuilder {
    private final NamePropertiesBuilder namePropertiesBuilder = new NamePropertiesBuilder();
    private int tokens = -1;

    public LiteralBuilder tokens(int tokens) {
        this.tokens = tokens;
        return this;
    }

    public LiteralBuilder helpId(String helpId) {
        this.namePropertiesBuilder.setHelpId(helpId);
        return this;
    }

    public LiteralBuilder helpId() {
        this.namePropertiesBuilder.setHelpId(null);
        return this;
    }

    protected LiteralBuilder(String name) {
        this.namePropertiesBuilder.setName(Objects.requireNonNull(name));
    }

    @Override
    protected Expression build(GrammarBuildContext context) {
        return context.compose(new Literal(context, this, this.namePropertiesBuilder.build(false)));
    }

    private static class Literal
    implements NamedExpression {
        private final String name;
        private final Optional<String> helpId;
        private final int tokens;

        Literal(GrammarBuildContext context, LiteralBuilder builder, NamePropertiesBuilder.NameProperties nameProperties) {
            this.name = nameProperties.getName();
            this.helpId = nameProperties.getHelpId();
            this.tokens = builder.tokens;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Optional<String> getHelpId() {
            return this.helpId;
        }

        @Override
        public Set<String> getSynonyms() {
            return Collections.singleton(this.name);
        }

        @Override
        public Syntax getSyntax() {
            StringBuilder buff = new StringBuilder();
            buff.append('<');
            buff.append(this.name.toLowerCase());
            buff.append('>');
            return new Syntax(buff.toString(), false);
        }

        @Override
        public void visitNamedExpressions(NamedExpressionVisitor visitor) {
            if (this.helpId.isPresent()) {
                visitor.accept(this);
            }
        }

        @Override
        public void parse(Node node) {
            Token firstToken = node.next();
            if (firstToken == null) {
                node.setValue("");
            } else {
                String value = null;
                Token currentToken = firstToken;
                int tokensTaken = 1;
                while (value == null) {
                    if (tokensTaken == this.tokens) {
                        value = firstToken.getLine().substring(firstToken.getStart(), currentToken.getEnd());
                        continue;
                    }
                    Token nextToken = node.next();
                    if (nextToken == null) {
                        value = firstToken.getLine().substring(firstToken.getStart(), currentToken.getEnd());
                        continue;
                    }
                    currentToken = nextToken;
                    ++tokensTaken;
                }
                node.setValue(value);
            }
            node.setMatched();
        }

        public String toString() {
            return "LITERAL";
        }
    }
}

