/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.parameterparser.Help;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.Help.HelpMessages;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.parameter.StandardParameter;

public abstract class AbstractCommandConstants {
    public boolean escapeBackSlashes() {
        return true;
    }

    public abstract String getBackupHelpPropertiesFilename();

    public abstract String getBaseCommandName();

    public abstract String getBaseCommandShortName();

    public abstract Map<String, String> getCommandAliases();

    public abstract Map<String, Map<String, StandardParameter>> getCommandModel();

    public String getConstantName(String value) {
        return value.toUpperCase().replaceAll("-", "_");
    }

    public String getConstantValue(String ConstantName) throws IllegalArgumentException, IllegalAccessException, SecurityException {
        try {
            return this.getClass().getDeclaredField(this.getConstantName(ConstantName)).get(null).toString();
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
            throw e;
        }
        catch (NoSuchFieldException e) {
            return "!" + ConstantName + "!";
        }
    }

    public Function<String, String> getHelpMap() {
        return new HelpMessages(this.getHelpPropertiesFilename(), this.getBackupHelpPropertiesFilename(), this.getClass().getClassLoader());
    }

    public abstract String getHelpPropertiesFilename();

    public abstract Map<String, String> getParameterAliases();

    public abstract String getParameterSetName();

    public String getShortCommand(String command) {
        return this.getCommandAliases().entrySet().stream().filter(x -> ((String)x.getValue()).equals(command)).map(Map.Entry::getKey).collect(Collectors.joining(", "));
    }

    public String getShortParam(String command) {
        return this.getParameterAliases().entrySet().stream().filter(x -> ((String)x.getValue()).equals(command)).map(Map.Entry::getKey).collect(Collectors.joining(", "));
    }

    public boolean loadBaseCommand() {
        return true;
    }

    public boolean showDefaultInHelp() {
        return true;
    }

    public boolean hasHelpSubCommand() {
        return true;
    }
}

