/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.IStoreCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.StoreRegistry;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;

@Restricted(level=Restricted.Level.R4)
public class ShowTrimspool
implements IShowCommand,
IStoreCommand {
    private static final String[] SHOWTRIMSPOOL = new String[]{"trims", "trimsp", "trimspo", "trimspoo", "trimspool"};

    @Override
    public String[] getShowAliases() {
        return SHOWTRIMSPOOL;
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        return this.doShowTrimspool(conn, ctx, cmd);
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }

    private boolean doShowTrimspool(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        Boolean setting = (Boolean)ctx.getProperty("script.runner.settrimspool");
        if (setting != null && setting.equals(Boolean.TRUE)) {
            ctx.write("trimspool ON\n");
        } else {
            ctx.write("trimspool OFF\n");
        }
        return true;
    }

    @Override
    public String getStoreCommand(ScriptRunnerContext ctx) {
        Boolean setting = (Boolean)ctx.getProperty("script.runner.settrimspool");
        if (setting != null && setting.equals(Boolean.TRUE)) {
            return StoreRegistry.getCommand("trimspool", "ON");
        }
        return StoreRegistry.getCommand("trimspool", "OFF");
    }
}

