/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.IStoreCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.StoreRegistry;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;

@Restricted(level=Restricted.Level.NONE)
public class ShowTimingout
implements IShowCommand,
IStoreCommand {
    private static final String[] SHOWTIMINGOUT = new String[]{"timi", "timin", "timing"};

    @Override
    public String[] getShowAliases() {
        return SHOWTIMINGOUT;
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        return this.doShowTimingout(conn, ctx, cmd);
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }

    private boolean doShowTimingout(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        Boolean isTimingOn = (Boolean)ctx.getProperty("script.runner.context.timing");
        if (isTimingOn != null && isTimingOn.equals(Boolean.TRUE)) {
            ctx.write("timing ON\n");
        } else {
            ctx.write("timing OFF\n");
        }
        return true;
    }

    @Override
    public String getStoreCommand(ScriptRunnerContext ctx) {
        Boolean isTimingOn = (Boolean)ctx.getProperty("script.runner.context.timing");
        if (isTimingOn != null && isTimingOn.equals(Boolean.TRUE)) {
            return StoreRegistry.getCommand("timing", "ON");
        }
        return StoreRegistry.getCommand("timing", "OFF");
    }
}

