/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.db.ResultSetFormatter;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;
import oracle.jdbc.OracleConnection;

@Restricted(level=Restricted.Level.NONE)
public class ShowEdition
implements IShowCommand {
    private static final String[] SHOWEDITION = new String[]{"edition"};

    @Override
    public String[] getShowAliases() {
        return SHOWEDITION;
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx.getCurrentConnection() == null || ctx.getCurrentConnection() instanceof OracleConnection) {
            return this.doShowEdition(conn, ctx, cmd);
        }
        if (ctx.getCurrentConnection() != null && ctx.getCurrentConnection().getClass().getName().equals("oracle.nucleo.jdbc.impl.NucleoConnectionImpl")) {
            ctx.write("Not supported for nucleo connection\n");
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean doShowEdition(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        block11: {
            ResultSet rset = null;
            if (conn != null && LockManager.lock(conn)) {
                block10: {
                    try {
                        String sql = "SELECT sys_context('USERENV', 'CURRENT_EDITION_NAME') edition FROM dual";
                        ArrayList localBind = new ArrayList();
                        rset = DBUtil.getInstance(ctx.getCurrentConnection()).executeQuery(sql, localBind);
                        if (rset != null) {
                            ResultSetFormatter rFormat = new ResultSetFormatter(ctx);
                            rFormat.setProgressUpdater(ctx.getTaskProgressUpdater());
                            rFormat.rset2sqlplusShrinkToSize(rset, ctx.getCurrentConnection(), ctx.getOutputStream());
                        }
                        if (rset == null) break block10;
                    }
                    catch (IOException e) {
                        ctx.write(e.getLocalizedMessage());
                        break block11;
                    }
                    catch (SQLException e2) {
                        block12: {
                            ctx.putProperty("sqldev.last.err.message.forsqlcode", e2.getMessage());
                            ctx.write(e2.getLocalizedMessage());
                            if (rset == null) break block12;
                            {
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                            }
                            DBUtil.closeResultSet(rset);
                        }
                        LockManager.unlock(conn);
                        break block11;
                    }
                    finally {
                        if (rset != null) {
                            DBUtil.closeResultSet(rset);
                        }
                        LockManager.unlock(conn);
                    }
                    DBUtil.closeResultSet(rset);
                }
                LockManager.unlock(conn);
            }
        }
        return true;
    }

    @Override
    public boolean needsDatabase() {
        return true;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }
}

