/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import java.text.MessageFormat;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.IStoreCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.Show;
import oracle.dbtools.raptor.newscriptrunner.commands.StoreRegistry;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;

@Restricted(level=Restricted.Level.R4)
public class ShowColsep
implements IShowCommand,
IStoreCommand {
    private static final String[] SHOWCOLSEP = new String[]{"colsep"};

    @Override
    public String[] getShowAliases() {
        return SHOWCOLSEP;
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        return this.doShowColsep(conn, ctx, cmd);
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }

    private boolean doShowColsep(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String colsp = (String)ctx.getProperty("script.runner.setcolsep");
        String str = MessageFormat.format(Messages.getString("COLSEP"), colsp) + Show.m_lineSeparator;
        ctx.write(str);
        return true;
    }

    @Override
    public String getStoreCommand(ScriptRunnerContext ctx) {
        String colsp = (String)ctx.getProperty("script.runner.setcolsep");
        return StoreRegistry.getCommand("colsep", MessageFormat.format("\"{0}\"", String.valueOf(colsp)));
    }
}

