/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.IStoreCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;

@Restricted(level=Restricted.Level.R4)
public class ShowAutoprint
implements IShowCommand,
IStoreCommand {
    private static final String[] SHOWAUTOPRINT = new String[]{"autop", "autopr", "autopri", "autoprin", "autoprint"};

    @Override
    public String[] getShowAliases() {
        return SHOWAUTOPRINT;
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        return this.doShowAutoprint(conn, ctx, cmd);
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }

    private String getStatement(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        Boolean isAutoPrintOn = (Boolean)ctx.getProperty("script.runner.context.autoprint");
        if (isAutoPrintOn != null && isAutoPrintOn.equals(Boolean.TRUE)) {
            return "autoprint ON\n";
        }
        return "autoprint OFF\n";
    }

    private boolean doShowAutoprint(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        ctx.write(this.getStatement(conn, ctx, cmd));
        return true;
    }

    @Override
    public String getStoreCommand(ScriptRunnerContext ctx) {
        return "set " + this.getStatement(null, ctx, null);
    }
}

