/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.connect.save;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import oracle.dbtools.app.CompletionItem;
import oracle.dbtools.core.connections.folder.Folder;
import oracle.dbtools.core.connections.folder.FolderSerializationException;
import oracle.dbtools.core.connections.folder.utils.FolderUtils;
import oracle.dbtools.core.connections.folder.utils.PathsUtils;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.save.ConnectionsFolderManager;
import oracle.dbtools.raptor.newscriptrunner.util.completer.SemanticCompleter;
import oracle.dbtools.util.Logger;

public class ConnectionFolderCompleter
implements SemanticCompleter {
    @Override
    public List<CompletionItem> complete(String prefix, ScriptRunnerContext ctx, Map<String, Object> transformedOptionsMap) {
        ArrayList<CompletionItem> paths = new ArrayList<CompletionItem>();
        try {
            ConnectionsFolderManager connectionsFolderManager = new ConnectionsFolderManager();
            Folder rootFolder = connectionsFolderManager.getRootFolder();
            Optional parent = FolderUtils.findFolder((Folder)rootFolder, (String)prefix);
            if (parent.isPresent()) {
                Map subFolders = ((Folder)parent.get()).getSubFolders();
                if (PathsUtils.isRoot((String)prefix)) {
                    paths.add(new CompletionItem("/", CompletionItem.Type.KEYWORD));
                }
                if (!((String)prefix).endsWith("/")) {
                    prefix = (String)prefix + "/";
                }
                for (String folderName : subFolders.keySet()) {
                    paths.add(new CompletionItem(String.format("%s%s%s", prefix, folderName, "/"), CompletionItem.Type.KEYWORD));
                }
            }
        }
        catch (FolderSerializationException e) {
            Logger.warn(this.getClass(), "Unable to get connection folder's list of completion");
        }
        return paths;
    }
}

