/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.connect;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectOptionType;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectPluginType;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectorType;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectorTypeCache;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.HelpContainerRef;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.NamedObject;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.Property;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ReservedNames;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpBundleBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpContainer;

public final class ConnectorTypeCacheProvider
implements ConnectorTypeCache {
    private final Map<String, ConnectorType> connectorTypeMap;
    private final Map<String, ConnectPluginType> connectAddinTypeMap;
    private final Map<String, Property<?>> propertyMap;
    private final Set<String> flagPropertyNames;
    private final Set<String> valuePropertyNames;
    private final List<HelpContainer> helpContainers;

    public static ConnectorTypeCacheProvider of(Collection<ConnectorType> connectorTypes, Collection<ConnectPluginType> connectPluginTypes) throws IllegalStateException {
        Builder builder = new Builder();
        connectorTypes.forEach(builder::connectorType);
        connectPluginTypes.forEach(builder::connectAddinType);
        return builder.build();
    }

    private ConnectorTypeCacheProvider(Builder builder) {
        this.connectorTypeMap = new TreeMap<String, ConnectorType>(builder.connectorTypeMap);
        this.connectAddinTypeMap = new TreeMap<String, ConnectPluginType>(builder.connectAddinTypeMap);
        this.propertyMap = new TreeMap(builder.propertyMap);
        this.flagPropertyNames = new TreeSet<String>(builder.flagPropertyNames);
        this.valuePropertyNames = new TreeSet<String>(builder.valuePropertyNames);
        for (ConnectorType connectorType : this.connectorTypeMap.values()) {
            for (ConnectPluginType addinType : this.connectAddinTypeMap.values()) {
                if (!connectorType.supportsConnectPlugin(addinType)) continue;
                connectorType.registerConnectPlugin(addinType);
            }
        }
        this.helpContainers = new ArrayList<HelpContainer>();
        builder.helpContainerRefSet.forEach(p -> this.helpContainers.add(p.get()));
    }

    @Override
    public Set<String> getConnectorTypeNames() {
        return this.connectorTypeMap.keySet();
    }

    @Override
    public ConnectorType getConnectorType(String name) {
        return name != null ? this.connectorTypeMap.get(name) : null;
    }

    @Override
    public Collection<ConnectorType> getConnectorTypes() {
        return this.connectorTypeMap.values();
    }

    @Override
    public Set<String> getConnectAddinTypeNames() {
        return this.connectAddinTypeMap.keySet();
    }

    @Override
    public ConnectPluginType getConnectAddinType(String name) {
        return name != null ? this.connectAddinTypeMap.get(name) : null;
    }

    @Override
    public Collection<ConnectPluginType> getConnectAddinTypes() {
        return this.connectAddinTypeMap.values();
    }

    @Override
    public Set<String> getPropertyNames() {
        return this.propertyMap.keySet();
    }

    @Override
    public <T> Property<T> getProperty(String name) {
        return name != null ? this.propertyMap.get(name) : null;
    }

    @Override
    public Collection<Property<?>> getProperties() {
        return this.propertyMap.values();
    }

    @Override
    public Collection<HelpContainer> getHelpContainers() {
        return this.helpContainers;
    }

    @Override
    public boolean isFlagProperty(String propertyName) {
        return this.flagPropertyNames.contains(propertyName);
    }

    @Override
    public boolean isValueProperty(String propertyName) {
        return this.valuePropertyNames.contains(propertyName);
    }

    private static void verifyPropertyName(StringBuilder errorBuff, Set<String> reservedNames, Map<String, Property> propertyNames, Property<?> property) {
        ConnectorTypeCacheProvider.verifyName(errorBuff, reservedNames, propertyNames, property, property.getName());
        if (property.getShortName() != null) {
            ConnectorTypeCacheProvider.verifyName(errorBuff, reservedNames, propertyNames, property, property.getShortName());
        }
    }

    private static void verifyName(StringBuilder errorBuff, Set<String> reservedNames, Map<String, Property> propertyNames, Property<?> property, String name) {
        ConnectorTypeCacheProvider.verifyName(errorBuff, reservedNames, name);
        if (propertyNames.containsKey(name)) {
            errorBuff.append("\tname duplication for ").append(name).append(" (sources ").append(ConnectorTypeCacheProvider.propertyId(property)).append(" and ").append(ConnectorTypeCacheProvider.propertyId(propertyNames.get(name))).append(")\n");
        } else {
            propertyNames.put(name, property);
        }
    }

    private static void verifyName(StringBuilder errorBuff, Set<String> reservedNames, String name) {
        if (!name.matches("\\w+")) {
            errorBuff.append("\tconnector, property and option names may only contain word characters (A-Z, a-z, 0-9 or _): ").append(name).append('\n');
        } else if (reservedNames.contains(name)) {
            errorBuff.append("\tproperty may not be named using reserved symbol '").append(name).append("'").append('\n');
        }
    }

    private static void verifyHelpKey(StringBuilder errorBuff, Set<String> helpKeys, NamedObject namedObject) {
        String helpId = namedObject.getHelpId();
        if (!helpKeys.add(helpId)) {
            errorBuff.append("\tduplicate help ID '").append(helpId).append("' for object '").append(namedObject.getName()).append("'\n");
        }
    }

    private static String propertyId(Property property) {
        Class<?> cls = property.getClass();
        Class<?> outer = null;
        while (outer == null) {
            Class<?> enclosing = cls.getEnclosingClass();
            if (enclosing == null) {
                outer = cls;
                continue;
            }
            cls = enclosing;
        }
        if (ConnectorType.class.isAssignableFrom(outer)) {
            return "connector::" + property.getName();
        }
        return "property::" + property.getName();
    }

    public static class Builder {
        private final SortedMap<String, ConnectorType> connectorTypeMap = new TreeMap<String, ConnectorType>(String.CASE_INSENSITIVE_ORDER);
        private final SortedMap<String, ConnectPluginType> connectAddinTypeMap = new TreeMap<String, ConnectPluginType>(String.CASE_INSENSITIVE_ORDER);
        private final SortedMap<String, Property<?>> propertyMap = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        private final SortedSet<String> flagPropertyNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        private final SortedSet<String> valuePropertyNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        private final Set<String> reservedNames = new TreeSet<String>(ReservedNames.get());
        StringBuilder errorBuff = new StringBuilder();
        Map<String, Property> propertyNames = new HashMap<String, Property>();
        Set<Property> properties = new HashSet<Property>();
        Set<String> helpKeys = new HashSet<String>();
        Set<HelpContainerRef> helpContainerRefSet = new HashSet<HelpContainerRef>();

        private Builder() {
            this.helpContainerRefSet.add(HelpContainerRef.create(new HelpBundleBuilder(ConnectorTypeCacheProvider.class.getPackageName() + ".Help").build()));
        }

        public Builder connectorType(ConnectorType type) {
            this.addConnectOptionType(this.connectorTypeMap, type);
            return this;
        }

        public Builder connectAddinType(ConnectPluginType type) {
            this.addConnectOptionType(this.connectAddinTypeMap, type);
            return this;
        }

        private <T extends ConnectOptionType> void addConnectOptionType(Map<String, T> map, T type) {
            HelpContainerRef connectorHelpContainerRef;
            String connectorTypeName = type.getName();
            ConnectorTypeCacheProvider.verifyName(this.errorBuff, this.reservedNames, connectorTypeName);
            ConnectorTypeCacheProvider.verifyHelpKey(this.errorBuff, this.helpKeys, type);
            if (map.containsKey(connectorTypeName)) {
                this.errorBuff.append("\tconnector type must have unique name ").append(connectorTypeName).append('\n');
            }
            if ((connectorHelpContainerRef = type.getHelpContainer()) != null) {
                this.helpContainerRefSet.add(connectorHelpContainerRef);
            }
            map.put(type.getName(), type);
            for (Property<?> property : type.getProperties()) {
                if (!this.properties.add(property)) continue;
                ConnectorTypeCacheProvider.verifyPropertyName(this.errorBuff, this.reservedNames, this.propertyNames, property);
                ConnectorTypeCacheProvider.verifyHelpKey(this.errorBuff, this.helpKeys, property);
                HelpContainerRef propertyHelpContainerRef = property.getHelpContainer();
                if (propertyHelpContainerRef != null) {
                    this.helpContainerRefSet.add(propertyHelpContainerRef);
                }
                this.propertyMap.put(property.getName(), property);
                if (property.isFlag()) {
                    this.flagPropertyNames.add(property.getName());
                    continue;
                }
                this.valuePropertyNames.add(property.getName());
            }
        }

        public ConnectorTypeCacheProvider build() throws IllegalStateException {
            if (this.errorBuff.length() != 0) {
                System.out.println("Error initializing connector cache:\n" + String.valueOf(this.errorBuff));
                throw new IllegalStateException();
            }
            return new ConnectorTypeCacheProvider(this);
        }
    }
}

