/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.bridge;

import java.util.ArrayList;
import java.util.LinkedList;
import oracle.dbtools.common.utils.OracleSQLConstants;

public class BridgeUtil {
    private static final String NOTALLOWEDCHARS = " ' .@`!\"%^&*()-+=[]{};:,.<>?/~''\u00a3";
    private static final String DIGITS = "0123456789";
    private static final String EXTRAALLOWED = "_$";

    public static String createValidIdentifier(String sourceName, String type) {
        try {
            if (sourceName == null || sourceName.trim().equals("")) {
                return sourceName;
            }
            String targetName = sourceName;
            if (targetName.trim().equals("\"\"")) {
                return targetName;
            }
            if (targetName.trim().startsWith("'") && targetName.trim().endsWith("'")) {
                return targetName;
            }
            targetName = BridgeUtil.removeQuoteCharacters(targetName);
            if (type.equals("object")) {
                int intValue = -999999996;
                try {
                    intValue = Integer.parseInt(targetName);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (intValue != -999999996) {
                    return "A_" + targetName;
                }
            }
            String backupTargetName = targetName;
            if ((targetName = BridgeUtil.leftTrimNonAlphaNumeric(targetName)).length() == 0) {
                return "\"" + backupTargetName + "\"";
            }
            targetName = BridgeUtil.firstCharCheck(targetName, type);
            targetName = BridgeUtil.temporaryObjectCheck(targetName);
            targetName = BridgeUtil.removeInvalidCharacters(targetName);
            targetName = BridgeUtil.modifyReservedNames(targetName);
            return targetName;
        }
        catch (Exception e) {
            return sourceName;
        }
    }

    public static String createValidObjectNameForScratchEditor(String sourceName) {
        String targetName = sourceName;
        targetName = BridgeUtil.temporaryObjectCheck(targetName);
        targetName = BridgeUtil.removeInvalidCharacters(targetName);
        targetName = BridgeUtil.trimToSize(targetName, 30);
        return targetName;
    }

    private static String temporaryObjectCheck(String targetName) {
        if (targetName.trim().startsWith("#")) {
            // empty if block
        }
        return targetName;
    }

    private static String removeInvalidCharacters(String targetName) {
        char[] targetNameCharArray = targetName.toCharArray();
        int i = 0;
        for (char c : targetNameCharArray) {
            if (NOTALLOWEDCHARS.indexOf(c) != -1) {
                targetNameCharArray[i] = 95;
            }
            ++i;
        }
        i = 0;
        StringBuffer newTargetName = new StringBuffer();
        for (char c : targetNameCharArray) {
            if (c == '_') {
                if (targetNameCharArray.length == i + 1) {
                    newTargetName.append(c);
                } else if (targetNameCharArray.length > i + 1 && targetNameCharArray[i + 1] != '_') {
                    newTargetName.append(c);
                }
            } else {
                newTargetName.append(c);
            }
            ++i;
        }
        return newTargetName.toString();
    }

    private static String modifyReservedNames(String targetName) {
        if (OracleSQLConstants.isSignificantWord((String)targetName) || OracleSQLConstants.isRservedWord((String)targetName)) {
            targetName = (String)targetName + "_";
        }
        return targetName;
    }

    private static String trimToSize(String targetName, int size) {
        if (targetName != null && targetName.trim().length() > size) {
            targetName = targetName.trim().substring(0, size);
        }
        return targetName;
    }

    private static String firstCharCheck(String targetName, String type) {
        char firstChar = ((String)targetName).charAt(0);
        if (" ' .@`!\"%^&*()-+=[]{};:,.<>?/~''\u00a3_$0123456789".indexOf(firstChar) != -1) {
            targetName = "A" + (String)targetName;
        }
        return targetName;
    }

    private static String leftTrimNonAlphaNumeric(String targetName) {
        int startIndex = 0;
        for (char c : targetName.toCharArray()) {
            if (" ' .@`!\"%^&*()-+=[]{};:,.<>?/~''\u00a3_$".indexOf(c) == -1) break;
            ++startIndex;
        }
        return targetName.substring(startIndex);
    }

    protected static String removeQuoteCharacters(String name) {
        if (name != null && (name.trim().startsWith("[") && name.trim().endsWith("]") || name.trim().startsWith("\"") && name.trim().endsWith("\""))) {
            name = name.trim().substring(1, name.length() - 1);
        }
        return name;
    }

    public ArrayList<String> getEmulationFuncsForSchema(Object schemaId) {
        return null;
    }

    public ArrayList<String> getEmulationFuncsForConnection(Object connectionId) {
        return null;
    }

    public void addInfoKeyValue(String key, String value) {
    }

    public String getInfoKeyValue(String key) {
        return null;
    }

    public void clearInfoKey() {
    }

    public LinkedList<Long> getViewGenOrderList() {
        return null;
    }

    public void setViewGenOrderList(LinkedList<Long> viewList) {
    }

    public boolean getUseViewList() {
        return false;
    }

    public void setUseViewList(boolean flag) {
    }
}

