/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.alias;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.common.utils.FileUtils;
import oracle.dbtools.common.utils.PlatformUtils;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.raptor.newscriptrunner.commands.alias.Alias;
import oracle.dbtools.raptor.newscriptrunner.commands.alias.AliasParser;
import oracle.dbtools.raptor.newscriptrunner.commands.alias.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.alias.MetricsParser;
import oracle.dbtools.raptor.newscriptrunner.commands.alias.ReportsParser;
import oracle.dbtools.raptor.query.Bind;
import oracle.dbtools.raptor.query.Query;

public class Aliases {
    public static final String CONFIGFILE = File.separator + "aliases.xml";
    public static final String CONFIGBACK = File.separator + "aliases.xml~";
    private static final String DEFAULT_ALIASES = "META-INF/aliases/";
    private static final String DEFAULT_METRICS = "oracle/dbtools/raptor/metrics/";
    private static final String DEFAULT_REPORTS = "META-INF/reports/oracle/";
    private static final String EXTENSION = "xml";
    private static final CaseInsensitiveComparator caseInsensitiveComparator = new CaseInsensitiveComparator();
    private TreeMap<String, Alias> aliases = new TreeMap(caseInsensitiveComparator);
    private static Aliases _INSTANCE;

    public static String getBase() {
        String storage = System.getProperty("user.home") + File.separator + ".sqlcl";
        if (PlatformUtils.isWindows()) {
            String appData = System.getenv("APPDATA");
            storage = appData != null ? appData + File.separator + "sqlcl" : null;
        }
        return storage;
    }

    public static Aliases getInstance() {
        if (_INSTANCE == null) {
            _INSTANCE = new Aliases();
            _INSTANCE.load_default();
            _INSTANCE.load_metrics();
            _INSTANCE.load_reports();
            _INSTANCE.load_userdefined();
        }
        return _INSTANCE;
    }

    private Aliases() {
    }

    private void load_default() {
        List<Path> paths = FileUtils.getFilesInPackage(DEFAULT_ALIASES, EXTENSION);
        AliasParser parser = new AliasParser();
        try {
            for (Path p : paths) {
                ArrayList<Alias> aliases = parser.processXML(p.toUri().toURL());
                aliases.forEach(alias -> alias.setPredefined());
                this.add(aliases);
            }
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, e.getLocalizedMessage());
        }
    }

    private void load_metrics() {
        MetricsParser mp = new MetricsParser();
        List<Path> paths = FileUtils.getFilesInPackage(DEFAULT_METRICS, EXTENSION);
        try {
            for (Path p : paths) {
                ArrayList<Alias> aliases = mp.processXML(p.toUri().toURL());
                aliases.forEach(alias -> alias.setPredefined());
                this.add(aliases);
            }
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, e.getLocalizedMessage());
        }
    }

    private void load_reports() {
        ReportsParser rp = new ReportsParser();
        List<Path> paths = FileUtils.getFilesInPackage(DEFAULT_REPORTS, EXTENSION);
        try {
            for (Path p : paths) {
                ArrayList<Alias> aliases = rp.processXML(p.toUri().toURL());
                aliases.forEach(alias -> alias.setPredefined());
                this.add(aliases);
            }
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, e.getLocalizedMessage());
        }
    }

    private String load_userdefined() {
        return this.load(null);
    }

    public void add(List<Alias> aliasList) {
        if (aliasList != null && aliasList.size() > 0) {
            for (Alias alias : aliasList) {
                this.add(alias);
            }
        }
    }

    public void add(Alias alias) {
        if (this.aliases.containsKey(alias.getName())) {
            this.aliases.remove(alias.getName());
        }
        this.aliases.put(alias.getName(), alias);
    }

    public void add(String name, String query, String desc, boolean nullDefaults, String group, List<Bind> binds) {
        Query q = new Query();
        q.setSql(query);
        q.setBinds(binds);
        q.setMinversion(new Version("8"));
        Alias alias = new Alias(name, q, desc, group, nullDefaults);
        this.add(alias);
    }

    public String drop(String name) {
        if (this.aliases.containsKey(name)) {
            if (this.aliases.get(name).isPredefined()) {
                return MessageFormat.format(Messages.getString("Aliases.9"), name);
            }
            this.aliases.remove(name);
            return MessageFormat.format(Messages.getString("Aliases.0"), name);
        }
        return MessageFormat.format(Messages.getString("Aliases.1"), name);
    }

    public ArrayList<String> getAliases() {
        ArrayList<String> list = new ArrayList<String>();
        for (String alias : this.aliases.keySet()) {
            list.add(alias);
        }
        Collections.sort(list);
        return list;
    }

    public boolean contains(String key) {
        return this.aliases.containsKey(key);
    }

    public Alias get(String key) {
        return this.aliases.get(key);
    }

    public String save() {
        return this.save(null);
    }

    public String save(String filename) {
        String base = Aliases.getBase();
        new File(base).mkdirs();
        File file = null;
        if (filename != null) {
            if (((String)filename).lastIndexOf(47) > -1) {
                if (!((String)filename).substring(((String)filename).lastIndexOf(47)).contains(".")) {
                    filename = (String)filename + ".xml";
                }
            } else if (!((String)filename).contains(".")) {
                filename = (String)filename + ".xml";
            }
            file = new File((String)filename);
        } else {
            filename = base + CONFIGFILE;
            file = new File((String)filename);
        }
        ArrayList<Alias> aliasesAL = new ArrayList<Alias>();
        AliasParser parser = new AliasParser();
        try {
            for (Map.Entry<String, Alias> a : this.aliases.entrySet()) {
                Alias al = a.getValue();
                if (al.isPredefined()) continue;
                aliasesAL.add(al);
            }
            if (base == null) {
                return Messages.getString("Aliases.8");
            }
            if (file.exists()) {
                try {
                    int a = 1;
                    boolean found = false;
                    String filenamebak = (String)filename + ".bak_";
                    while (!found) {
                        File findme = new File(filenamebak + a);
                        if (findme.exists() && a < 3) {
                            ++a;
                            continue;
                        }
                        Files.deleteIfExists(Paths.get(filenamebak + a, new String[0]));
                        found = true;
                    }
                    if (file.exists()) {
                        Files.move(Paths.get((String)filename, new String[0]), Paths.get(filenamebak + a, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                    }
                }
                catch (Exception e) {
                    return MessageFormat.format(Messages.getString("Aliases.11"), filename, (String)filename + ".bak", e.getMessage());
                }
            }
            if (base != null) {
                parser.putXML(new File((String)filename), aliasesAL);
            }
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, e.getLocalizedMessage());
        }
        return MessageFormat.format(Messages.getString("Aliases.13"), filename);
    }

    public String load() {
        return this.load(null);
    }

    public String load(String filename) {
        File file = null;
        URLConnection uc = null;
        try {
            if (filename != null) {
                if (((String)filename).lastIndexOf(47) > -1) {
                    if (!((String)filename).substring(((String)filename).lastIndexOf(47)).contains(".")) {
                        filename = (String)filename + ".xml";
                    }
                } else if (!((String)filename).contains(".")) {
                    filename = (String)filename + ".xml";
                }
                if (Aliases.startsWithHttpOrFtp((String)filename) && Aliases.haveIBytes((String)filename)) {
                    uc = new URL(((String)filename).replaceAll("\\\\", "/")).openConnection();
                } else {
                    file = new File((String)filename);
                    if (file.exists()) {
                        uc = file.toURI().toURL().openConnection();
                    }
                }
            } else {
                String base = Aliases.getBase();
                if (base == null) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, Messages.getString("Aliases.14"));
                }
                if ((file = new File((String)(filename = base + CONFIGFILE))).exists()) {
                    uc = file.toURI().toURL().openConnection();
                }
            }
        }
        catch (MalformedURLException base) {
        }
        catch (IOException base) {
            // empty catch block
        }
        if (uc != null) {
            try {
                AliasParser parser = new AliasParser();
                if (uc.getInputStream() != null) {
                    ArrayList<Alias> filealiases = parser.processXML(uc.getInputStream());
                    for (Alias a : filealiases) {
                        Alias existing = this.aliases.get(a.getName());
                        if (existing != null && (existing.isPredefined() || Alias.isPredefinedGroup(existing.getGroup()))) continue;
                        this.aliases.put(a.getName(), a);
                    }
                    return Messages.getString("Aliases.15");
                }
            }
            catch (Exception e) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getLocalizedMessage());
            }
        } else {
            return MessageFormat.format(Messages.getString("Aliases.16"), filename);
        }
        return "";
    }

    static boolean containsFile(String inFile) {
        String stub;
        boolean retVal = false;
        if (inFile.indexOf(":") > 1 && (stub = inFile.substring(0, inFile.indexOf(":"))).endsWith("file") && stub.indexOf("/") == -1 && stub.indexOf("\\") == -1) {
            retVal = true;
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    boolean haveIBytesRaw(String base) {
        if (!Aliases.startsWithHttpOrFtp(base)) {
            return false;
        }
        InputStream is = null;
        URLConnection c = null;
        try {
            String lower = base.toLowerCase();
            if (Aliases.containsFile(lower)) {
                base = base.substring(lower.indexOf("file:"));
            }
            if (base.indexOf("\\") != -1) {
                base.replace("/", "\\");
                c = new URL(base).openConnection();
                is = c.getInputStream();
                if (is.read() != -1) {
                    boolean bl = true;
                    return bl;
                }
            }
        }
        catch (MalformedURLException e1) {
            boolean bl = false;
            return bl;
        }
        catch (IOException e1) {
            boolean bl = false;
            return bl;
        }
        catch (Exception e2) {
            boolean bl = false;
            return bl;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static boolean haveIBytes(String base) {
        if (!Aliases.startsWithHttpOrFtp(base)) {
            return false;
        }
        InputStream is = null;
        URLConnection c = null;
        try {
            String lower = base.toLowerCase();
            if (Aliases.containsFile(lower)) {
                base = base.substring(lower.indexOf("file:"));
            }
            if ((is = (c = new URL(base.replaceAll("\\\\", "/")).openConnection()).getInputStream()).read() != -1) {
                boolean bl = true;
                return bl;
            }
        }
        catch (MalformedURLException e1) {
            boolean bl = false;
            return bl;
        }
        catch (IOException e1) {
            boolean bl = false;
            return bl;
        }
        catch (Exception e2) {
            boolean bl = false;
            return bl;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
        return false;
    }

    static boolean startsWithHttpOrFtp(String base) {
        if (base == null) {
            return false;
        }
        String lower = base.toLowerCase();
        return lower.startsWith("http://") || lower.startsWith("http:\\\\") || lower.startsWith("https://") || lower.startsWith("https:\\\\") || Aliases.containsFile(lower) || lower.startsWith("ftp:\\\\") || lower.startsWith("ftp://");
    }

    private static class CaseInsensitiveComparator
    implements Comparator<String> {
        public static final CaseInsensitiveComparator INSTANCE = new CaseInsensitiveComparator();

        private CaseInsensitiveComparator() {
        }

        @Override
        public int compare(String first, String second) {
            return first.compareToIgnoreCase(second);
        }
    }
}

