/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.text.MessageFormat;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;

public class SetEscape
extends CommandListener {
    private static final String ESCAPE = "escape";
    private static final String ESCAPE_ON = "on";
    private static final String ESCAPE_OFF = "off";

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String sql = cmd.getSql().trim().toLowerCase();
        String[] tokens = sql.split("\\s+");
        if (tokens.length < 3) {
            ctx.write(Messages.getString("NO_ESCAPE_VAL"));
            return true;
        }
        if (tokens.length != 3) {
            ctx.write(Messages.getString("NO_ESCAPE_VAL"));
            return true;
        }
        if (tokens[1].equalsIgnoreCase(ESCAPE) && tokens[2].equalsIgnoreCase(ESCAPE_OFF)) {
            ctx.setEscapeChar('\u0000');
            ctx.setEscape(false);
        } else if (tokens[1].equalsIgnoreCase(ESCAPE) && tokens[2].equalsIgnoreCase(ESCAPE_ON)) {
            ctx.setEscapeChar('\\');
            ctx.setEscape(true);
        } else {
            String checkValue = this.validString(tokens[2], ctx);
            if (checkValue == null) {
                return true;
            }
            ctx.setEscapeChar(checkValue.charAt(0));
            ctx.setEscape(true);
        }
        return true;
    }

    public String validString(String toTestIn, ScriptRunnerContext ctx) {
        String toTest = toTestIn;
        if (toTest == null || toTest.equals("")) {
            ctx.write(Messages.getString("NO_ESCAPE_VAL"));
            return null;
        }
        if (toTest.equals("\"\"\"\"") || toTest.equals("'\"'")) {
            return "\"";
        }
        if (toTest.equals("''''") || toTest.equals("\"'\"")) {
            return "'";
        }
        if ((toTest = this.removeQuotesString(toTest)).length() > 1) {
            ctx.write(MessageFormat.format(Messages.getString("ONE_CHARACTER"), toTest));
            return null;
        }
        if (toTest.equals("") || toTest.equals("\"") || toTest.equals("'")) {
            ctx.write(Messages.getString("INVALID_ESCAPE"));
            return null;
        }
        if (toTest.matches("^\\s") || toTest.matches("^\\w") && !toTest.startsWith("_") || toTest.matches("^\\d")) {
            ctx.write(Messages.getString("NOT_ALHA_OR_WHITE"));
            return null;
        }
        return toTest.substring(0, 1);
    }

    public String removeQuotesString(String toBeStripped) {
        if (toBeStripped.startsWith("'") && toBeStripped.endsWith("'") && toBeStripped.length() >= 2) {
            return toBeStripped.substring(1, toBeStripped.length() - 1);
        }
        if (toBeStripped.startsWith("\"") && toBeStripped.endsWith("\"") && toBeStripped.length() >= 2) {
            return toBeStripped.substring(1, toBeStripped.length() - 1);
        }
        return toBeStripped;
    }
}

