/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.CommandsHelp;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;

public class CTAS
extends CommandListener
implements IHelp {
    @Override
    public String getCommand() {
        return "CTAS";
    }

    @Override
    public String getHelp() {
        return CommandsHelp.getString(this.getCommand());
    }

    @Override
    public boolean isSqlPlus() {
        return false;
    }

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (CTAS.matches("ctas", cmd.getSql())) {
            String[] parts = cmd.getSql().split("\\W");
            HashMap<String, String> binds = new HashMap<String, String>();
            if (parts.length < 3) {
                ctx.write(this.getHelp());
                return true;
            }
            try {
                if (conn == null) {
                    ctx.write(Messages.getString("CTAS_CONNECTION_FAILED"));
                    return false;
                }
                if (conn.isClosed()) {
                    ctx.write(Messages.getString("CTAS_CONNECTION_FAILED"));
                    return false;
                }
            }
            catch (Exception e) {
                Logger.getLogger("ScriptExecutor").log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
            binds.put("NAME", parts[1].toUpperCase());
            binds.put("NEW_NAME", parts[2].toUpperCase());
            DBUtil dbUtil = DBUtil.getInstance(conn);
            dbUtil.execute("begin DBMS_METADATA.SET_TRANSFORM_PARAM(DBMS_METADATA.SESSION_TRANSFORM, 'REF_CONSTRAINTS',false); end;");
            dbUtil.execute("begin DBMS_METADATA.SET_REMAP_PARAM(dbms_metadata.session_transform,'REMAP_NAME',:NAME,:NEW_NAME); end;", binds);
            String orig = dbUtil.executeReturnOneCol("select dbms_metadata.get_ddl('TABLE',:NAME) from dual", binds);
            if (orig == null) {
                ctx.write(MessageFormat.format(Messages.getString("CTAS_NO_SOURCE_TABLE"), parts[1].toUpperCase()));
                return false;
            }
            if (orig != null && orig.length() < 1) {
                ctx.write(this.getHelp());
                return true;
            }
            String str = (orig = orig.replace("\"" + parts[1].toUpperCase() + "\"", "\"" + parts[2].toUpperCase() + "\"")).trim();
            if (str.length() > 0 && str.charAt(str.length() - 1) == ';') {
                orig = str = str.substring(0, str.length() - 1);
            }
            BufferedReader sr = new BufferedReader(new StringReader(orig));
            String line = null;
            Object newSQL = "";
            try {
                boolean last = false;
                ArrayList<String> ddl = new ArrayList<String>();
                while ((line = sr.readLine()) != null) {
                    ddl.add(line);
                }
                line = "";
                int i = 0;
                Iterator it = ddl.iterator();
                while (it.hasNext()) {
                    line = (String)it.next();
                    ++i;
                    if (line.indexOf("\t\"") > -1) {
                        int q1 = line.indexOf("\"");
                        int q2 = line.indexOf("\"", q1 + 1);
                        Object newLine = line.substring(0, q2 + 1);
                        if (line.indexOf(" ", q2) <= 0) {
                            newLine = (String)newLine + ",";
                        }
                        if (it.hasNext() && (((String)ddl.get(i)).indexOf("SEGMENT CREATION") > -1 || ((String)ddl.get(i)).indexOf(") PCTFREE ") > -1 || ((String)ddl.get(i)).trim().equals(")"))) {
                            newSQL = (String)newSQL + (String)newLine + "\n";
                            continue;
                        }
                        if (((String)newLine).trim().endsWith(",")) continue;
                        newSQL = (String)newSQL + (String)newLine + ",\n";
                        continue;
                    }
                    newSQL = (String)newSQL + line + "\n";
                }
            }
            catch (IOException e) {
                newSQL = orig;
            }
            newSQL = (String)newSQL + " as \nselect * from " + parts[1].toUpperCase();
            ctx.write((String)newSQL + "\n");
            cmd.setStmtClass(SQLCommand.StmtType.G_C_SQL);
            cmd.setStmtId(SQLCommand.StmtSubType.G_S_CREATE_TABLE);
            cmd.setSql((String)newSQL);
            String[] sqlArr = ((String)newSQL).trim().split("\n");
            if (ctx.getSQLPlusBuffer() != null) {
                ctx.getSQLPlusBuffer().getBufferSafe().resetBuffer(Arrays.asList(sqlArr));
            }
        }
        return true;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }
}

