/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.extendedtype;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskDescriptor;
import oracle.dbtools.raptor.extendedtype.AbstractExtendedType;
import oracle.dbtools.raptor.extendedtype.BFILEDirectory;
import oracle.jdbc.driver.OracleConnection;
import oracle.sql.BFILE;
import oracle.sql.BfileDBAccess;

public class BFILEType
extends AbstractExtendedType {
    private OutputStream out = null;
    private BFILEDirectory dirAlias_new = null;
    private String fileName_new = null;

    protected BFILEType(int sqlType, BFILE origValue) {
        super(sqlType, origValue);
    }

    public BFILEType(BFILE bfile) {
        this(-13, bfile);
    }

    public BFILE getOrigBFile() {
        return this.getOrigValue();
    }

    @Override
    public BFILE getOrigValue() {
        return (BFILE)super.getOrigValue();
    }

    public BFILEDirectory getDirAlias_new() {
        return this.dirAlias_new;
    }

    public void setDirAlias_new(BFILEDirectory dirAlias_new) {
        this.dirAlias_new = dirAlias_new;
        this.setLoadFromURL(this.dirAlias_new, this.fileName_new);
    }

    public String getFileName_new() {
        return this.fileName_new;
    }

    public void setFileName_new(String fileName_new) {
        this.fileName_new = fileName_new;
        this.setLoadFromURL(this.dirAlias_new, this.fileName_new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveToDb(Connection conn, String tableName, String columnName, String rowId, String rowScn, boolean dataIntegrity, List<String> log) throws SQLException, IOException {
        if (this.dirAlias_new != null && this.fileName_new != null) {
            Statement stmt = null;
            Statement prep = null;
            try {
                StringBuffer insertSql = new StringBuffer("BEGIN UPDATE " + tableName + "SET " + columnName + "=bfilename('" + String.valueOf(this.dirAlias_new) + "','" + this.fileName_new + "') WHERE ROWID=:sqldevrowid");
                if (dataIntegrity && rowScn != null) {
                    insertSql.append(" AND ORA_ROWSCN=:sqldevrowscn");
                }
                insertSql.append(" RETURNING ROWID INTO ?; END;");
                log.add(insertSql.toString());
                stmt = conn.prepareCall(insertSql.toString());
                int i = 0;
                stmt.setString(++i, rowId);
                if (rowScn != null && dataIntegrity) {
                    stmt.setString(++i, rowScn);
                }
                stmt.registerOutParameter(++i, 1);
                int updates = stmt.executeUpdate();
                if (updates == 1) {
                    ResultSet rs;
                    StringBuffer selectSql = new StringBuffer("SELECT " + columnName + " FROM " + tableName + " WHERE ROWID=:sqldevrowid");
                    if (dataIntegrity && rowScn != null) {
                        selectSql.append(" AND ORA_ROWSCN=:sqldevrowscn");
                    }
                    prep = conn.prepareStatement(selectSql.toString());
                    prep.setString(1, rowId);
                    if (rowScn != null && dataIntegrity) {
                        prep.setString(2, rowScn);
                    }
                    if ((rs = prep.executeQuery()).next()) {
                        this.setOrigValue(rs.getObject(1));
                    }
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (prep != null) {
                        prep.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveToDisk(String tableName, String columnName, String rowId, String rowScn, boolean dataIntegrity) throws SQLException, IOException {
        BFILE origBFile;
        OutputStream out = this.out;
        RaptorTaskDescriptor taskDescriptor = this.getToDiskTaskDescriptor();
        if (taskDescriptor != null) {
            this.setToDiskTaskProgress(taskDescriptor, 0);
        }
        if ((origBFile = this.getOrigValue()) != null && out != null) {
            InputStream blobStream = null;
            try {
                long expectedLength = origBFile.getLength();
                origBFile.openFile();
                blobStream = origBFile.getBinaryStream();
                if (blobStream != null && expectedLength > 0L) {
                    long written = 0L;
                    blobStream = new BufferedInputStream(blobStream, 16384);
                    byte[] buffer = new byte[8192];
                    int nbytes = 0;
                    while (!(out != this.out || taskDescriptor != null && taskDescriptor.isCancelled() || (nbytes = blobStream.read(buffer)) == -1)) {
                        out.write(buffer, 0, nbytes);
                        written += (long)nbytes;
                        if (taskDescriptor == null) continue;
                        int percentage = (int)(written * 100L / expectedLength);
                        this.setToDiskTaskProgress(taskDescriptor, percentage);
                    }
                    if (taskDescriptor != null) {
                        this.setToDiskTaskProgress(taskDescriptor, 100);
                    }
                    boolean bl = out == this.out;
                    return bl;
                }
            }
            finally {
                try {
                    if (blobStream != null) {
                        blobStream.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (origBFile != null) {
                        origBFile.closeFile();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        return false;
    }

    @Override
    public boolean isToDiskInDeterministic() {
        return false;
    }

    @Override
    public void setLoadFromURL(URL url) {
        if (url == null) {
            this.setDirAlias_new(null);
            this.setFileName_new(null);
        }
    }

    protected void setSuperLoadFromURL(URL url) {
        super.setLoadFromURL(url);
    }

    @Override
    public void setToDiskStream(OutputStream out) {
        this.out = out;
    }

    public String toString() {
        return "(BFILE)";
    }

    public InputStream asciiStreamValue() throws SQLException {
        return this.getOrigValue().asciiStreamValue();
    }

    public BigDecimal bigDecimalValue() throws SQLException {
        return this.getOrigValue().bigDecimalValue();
    }

    public InputStream binaryStreamValue() throws SQLException {
        return this.getOrigValue().binaryStreamValue();
    }

    public boolean booleanValue() throws SQLException {
        return this.getOrigValue().booleanValue();
    }

    public byte byteValue() throws SQLException {
        return this.getOrigValue().byteValue();
    }

    public Reader characterStreamValue() throws SQLException {
        return this.getOrigValue().characterStreamValue();
    }

    public void close() throws SQLException {
        this.getOrigValue().close();
    }

    public void closeFile() throws SQLException {
        this.getOrigValue().closeFile();
    }

    public Date dateValue() throws SQLException {
        return this.getOrigValue().dateValue();
    }

    public double doubleValue() throws SQLException {
        return this.getOrigValue().doubleValue();
    }

    public boolean equals(Object arg0) {
        return this == arg0;
    }

    public boolean fileExists() throws SQLException {
        return this.getOrigValue().fileExists();
    }

    public float floatValue() throws SQLException {
        return this.getOrigValue().floatValue();
    }

    @Override
    public InputStream getBinaryStream(Boolean orig) throws Exception {
        if (orig == null && this.getLoadFromURL() != null || orig != null && !orig.booleanValue()) {
            return super.getBinaryStream(orig);
        }
        if (this.getOrigValue() != null) {
            return this.getOrigValue().getBinaryStream();
        }
        return null;
    }

    public InputStream getBinaryStream(long arg0) throws SQLException {
        return this.getOrigValue().getBinaryStream(arg0);
    }

    public byte[] getBytes() {
        return this.getOrigValue().getBytes();
    }

    public int getBytes(long arg0, int arg1, byte[] arg2) throws SQLException {
        return this.getOrigValue().getBytes(arg0, arg1, arg2);
    }

    public byte[] getBytes(long arg0, int arg1) throws SQLException {
        return this.getOrigValue().getBytes(arg0, arg1);
    }

    public OracleConnection getConnection() throws SQLException {
        return this.getOrigValue().getConnection();
    }

    public BfileDBAccess getDBAccess() throws SQLException {
        return this.getOrigValue().getDBAccess();
    }

    public String getDirAlias() throws SQLException {
        return this.getOrigValue().getDirAlias();
    }

    public oracle.jdbc.internal.OracleConnection getInternalConnection() throws SQLException {
        return this.getOrigValue().getInternalConnection();
    }

    public Connection getJavaSqlConnection() throws SQLException {
        return this.getOrigValue().getJavaSqlConnection();
    }

    public long getLength() {
        return this.getOrigValue().getLength();
    }

    public byte[] getLocator() {
        return this.getOrigValue().getLocator();
    }

    public String getName() throws SQLException {
        return this.getOrigValue().getName();
    }

    public oracle.jdbc.OracleConnection getOracleConnection() throws SQLException {
        return this.getOrigValue().getOracleConnection();
    }

    public InputStream getStream() {
        return this.getOrigValue().getStream();
    }

    public int hashCode() {
        return this.getOrigValue().hashCode();
    }

    public int intValue() throws SQLException {
        return this.getOrigValue().intValue();
    }

    public boolean isConvertibleTo(Class arg0) {
        return this.getOrigValue().isConvertibleTo(arg0);
    }

    public boolean isFileOpen() throws SQLException {
        return this.getOrigValue().isFileOpen();
    }

    public boolean isOpen() throws SQLException {
        return this.getOrigValue().isOpen();
    }

    public long length() throws SQLException {
        return this.getOrigValue().length();
    }

    public long longValue() throws SQLException {
        return this.getOrigValue().longValue();
    }

    public Object makeJdbcArray(int arg0) {
        return this.getOrigValue().makeJdbcArray(arg0);
    }

    public void open() throws SQLException {
        this.getOrigValue().open();
    }

    public void open(int arg0) throws SQLException {
        this.getOrigValue().open(arg0);
    }

    public void openFile() throws SQLException {
        this.getOrigValue().openFile();
    }

    public long position(BFILE arg0, long arg1) throws SQLException {
        return this.getOrigValue().position(arg0, arg1);
    }

    public long position(byte[] arg0, long arg1) throws SQLException {
        return this.getOrigValue().position(arg0, arg1);
    }

    public void setBytes(byte[] arg0) {
        this.getOrigValue().setBytes(arg0);
    }

    public void setLocator(byte[] arg0) {
        this.getOrigValue().setLocator(arg0);
    }

    public void setPhysicalConnectionOf(Connection arg0) {
        this.getOrigValue().setPhysicalConnectionOf(arg0);
    }

    public void setShareBytes(byte[] arg0) {
        this.getOrigValue().setShareBytes(arg0);
    }

    public byte[] shareBytes() {
        return this.getOrigValue().shareBytes();
    }

    public String stringValue() throws SQLException {
        return this.getOrigValue().stringValue();
    }

    public Timestamp timestampValue() throws SQLException {
        return this.getOrigValue().timestampValue();
    }

    public Time timeValue() throws SQLException {
        return this.getOrigValue().timeValue();
    }

    public Object toJdbc() throws SQLException {
        return this.getOrigValue().toJdbc();
    }

    @Override
    public InputStream getCharStream() throws SQLException {
        return this.asciiStreamValue();
    }

    @Override
    public void duplicate() throws SQLException {
    }

    public void setLoadFromURL(BFILEDirectory dirAlias, String fileName) {
        try {
            if (dirAlias != null && dirAlias.getPath() != null && fileName != null) {
                this.setSuperLoadFromURL(new File(dirAlias.getPath() + File.separator + fileName).toURI().toURL());
                return;
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        this.setSuperLoadFromURL(null);
    }
}

