/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.util;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;

public class CappedFilterWriter
extends FilterWriter {
    protected final int maxLen;
    protected int count;

    public CappedFilterWriter(Writer writer, int maxLen) {
        super(writer);
        this.maxLen = maxLen;
        this.count = 0;
    }

    @Override
    public void write(int c) throws IOException {
        if (!this.checkLimitOverRun(this.maxLen)) {
            super.write(c);
        }
        ++this.count;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (!this.checkLimitOverRun(this.maxLen)) {
            super.write(cbuf, off, len);
        }
        this.count += len;
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        if (!this.checkLimitOverRun(this.maxLen)) {
            super.write(str, off, len);
        }
        this.count += len;
    }

    private boolean checkLimitOverRun(int maxLen) throws IOException {
        if (maxLen >= 0 && this.count >= maxLen) {
            throw new IOException();
        }
        return false;
    }
}

