/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.ocidbmetrics;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.ocidbmetrics.DBMetrics;

public class CDBMetrics
extends DBMetrics {
    private static final String[] FILES = new String[]{"ActiveSession.sql", "ActiveSessionHistory.sql", "ArchiveDest.sql", "ArchiveDestStatus.sql", "BackupDatafile.sql", "BackupRedolog.sql", "BackupSet.sql", "Containers.sql", "DBGAlertText.sql", "Database.sql", "DatabaseBlockCorruption.sql", "Datafile.sql", "DatafileHeader.sql", "EventMetric.sql", "ExtentMonitor.sql", "FailedRedef.sql", "HealthCheck.sql", "LogHistory.sql", "LogstdbyProgress.sql", "Osstat.sql", "Parameter.sql", "PdbSavedStates.sql", "RecoveryAreaUsage.sql", "RecoveryFileDest.sql", "ResourceLimit.sql", "RsrcMgrMetric.sql", "Services.sql", "Session.sql", "SqlPerf.sql", "Sqlstats.sql", "Switchover.sql", "Sysmetric.sql", "Tablespaces.sql", "TempFiles.sql"};
    private static final String[] TABLES = new String[]{"cdb_data_files", "cdb_free_space", "cdb_pdb_saved_states", "cdb_services", "cdb_tablespaces", "cdb_temp_files", "cdb_temp_free_space", "dba_hist_snapshot", "dba_logstdby_progress", "dba_pdbs", "v$active_services", "v$active_session_history", "v$archive_dest", "v$archive_dest_status", "v$backup_datafile", "v$backup_piece_details", "v$backup_redolog", "v$backup_set", "v$containers", "v$database", "v$database_block_corruption", "v$datafile", "v$datafile_header", "v$event_name", "v$eventmetric", "v$instance", "v$log_history", "v$osstat", "v$parameter", "v$recovery_area_usage", "v$recovery_file_dest", "v$resource_limit", "v$rsrcmgrmetric", "v$session", "v$sql", "v$sqlstats", "v$sysmetric", "v$system_parameter", "x$dbgalertext", "x$ksuse"};

    @Override
    public String[] getFiles() {
        return FILES;
    }

    @Override
    public String[] getTables() {
        return TABLES;
    }

    @Override
    public String getSetupScript(String username) {
        String user = username == null ? "[username]" : username;
        StringBuilder ret = new StringBuilder();
        ret.append("create user " + user + " identified by <passwd>;\r\n");
        ret.append("grant connect to " + user + ";\r\n");
        for (String tab : TABLES) {
            if (tab.startsWith("v$")) {
                ret.append("grant select on " + tab.replace("v$", "v_$") + " to " + user + ";\r\n");
                continue;
            }
            if (tab.startsWith("x$")) {
                ret.append("drop view x_" + tab.substring(2) + " ;\r\n");
                ret.append("create view x_" + tab.substring(2) + " as select * from " + tab + ";\r\n");
                ret.append("grant select on  x_" + tab.substring(2) + " to  " + user + ";\r\n");
                continue;
            }
            ret.append("grant select on " + tab + " to " + user + ";\r\n");
        }
        return ret.toString();
    }

    public List<String> getALLSQL(String username) throws IOException {
        ArrayList<String> ret = new ArrayList<String>();
        for (String file : FILES) {
            ret.add(this.getSQL(username, file));
        }
        return ret;
    }

    @Override
    public String getSQL(String username, String fileName) throws IOException {
        InputStream sqlInStream = this.getClass().getResourceAsStream("/oracle/dbtools/ocidbmetrics/cdb/" + fileName);
        String sql = new String(sqlInStream.readAllBytes());
        if (!username.equalsIgnoreCase("sys")) {
            sql = sql.replaceAll("x$dbgalertext", "sys.x_dbgalertext");
            sql = sql.replaceAll("x$ksuse", "sys.x_ksuse");
        }
        return sql;
    }

    public static void main(String[] args) {
        CDBMetrics cdb = new CDBMetrics();
        System.out.println(cdb.getSetupScript("C##MONITOR"));
    }
}

