/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.lsp.dictionary;

import java.io.IOException;
import oracle.dbtools.lsp.BackgroundParser;
import oracle.dbtools.lsp.dictionary.Registry;

public class ArboriCatalog
extends Registry {
    private BackgroundParser connection;

    public ArboriCatalog(BackgroundParser parser) {
        super(parser);
    }

    @Override
    public Object getConnection() {
        return this.connection;
    }

    @Override
    public void dissociateConnection() {
        this.connection = null;
        this.cleanSymbols();
    }

    @Override
    public String fullConnString() {
        if (this.connection == null) {
            return null;
        }
        return this.connection.docUrl;
    }

    @Override
    public String redactedConnString() {
        return this.fullConnString();
    }

    @Override
    public String abbreviatedConnString() {
        return this.fullConnString();
    }

    @Override
    public boolean isEqual(String connection1, String connection2) {
        return ArboriCatalog.canonicalFileURL(connection1).equals(ArboriCatalog.canonicalFileURL(connection2));
    }

    public static String canonicalFileURL(String filename) {
        filename = ((String)filename).replace("\\", "/");
        String filePrefix = "\"file:///";
        if (!((String)filename).startsWith("\"file:///")) {
            filename = "\"file:///" + ((String)filename).substring(1);
        }
        filename = ((String)filename).replace("C:/", "c:/");
        return filename;
    }

    @Override
    public void associateConnection(String connStr) {
        try {
            this.connection = this.parser.getLanguageServer().getParser(connStr);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void liquidate() {
    }
}

