/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.lsp.commands.dictionary;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.logging.Level;
import oracle.dbtools.lsp.BackgroundParser;
import oracle.dbtools.lsp.LSP;
import oracle.dbtools.lsp.LanguageServer;
import oracle.dbtools.lsp.commands.CodeLens;
import oracle.dbtools.lsp.dictionary.Item;
import oracle.dbtools.lsp.dictionary.OracleDictionary;
import oracle.dbtools.lsp.features.Range;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.json.ResponseError;
import oracle.dbtools.parser.json.Util;
import oracle.dbtools.util.Service;

public class ExpandTreeNode
extends CodeLens {
    public ExpandTreeNode(ParseNode node, BackgroundParser parser) {
        super(node, "Expand tree node", parser);
    }

    @Override
    public Object executeCommand() {
        ParseNode current = null;
        for (ParseNode child : this.node.children()) {
            if (!child.contains("more")) continue;
            current = child;
        }
        LanguageServer server = this.parser.languageServer;
        boolean done = this.parser.waitForParsingFinish();
        if (!done) {
            return new ResponseError(-32603, "Parsing failed to complete", (Object)server.getLastUrl());
        }
        Range range = this.parser.nodeRange(current);
        String uri = server.getLastUrl().substring(1, server.getLastUrl().length() - 1);
        if (this.node.contains("user")) {
            String indentedDict = OracleDictionary.indent(OracleDictionary.dictionaryScheleton.replace("\n\n", "\n").replace("\n\r\n", "\n"), 2);
            this.parser.replaceText(current, indentedDict);
            server.getLSP().documentInsert(range, uri, indentedDict);
            return "OK";
        }
        if (this.node.contains("other_datatypes_node")) {
            String indentedDict = OracleDictionary.indent(OracleDictionary.nonessentialScheleton.replace("\n\n", "\n").replace("\n\r\n", "\n"), 2);
            this.parser.replaceText(current, indentedDict);
            server.getLSP().documentInsert(range, uri, indentedDict);
            LanguageServer languageServer = this.parser.languageServer;
            String folder = languageServer.dictionaryUri + "/" + ((OracleDictionary)this.parser.getRegistry()).dirName();
            languageServer.getLSP().createDirectory(folder + "/Other Datatypes/INDEXES");
            languageServer.getLSP().createDirectory(folder + "/Other Datatypes/MATERIALIZED VIEWS");
            languageServer.getLSP().createDirectory(folder + "/Other Datatypes/MATERIALIZED VIEW LOGSS");
            languageServer.getLSP().createDirectory(folder + "/Other Datatypes/OPERATORS");
            languageServer.getLSP().createDirectory(folder + "/Other Datatypes/TYPES");
            languageServer.getLSP().createDirectory(folder + "/Other Datatypes/QUEUES");
            languageServer.getLSP().createDirectory(folder + "/Other Datatypes/QUEUE TABLES");
            languageServer.getLSP().createDirectory(folder + "/Other Datatypes/SEQUENCES");
            languageServer.getLSP().createDirectory(folder + "/Other Datatypes/SYNONYMS");
            languageServer.getLSP().createDirectory(folder + "/Other Datatypes/PUBLIC SYNONYMS");
            languageServer.getLSP().createDirectory(folder + "/Other Datatypes/DATABASE LINKS");
            languageServer.getLSP().createDirectory(folder + "/Other Datatypes/DIRECTORIES");
            languageServer.getLSP().createDirectory(folder + "/Other Datatypes/EDITIONS");
            return "OK";
        }
        ParseNode grandParent = this.node.parent().parent();
        Object schema = "USER";
        if (grandParent != null && !grandParent.contains("other_datatypes_node")) {
            schema = "'" + this.parser.src.get((int)grandParent.from).content.toUpperCase() + "'";
        }
        String symbol = this.parser.earley.allSymbols[this.node.content()[0]].toUpperCase();
        int chop = symbol.indexOf("_NODE");
        String objType = symbol.substring(0, chop);
        objType = objType.replace('_', ' ');
        Object conn = this.parser.getRegistry().getConnection();
        if (conn == null || !(conn instanceof Connection)) {
            return new ResponseError(-32603, "Not connected", (Object)server.getLastUrl());
        }
        try {
            List<Item> items = OracleDictionary.queryItems(this.node, this.parser.src, (String)schema, objType, conn);
            StringBuilder aggr = new StringBuilder();
            int level = grandParent != null ? 3 : 1;
            int cnt = -1;
            for (Item item : items) {
                ++cnt;
                Object name = item.name;
                if (objType.equals("OTHER_USERS")) {
                    LanguageServer languageServer = this.parser.languageServer;
                    String folder = languageServer.dictionaryUri + "/" + ((OracleDictionary)this.parser.getRegistry()).dirName();
                    languageServer.getLSP().createDirectory(folder + "/Other Users/" + (String)name);
                    if (item != Item.MORE) {
                        name = (String)name + "...";
                    }
                }
                if (cnt < items.size() - 1) {
                    name = (String)name + ",\n";
                }
                aggr.append(OracleDictionary.indent((String)name, level));
            }
            Object ins = "\n" + Service.padln((String)"", (int)(4 * level)) + aggr.toString();
            if (cnt == 0) {
                ins = "\n";
            }
            this.parser.replaceText(current, (String)ins);
            server.getLSP().documentInsert(range, uri, (String)ins);
            return "OK";
        }
        catch (SQLException e) {
            LSP.Log.log(Level.SEVERE, e.getMessage(), e);
            return new ResponseError(-32603, Util.sugarcoatText((String)e.getMessage()), conn);
        }
    }
}

