/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.lsp;

import java.io.IOException;
import java.sql.Connection;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import javax.script.ScriptException;
import oracle.dbtools.app.Completer;
import oracle.dbtools.arbori.Program;
import oracle.dbtools.lsp.BackgroundArboriParser;
import oracle.dbtools.lsp.BackgroundDictParser;
import oracle.dbtools.lsp.BackgroundSqlParser;
import oracle.dbtools.lsp.GridRenderer;
import oracle.dbtools.lsp.LSP;
import oracle.dbtools.lsp.LanguageServer;
import oracle.dbtools.lsp.PublishDiagnosticsParams;
import oracle.dbtools.lsp.TableRenderer;
import oracle.dbtools.lsp.commands.CodeLens;
import oracle.dbtools.lsp.dictionary.OracleDictionary;
import oracle.dbtools.lsp.dictionary.Registry;
import oracle.dbtools.lsp.features.Diagnostics;
import oracle.dbtools.lsp.features.DocumentSymbol;
import oracle.dbtools.lsp.features.FoldingRange;
import oracle.dbtools.lsp.features.Position;
import oracle.dbtools.lsp.features.Range;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.parser.Yelrae;
import oracle.dbtools.parser.json.Util;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.util.Service;
import oracle.jdbc.OracleDatabaseException;

public abstract class BackgroundParser {
    private int objRef;
    private static int objCnt = 0;
    public Earley earley;
    String topSymbol;
    private boolean up2date = true;
    public String text = null;
    public List<LexerToken> src = null;
    public List<LexerToken> allSrc = null;
    public Matrix matrix = null;
    public ParseNode root = null;
    private int[] lineMap = null;
    protected int lastCharPos = 0;
    public Program program = null;
    public CodeLens[] codeLens = null;
    boolean enableCodeLens = true;
    public List<Diagnostics> diagnostics = new LinkedList<Diagnostics>();
    public String docUrl;
    public LanguageServer languageServer;
    private Registry registry = null;
    Set<FoldingRange> foldingRanges = new HashSet<FoldingRange>();
    boolean quit = false;
    static int cnt = 0;
    int instance;
    TableRenderer renderer = new GridRenderer(this);

    public BackgroundParser(String input, Earley earley, String topSymbol, String url, LanguageServer languageServer) {
        this.text = input;
        this.earley = earley;
        this.topSymbol = topSymbol;
        this.docUrl = url;
        this.languageServer = languageServer;
        this.objRef = objCnt++;
    }

    public int getLastCharPos() {
        return this.lastCharPos;
    }

    public Program getProgram() {
        return this.program;
    }

    public void resetDiagnostics() {
        this.diagnostics = new LinkedList<Diagnostics>();
    }

    public void addDiagnostics(Diagnostics add) {
        if (this.diagnostics == null) {
            this.resetDiagnostics();
        }
        this.diagnostics.add(add);
    }

    public void initCodeLens(int len) {
        this.codeLens = new CodeLens[len];
    }

    public void setCodeLens(int index, CodeLens value) {
        this.codeLens[index] = value;
    }

    public void sortCodeLens() {
        Arrays.sort(this.codeLens);
    }

    public String escapedUrl() {
        String tmp = this.docUrl.substring(1, this.docUrl.length() - 1);
        return "\"" + Util.sugarcoatText((String)tmp) + "\"";
    }

    public LanguageServer getLanguageServer() {
        return this.languageServer;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public void initRegistry(Registry value) {
        this.registry = value;
    }

    public String associatedFullConnStr() {
        return this.getRegistry().fullConnString();
    }

    public int lineNo2CharPos0(int line) {
        int ret = Service.lineNo2CharPos0((int[])this.lineMap, (int)line);
        try {
            if (this.text.charAt(ret) == '\r') {
                return ret + 1;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return ret;
    }

    public int lineNo2CharPos1(int line) {
        return this.lineNo2CharPos0(line - 1);
    }

    public int charPos2LineNo0(int pos) {
        return Service.charPos2LineNo0((int[])this.lineMap, (int)pos);
    }

    public int charPos2LineNo1(int pos) {
        return Service.charPos2LineNo1((int[])this.lineMap, (int)pos);
    }

    public void addFoldingRange(ParseNode p) {
        int lineEnd;
        if (!this.up2date) {
            return;
        }
        int lineBegin = this.charPos2LineNo1(this.src.get((int)p.from).begin);
        if (lineBegin < (lineEnd = this.charPos2LineNo1(this.src.get((int)(p.to - 1)).end))) {
            this.foldingRanges.add(new FoldingRange(lineBegin - 1, lineEnd - 1));
        }
    }

    public void clearFoldingRanges() {
        this.foldingRanges = new HashSet<FoldingRange>();
    }

    public void replaceText(ParseNode range, String addendum) {
        this.updateText(this.text.substring(0, this.src.get((int)range.from).begin) + addendum + this.text.substring(this.src.get((int)(range.to - 1)).end));
    }

    public void updateText(String newText) {
        this.text = newText;
        this.up2date = false;
    }

    protected void lateInit() {
        this.up2date = false;
        try {
            this.parse();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            this.instance = cnt++;
            Thread parsingThread = new Thread("Background Parser#" + this.instance){

                @Override
                public void run() {
                    BackgroundParser.this.quit = false;
                    while (!BackgroundParser.this.quit) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (BackgroundParser.this.up2date) continue;
                        try {
                            BackgroundParser.this.parse();
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                    }
                }
            };
            parsingThread.start();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            // empty catch block
        }
    }

    public boolean isLexing() {
        return !this.up2date;
    }

    public boolean isParsing() {
        return !this.up2date;
    }

    public boolean waitForLexingFinish() {
        for (int i = 0; i < 20; ++i) {
            if (!this.isLexing()) {
                return true;
            }
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean waitForParsingFinish() {
        for (int i = 0; i < 20; ++i) {
            if (!this.isParsing()) {
                return true;
            }
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean waitForArboriFinish() {
        for (int i = 0; i < 20; ++i) {
            if (this.codeLens != null) {
                return true;
            }
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return false;
    }

    public void parse() {
        long elapsed;
        if (this.text == null) {
            this.lineMap = null;
            this.src = null;
            this.allSrc = null;
            this.matrix = null;
            this.root = null;
            this.codeLens = null;
            this.up2date = true;
            return;
        }
        long t1 = System.currentTimeMillis();
        this.lineMap = Service.lineMap((String)this.text);
        this.lex();
        this.matrix = new Matrix((Parser)this.earley);
        this.earley.parse(this.src, this.matrix);
        this.root = Yelrae.duplexParse((Earley)this.earley, this.src, (Matrix)this.matrix);
        this.up2date = true;
        this.clearFoldingRanges();
        Parsed target = new Parsed(this.text, this.src, this.root);
        if (this.program == null) {
            this.program = new Program(this.earley, this){};
            try {
                String prg = null;
                Object filename = this.semanticActionsFile();
                Properties pr = System.getProperties();
                Object m = (String)pr.get("dbtools.lsp.codeLensDir");
                if (m != null) {
                    if (!((String)m).endsWith("/") || !((String)m).endsWith("\\")) {
                        m = (String)m + "/";
                    }
                    filename = (String)m + (String)filename;
                } else {
                    m = (String)pr.get("dbtools.lsp." + this.semanticActionsFile());
                    if (m != null) {
                        filename = m;
                    }
                }
                try {
                    prg = m == null ? Service.readFile(LSP.class, (String)filename) : Service.readFile((String)filename);
                }
                catch (IOException e2) {
                    throw new AssertionError((Object)((String)filename + " not found"));
                }
                this.program.compile(prg, null, true);
            }
            catch (AssertionError e) {
                LSP.Log.log(Level.SEVERE, ((Throwable)((Object)e)).getMessage(), (Throwable)((Object)e));
            }
            catch (Exception e) {
                e.printStackTrace();
                LSP.Log.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        try {
            this.program.eval(target, (Object)this);
        }
        catch (oracle.dbtools.arbori.ScriptException e) {
            e.printStackTrace();
        }
        if (this.codeLens == null) {
            this.codeLens = new CodeLens[0];
        }
        if (400L < (elapsed = System.currentTimeMillis() - t1)) {
            System.out.println("***** Background parser parser timing = " + elapsed);
        }
    }

    public void lex() {
        this.allSrc = LexerToken.parse((String)this.text, (boolean)true);
        this.src = LexerToken.parse((String)this.text);
    }

    public Range nodeRange(ParseNode node) {
        if (node == null) {
            boolean bl = true;
        }
        if (node.from == 0 && node.to == 0) {
            Position start = new Position(0, 0);
            return new Range(start, start);
        }
        int pos = -1;
        try {
            pos = this.src.get((int)node.from).begin;
        }
        catch (IndexOutOfBoundsException e) {
            pos = -1;
        }
        int line = Service.charPos2LineNo1((int[])this.lineMap, (int)pos);
        int lineStart = Service.lineNo2CharPos1((int[])this.lineMap, (int)line);
        Position start = new Position(line - 1, pos - lineStart);
        Position end = null;
        if (node.to == 0) {
            end = start;
        } else {
            pos = this.src.get((int)(node.to - 1)).end;
            line = Service.charPos2LineNo1((int[])this.lineMap, (int)pos);
            lineStart = Service.lineNo2CharPos1((int[])this.lineMap, (int)line);
            end = new Position(line - 1, pos - lineStart);
        }
        return new Range(start, end);
    }

    public String tokenAt(int pos) {
        return this.src.get((int)pos).content;
    }

    public static BackgroundParser factory(String input, String url, LanguageServer languageServer) throws IOException {
        if (((String)url).indexOf("\"") != 0) {
            url = "\"" + (String)url + "\"";
        }
        if (((String)url).endsWith(".dict\"")) {
            return new BackgroundDictParser(input, (String)url, languageServer);
        }
        if (((String)url).endsWith(".arbori\"") || ((String)url).endsWith(".prg\"")) {
            return new BackgroundArboriParser(input, (String)url, languageServer);
        }
        return new BackgroundSqlParser(input, (String)url, languageServer);
    }

    List<DocumentSymbol> filter(ParseNode node) {
        int pos = this.src.get((int)node.from).begin;
        int line = Service.charPos2LineNo1((int[])this.lineMap, (int)pos);
        int lineStart = Service.lineNo2CharPos1((int[])this.lineMap, (int)line);
        Position start = new Position(line - 1, pos - lineStart);
        Position end = new Position(line - 1, this.src.get((int)node.from).end - lineStart);
        Range range = new Range(start, end);
        LinkedList<DocumentSymbol> ret = new LinkedList<DocumentSymbol>();
        String label = this.label(node);
        if (label != null) {
            DocumentSymbol ds = new DocumentSymbol(label, range, this.kind(node));
            for (ParseNode child : node.children()) {
                ds.addChildren(this.filter(child));
            }
            ret.add(ds);
        } else {
            for (ParseNode child : node.children()) {
                ret.addAll(this.filter(child));
            }
        }
        return ret;
    }

    int kind(ParseNode node) {
        return DocumentSymbol.SymbolKind.Namespace.getValue();
    }

    public void documentBump() {
        this.languageServer.getLSP().documentBump(this);
    }

    public void failedCommand(ParseNode command, Throwable exception) {
        Throwable exc;
        Object exc2;
        int commandOffset;
        int from = command.from;
        this.waitForLexingFinish();
        LexerToken current = this.src.get(from);
        int errorOffset = commandOffset = current.begin;
        if (exception.getCause() instanceof OracleDatabaseException) {
            exc2 = (OracleDatabaseException)exception.getCause();
            errorOffset += exc2.getErrorPosition();
        }
        if (exception instanceof oracle.dbtools.arbori.ScriptException && !current.content.equalsIgnoreCase("include")) {
            exc2 = (oracle.dbtools.arbori.ScriptException)exception;
            errorOffset += exc2.offset;
        }
        int line = this.charPos2LineNo0(errorOffset);
        int offset = -1;
        if (exception instanceof ScriptException && !current.content.equalsIgnoreCase("include")) {
            exc = (ScriptException)exception;
            line += ((ScriptException)exc).getLineNumber() - 1;
            try {
                LexerToken t = LexerToken.getTokenAtCharOffset(this.src, (int)this.lineNo2CharPos0(line));
                offset = t.begin - this.lineNo2CharPos0(line);
            }
            catch (Exception e) {
                e.printStackTrace();
                LSP.Log.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if (exception instanceof oracle.dbtools.arbori.ScriptException && !current.content.equalsIgnoreCase("include")) {
            exc = (oracle.dbtools.arbori.ScriptException)exception;
            int localLine = ((ScriptException)exc.getCause()).getLineNumber();
            line += localLine - 1;
            try {
                LexerToken t = LexerToken.getTokenAtCharOffset(this.src, (int)this.lineNo2CharPos0(line));
                offset = t.begin - this.lineNo2CharPos0(line);
            }
            catch (Exception e) {
                e.printStackTrace();
                LSP.Log.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if (offset < 0) {
            offset = errorOffset - this.lineNo2CharPos0(line);
        }
        if (offset < 0) {
            offset = 0;
        }
        Position start = new Position(line, offset);
        Position end = new Position(line, offset + 3);
        Range range = new Range(start, end);
        this.diagnostics.add(new Diagnostics(range, exception.getMessage()));
    }

    public PublishDiagnosticsParams publishDiagnostics() {
        SyntaxError err = SyntaxError.checkSyntax((String)this.text, (String[])new String[]{this.topSymbol}, this.src, (Earley)this.earley, (Matrix)this.matrix);
        if (err != null) {
            Position start = new Position(err.line, err.offset);
            Position end = new Position(err.line, err.offset + 3);
            return new PublishDiagnosticsParams(this, new Diagnostics(new Range(start, end), err.getDetailedMessage()));
        }
        if (0 < this.diagnostics.size()) {
            return new PublishDiagnosticsParams(this, this.diagnostics.toArray(new Diagnostics[0]));
        }
        return new PublishDiagnosticsParams(this, new Diagnostics[0]);
    }

    public boolean isAlive(String connStr) {
        try {
            Object connection = this.languageServer.getConnection(OracleDictionary.parseConnectCommand(connStr));
            if (connection == null || !(connection instanceof Connection)) {
                return false;
            }
            return ((Connection)connection).isValid(1);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void recordSymbol(ParseNode symbol, ParseNode type) {
        this.getRegistry().recordSymbol(symbol, type, this);
    }

    public void recordSymbol(ParseNode symbol, String[] types) {
        this.getRegistry().recordSymbol(symbol, types, this);
    }

    public void recordSymbol(ParseNode symbol, String type, int declaration) {
        this.getRegistry().recordSymbol(symbol, type, declaration, this);
    }

    public TableRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(TableRenderer newValue) {
        this.renderer = newValue;
    }

    public abstract String label(ParseNode var1);

    public abstract String semanticActionsFile();

    public abstract Completer getCompleter();

    public String toString() {
        return this.getClass().getName() + "@" + this.objRef;
    }
}

