/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.data.validators;

import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Locale;
import oracle.dbtools.data.model.Column;
import oracle.dbtools.data.validators.BaseValidator;
import oracle.dbtools.raptor.nls.NLSProvider;
import oracle.dbtools.raptor.nls.OraDATEFormat;
import oracle.dbtools.raptor.nls.OraTIMESTAMPFormat;
import oracle.dbtools.raptor.nls.OraTIMESTAMPLTZFormat;
import oracle.dbtools.raptor.nls.OraTIMESTAMPTZFormat;
import oracle.dbtools.raptor.nls.OracleNLSProvider;
import oracle.i18n.util.OraLocaleInfo;
import oracle.sql.DATE;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

public class DateValidator
extends BaseValidator {
    @Override
    public boolean validateData(Column c, Object data) {
        boolean result;
        block11: {
            if (data == null || data.toString().isEmpty()) {
                return c.isNullable();
            }
            result = false;
            try {
                OraDATEFormat format;
                String dataStr;
                String fmt = c.getFormat();
                if (fmt != null) {
                    fmt = fmt.replaceAll("\"", "");
                }
                if (data == null || (dataStr = data.toString()).length() <= 0 || dataStr.equals("NULL")) break block11;
                if (c.getType().equalsIgnoreCase("TIMESTAMP")) {
                    OraTIMESTAMPFormat format2 = fmt == null || fmt.length() == 0 ? ((OracleNLSProvider)NLSProvider.getProvider(this.m_connection)).getOraTIMESTAMPFormat() : new OraTIMESTAMPFormat(fmt, OraLocaleInfo.getInstance((Locale)this.getLocale()));
                    TIMESTAMP tst = format2.parse(dataStr, new ParsePosition(0));
                    result = true;
                    break block11;
                }
                if (c.getType().equalsIgnoreCase("TIMESTAMP WITH TIME ZONE")) {
                    OraTIMESTAMPTZFormat format3 = fmt == null || fmt.length() == 0 ? ((OracleNLSProvider)NLSProvider.getProvider(this.m_connection)).getOraTIMESTAMPTZFormat() : new OraTIMESTAMPTZFormat(fmt, OraLocaleInfo.getInstance((Locale)this.getLocale()));
                    TIMESTAMPTZ tstz = format3.parse(dataStr, new ParsePosition(0));
                    result = true;
                    break block11;
                }
                if (c.getType().equalsIgnoreCase("TIMESTAMP WITH LOCAL TIME ZONE")) {
                    OracleNLSProvider nlsProvider = (OracleNLSProvider)NLSProvider.getProvider(this.m_connection);
                    OraTIMESTAMPLTZFormat format4 = fmt == null || fmt.length() == 0 ? nlsProvider.getOraTIMESTAMPLTZFormat() : new OraTIMESTAMPLTZFormat(fmt, OraLocaleInfo.getInstance((Locale)this.getLocale()), nlsProvider.getTimeZone(nlsProvider.getDBTimeZone()), nlsProvider.getSessionTimeZone());
                    TIMESTAMPLTZ tst = format4.parse(dataStr, new ParsePosition(0));
                    result = true;
                    break block11;
                }
                if (fmt == null || fmt.length() == 0) {
                    try {
                        format = ((OracleNLSProvider)NLSProvider.getProvider(this.m_connection)).getOraDATEFormat();
                    }
                    catch (ParseException pe) {
                        format = null;
                    }
                } else {
                    format = new OraDATEFormat(fmt, OraLocaleInfo.getInstance((Locale)this.getLocale()));
                }
                DATE tst = format.parse(dataStr, new ParsePosition(0));
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return result;
    }
}

