/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.data.model;

import java.util.ArrayList;
import java.util.List;

public enum DataType {
    VARCHAR2("VARCHAR2"),
    NUMBER("NUMBER"),
    INTEGER("INTEGER"),
    FLOAT("FLOAT"),
    CHAR("CHAR"),
    DATE("DATE"),
    TIMESTAMP("TIMESTAMP"),
    TIMESTAMPTZ("TIMESTAMP WITH TIME ZONE"),
    TIMESTAMPLTZ("TIMESTAMP WITH LOCAL TIME ZONE"),
    NCHAR("NCHAR"),
    NVARCHAR2("NVARCHAR2");

    private static final String[] DATE_MASKS;
    private static final String[] TIMESTAMP_MASKS;
    private static final String[] TIMESTAMPTZ_MASKS;
    private String m_label;

    private DataType(String label) {
        this.m_label = label;
    }

    public String toString() {
        return this.m_label;
    }

    public static List<String> getValuesAsList() {
        ArrayList<String> l = new ArrayList<String>();
        for (DataType d : DataType.values()) {
            l.add(d.toString());
        }
        return l;
    }

    public String[] getMasksAsArray() {
        switch (this.ordinal()) {
            case 5: {
                return DATE_MASKS;
            }
            case 6: {
                return TIMESTAMP_MASKS;
            }
            case 7: {
                return TIMESTAMPTZ_MASKS;
            }
            case 8: {
                return TIMESTAMP_MASKS;
            }
        }
        return new String[0];
    }

    static {
        DATE_MASKS = new String[]{"RRRR-MM-DD", "RR-MM-DD", "RRRR-MON-DD", "RR-MON-DD", "YYYY-MM-DD", "YY-MM-DD", "YYYY-MON-DD", "YY-MON-DD"};
        TIMESTAMP_MASKS = new String[]{"YYYY-MM-DD HH24:MI:SS.FF"};
        TIMESTAMPTZ_MASKS = new String[]{"YYYY-MM-DD HH24:MI:SS.FF TZH:TZM", "YYYY-MM-DD HH24:MI:SS.FF TZR"};
    }
}

