/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.data.formattors;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParsePosition;
import oracle.dbtools.data.formattors.BaseFormattor;
import oracle.dbtools.data.model.Column;
import oracle.dbtools.raptor.nls.NLSProvider;
import oracle.dbtools.raptor.nls.OracleNLSProvider;

public class NumberFormattor
extends BaseFormattor {
    Character _nlsDecimalSeparator;

    public void setNlsDecimalSeparator(Character nlsDecimalSeparator) {
        this._nlsDecimalSeparator = nlsDecimalSeparator;
    }

    @Override
    public String formatColumn(Column col) {
        String result = null;
        result = this.addDoubleQuote(col.getName()) + " " + col.getType();
        if (col.getName() != null && this.isPrecisionAllowed() && col.getPrecision() > 0) {
            result = col.getScale() > 0 ? result + "(" + col.getPrecision() + ", " + col.getScale() + ")" : result + "(" + col.getPrecision() + ")";
        }
        if (col.getDefault() != null && col.getDefault().trim().length() > 0) {
            result = result + " DEFAULT " + col.getDefault();
        }
        if (!col.isNullable()) {
            result = result + " NOT NULL";
        }
        return result;
    }

    @Override
    public String formatData(Object data, Column c) {
        Object result = "NULL";
        String dataStr = data.toString();
        DecimalFormat fmt = null;
        ParsePosition pp = new ParsePosition(0);
        fmt = this._l != null ? (DecimalFormat)DecimalFormat.getInstance(this._l) : (DecimalFormat)DecimalFormat.getInstance();
        if (this._nlsDecimalSeparator != null && fmt instanceof DecimalFormat) {
            DecimalFormatSymbols symbols = fmt.getDecimalFormatSymbols();
            symbols.setDecimalSeparator(this._nlsDecimalSeparator.charValue());
            fmt.setDecimalFormatSymbols(symbols);
        }
        try {
            fmt.setParseBigDecimal(true);
            result = ((BigDecimal)fmt.parse(dataStr, pp)).toPlainString();
        }
        catch (Exception e) {
            return dataStr;
        }
        if (pp.getIndex() < dataStr.length()) {
            return dataStr;
        }
        if (((String)result).length() == 0) {
            return "NULL";
        }
        return result;
    }

    public String formatDataSave(Object data, Column c) {
        Object result = "NULL";
        if (data != null) {
            String dataStr = data.toString();
            NumberFormat fmt = null;
            ParsePosition pp = new ParsePosition(0);
            fmt = this._l != null ? NumberFormat.getInstance(this._l) : NumberFormat.getInstance();
            try {
                result = c.getPrecision() > 0 && c.getScale() > 0 || c.getPrecision() == 0 && c.getScale() == 0 || this.isScaleImported() ? "" + fmt.parse(dataStr, pp).doubleValue() : "" + fmt.parse(dataStr, pp).longValue();
            }
            catch (Exception e) {
                result = dataStr;
            }
            if (pp.getIndex() < dataStr.length()) {
                return dataStr;
            }
        }
        if (((String)result).length() == 0) {
            return "NULL";
        }
        return result;
    }

    @Override
    public Object formatDataForJava(Object data, Column c) throws Exception {
        this.setNlsDecimalSeparator(Character.valueOf(((OracleNLSProvider)NLSProvider.getProvider(this.m_connection)).getDecimalSeparator()));
        String num = this.formatData(data, c);
        if (this.m_connection != null && num != null) {
            String decChar = "" + ((OracleNLSProvider)NLSProvider.getProvider(this.m_connection)).getDecimalSeparator();
            num = num.replace(".", decChar);
        }
        return num;
    }

    @Override
    public int getSqlType(String type) {
        if (type.equals("NUMBER")) {
            return 2;
        }
        if (type.equals("INTEGER")) {
            return 4;
        }
        if (type.equals("LONG")) {
            return 8;
        }
        if (type.equals("FLOAT")) {
            return 6;
        }
        return 2;
    }
}

