/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import oracle.dbtools.core.io.file.HomeFolder;

public final class PlatformUtils {
    private static String _osName;
    private static String _osVersion;
    public static final int OS_UNKNOWN = 0;
    public static final int OS_LINUX = 1;
    public static final int OS_MAC = 2;
    public static final int OS_MAC_PANTHER = 3;
    public static final int OS_MAC_TIGER = 4;
    public static final int OS_MAC_LEOPARD = 5;
    public static final int OS_MAC_SNOW_LEOPARD = 6;
    public static final int OS_MAC_LION = 7;
    public static final int OS_MAC_MOUNTAIN_LION = 8;
    public static final int OS_MAC_MAVERICKS = 9;
    public static final int OS_WINDOWS = 10;
    public static final int OS_WINDOWS_NT = 11;
    public static final int OS_WINDOWS_2K = 12;
    public static final int OS_WINDOWS_XP = 13;
    private static final int OS_WINDOWS_VISTA = 14;
    private static final int OS_WINDOWS_7 = 15;
    private static final int OS_WINDOWS_8 = 16;
    private static int _platform;
    private static boolean caseSensitiveFileSystem;

    public static String osName() {
        return _osName;
    }

    public static String osVersion() {
        return _osVersion;
    }

    public static int getPlatform() {
        return _platform;
    }

    public static boolean isCaseSensitiveFileSystem() {
        return caseSensitiveFileSystem;
    }

    public static boolean isKnown() {
        return _platform != 0;
    }

    public static boolean isLinux() {
        return _platform == 1;
    }

    public static boolean isMac() {
        return _platform >= 2 && _platform < 10;
    }

    public static boolean isMacPanther() {
        return _platform == 3;
    }

    public static boolean isMacTiger() {
        return _platform == 4;
    }

    public static boolean isMacLeopard() {
        return _platform == 5;
    }

    public static boolean isMacSnowLeopard() {
        return _platform == 6;
    }

    public static boolean isMacLion() {
        return _platform == 7;
    }

    public static boolean isMacMountainLion() {
        return _platform == 8;
    }

    public static boolean isMacMavericks() {
        return _platform == 9;
    }

    public static boolean isWindows() {
        return _platform >= 10;
    }

    public static boolean isWindowsNT() {
        return _platform == 11;
    }

    public static boolean isWindows2K() {
        return _platform == 12;
    }

    public static boolean isWindowsXP() {
        return _platform == 13;
    }

    public static boolean isWindowsVista() {
        return _platform == 14;
    }

    public static boolean isWindows7() {
        return _platform == 15;
    }

    public static boolean isWindows8() {
        return _platform == 16;
    }

    public static boolean isAtLeastMacPanther() {
        return _platform >= 3 && _platform < 10;
    }

    public static boolean isAtLeastMacTiger() {
        return _platform >= 4 && _platform < 10;
    }

    public static boolean isAtLeastWindowsNT() {
        return _platform >= 11;
    }

    public static boolean isAtLeastWindows2K() {
        return _platform >= 12;
    }

    public static boolean isAtLeastWindowsXP() {
        return _platform >= 13;
    }

    public static boolean isAtLeastWindowsVista() {
        return _platform >= 14;
    }

    public static boolean isAtLeastWindows7() {
        return _platform >= 15;
    }

    public static boolean isAtLeastWindows8() {
        return _platform >= 16;
    }

    public static Path getSharedConfigDirectory() {
        return HomeFolder.ofSystem().path();
    }

    static {
        String lower;
        _platform = 0;
        _osName = System.getProperty("os.name");
        if (_osName == null) {
            _osName = "";
        }
        if ((_osVersion = System.getProperty("os.version")) == null) {
            _osVersion = "";
        }
        if ((lower = _osName.toLowerCase()).startsWith("linux")) {
            _platform = 1;
        } else if (lower.startsWith("mac os x")) {
            _platform = _osVersion.startsWith("10.9") ? 9 : (_osVersion.startsWith("10.8") ? 8 : (_osVersion.startsWith("10.7") ? 7 : (_osVersion.startsWith("10.6") ? 6 : (_osVersion.startsWith("10.5") ? 5 : (_osVersion.startsWith("10.4") ? 4 : (_osVersion.startsWith("10.3") ? 3 : 2))))));
        } else if (lower.startsWith("windows")) {
            _platform = lower.startsWith("windows xp") ? 13 : (lower.startsWith("windows 2000") ? 12 : (lower.startsWith("windows nt") ? 11 : (lower.startsWith("windows vista") ? 14 : (lower.startsWith("windows 7") ? 15 : (lower.startsWith("windows 8") ? 16 : 10)))));
        }
        try {
            File tempFile = File.createTempFile("ABC", null);
            tempFile.deleteOnExit();
            caseSensitiveFileSystem = !new File(tempFile.getPath().toLowerCase()).exists();
        }
        catch (IOException ioe) {
            caseSensitiveFileSystem = !new File("A").equals(new File("a"));
        }
    }
}

