/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app.injection;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import oracle.dbtools.app.injection.SqlInjectionGraph;
import oracle.dbtools.app.injection.ValueNode;
import oracle.dbtools.parser.Parser;

public class VerifyValueNodeTypes {
    private Parser parser;
    HashMap<String, Integer> tokenInt;
    private Parser.Tuple[] sortedRules;
    private final SqlInjectionGraph.DispatchInfo[] dispatch;
    private HashMap<Integer, ValueNode.ValueType> tokenTypesDeclared;
    private HashMap<Integer, ValueNode.ValueType> tokenTypesInferred;
    private HashMap<Integer, String> tokenTypeSource;
    private Set<Integer> plsqlTokens;
    private Deque<Integer> plsqlTokensToInfer;
    Set<String> bogusSymbols;
    HashSet<Integer> recursiveInfer = new HashSet();

    public VerifyValueNodeTypes(Parser parser, HashMap<String, Integer> tokenInt, Parser.Tuple[] sortedRules, SqlInjectionGraph.DispatchInfo[] dispatch, HashMap<Integer, ValueNode.ValueType> tokenTypesDeclared) {
        this.parser = parser;
        this.tokenInt = tokenInt;
        this.sortedRules = sortedRules;
        this.dispatch = dispatch;
        this.tokenTypesDeclared = tokenTypesDeclared;
        this.tokenTypesInferred = new HashMap(parser.allSymbols.length);
        this.tokenTypeSource = new HashMap(parser.allSymbols.length);
        this.plsqlTokens = new HashSet<Integer>();
        this.plsqlTokensToInfer = new ArrayDeque<Integer>();
        for (String token : new String[]{"compilation_unit"}) {
            int tok = tokenInt.get(token);
            this.plsqlTokens.add(tok);
            this.plsqlTokensToInfer.addLast(tok);
        }
        this.bogusSymbols = new HashSet<String>(Arrays.asList(parser.allSymbols));
    }

    HashMap<Integer, ValueNode.ValueType> inferTypes() throws IllegalStateException {
        for (Parser.Tuple tuple : this.sortedRules) {
            String head = this.parser.allSymbols[tuple.head];
            if (tuple.rhs.length > 0) {
                this.bogusSymbols.remove(head);
                continue;
            }
            if (!head.contains("'")) continue;
            this.bogusSymbols.remove(head);
            this.tokenTypesDeclared.put(tuple.head, ValueNode.ValueType.TOKENNODE);
        }
        for (Parser.Tuple tuple : new String[]{"digits", "identifier", "alternatively_quoted_nonnative_string_literal", "alternatively_quoted_string_literal", "COMMENT_literal_opt", "datetime_literal", "ext_tbl_string_literal", "interval_literal", "interval_literal_qualifier", "level_member_literal", "literal", "literal_list", "number_literal", "nonnative_string_literal", "static_or_string_literal", "string_literal"}) {
            this.bogusSymbols.remove(tuple);
            int tok = this.tokenInt.get(tuple);
            ValueNode.ValueType declType = this.tokenTypesDeclared.get(tok);
            if (declType == null) {
                this.tokenTypesInferred.put(tok, ValueNode.ValueType.TOKENNODE);
                this.tokenTypeSource.put(tok, "returned by tokenizer");
                continue;
            }
            this.tokenTypesInferred.put(tok, declType);
            this.tokenTypeSource.put(tok, "explicitly declared");
        }
        for (String bogus : this.bogusSymbols) {
            this.tokenTypesInferred.put(this.tokenInt.get(bogus), ValueNode.ValueType.BOGUS_SYMBOL);
            this.tokenTypeSource.put(this.tokenInt.get(bogus), "bogus symbol");
        }
        System.out.println("Propagating types...");
        while (!this.plsqlTokensToInfer.isEmpty()) {
            int token = this.plsqlTokensToInfer.pollFirst();
            assert (this.plsqlTokens.contains(token));
            if (this.tokenTypesInferred.get(token) != null) continue;
            this.inferTokenType(token);
        }
        for (int tok : this.tokenTypesDeclared.keySet()) {
            ValueNode.ValueType declType = this.tokenTypesDeclared.get(tok);
            ValueNode.ValueType valueType = this.tokenTypesInferred.put(tok, declType);
            if (valueType == null || valueType == declType) continue;
            throw new IllegalStateException("token " + this.parser.allSymbols[tok] + " inferred " + String.valueOf((Object)valueType) + " but declared " + String.valueOf((Object)declType) + " source " + this.tokenTypeSource.get(tok));
        }
        if (Debug.STATS.debug) {
            int nullCount = 0;
            int[] typeCounts = new int[ValueNode.ValueType.values().length];
            for (int tok = 0; tok < this.parser.allSymbols.length; ++tok) {
                ValueNode.ValueType valueType = this.tokenTypesInferred.get(tok);
                if (valueType == null) {
                    ++nullCount;
                    continue;
                }
                int n = valueType.ordinal();
                typeCounts[n] = typeCounts[n] + 1;
            }
            System.out.println("Token type stats:");
            for (ValueNode.ValueType type : ValueNode.ValueType.values()) {
                System.out.println(String.format("%2$5d %1s", new Object[]{type, typeCounts[type.ordinal()]}));
            }
            System.out.println(String.format("%2$5d %1s", "Null", nullCount));
            System.out.println(String.format("%2$5d %1s", "Plsql tokens", this.plsqlTokens.size()));
        }
        return this.tokenTypesInferred;
    }

    /*
     * Could not resolve type clashes
     */
    private ValueNode.ValueType inferTokenType(int token) {
        if (Debug.TYPE_INFERENCE.debug || Debug.INTERESTING_TOKENS.debug && this.interestingToken(token)) {
            String tokStr = this.parser.allSymbols[token];
            System.out.print("Inferring " + tokStr);
            System.out.println();
        }
        ValueNode.ValueType declType = this.tokenTypesDeclared.get(token);
        if (this.recursiveInfer.contains(token)) {
            if (Debug.TYPE_INFERENCE.debug) {
                System.out.println("Loop on " + this.parser.allSymbols[token]);
            }
            return null;
        }
        this.recursiveInfer.add(token);
        ValueNode.ValueType inferredType = null;
        boolean hasConflictedRule = false;
        int rulesInferred = 0;
        HashMap<ValueNode.ValueType, Integer> typeSource = new HashMap<ValueNode.ValueType, Integer>();
        int rulesDispatched = 0;
        int rulesNonBogus = 0;
        Parser parser = this.parser;
        Objects.requireNonNull(parser);
        int ruleIdx = Arrays.binarySearch(this.sortedRules, new Parser.Tuple(parser, token, new int[0]));
        int n = ruleIdx = ruleIdx >= 0 ? ruleIdx : -(ruleIdx + 1);
        assert (this.sortedRules[ruleIdx].head == token);
        while (ruleIdx < this.sortedRules.length && this.sortedRules[ruleIdx].head == token) {
            block51: {
                Parser.Tuple rule = this.sortedRules[ruleIdx];
                for (int tok : rule.rhs) {
                    if (!this.bogusSymbols.contains(this.parser.allSymbols[tok])) {
                        if (!this.plsqlTokens.add(tok)) continue;
                        this.plsqlTokensToInfer.addFirst(tok);
                        continue;
                    }
                    break block51;
                }
                ++rulesNonBogus;
                if (this.dispatch[ruleIdx] != null) {
                    ++rulesDispatched;
                    if (declType == null) {
                        throw new IllegalStateException(String.valueOf(rule) + " has dispatch but not declared type");
                    }
                } else {
                    Object type;
                    int n2;
                    Object inferredFromRule;
                    ValueNode.ValueType[] types = new ValueNode.ValueType[rule.rhs.length];
                    for (int i = 0; i < rule.rhs.length; ++i) {
                        int tok = rule.rhs[i];
                        ValueNode.ValueType tokType = this.tokenTypesDeclared.get(tok);
                        if (tokType == null) {
                            tokType = this.tokenTypesInferred.get(tok);
                        }
                        if (tokType == null && tok != rule.head) {
                            tokType = this.inferTokenType(tok);
                            if (tokType == ValueNode.ValueType.BOGUS_SYMBOL) {
                                if (Debug.RECURSIVE_BOGUS.debug) {
                                    System.out.println("Token " + this.parser.allSymbols[rule.rhs[i]] + " went BOGUS during rule " + String.valueOf(rule));
                                }
                                --rulesNonBogus;
                                break block51;
                            }
                            types[i] = tokType;
                            if (tokType == null && Debug.TYPE_INFERENCE.debug) {
                                System.out.println("Null type for " + this.parser.allSymbols[tok] + " in rule " + String.valueOf(rule));
                            }
                        }
                        if (tokType == ValueNode.ValueType.CONFLICTED) {
                            if (Debug.TYPE_INFERENCE.debug || Debug.SHOW_CONFLICTED.debug) {
                                System.out.println(">< " + this.parser.allSymbols[tok] + " CONFLICTED rule " + String.valueOf(rule));
                            }
                            hasConflictedRule = true;
                            this.dispatch[ruleIdx] = SqlInjectionGraph.conflictedDispatch(this.dispatch[ruleIdx], "Token " + this.parser.allSymbols[tok] + " in " + rule.toString());
                            break block51;
                        }
                        types[i] = tokType;
                    }
                    try {
                        if (rule.rhs.length == 0) {
                            inferredFromRule = ValueNode.ValueType.TOKENNODE;
                            assert (this.parser.allSymbols[token].contains("'") || this.tokenTypesDeclared.get(token) == ValueNode.ValueType.TOKENNODE);
                        } else if (rule.rhs.length == 1) {
                            inferredFromRule = types[0];
                        } else {
                            inferredFromRule = this.parseMergeValueTypes(types);
                            if ((Debug.INFERENCE_TREE.debug || Debug.SHOW_CONFLICTED.debug) && inferredFromRule == ValueNode.ValueType.CONFLICTED) {
                                if (Debug.INFERENCE_TREE.debug) {
                                    this.printInferenceTree(rule.head, 1);
                                }
                                System.out.println("CONFLICTED from #" + ruleIdx + " " + String.valueOf(rule));
                                System.out.print("types=[");
                                ValueNode.ValueType[] tok = types;
                                int n3 = tok.length;
                                for (n2 = 0; n2 < n3; ++n2) {
                                    type = tok[n2];
                                    System.out.print(String.valueOf(type) + ", ");
                                }
                                System.out.println("]");
                            }
                        }
                        ++rulesInferred;
                    }
                    catch (IllegalStateException e) {
                        if (Debug.INFERENCE_TREE.debug) {
                            this.printInferenceTree(rule.head, 1);
                        }
                        throw new IllegalStateException("Inconsistent types from " + String.valueOf(rule), e);
                    }
                    typeSource.put((ValueNode.ValueType)((Object)inferredFromRule), ruleIdx);
                    if (this.interestingToken(token)) {
                        System.out.println("  " + String.valueOf(rule));
                        System.out.print("  types=[");
                        Object e = types;
                        int n4 = ((Object)e).length;
                        for (n2 = 0; n2 < n4; ++n2) {
                            type = e[n2];
                            System.out.print(String.valueOf(type) + ", ");
                        }
                        System.out.print("] ==> " + String.valueOf(inferredFromRule));
                        System.out.println();
                    }
                    if (inferredType == null) {
                        inferredType = inferredFromRule;
                    } else {
                        ValueNode.ValueType prev_inferred_type = inferredType;
                        inferredType = ValueNode.ValueType.inferCompatibleType(true, new ValueNode.ValueType[]{inferredType, inferredFromRule});
                        if (this.interestingToken(token)) {
                            System.out.print("  " + String.valueOf((Object)prev_inferred_type) + " + " + String.valueOf(inferredFromRule) + " = " + String.valueOf((Object)inferredType));
                            System.out.println();
                        }
                        if (inferredType == null) {
                            if (Debug.INFERENCE_TREE.debug) {
                                this.printInferenceTree(rule.head, 1);
                            }
                            throw new IllegalStateException("Inconsistent: (" + String.valueOf((Object)prev_inferred_type) + ", " + String.valueOf(inferredFromRule) + ") = null for " + String.valueOf(rule));
                        }
                        if (inferredType != prev_inferred_type) {
                            typeSource.put(prev_inferred_type, ruleIdx);
                        }
                    }
                    typeSource.put(inferredType, ruleIdx);
                }
            }
            ++ruleIdx;
        }
        if (rulesNonBogus == 0) {
            assert (inferredType == null);
            if (Debug.RECURSIVE_BOGUS.debug) {
                System.out.println("Recursively BOGUS non-terminal: " + this.parser.allSymbols[token]);
            }
            this.bogusSymbols.add(this.parser.allSymbols[token]);
            inferredType = ValueNode.ValueType.BOGUS_SYMBOL;
        }
        if (inferredType == null && hasConflictedRule) {
            inferredType = ValueNode.ValueType.CONFLICTED;
        }
        if (inferredType == ValueNode.ValueType.TOKENNODE && declType == null && hasConflictedRule) {
            inferredType = ValueNode.ValueType.CONFLICTED;
        }
        if (declType == null) {
            if (Debug.TYPE_INFERENCE.debug) {
                System.out.println(">" + String.valueOf((Object)inferredType) + " " + this.parser.allSymbols[token]);
            }
            if (inferredType == null) {
                System.out.println("rulesDispatched=" + rulesDispatched + " rulesInferred=" + rulesInferred + " rulesNonBogus=" + rulesNonBogus);
                assert (inferredType != null);
            }
        } else {
            if (ValueNode.ValueType.inferCompatibleType(true, inferredType, declType) != declType) {
                String msg = "Non-dispatched symbol " + this.parser.allSymbols[token] + " declared:" + String.valueOf((Object)declType) + " inferred:" + String.valueOf((Object)inferredType);
                typeSource.put(inferredType, ruleIdx);
                for (Map.Entry entry : typeSource.entrySet()) {
                    msg = msg + System.lineSeparator() + String.valueOf(entry.getKey()) + " <- " + SqlInjectionGraph.tupleToString(this.sortedRules[(Integer)entry.getValue()], this.parser);
                }
                throw new IllegalStateException(msg);
            }
            inferredType = declType;
        }
        this.tokenTypesInferred.put(token, inferredType);
        this.tokenTypeSource.put(token, "inferTokenType(" + token + ") succeeded");
        this.recursiveInfer.remove(token);
        if (Debug.INTERESTING_TOKENS.debug && this.interestingToken(token)) {
            for (Map.Entry entry : typeSource.entrySet()) {
                System.out.println(String.valueOf(entry.getKey()) + " <- " + SqlInjectionGraph.tupleToString(this.sortedRules[(Integer)entry.getValue()], this.parser));
            }
            System.out.println("Token " + this.parser.allSymbols[token] + " inferred as " + String.valueOf((Object)inferredType));
        }
        return inferredType;
    }

    private ValueNode.ValueType parseMergeValueTypes(ValueNode.ValueType[] types) throws IllegalStateException {
        boolean inconsistent = false;
        int count = 0;
        ValueNode.ValueType retType = null;
        ValueNode.ValueType fallback = null;
        for (ValueNode.ValueType type : types) {
            if (type == null || type == ValueNode.ValueType.NULLNODE) continue;
            if (type == ValueNode.ValueType.TOKENNODE) {
                fallback = type;
                continue;
            }
            if (++count == 1) {
                retType = type;
                continue;
            }
            assert (type != null);
            assert (retType != null);
            retType = ValueNode.ValueType.inferCompatibleType(false, type, retType);
            if (!inconsistent) continue;
            Object error = "Inconsistent types for parseMergeValueNodes:";
            for (ValueNode.ValueType t : types) {
                error = (String)error + " " + String.valueOf((Object)t);
            }
            return ValueNode.ValueType.CONFLICTED;
        }
        if (count == 0) {
            retType = fallback;
        }
        return retType;
    }

    void printInferenceTree(EnumSet<ValueNode.ValueType> types, int tok, int depth, int maxdepth, Set<Integer> printed) {
        if (depth > maxdepth) {
            return;
        }
        if (types == null) {
            types = EnumSet.allOf(ValueNode.ValueType.class);
        }
        if (printed == null) {
            printed = new HashSet<Integer>();
        }
        printed.add(tok);
        String indent = String.join((CharSequence)"", Collections.nCopies(depth, ": "));
        for (Parser.Tuple rule : this.sortedRules) {
            if (rule.head != tok) continue;
            String declared = "(declared)";
            ValueNode.ValueType tokType = this.tokenTypesDeclared.get(tok);
            if (tokType == null) {
                tokType = this.tokenTypesInferred.get(tok);
                declared = "";
            }
            if (!types.contains((Object)tokType) && tokType != null) continue;
            System.out.println(indent + String.valueOf((Object)tokType) + declared + " " + rule.toString().replaceAll("  *", " "));
            for (int subtok : rule.rhs) {
                if (printed.contains(subtok)) continue;
                this.printInferenceTree(types, subtok, depth + 1, maxdepth, printed);
            }
        }
        System.out.flush();
    }

    void printInferenceTree(int tok, int maxdepth) {
        this.printInferenceTree(null, tok, 0, maxdepth, null);
    }

    private boolean interestingToken(int tok) {
        if (!Debug.INTERESTING_TOKENS.debug) {
            return false;
        }
        for (Object interesting : Debug.INTERESTING_TOKENS.parms) {
            if (!this.parser.allSymbols[tok].equals(interesting)) continue;
            return true;
        }
        return false;
    }

    public static enum Debug {
        TYPE_INFERENCE(false),
        INFERENCE_TREE(false),
        SHOW_CONFLICTED(false),
        RECURSIVE_BOGUS(false),
        INTERESTING_TOKENS(false, "unlabeled_nonblock_stmt"),
        STATS(true);

        boolean debug = false;
        Object[] parms;

        private Debug(boolean debug) {
        }

        private Debug(boolean debug, Object ... parms) {
            this.parms = parms;
        }
    }
}

