/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.arbori.MaterializedPredicate;
import oracle.dbtools.arbori.Program;
import oracle.dbtools.arbori.SqlProgram;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.Lexer;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.raptor.utils.MessageLogging;
import oracle.dbtools.util.Service;

public class Format {
    public final String formatWhenSyntaxError = "formatWhenSyntaxError";
    public final String parseForwardAndBackward = "parseForwardAndBackward";
    public final String singleLineComments = "singleLineComments";
    public final String kwCase = "kwCase";
    public final String idCase = "idCase";
    public final String adjustCaseOnly = "adjustCaseOnly";
    public final String removeDoubleQuotes = "removeDoubleQuotes";
    public final String formatThreshold = "formatThreshold";
    public final String alignTabColAliases = "alignTabColAliases";
    public final String alignTypeDecl = "alignTypeDecl";
    public final String alignNamedArgs = "alignNamedArgs";
    public final String alignAssignments = "alignAssignments";
    public final String alignEquality = "alignEquality";
    public final String alignRight = "alignRight";
    public final String identSpaces = "identSpaces";
    public final String useTab = "useTab";
    public final String breaksComma = "breaksComma";
    public final String breaksProcArgs = "breaksProcArgs";
    public final String breaksConcat = "breaksConcat";
    public final String breaksAroundLogicalConjunctions = "breaksAroundLogicalConjunctions";
    public final String breaksAfterSelect = "breaksAfterSelect";
    public final String commasPerLine = "commasPerLine";
    public final String breakOnSubqueries = "breakOnSubqueries";
    public final String breakAnsiiJoin = "breakAnsiiJoin";
    public final String breakParenCondition = "breakParenCondition";
    public final String maxCharLineSize = "maxCharLineSize";
    public final String forceLinebreaksBeforeComment = "forceLinebreaksBeforeComment";
    public final String extraLinesAfterSignificantStatements = "extraLinesAfterSignificantStatements";
    public final String flowControl = "flowControl";
    public final String spaceAroundOperators = "spaceAroundOperators";
    public final String spaceAfterCommas = "spaceAfterCommas";
    public final String spaceAroundBrackets = "spaceAroundBrackets";
    public final String formatProgramURL = "formatProgramURL";
    public final Map<String, Object> options = new HashMap<String, Object>(){

        @Override
        public Object put(String key, Object value) {
            Format.this.programInstance = null;
            return super.put(key, value);
        }
    };
    public int inputPos = -1;
    public int outputPos = -1;
    final String path = "/oracle/dbtools/app/";
    SqlProgram programInstance = null;
    final int unary_add_op = SqlEarley.getInstance().getSymbol("unary_add_op");
    final int sql_statement = SqlEarley.getInstance().getSymbol("sql_statement");
    final int numeric_literal = SqlEarley.getInstance().getSymbol("numeric_literal");
    final int exp = SqlEarley.getInstance().getSymbol("\".exp.\"");
    public static boolean reportedNoJSEngineAvailable = false;
    Map<Integer, Integer> posDepths = new HashMap<Integer, Integer>();
    Map<Integer, String> newlinePositions = new HashMap<Integer, String>();
    public Map<String, String> casedIds = new HashMap<String, String>();
    public Map<String, Integer> maxIdLengthInScope = new HashMap<String, Integer>();
    public Map<Integer, String> ids2scope = new HashMap<Integer, String>();
    public Map<Integer, Integer> ids2interval = new HashMap<Integer, Integer>();
    public Map<Integer, Integer> ids2adjustments = new HashMap<Integer, Integer>();
    public Set<Integer> skipWSPositions = new HashSet<Integer>();
    public Set<Integer> unformattedPositions = new HashSet<Integer>();
    ParseNode priorProc;
    int argNum = 1;
    ParseNode priorScope;
    int cNum = 1;

    public static void main(String[] args) throws Exception {
        String input = null;
        if (1 == args.length) {
            input = args[0].endsWith(".sql") || args[0].endsWith(".pkgbdy") ? Service.readFile((String)args[0]) : args[0];
        }
        long t0 = System.currentTimeMillis();
        Program.timing = 10000 < input.length();
        Format format = new Format(){};
        String output = format.format(input);
        if (input.length() < 100000) {
            System.out.println("----------------- output: ------------------");
            System.out.println(output);
        }
    }

    private static void checkContentMatch(String input, String output) {
        List srcI = Lexer.parse((String)input, (boolean)true);
        List srcO = Lexer.parse((String)output, (boolean)true);
        int i = 0;
        int j = 0;
        while (i < srcI.size() && j < srcO.size()) {
            LexerToken tI = (LexerToken)srcI.get(i);
            if (tI.type == Token.WS) {
                ++i;
                continue;
            }
            LexerToken tO = (LexerToken)srcO.get(j);
            if (tO.type == Token.WS) {
                ++j;
                continue;
            }
            if (!tI.content.toLowerCase().equals(tO.content.toLowerCase())) {
                System.err.println("i=" + i + "   " + tI.content + "!=" + tO.content);
                return;
            }
            ++i;
            ++j;
        }
        System.out.println("*** content matches ***");
    }

    public Format() {
        this.setDefaultOptions();
    }

    public void setDefaultOptions() {
        this.options.put("formatWhenSyntaxError", true);
        this.options.put("parseForwardAndBackward", true);
        this.options.put("singleLineComments", (Object)InlineComments.CommentsUnchanged);
        this.options.put("kwCase", (Object)Case.UPPER);
        this.options.put("idCase", (Object)Case.lower);
        this.options.put("adjustCaseOnly", false);
        this.options.put("removeDoubleQuotes", false);
        this.options.put("formatThreshold", 1);
        this.options.put("alignTabColAliases", true);
        this.options.put("alignTypeDecl", true);
        this.options.put("alignNamedArgs", true);
        this.options.put("alignEquality", false);
        this.options.put("alignAssignments", false);
        this.options.put("alignRight", false);
        this.options.put("identSpaces", 4);
        this.options.put("useTab", false);
        this.options.put("breaksComma", (Object)Breaks.After);
        this.options.put("breaksProcArgs", false);
        this.options.put("breaksConcat", (Object)Breaks.Before);
        this.options.put("breaksAroundLogicalConjunctions", (Object)Breaks.Before);
        this.options.put("breaksAfterSelect", true);
        this.options.put("commasPerLine", 5);
        this.options.put("breakOnSubqueries", true);
        this.options.put("breakAnsiiJoin", false);
        this.options.put("breakParenCondition", false);
        this.options.put("maxCharLineSize", 128);
        this.options.put("forceLinebreaksBeforeComment", false);
        this.options.put("extraLinesAfterSignificantStatements", (Object)BreaksX2.X2);
        this.options.put("flowControl", (Object)FlowControl.IndentedActions);
        this.options.put("spaceAroundOperators", true);
        this.options.put("spaceAfterCommas", true);
        this.options.put("spaceAroundBrackets", (Object)Space.Default);
        this.options.put("formatProgramURL", "default");
    }

    public void setOptions(Map<String, Object> changed) {
        for (String key : changed.keySet()) {
            this.options.put(key, changed.get(key));
        }
    }

    public void verifyOptions(Map<String, Object> changed) {
        for (String key : changed.keySet()) {
            if (!this.options.containsKey(key)) {
                throw new AssertionError((Object)(key + " is not listed in Format.options"));
            }
            Object value = changed.get(key);
            if ("formatWhenSyntaxError".equals(key) && !(value instanceof Boolean)) {
                throw new AssertionError((Object)(key + " value is not Boolean"));
            }
            if ("parseForwardAndBackward".equals(key) && !(value instanceof Boolean)) {
                throw new AssertionError((Object)(key + " value is not Boolean"));
            }
            if ("singleLineComments".equals(key) && !(value instanceof InlineComments)) {
                throw new AssertionError((Object)(key + " value is not InlineComments"));
            }
            if ("kwCase".equals(key) && !(value instanceof Case)) {
                throw new AssertionError((Object)(key + " value is not Case"));
            }
            if ("idCase".equals(key) && !(value instanceof Case)) {
                throw new AssertionError((Object)(key + " value is not Case"));
            }
            if ("adjustCaseOnly".equals(key) && !(value instanceof Boolean)) {
                throw new AssertionError((Object)(key + " value is not Boolean"));
            }
            if ("removeDoubleQuotes".equals(key) && !(value instanceof Boolean)) {
                throw new AssertionError((Object)(key + " value is not Boolean"));
            }
            if ("alignTabColAliases".equals(key) && !(value instanceof Boolean)) {
                throw new AssertionError((Object)(key + " value is not Boolean"));
            }
            if ("alignTypeDecl".equals(key) && !(value instanceof Boolean)) {
                throw new AssertionError((Object)(key + " value is not Boolean"));
            }
            if ("alignNamedArgs".equals(key) && !(value instanceof Boolean)) {
                throw new AssertionError((Object)(key + " value is not Boolean"));
            }
            if ("alignEquality".equals(key) && !(value instanceof Boolean)) {
                throw new AssertionError((Object)(key + " value is not Boolean"));
            }
            if ("alignAssignments".equals(key) && !(value instanceof Boolean)) {
                throw new AssertionError((Object)(key + " value is not Boolean"));
            }
            if ("alignRight".equals(key) && !(value instanceof Boolean)) {
                throw new AssertionError((Object)(key + " value is not Boolean"));
            }
            if ("useTab".equals(key) && !(value instanceof Boolean)) {
                throw new AssertionError((Object)(key + " value is not Boolean"));
            }
            if ("breaksComma".equals(key) && !(value instanceof Breaks)) {
                throw new AssertionError((Object)(key + " value is not Breaks"));
            }
            if ("breaksProcArgs".equals(key) && !(value instanceof Boolean)) {
                throw new AssertionError((Object)(key + " value is not Boolean"));
            }
            if ("breaksConcat".equals(key) && !(value instanceof Breaks)) {
                throw new AssertionError((Object)(key + " value is not Breaks"));
            }
            if ("breaksAroundLogicalConjunctions".equals(key) && !(value instanceof Breaks)) {
                throw new AssertionError((Object)(key + " value is not Breaks"));
            }
            if ("breaksAfterSelect".equals(key) && !(value instanceof Boolean)) {
                throw new AssertionError((Object)(key + " value is not Boolean"));
            }
            if ("breakOnSubqueries".equals(key) && !(value instanceof Boolean)) {
                throw new AssertionError((Object)(key + " value is not Boolean"));
            }
            if ("breakAnsiiJoin".equals(key) && !(value instanceof Boolean)) {
                throw new AssertionError((Object)(key + " value is not Boolean"));
            }
            if ("breakParenCondition".equals(key) && !(value instanceof Boolean)) {
                throw new AssertionError((Object)(key + " value is not Boolean"));
            }
            if ("forceLinebreaksBeforeComment".equals(key) && !(value instanceof Boolean)) {
                throw new AssertionError((Object)(key + " value is not Boolean"));
            }
            if ("extraLinesAfterSignificantStatements".equals(key) && !(value instanceof BreaksX2)) {
                throw new AssertionError((Object)(key + " value is not BreaksX2"));
            }
            if ("flowControl".equals(key) && !(value instanceof FlowControl)) {
                throw new AssertionError((Object)(key + " value is not FlowControl"));
            }
            if ("spaceAroundOperators".equals(key) && !(value instanceof Boolean)) {
                throw new AssertionError((Object)(key + " value is not Boolean"));
            }
            if ("spaceAfterCommas".equals(key) && !(value instanceof Boolean)) {
                throw new AssertionError((Object)(key + " value is not Boolean"));
            }
            if ("spaceAroundBrackets".equals(key) && !(value instanceof Space)) {
                throw new AssertionError((Object)(key + " value is not Space"));
            }
        }
    }

    public int getIntOption(String name) {
        return (Integer)this.options.get(name);
    }

    public int getCommasPerLine() {
        return this.getIntOption("commasPerLine");
    }

    public int indentLength() {
        return this.getIntOption("identSpaces");
    }

    public Boolean getBoolBind(String name) {
        return this.programInstance.getBoolBindVar(name);
    }

    public boolean breaksAfterComma() {
        return this.options.get("breaksComma") == Breaks.After;
    }

    public boolean breaksBeforeComma() {
        return this.options.get("breaksComma") == Breaks.Before;
    }

    public boolean breaksAfterLogicalConjunction() {
        return this.options.get("breaksAroundLogicalConjunctions") == Breaks.After || this.options.get("breaksAroundLogicalConjunctions") == Breaks.BeforeAndAfter;
    }

    public boolean breaksBeforeLogicalConjunction() {
        return this.options.get("breaksAroundLogicalConjunctions") == Breaks.Before || this.options.get("breaksAroundLogicalConjunctions") == Breaks.BeforeAndAfter;
    }

    public boolean breaksAfterConcat() {
        return this.options.get("breaksConcat") == Breaks.After || this.options.get("breaksConcat") == Breaks.BeforeAndAfter;
    }

    public boolean breaksBeforeConcat() {
        return this.options.get("breaksConcat") == Breaks.Before || this.options.get("breaksConcat") == Breaks.BeforeAndAfter;
    }

    public boolean breaksAfterSelectFromWhere() {
        return (Boolean)this.options.get("breaksAfterSelect");
    }

    public boolean spaceParenDefault() {
        return this.options.get("spaceAroundBrackets") == Space.Default;
    }

    public boolean noSpaceBeforeOpenParen() {
        return this.options.get("spaceAroundBrackets") == Space.Inside || this.options.get("spaceAroundBrackets") == Space.NoSpace;
    }

    public boolean noSpaceBeforeCloseParen() {
        return this.options.get("spaceAroundBrackets") == Space.Outside || this.options.get("spaceAroundBrackets") == Space.NoSpace;
    }

    public boolean noSpaceAfterOpenParen() {
        return this.options.get("spaceAroundBrackets") == Space.Outside || this.options.get("spaceAroundBrackets") == Space.NoSpace;
    }

    public boolean noSpaceAfterCloseParen() {
        return this.options.get("spaceAroundBrackets") == Space.Inside || this.options.get("spaceAroundBrackets") == Space.NoSpace;
    }

    public boolean indentConditions() {
        return this.options.get("flowControl") == FlowControl.IndentedConditionsActions;
    }

    public boolean indentActions() {
        return this.options.get("flowControl") == FlowControl.IndentedConditionsActions || this.options.get("flowControl") == FlowControl.IndentedActions;
    }

    public boolean breakAfterConditions() {
        return this.options.get("flowControl") == FlowControl.SeparateConditionsActions;
    }

    public boolean breakAfterThen() {
        return this.options.get("flowControl") == FlowControl.IndentedActions;
    }

    public void resetProgramInstance(String prg) {
        this.options.put("formatProgramURL", prg);
        this.programInstance = null;
    }

    public void resetProgramInstance() {
        this.programInstance = null;
    }

    public String getActiveFormatProgram() throws IOException {
        String ret = Service.readFile(Format.class, (String)"/oracle/dbtools/app/format.prg");
        Object tmp = this.options.get("formatProgramURL");
        if (tmp != null) {
            try {
                String customURL = (String)tmp;
                if (!"default".equalsIgnoreCase(customURL)) {
                    ret = Service.readFile((String)customURL);
                }
            }
            catch (Exception e) {
                System.out.println("Failed to read custom formatting program " + tmp.toString());
                System.out.println(e.getMessage());
            }
        }
        return ret;
    }

    public boolean getRethrowSyntaxError() {
        return (Boolean)this.options.get("formatWhenSyntaxError") == false;
    }

    public void setRethrowSyntaxError(boolean rethrow) {
        this.options.put("formatWhenSyntaxError", !rethrow);
    }

    public synchronized String format(String input) throws IOException {
        this.checkValidity();
        this.initCallbackScaffolds();
        StringBuilder output = new StringBuilder();
        this.outputPos = -1;
        Parsed target = null;
        if (this.programInstance == null) {
            String formaterArboriCode = this.getActiveFormatProgram();
            this.programInstance = new SqlProgram(formaterArboriCode, this){

                public Boolean getBoolBindVar(String name) {
                    Object value = Format.this.options.get(name);
                    if (value != null && value instanceof Boolean) {
                        return (Boolean)value;
                    }
                    return super.getBoolBindVar(name);
                }
            };
            if (this.programInstance.getEngine() == null && !reportedNoJSEngineAvailable) {
                reportedNoJSEngineAvailable = true;
            }
        } else {
            this.programInstance.setStruct((Object)this);
        }
        try {
            List src = Lexer.parse((String)input);
            for (LexerToken t : src) {
                if (t.type != Token.WRAP) continue;
                return input;
            }
            String rootPayload = "sql_statements";
            if (!this.getRethrowSyntaxError() && ((Boolean)this.options.get("parseForwardAndBackward")).booleanValue()) {
                rootPayload = "parse with errors";
            }
            target = new Parsed(input, src, (Earley)SqlEarley.getInstance(), new String[]{rootPayload});
            if (this.getRethrowSyntaxError() && target.getSyntaxError() != null) {
                throw target.getSyntaxError();
            }
            this.programInstance.eval(target, (Object)this);
            if (this.inputPos < 1) {
                this.outputPos = output.length();
            }
        }
        catch (SyntaxError e) {
            this.outputPos = e.end;
            if (this.getRethrowSyntaxError()) {
                throw e;
            }
            return input;
        }
        catch (Exception e) {
            if (this.getRethrowSyntaxError()) {
                throw new AssertionError((Object)e);
            }
            return input;
        }
        List fullCode = Lexer.parse((String)target.getInput(), (boolean)true);
        int pos = -1;
        String priorIdent = null;
        LexerToken prior = null;
        int lastNewLine = -1;
        ParseNode root = target.getRoot();
        if (root.children().size() == 0) {
            return input;
        }
        for (LexerToken t : fullCode) {
            ParseNode node;
            if (this.options.get("adjustCaseOnly").equals(Boolean.TRUE)) {
                if (t.type != Token.COMMENT && t.type != Token.LINE_COMMENT && t.type != Token.WS && t.type != Token.INCOMPLETE) {
                    ++pos;
                }
                String word = t.content;
                if (t.type == Token.IDENTIFIER && !this.unformattedPositions.contains(pos)) {
                    word = this.adjustCase(word, this.options.get("kwCase"));
                    node = target.getRoot().leafAtPos(pos);
                    if (node != null && this.casedIds.containsKey(node.interval())) {
                        word = this.casedIds.get(node.interval());
                    }
                }
                output.append(word);
                continue;
            }
            if (this.outputPos < 0 && this.inputPos <= t.begin) {
                this.outputPos = t.begin;
            }
            if (this.unformattedPositions.contains(pos) && this.unformattedPositions.contains(pos + 1) || root.topLevel != null && root.coveredByOnTopLevel(pos + 1) == null) {
                output.append(t.content);
                if (t.type != Token.WS && t.type != Token.INCOMPLETE && t.type != Token.COMMENT && t.type != Token.LINE_COMMENT && t.type != Token.MACRO_SKIP && t.type != Token.SQLPLUSLINECONTINUE_SKIP) {
                    ++pos;
                }
                prior = t;
                continue;
            }
            if (t.type == Token.WS) {
                if (!"\n".equals(t.content)) continue;
                lastNewLine = t.end;
                continue;
            }
            String prior_end2t_begin = "";
            if (prior != null) {
                prior_end2t_begin = target.getInput().substring(prior.end, t.begin);
            }
            if (t.type == Token.COMMENT || t.type == Token.LINE_COMMENT || t.type == Token.MACRO_SKIP || t.type == Token.SQLPLUSLINECONTINUE_SKIP || t.type == Token.INCOMPLETE) {
                if (((Boolean)this.options.get("forceLinebreaksBeforeComment")).booleanValue() && (t.type == Token.COMMENT || t.type == Token.LINE_COMMENT) && prior != null && lastNewLine < prior.end) {
                    output.append("\n    ");
                }
                output.append(prior_end2t_begin);
                if (t.content.endsWith("\r")) {
                    t.content = t.content.substring(0, t.content.length() - 1) + "\n";
                }
                String pureContent = t.content;
                boolean endsWNL = false;
                if (pureContent.endsWith("\n")) {
                    pureContent = pureContent.substring(0, pureContent.length() - 1);
                    endsWNL = true;
                }
                if (pureContent.startsWith("--")) {
                    pureContent = pureContent.substring(2);
                } else if (pureContent.startsWith("/*") && pureContent.endsWith("*/")) {
                    pureContent = pureContent.substring(2, pureContent.length() - 2);
                }
                if (!pureContent.contains("\n")) {
                    if (this.options.get("singleLineComments") == InlineComments.MultiLine) {
                        output.append("/*" + pureContent + "*/");
                        if (endsWNL) {
                            output.append("\n");
                        }
                    } else if (this.options.get("singleLineComments") == InlineComments.SingleLine) {
                        output.append("--" + pureContent);
                    } else {
                        output.append(t.content);
                    }
                } else {
                    output.append(t.content);
                }
                prior = t;
                continue;
            }
            node = target.getRoot().leafAtPos(++pos);
            Object ident = this.newlinePositions.get(pos);
            if (ident != null) {
                if (prior != null && (this.options.get("extraLinesAfterSignificantStatements") == BreaksX2.Keep && ((String)ident).startsWith("\n\n") || prior.type == Token.LINE_COMMENT || prior.type == Token.COMMENT) && prior != null) {
                    String spacing = ((String)ident).replace("\n", "").replace("\r", "");
                    String lineBreaks = prior_end2t_begin.replace(" ", "").replace("\t", "");
                    if (0 < lineBreaks.length()) {
                        ident = lineBreaks + spacing;
                    }
                }
                output.append((String)ident);
                priorIdent = ident;
            } else {
                String scope;
                if (prior != null && prior.type == Token.LINE_COMMENT) {
                    if (priorIdent != null) {
                        output.append(priorIdent);
                    } else {
                        output.append("\n");
                    }
                }
                if (null != (scope = this.ids2scope.get(pos))) {
                    scope = this.nullifySingletonIds(scope);
                }
                if (null != scope) {
                    int maxLen = this.maxIdLengthInScope.get(scope);
                    if ((Integer)this.options.get("maxCharLineSize") + 10 < maxLen) {
                        maxLen = (Integer)this.options.get("maxCharLineSize") + 10;
                    }
                    Integer adj = this.ids2adjustments.get(pos);
                    int idLen = 0;
                    for (int i = this.ids2interval.get(pos).intValue(); i < pos; ++i) {
                        idLen += ((LexerToken)target.getSrc().get((int)i)).content.length();
                        if (1 != this.decideSpace(target, i + 1).length()) continue;
                        ++idLen;
                    }
                    int pad = maxLen + 1 - idLen;
                    if (adj != null) {
                        pad -= adj.intValue();
                    }
                    if (pad < 1) {
                        pad = 1;
                    }
                    output.append(Service.padln((String)"", (int)pad));
                } else {
                    Object separator = this.decideSpace(target, pos);
                    if ("/".equals(t.content) && node.parent() != null && node.parent().contains(this.sql_statement)) {
                        separator = "\n";
                    }
                    int currentOffset = output.length() - output.lastIndexOf("\n");
                    if ((Integer)this.options.get("maxCharLineSize") + 5 < currentOffset && this.isBreakable(t) && prior != null && this.isBreakable(prior)) {
                        if (priorIdent != null) {
                            separator = priorIdent;
                        }
                        if (((String)separator).startsWith("\n\n")) {
                            separator = ((String)separator).substring(1);
                        }
                        if (((String)separator).startsWith("\n\r\n")) {
                            separator = ((String)separator).substring(2);
                        }
                        if (!((String)separator).contains("\n")) {
                            separator = "\n" + (String)separator;
                        }
                    }
                    output.append((String)separator);
                }
            }
            String word = t.content;
            if (t.type == Token.IDENTIFIER && !this.unformattedPositions.contains(pos)) {
                word = this.adjustCase(word, this.options.get("kwCase"));
            }
            if (node != null && this.casedIds.containsKey(node.interval()) && !this.unformattedPositions.contains(pos)) {
                word = this.casedIds.get(node.interval());
            }
            output.append(word);
            prior = t;
        }
        if (pos < (Integer)this.options.get("formatThreshold")) {
            return input;
        }
        Object ret = output.toString();
        if (((String)ret).startsWith("\n")) {
            ret = ((String)ret).substring(1);
        }
        if (this.options.get("extraLinesAfterSignificantStatements") != BreaksX2.Keep) {
            ret = ((String)ret).replace("\n\n\n", "\n\n");
        }
        int index = -1;
        while ((index = ((String)ret).indexOf(";/", index + 1)) >= 0) {
            if (((String)ret).indexOf("*", index + 1) == index + 2) continue;
            try {
                LexerToken t = LexerToken.getTokenAtCharOffset((List)fullCode, (int)index);
                if (t.type == Token.DQUOTED_STRING || t.type == Token.QUOTED_STRING || t.type == Token.COMMENT || t.type == Token.LINE_COMMENT) {
                    continue;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ret = ((String)ret).substring(0, index) + ";\n/" + ((String)ret).substring(index + 2);
        }
        this.inputPos = -1;
        return ret;
    }

    private boolean isBreakable(LexerToken t) {
        if (",".equals(t.content)) {
            return true;
        }
        if (";".equals(t.content)) {
            return true;
        }
        if ("(".equals(t.content)) {
            return true;
        }
        if (")".equals(t.content)) {
            return true;
        }
        if ("+".equals(t.content)) {
            return true;
        }
        return t.type != Token.OPERATION;
    }

    private void checkValidity() throws IOException {
        String formaterArboriCode = this.getActiveFormatProgram();
        boolean oK = this.checkIfContains(formaterArboriCode, "order_by_clause___0");
    }

    private boolean checkIfContains(String formaterArboriCode, String substr) {
        boolean oK = true;
        if (formaterArboriCode.indexOf(substr) < 0) {
            oK = false;
        }
        if (!oK) {
            MessageLogging.getInstance().log("Mising " + substr + "; had to reset format program");
            this.resetProgramInstance();
            this.options.put("formatProgramURL", "default");
        }
        return oK;
    }

    private String nullifySingletonIds(String scope) {
        int cnt = 0;
        for (String sc : this.ids2scope.values()) {
            if (!sc.equals(scope)) continue;
            ++cnt;
        }
        return cnt > 1 ? scope : null;
    }

    private String decideSpace(Parsed target, int pos) {
        if (pos == 0) {
            return "";
        }
        if (this.skipWSPositions.contains(pos)) {
            return "";
        }
        return " ";
    }

    public String adjustCase(String word, Object changeCase) {
        if (!word.startsWith("\"") && changeCase == Case.lower) {
            word = word.toLowerCase();
        }
        if (!word.startsWith("\"") && changeCase == Case.UPPER) {
            word = word.toUpperCase();
        }
        if (!word.startsWith("\"") && changeCase == Case.InitCap) {
            char[] converted = new char[word.length()];
            int prior1 = 37;
            for (int i = 0; i < converted.length; ++i) {
                char current = word.charAt(i);
                converted[i] = i == 0 || prior1 == 95 ? Character.toUpperCase(current) : Character.toLowerCase(current);
                prior1 = current;
            }
            word = new String(converted);
        }
        return word;
    }

    String spaceSequence(int level) {
        Object output = "";
        if (((Boolean)this.options.get("useTab")).booleanValue()) {
            for (int i = 0; i < level; ++i) {
                output = (String)output + "\t";
            }
        } else {
            for (int i = 0; i < level * (Integer)this.options.get("identSpaces"); ++i) {
                output = (String)output + " ";
            }
        }
        return output;
    }

    public void putNewline(int pos, String newline) {
        this.newlinePositions.put(pos, newline);
    }

    public String getNewline(int pos) {
        return this.newlinePositions.get(pos);
    }

    private void initCallbackScaffolds() {
        this.posDepths = new HashMap<Integer, Integer>();
        this.newlinePositions = new HashMap<Integer, String>();
        this.casedIds = new HashMap<String, String>();
        this.maxIdLengthInScope = new HashMap<String, Integer>();
        this.ids2scope = new HashMap<Integer, String>();
        this.ids2interval = new HashMap<Integer, Integer>();
        this.ids2adjustments = new HashMap<Integer, Integer>();
        this.skipWSPositions = new HashSet<Integer>();
        this.unformattedPositions = new HashSet<Integer>();
    }

    public void closestPrecursorDescendant(Parsed target, Map<String, ParseNode> tuple) {
        String m = new Object(){}.getClass().getEnclosingMethod().getName();
        System.out.println(m + ".  " + MaterializedPredicate.tupleMnemonics(tuple, (List)target.getSrc()));
    }

    public void ancestorDescendant(Parsed target, Map<String, ParseNode> tuple) {
        String m = new Object(){}.getClass().getEnclosingMethod().getName();
        System.out.println(m + ".  " + MaterializedPredicate.tupleMnemonics(tuple, (List)target.getSrc()));
    }

    public void indentedNodes1(Parsed target, Map<String, ParseNode> tuple) {
        ParseNode node = tuple.get("node");
        if (node == null) {
            throw new AssertionError((Object)"node == null");
        }
        for (int i = node.from; i < node.to; ++i) {
            Integer posDepth = this.posDepths.get(i);
            if (posDepth == null) {
                posDepth = 0;
            }
            Integer n = posDepth;
            posDepth = posDepth + 1;
            this.posDepths.put(i, posDepth);
        }
    }

    public void indentedNodes2(Parsed target, Map<String, ParseNode> tuple) {
        ParseNode node = tuple.get("node");
        int pos = node.from;
        Integer depth = this.depth(pos);
        int priorDepth = -1;
        if (0 < pos) {
            priorDepth = this.depth(pos - 1);
        }
        if (priorDepth != depth) {
            this.newlinePositions.put(pos, "\n" + this.spaceSequence(depth));
        }
        if (target.getSrc().size() <= node.to) {
            return;
        }
        pos = node.to;
        this.newlinePositions.put(pos, "\n" + this.spaceSequence(this.depth(pos)));
    }

    private int depth(int pos) {
        Integer ret = this.posDepths.get(pos);
        if (ret == null) {
            return 0;
        }
        return ret;
    }

    public void identifiers(Parsed target, Map<String, ParseNode> tuple) {
        String possiblyQuoted;
        String unquoted;
        ParseNode node = tuple.get("identifier");
        LexerToken t = (LexerToken)target.getSrc().get(node.from);
        if (t.type == Token.DQUOTED_STRING && this.options.get("removeDoubleQuotes").equals(Boolean.TRUE) && (unquoted = t.content.substring(1, t.content.length() - 1)).equals(possiblyQuoted = DBUtil.addDoubleQuote(unquoted))) {
            t.content = unquoted;
            t.type = Token.IDENTIFIER;
        }
        t.content = this.adjustCase(t.content, this.options.get("idCase"));
        this.casedIds.put(node.interval(), t.content);
    }

    public void paddedIdsInScope(Parsed target, Map<String, ParseNode> tuple) {
        ParseNode scope = tuple.get("scope");
        Integer maxLen = this.maxIdLengthInScope.get(scope.interval());
        if (maxLen == null) {
            maxLen = 0;
        }
        ParseNode id = tuple.get("predecessor");
        ParseNode id1 = tuple.get("follower");
        int from = id.from;
        int indentOffset = 0;
        String indent0 = this.newlinePositions.get(id.from);
        for (int i = id.to - 1; id.from <= i; --i) {
            String indent = this.newlinePositions.get(i);
            if (indent == null) continue;
            from = i;
            if (indent0 == null || indent0.length() >= indent.length()) break;
            indentOffset += indent.length() - indent0.length();
            break;
        }
        int idLen = 0;
        for (int i = from; i < id1.from; ++i) {
            idLen += ((LexerToken)target.getSrc().get((int)i)).content.length();
            if (1 != this.decideSpace(target, i + 1).length()) continue;
            ++idLen;
        }
        if (maxLen < (idLen += indentOffset)) {
            maxLen = idLen;
        }
        this.maxIdLengthInScope.put(scope.interval(), maxLen);
        this.ids2scope.put(id1.from, scope.interval());
        this.ids2interval.put(id1.from, from);
        this.ids2adjustments.put(id1.from, indentOffset);
    }

    public void incrementalAlignments(Parsed target, Map<String, ParseNode> tuple) {
        ParseNode node = tuple.get("node");
        String ident = this.offset(node.from, target);
        for (int i = node.from + 1; i < node.to; ++i) {
            String oldOffset = this.newlinePositions.get(i);
            if (oldOffset == null) continue;
            this.newlinePositions.put(i, oldOffset + Service.padln((String)"", (int)(ident.length() - this.indent(node.from, target))));
        }
    }

    private int indent(int pos, Parsed target) {
        int i = pos;
        while (pos - 50 < i & 0 <= i) {
            String tmp = this.newlinePositions.get(i);
            if (tmp != null) {
                return tmp.length();
            }
            --i;
        }
        return 1;
    }

    public void pairwiseAlignments(Parsed target, Map<String, ParseNode> tuple) {
        ParseNode node = tuple.get("node");
        ParseNode predecessor = tuple.get("predecessor");
        String nodeIndent = this.newlinePositions.get(node.from);
        if (nodeIndent == null) {
            return;
        }
        String ident = this.offset(predecessor.from, target);
        int delta = ident.length() - nodeIndent.length();
        this.newlinePositions.put(node.from, ident);
        if (0 < delta) {
            for (int i = node.from + 1; i < node.to; ++i) {
                String oldOffset = this.newlinePositions.get(i);
                if (oldOffset == null) continue;
                String newOffset = oldOffset + Service.padln((String)"", (int)delta);
                this.newlinePositions.put(i, newOffset);
            }
        }
    }

    private String offset(int pos, Parsed target) {
        Object ret = "\n";
        int i = pos;
        while (pos - 50 < i & 0 <= i) {
            String tmp = this.newlinePositions.get(i);
            if (tmp != null && tmp.startsWith("\n\n")) {
                tmp = tmp.substring(1);
            }
            if (i == 0) {
                tmp = "\n";
            }
            if (tmp != null) {
                ret = tmp;
                for (int j = i; j < pos; ++j) {
                    for (int k = 0; k < ((LexerToken)target.getSrc().get((int)j)).content.length(); ++k) {
                        ret = (String)ret + " ";
                    }
                    ret = (String)ret + this.decideSpace(target, j + 1);
                    if ((Integer)this.options.get("maxCharLineSize") >= ((String)ret).length()) continue;
                    return ret;
                }
                break;
            }
            --i;
        }
        return ret;
    }

    public void rightAlignments(Parsed target, Map<String, ParseNode> tuple) {
        ParseNode node = tuple.get("node");
        String kw = ((LexerToken)target.getSrc().get((int)node.from)).content;
        int delta = "select".length() - kw.length();
        String nodeIndent = this.newlinePositions.get(node.from);
        if (nodeIndent == null) {
            return;
        }
        this.newlinePositions.put(node.from, nodeIndent + Service.padln((String)"", (int)delta));
    }

    public void extraBrkBefore(Parsed target, Map<String, ParseNode> tuple) {
        ParseNode node = tuple.get("node");
        String padding = this.newlinePositions.get(node.from);
        if (padding == null) {
            int depth = this.depth(node.from);
            this.newlinePositions.put(node.from, "\n" + this.spaceSequence(depth));
        }
    }

    public void extraBrkAfter(Parsed target, Map<String, ParseNode> tuple) {
        ParseNode node = tuple.get("node");
        String padding = this.newlinePositions.get(node.to);
        if (padding == null) {
            int depth = this.depth(node.to);
            this.newlinePositions.put(node.to, "\n" + this.spaceSequence(depth));
        }
    }

    public void brkX2(Parsed target, Map<String, ParseNode> tuple) {
        if (this.options.get("extraLinesAfterSignificantStatements") == BreaksX2.X1) {
            return;
        }
        ParseNode node = tuple.get("node");
        String padding = this.newlinePositions.get(node.to);
        if (padding == null) {
            this.newlinePositions.put(node.to, "\n\n");
        } else {
            this.newlinePositions.put(node.to, "\n" + padding);
        }
    }

    public void ignoreLineBreaksBeforeNode(Parsed target, Map<String, ParseNode> tuple) {
        ParseNode node = tuple.get("node");
        this.newlinePositions.remove(node.from);
    }

    public void ignoreLineBreaksAfterNode(Parsed target, Map<String, ParseNode> tuple) {
        ParseNode node = tuple.get("node");
        this.newlinePositions.remove(node.to);
    }

    public void dontFormatNode(Parsed target, Map<String, ParseNode> tuple) {
        ParseNode node = tuple.get("node");
        for (int i = node.from; i < node.to; ++i) {
            this.unformattedPositions.add(i);
        }
    }

    public void skipWhiteSpaceBeforeNode(Parsed target, Map<String, ParseNode> tuple) {
        ParseNode node = tuple.get("node");
        this.skipWSPositions.add(node.from);
    }

    public void skipWhiteSpaceAfterNode(Parsed target, Map<String, ParseNode> tuple) {
        ParseNode node = tuple.get("node");
        this.skipWSPositions.add(node.to);
    }

    public boolean breaksProcArgs(Map<String, Integer> attributePositions, ParseNode[] t, List<LexerToken> src) {
        return this.getCommasPerLine() == 1;
    }

    public boolean breaks4JSON(Map<String, Integer> attributePositions, ParseNode[] t, List<LexerToken> src) {
        return true;
    }

    public boolean breaks4XML(Map<String, Integer> attributePositions, ParseNode[] t, List<LexerToken> src) {
        return true;
    }

    public void breakLongProcArgLists(Parsed target, Map<String, ParseNode> tuple) {
        ++this.argNum;
        ParseNode proc = tuple.get("procedureCall");
        Object name = ((LexerToken)target.getSrc().get((int)proc.from)).content;
        String dot = ((LexerToken)target.getSrc().get((int)(proc.from + 1))).content;
        if (".".equals(dot)) {
            name = (String)name + "." + ((LexerToken)target.getSrc().get((int)(proc.from + 2))).content;
        }
        if (proc != this.priorProc) {
            this.argNum = 1;
            this.priorProc = proc;
        }
        int breakEvery5thArg = this.getCommasPerLine();
        ParseNode node = tuple.get("node");
        String procIndent = this.getNewline(proc.from);
        if (procIndent == null) {
            procIndent = "\n";
        }
        StringBuilder pad = new StringBuilder();
        for (int i = 0; i <= ((String)name).length(); ++i) {
            pad.append(" ");
        }
        ParseNode argAfterComma = target.getRoot().leafAtPos(node.to);
        if (this.argNum % breakEvery5thArg == 0) {
            if (this.getBoolBind("breaksAfterComma").booleanValue()) {
                this.putNewline(node.to, procIndent + pad.toString());
            }
            if (this.getBoolBind("breaksBeforeComma").booleanValue()) {
                this.putNewline(node.from, procIndent + pad.toString());
            }
        }
    }

    public void breakComplexProcArgLists(Parsed target, Map<String, ParseNode> tuple) {
        ParseNode proc = tuple.get("functionInFunction.procedureCall");
        String name = ((LexerToken)target.getSrc().get((int)proc.from)).content;
        ParseNode node = tuple.get("node");
        String procIndent = this.getNewline(proc.from);
        if (procIndent == null) {
            procIndent = "\n";
        }
        StringBuilder pad = new StringBuilder();
        for (int i = 0; i <= name.length(); ++i) {
            pad.append(" ");
        }
        ParseNode argAfterComma = target.getRoot().leafAtPos(node.to);
        if (this.getBoolBind("breaksAfterComma").booleanValue()) {
            this.putNewline(node.to, procIndent + pad.toString());
        }
        if (this.getBoolBind("breaksBeforeComma").booleanValue()) {
            this.putNewline(node.from, procIndent + pad.toString());
        }
    }

    public void extraIndent(Parsed target, Map<String, ParseNode> tuple) {
        ParseNode root = tuple.get("node");
        int indent = this.indentLength();
        List desc = root.descendants();
        TreeSet<Integer> processed = new TreeSet<Integer>();
        for (ParseNode node : desc) {
            if (processed.contains(node.from)) continue;
            processed.add(node.from);
            this.padNode(node, indent);
        }
    }

    private void padNode(ParseNode node, int len) {
        Object nodeIndent = this.getNewline(node.from);
        if (nodeIndent == null) {
            return;
        }
        for (int i = 0; i < len; ++i) {
            nodeIndent = (String)nodeIndent + " ";
        }
        this.putNewline(node.from, (String)nodeIndent);
    }

    public void extra5Spaces(Parsed target, Map<String, ParseNode> tuple) {
        ParseNode node = tuple.get("node");
        this.padNode(node, 5);
    }

    public void less2Spaces(Parsed target, Map<String, ParseNode> tuple) {
        ParseNode node = tuple.get("node");
        String nodeIndent = this.getNewline(node.from);
        int offset = 2;
        if (!this.getBoolBind("spaceAfterCommas").booleanValue()) {
            offset = 1;
        }
        if (nodeIndent != null) {
            this.putNewline(node.from, nodeIndent.substring(0, nodeIndent.length() - offset));
        }
    }

    public void breakLongConcatenationLists(Parsed target, Map<String, ParseNode> tuple) {
        ++this.cNum;
        ParseNode scope = tuple.get("scope");
        if (scope != this.priorScope) {
            this.cNum = 1;
            this.priorScope = scope;
        }
        int breakEvery5thArg = this.getCommasPerLine();
        ParseNode node = tuple.get("node");
        int indent = 20;
        StringBuilder pad = new StringBuilder();
        for (int i = 0; i <= indent; ++i) {
            pad.append(" ");
        }
        ParseNode cAfter = target.getRoot().leafAtPos(node.to);
        if (this.cNum % breakEvery5thArg == 0) {
            String procIndent = this.getNewline(scope.from);
            if (procIndent == null) {
                procIndent = "\n";
            }
            this.putNewline(node.from, procIndent + pad.toString());
            this.cNum = 1;
        }
    }

    public static enum InlineComments {
        CommentsUnchanged,
        SingleLine,
        MultiLine;

    }

    public static enum Case {
        UPPER,
        lower,
        InitCap,
        NoCaseChange;

    }

    public static enum Breaks {
        Before,
        After,
        None,
        BeforeAndAfter;

    }

    public static enum BreaksX2 {
        X1,
        X2,
        Keep;

    }

    public static enum FlowControl {
        IndentedActions,
        Terse,
        SeparateConditionsActions,
        IndentedConditionsActions;

    }

    public static enum Space {
        Default,
        Inside,
        Outside,
        NoSpace;

    }
}

