/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sdks.installer.commands;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.sdks.exceptions.SdkRemovalException;
import oracle.dbtools.sdks.installer.downloader.DependencyDownloaderImpl;
import oracle.dbtools.sdks.installer.downloader.DependencyInfo;
import oracle.dbtools.sdks.installer.dto.SDK;
import oracle.dbtools.sdks.installer.help.SDKSMessages;
import oracle.dbtools.sdks.installer.utils.CommandLineTableGenerator;
import oracle.dbtools.sdks.messages.SDKSMessenger;
import org.apache.commons.io.FileUtils;
import org.xml.sax.SAXException;

public class SDKSManager {
    private final String sdks_dir = SDKSManager.defineRootPath();
    private final String version_file = "/version.txt";
    private final HttpClient httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(60L)).build();
    private final List<SDK> sdks = List.of(new SDK("jdbc-oci", List.of("https://repo1.maven.org/maven2/com/oracle/database/jdbc/ojdbc-provider-oci/"), "https://docs.oracle.com/en/database/oracle/oracle-database/23/jjdbc/", "com.oracle.database.jdbc", "ojdbc-provider-oci", null, null), new SDK("jdbc-azure", List.of("https://repo1.maven.org/maven2/com/oracle/database/jdbc/ojdbc-provider-azure/"), "https://docs.oracle.com/en/database/oracle/oracle-database/23/jjdbc/", "com.oracle.database.jdbc", "ojdbc-provider-azure", null, null));

    private static String defineRootPath() {
        String SQL_HOME = System.getProperty("sqlcl.home");
        return SQL_HOME == null ? "../lib/sdks/" : SQL_HOME + "/lib/sdks/";
    }

    public void listAvailable(ScriptRunnerContext ctx) {
        SDKSMessenger sdksmessenger = new SDKSMessenger(ctx);
        CommandLineTableGenerator table = new CommandLineTableGenerator(ctx);
        table.setShowVerticalLines(true);
        table.setHeaders(SDKSMessages.getString("TABLE_SDK"), SDKSMessages.getString("TABLE_INSTALLED"), SDKSMessages.getString("TABLE_VERSION"), SDKSMessages.getString("TABLE_DOCS"));
        this.sdks.forEach(sdk -> {
            try {
                String latestVersion = this.extractLatestVersionFromMetadataXML((String)sdk.baseUrls.stream().findFirst().get());
                Path sdkDir = Paths.get(this.sdks_dir + sdk.name + "/", new String[0]);
                if (this.sdkInstalled(sdkDir)) {
                    String installedVersion = this.readVersion(sdkDir).trim();
                    if (installedVersion.equals(latestVersion)) {
                        table.addRow(sdk.name, SDKSMessages.getString("TABLE_YES"), installedVersion, sdk.docUrl);
                    } else {
                        table.addRow(sdk.name, SDKSMessages.getString("TABLE_YES"), installedVersion + " -> " + latestVersion, sdk.docUrl);
                    }
                } else {
                    table.addRow(sdk.name, SDKSMessages.getString("TABLE_NO"), latestVersion, sdk.docUrl);
                }
            }
            catch (Exception e) {
                sdksmessenger.errorMsg(e.getMessage());
                sdksmessenger.debugStackTraceException(e);
            }
        });
        table.print();
    }

    private String readVersion(Path sdkDir) throws IOException {
        Path versionFile = Path.of(String.valueOf(sdkDir) + "/version.txt", new String[0]);
        return Files.readString(versionFile);
    }

    private void removeFiles(Path sdkDirectory) throws SdkRemovalException {
        try (Stream<Path> walk = Files.walk(sdkDirectory, new FileVisitOption[0]);){
            walk.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
        }
        catch (IOException e) {
            throw new SdkRemovalException(SDKSMessages.getString("SDK_REMOVAL_EXCEPTION"), e);
        }
    }

    public void remove(ScriptRunnerContext ctx, String sdkName) throws Exception {
        SDKSMessenger sdksmessenger = new SDKSMessenger(ctx);
        Path sdkDirectory = Paths.get(this.sdks_dir + sdkName + "/", new String[0]);
        if (this.sdkIsAvailable(sdkName) && this.sdkInstalled(sdkDirectory)) {
            sdksmessenger.removingDirectoryMsg(sdkName);
            this.removeFiles(sdkDirectory);
            sdksmessenger.sdkRemovedMsg(sdkName);
        } else {
            sdksmessenger.invalidRmSdkMsg();
        }
    }

    public void update(ScriptRunnerContext ctx, String sdkName) throws Exception {
        SDKSMessenger sdksmessenger = new SDKSMessenger(ctx);
        Path sdkDirectory = Paths.get(this.sdks_dir + sdkName + "/", new String[0]);
        if (this.sdkIsAvailable(sdkName) && this.sdkInstalled(sdkDirectory)) {
            this.remove(ctx, sdkName);
            this.install(ctx, sdkName);
        } else {
            sdksmessenger.invalidRmSdkMsg();
        }
    }

    public void install(ScriptRunnerContext ctx, String sdkName) throws Exception {
        SDKSMessenger sdksmessenger = new SDKSMessenger(ctx);
        try {
            Path sdkRootDir = Paths.get(this.sdks_dir + sdkName + "/", new String[0]);
            DependencyDownloaderImpl downloader = new DependencyDownloaderImpl();
            if (this.sdkIsAvailable(sdkName)) {
                if (Files.exists(sdkRootDir, new LinkOption[0])) {
                    if (sdksmessenger.updatePromptMsg(sdkName)) {
                        this.update(ctx, sdkName);
                    }
                } else {
                    sdksmessenger.sdkFoundMsg(sdkName);
                    DependencyInfo dependencyInfo = downloader.downloadDependencies(new DependencyInfo(this.getSdkByName((String)sdkName).groupId, this.getSdkByName((String)sdkName).artifactId, null, null), sdkRootDir.toString(), ctx);
                    Path versionFile = Paths.get(this.sdks_dir + sdkName + "/version.txt", new String[0]);
                    Files.write(versionFile, dependencyInfo.version.getBytes(), new OpenOption[0]);
                    sdksmessenger.sdkInstalledMsg(sdkName);
                }
            } else {
                sdksmessenger.sdkNotFoundMsg(sdkName);
                this.listAvailable(ctx);
            }
        }
        catch (Exception e) {
            FileUtils.deleteDirectory((File)Paths.get(this.sdks_dir, new String[0]).toFile());
            throw e;
        }
    }

    private SDK getSdkByName(String sdkName) {
        return this.sdks.stream().filter(sdk -> sdk.name.equals(sdkName)).findAny().get();
    }

    private boolean sdkIsAvailable(String sdkName) {
        return this.sdks.stream().anyMatch(sdk -> sdk.name.equals(sdkName));
    }

    private boolean sdkInstalled(Path sdkDirectory) {
        return Files.exists(sdkDirectory, new LinkOption[0]);
    }

    private String extractLatestVersionFromMetadataXML(String baseUrl) throws ParserConfigurationException, IOException, URISyntaxException, InterruptedException, SAXException {
        HttpResponse<InputStream> metadataXML = this.getFileFromUri(baseUrl, "maven-metadata.xml");
        return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(metadataXML.body()).getElementsByTagName("latest").item(0).getFirstChild().getNodeValue();
    }

    private HttpResponse<InputStream> getFileFromUri(String baseUrl, String addition) throws URISyntaxException, IOException, InterruptedException {
        HttpRequest httpRequest = HttpRequest.newBuilder().uri(new URI(baseUrl + addition)).GET().build();
        return this.httpClient.send(httpRequest, responseInfo -> HttpResponse.BodySubscribers.ofInputStream());
    }
}

