/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.mcp.utils;

import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import oracle.dbtools.core.connections.storage.ConnectionDefinition;
import oracle.dbtools.core.connections.storage.ConnectionStorage;

public class ConnectionUtils {
    public static Map<String, String> listAllConnectionNames() {
        ConnectionStorage storage = ConnectionStorage.instance();
        return storage.listConnectionDirectories().stream().flatMap(identifier -> {
            try {
                ConnectionDefinition conn = storage.loadConnection(identifier);
                return Stream.of(Map.entry(conn.getConnectionName(), conn.getDbtoolsProperties().getProperty((CharSequence)"userName")));
            }
            catch (Exception e) {
                return Stream.empty();
            }
        }).filter(entry -> entry.getKey() != null && entry.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (existing, replacement) -> existing));
    }
}

