/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.mcp.tools;

import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.spec.McpSchema;
import java.sql.SQLException;
import java.util.ArrayList;
import oracle.dbtools.extension.mcp.exceptions.ArgumentException;
import oracle.dbtools.extension.mcp.exceptions.AuditTableException;
import oracle.dbtools.extension.mcp.tools.McpTool;
import oracle.dbtools.extension.mcp.utils.QueryUtils;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.runner.SqlClCommandsRunner;

public class RunSqlTool
implements McpTool {
    private final String toolName = "run-sql";

    @Override
    public McpServerFeatures.SyncToolSpecification create(ScriptRunnerContext ctx) {
        return new McpServerFeatures.SyncToolSpecification(new McpSchema.Tool("run-sql", "This tool executes SQL queries in an Oracle database. If no active connection exists, it prompts the user to connect using the connect tool.\n\nYou should:\n\n\tExecute the provided SQL query.\n\n\tReturn the results in CSV format.\n\nArgs:\n\n\tsql: The SQL query to execute.\n\nThe `model` argument should specify only the name and version of the LLM (Large Language Model) you are using, with no additional information.\nThe `mcp_client` argument should specify only the name of the MCP (Model Context Protocol) client you are using, with no additional information.\nReturns:\n\n\tCSV-formatted query results.\nFor every SQL query you generate, please include a comment at the beginning of the SELECT statement (or other main SQL command) that identifies the LLM model name and version you are using. Format the comment as: /* LLM in use is [model_name_and_version] */ and place it immediately after the main SQL keyword.\nFor example:\n\nSELECT /* LLM in use is claude-sonnet-4 */ column1, column2 FROM table_name;\nINSERT /* LLM in use is claude-sonnet-4 */ INTO table_name VALUES (...);\nUPDATE /* LLM in use is claude-sonnet-4 */ table_name SET ...;\n\nPlease apply this format consistently to all SQL queries you generate, using your actual model name and version in the comment\n", "{\n  \"type\" : \"object\",\n  \"id\" : \"urn:jsonschema:Operation\",\n  \"properties\" : {\n    \"sql\" : {\n      \"type\" : \"string\"\n    },\n    \"mcp_client\" : {\n      \"type\" : \"string\"\n    },\n    \"model\" : {\n      \"type\" : \"string\"\n    }\n  }\n}"), (exchange, arguments) -> {
            ArrayList<McpSchema.TextContent> contents;
            block8: {
                contents = new ArrayList<McpSchema.TextContent>();
                try {
                    String mcp_client;
                    String sql = !arguments.containsKey("sql") ? "" : arguments.get("sql").toString();
                    String model = !arguments.containsKey("model") ? "" : arguments.get("model").toString();
                    String string = mcp_client = !arguments.containsKey("mcp_client") ? "" : arguments.get("mcp_client").toString();
                    if (sql.isEmpty()) {
                        throw new ArgumentException("The SQL query argument is required");
                    }
                    if (model.isEmpty()) {
                        throw new ArgumentException("Model name argument is required");
                    }
                    if (mcp_client.isEmpty()) {
                        throw new ArgumentException("MCP Client name argument is required");
                    }
                    if (ctx.getCurrentConnection() != null) {
                        SqlClCommandsRunner sqlcl = SqlClCommandsRunner.builder().connection(ctx.getCurrentConnection()).build();
                        try {
                            this.createMcpLogTable(ctx.getCurrentConnection());
                        }
                        catch (AuditTableException e) {
                            contents.add(new McpSchema.TextContent(e.getLocalizedMessage()));
                        }
                        QueryUtils.insertSessionInfo(ctx.getCurrentConnection(), "run-sql", model);
                        QueryUtils.insertClientInfo(ctx.getCurrentConnection(), mcp_client);
                        QueryUtils.insertIntoDbtoolsMcpLog(ctx.getCurrentConnection(), mcp_client, model, "tool", "run-sql", sql);
                        contents.add(new McpSchema.TextContent(sqlcl.run("SET SQLFORMAT CSV\n" + sql)));
                        break block8;
                    }
                    contents.add(new McpSchema.TextContent("Connection not established"));
                }
                catch (SQLException | ArgumentException e) {
                    contents.clear();
                    contents.add(new McpSchema.TextContent("ERROR: " + ((Throwable)e).getLocalizedMessage()));
                    contents.add(new McpSchema.TextContent("\nBased on the error thrown, provide the user with a clear explanation of what went wrong. If possible, correct the issue and retry the request"));
                }
            }
            return new McpSchema.CallToolResult(contents, Boolean.valueOf(false));
        });
    }
}

