/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.mcp.tools;

import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.spec.McpSchema;
import java.sql.SQLException;
import java.util.ArrayList;
import oracle.dbtools.extension.mcp.exceptions.ArgumentException;
import oracle.dbtools.extension.mcp.exceptions.AuditTableException;
import oracle.dbtools.extension.mcp.tools.McpTool;
import oracle.dbtools.extension.mcp.utils.QueryUtils;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.runner.SqlClCommandsRunner;

public class RunSqlCLTool
implements McpTool {
    private final String toolName = "run-sqlcl";

    @Override
    public McpServerFeatures.SyncToolSpecification create(ScriptRunnerContext ctx) {
        return new McpServerFeatures.SyncToolSpecification(new McpSchema.Tool("run-sqlcl", "This tool executes SQLcl commands in the SQLcl CLI. If the given command requires a database connection, it prompts the user to connect using the connect tool.\nYou should:\n\n\tExecute the provided SQLcl command.\n\n\tReturn the results.\n\nArgs:\n\n\tsql: The SQLcl command to execute.\n\nReturns:\n\n\tCommand results.\n\nThe `model` argument should specify only the name and version of the LLM (Large Language Model) you are using, with no additional information.\nThe `mcp_client` argument should specify only the name of the MCP (Model Context Protocol) client you are using, with no additional information.", "{\n  \"type\" : \"object\",\n  \"id\" : \"urn:jsonschema:Operation\",\n  \"properties\" : {\n    \"sqlcl\" : {\n      \"type\" : \"string\"\n    },\n    \"mcp_client\" : {\n      \"type\" : \"string\"\n    },\n    \"model\" : {\n      \"type\" : \"string\"\n    }\n  }\n}"), (exchange, arguments) -> {
            ArrayList<McpSchema.TextContent> contents = new ArrayList<McpSchema.TextContent>();
            try {
                String mcp_client;
                String sql = !arguments.containsKey("sqlcl") ? "" : arguments.get("sqlcl").toString();
                String model = !arguments.containsKey("model") ? "" : arguments.get("model").toString();
                String string = mcp_client = !arguments.containsKey("mcp_client") ? "" : arguments.get("mcp_client").toString();
                if (sql.isEmpty()) {
                    throw new ArgumentException("SQLcl argument is required");
                }
                if (model.isEmpty()) {
                    throw new ArgumentException("Model name argument is required");
                }
                if (mcp_client.isEmpty()) {
                    throw new ArgumentException("MCP Client name argument is required");
                }
                SqlClCommandsRunner sqlcl = SqlClCommandsRunner.builder().connection(ctx.getCurrentConnection()).build();
                if (!ctx.getCurrentConnection().isClosed()) {
                    try {
                        this.createMcpLogTable(ctx.getCurrentConnection());
                    }
                    catch (AuditTableException e) {
                        contents.add(new McpSchema.TextContent(e.getLocalizedMessage()));
                    }
                    QueryUtils.insertSessionInfo(ctx.getCurrentConnection(), "run-sqlcl", model);
                    QueryUtils.insertClientInfo(ctx.getCurrentConnection(), mcp_client);
                    QueryUtils.insertIntoDbtoolsMcpLog(ctx.getCurrentConnection(), mcp_client, model, "tool", "run-sqlcl", sql);
                }
                contents.add(new McpSchema.TextContent(sqlcl.run("SET SQLFORMAT CSV\n" + sql)));
            }
            catch (SQLException | ArgumentException e) {
                contents.clear();
                contents.add(new McpSchema.TextContent("ERROR: " + ((Throwable)e).getLocalizedMessage()));
                contents.add(new McpSchema.TextContent("\nBased on the error thrown, provide the user with a clear explanation of what went wrong. If possible, correct the issue and retry the request"));
            }
            return new McpSchema.CallToolResult(contents, Boolean.valueOf(false));
        });
    }
}

