/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.mcp.tools;

import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.spec.McpError;
import io.modelcontextprotocol.spec.McpSchema;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.extension.mcp.tools.McpTool;
import oracle.dbtools.extension.mcp.utils.ConnectionUtils;
import oracle.dbtools.extension.mcp.utils.QueryUtils;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;

public class ListConnectionsTool
implements McpTool {
    private final String toolName = "list-connections";

    @Override
    public McpServerFeatures.SyncToolSpecification create(ScriptRunnerContext ctx) {
        return new McpServerFeatures.SyncToolSpecification(new McpSchema.Tool("list-connections", "List all available oracle named/saved connections in the connections storage\nThe `model` argument should specify only the name and version of the LLM (Large Language Model) you are using, with no additional information.\nThe `mcp_client` argument should specify only the name of the MCP (Model Context Protocol) client you are using, with no additional information.", "{\n  \"type\" : \"object\",\n  \"id\" : \"urn:jsonschema:Operation\",\n  \"properties\" : {\n    \"filter\" : {\n      \"type\" : \"string\"\n    },\n     \"mcp_client\" : {\n      \"type\" : \"string\"\n    },\n    \"model\" : {\n      \"type\" : \"string\"\n    }\n  }\n}"), (exchange, arguments) -> {
            McpSchema.TextContent content;
            try {
                String filter = !arguments.containsKey("filter") ? "" : arguments.get("filter").toString();
                String model = !arguments.containsKey("model") ? "" : arguments.get("model").toString();
                String mcp_client = !arguments.containsKey("mcp_client") ? "" : arguments.get("mcp_client").toString();
                List connections = filter.isEmpty() ? ConnectionUtils.listAllConnectionNames().keySet().stream().toList() : this.subList(ConnectionUtils.listAllConnectionNames(), filter).keySet().stream().toList();
                if (ctx.getCurrentConnection() != null) {
                    QueryUtils.insertSessionInfo(ctx.getCurrentConnection(), "list-connections", model);
                    QueryUtils.insertClientInfo(ctx.getCurrentConnection(), mcp_client);
                    QueryUtils.insertIntoDbtoolsMcpLog(ctx.getCurrentConnection(), mcp_client, model, "tool", "list-connections", "Connect to " + ctx.getCurrentConnection().getSchema());
                }
                content = new McpSchema.TextContent(String.join((CharSequence)",", connections));
            }
            catch (SQLException e) {
                throw new McpError((Object)e);
            }
            return new McpSchema.CallToolResult(Collections.singletonList(content), Boolean.valueOf(false));
        });
    }

    private Map<String, String> subList(Map<String, String> list, String filter) {
        HashMap<String, String> out = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : list.entrySet()) {
            if (!entry.getKey().toLowerCase().contains(filter.toLowerCase()) && !entry.getValue().equalsIgnoreCase(filter)) continue;
            out.put(entry.getKey(), entry.getValue());
        }
        return out;
    }
}

