/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.tns;

import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import oracle.dbtools.core.io.Printable;
import oracle.dbtools.core.tns.OracleConfiguration;
import oracle.dbtools.core.tns.OracleConfigurationSyntaxException;

public class SyntaxErrorReporter
implements Consumer<OracleConfigurationSyntaxException> {
    private final URI location;
    private final Printable output;
    private final IntFunction<String> lines;
    private final Map<URI, Integer> fileErrorCount;

    private SyntaxErrorReporter(Printable output, URI location, IntFunction<String> lines) {
        this.output = output;
        this.location = location;
        this.lines = lines;
        this.fileErrorCount = new LinkedHashMap<URI, Integer>();
    }

    public Map<URI, Integer> fileErrorCount() {
        return this.fileErrorCount;
    }

    public static SyntaxErrorReporter of(Appendable output, Path file) throws IOException {
        return SyntaxErrorReporter.of(output, file, StandardCharsets.UTF_8);
    }

    public static SyntaxErrorReporter of(Appendable output, Path file, Charset charset) throws IOException {
        URI location = file.toUri();
        List<String> lines = Files.readAllLines(file, charset);
        return SyntaxErrorReporter.of(output, location, lines::get);
    }

    public static SyntaxErrorReporter of(Appendable output, URI location, IntFunction<String> lines) {
        return new SyntaxErrorReporter(Printable.of(output), location, lines);
    }

    @Override
    public void accept(OracleConfigurationSyntaxException exception) {
        OracleConfiguration.SyntaxError error = exception.error();
        int lineNumber = error.position().line();
        String lineBeforeError = lineNumber == 0 ? null : this.lines.apply(lineNumber - 1);
        String errorLine = this.lines.apply(lineNumber);
        URI uri = error.location() == null ? this.location : error.location();
        Integer existingErrorCount = this.fileErrorCount.get(uri);
        if (existingErrorCount == null) {
            this.output.println(uri.getPath());
            this.fileErrorCount.put(uri, 1);
        } else {
            this.fileErrorCount.put(uri, existingErrorCount + 1);
        }
        OracleConfiguration.Position position = error.position().plus(1, 1);
        CharSequence message = error.message();
        this.output.println(String.valueOf(position) + " " + String.valueOf(message));
        if (lineBeforeError != null) {
            this.output.indent(2);
            this.output.println(lineBeforeError);
        }
        this.output.indent(2);
        this.output.println(errorLine);
        this.output.indent(2);
        this.output.indent(position.column() - 1);
        this.output.println("^");
    }
}

