/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.text;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Locale;
import oracle.dbtools.core.util.Eraser;

public class Text {
    public static String upperCase(CharSequence text) {
        return text == null ? null : text.toString().toUpperCase(Locale.ROOT);
    }

    public static char[] decode(byte[] utf8) {
        ByteBuffer bytes = ByteBuffer.wrap(utf8);
        CharBuffer buffer = StandardCharsets.UTF_8.decode(bytes);
        char[] buf = buffer.array();
        int position = buffer.position();
        int limit = buffer.limit();
        int offset = buffer.arrayOffset();
        if (offset == 0 && position == 0 && limit == buf.length) {
            return buf;
        }
        char[] chars = Arrays.copyOfRange(buf, offset + position, offset + limit);
        Eraser.erase(buf);
        return chars;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] decodeBase64(char[] base64) {
        CharBuffer chars = CharBuffer.wrap(base64);
        ByteBuffer utf8 = StandardCharsets.UTF_8.encode(chars);
        try {
            byte[] byArray = Base64.getDecoder().decode(utf8).array();
            return byArray;
        }
        finally {
            Eraser.erase(utf8);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char[] encodeBase64(char[] text) {
        CharBuffer chars = CharBuffer.wrap(text);
        ByteBuffer utf8 = StandardCharsets.UTF_8.encode(chars);
        try {
            char[] cArray;
            ByteBuffer bytes = Base64.getEncoder().encode(utf8);
            try {
                CharBuffer base64 = StandardCharsets.UTF_8.decode(bytes);
                cArray = base64.array();
            }
            catch (Throwable throwable) {
                Eraser.erase(bytes);
                throw throwable;
            }
            Eraser.erase(bytes);
            return cArray;
        }
        finally {
            Eraser.erase(utf8);
        }
    }
}

