/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.secrets;

import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import oracle.dbtools.core.secrets.BinarySecret;
import oracle.dbtools.core.secrets.SecretErasedException;
import oracle.dbtools.core.secrets.SecretException;
import oracle.dbtools.core.secrets.TextSecret;

public class BinarySecretImpl
implements BinarySecret {
    private static final int NULL_HASH_CODE = Objects.hashCode(null);
    private static final BinarySecret NONE = new BinarySecretImpl(NULL_HASH_CODE, null, null);
    private final Function<byte[], byte[]> decryptor;
    private final byte[] obfuscated;
    private final AtomicReference<State> state;
    private transient int hashCode;

    BinarySecretImpl(int hashCode, byte[] obfuscated, Function<byte[], byte[]> decryptor) {
        this(obfuscated == null ? State.NONE : State.VALUE, obfuscated == null ? NULL_HASH_CODE : hashCode, obfuscated, decryptor);
    }

    BinarySecretImpl(State state, int hashCode, byte[] obfuscated, Function<byte[], byte[]> decryptor) {
        this.state = new AtomicReference<State>(state);
        this.hashCode = hashCode;
        this.obfuscated = obfuscated;
        this.decryptor = decryptor;
    }

    static BinarySecret copyOf(BinarySecret secret) {
        if (secret == null) {
            return BinarySecret.none();
        }
        if (secret instanceof BinarySecretImpl) {
            BinarySecretImpl existing = (BinarySecretImpl)secret;
            State existingState = existing == null ? State.NONE : existing.state.get();
            switch (existingState.ordinal()) {
                case 1: {
                    byte[] obfuscated = existing.obfuscated;
                    byte[] dupe = Arrays.copyOf(obfuscated, obfuscated.length);
                    return new BinarySecretImpl(existing.hashCode, dupe, existing.decryptor);
                }
                case 2: {
                    throw new SecretErasedException();
                }
            }
            return BinarySecretImpl.none();
        }
        throw new IllegalArgumentException(secret.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean equalPlainText(BinarySecretImpl expected, BinarySecretImpl actual) {
        byte[] expectedPlainText = expected.decrypt();
        byte[] actualPlainText = actual.decrypt();
        try {
            if (expectedPlainText == null) {
                boolean bl = actualPlainText == null;
                return bl;
            }
            boolean bl = Arrays.equals(expectedPlainText, actualPlainText);
            return bl;
        }
        finally {
            BinarySecret.erase(expectedPlainText);
            BinarySecret.erase(actualPlainText);
        }
    }

    static BinarySecret none() {
        return NONE;
    }

    @Override
    public void close() {
        if (this.state.compareAndSet(State.VALUE, State.ERASED)) {
            BinarySecret.erase(this.obfuscated);
            this.hashCode = NULL_HASH_CODE;
        }
    }

    byte[] decrypt() {
        State state = this.state.get();
        switch (state.ordinal()) {
            case 1: {
                return this.decryptor.apply(this.obfuscated);
            }
            case 2: {
                throw new SecretErasedException();
            }
        }
        return null;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BinarySecretImpl)) {
            return false;
        }
        BinarySecretImpl secret = (BinarySecretImpl)o;
        return this.hashCode == secret.hashCode && this.state.get().equals((Object)secret.state.get()) && BinarySecretImpl.equalPlainText(this, secret);
    }

    @Override
    public boolean isPresent() {
        State state = this.state.get();
        return State.VALUE == state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T map(BinarySecret.ProtectedMapper<T> mapper, TextSecret password) {
        byte[] plainText = this.decrypt();
        if (plainText != null) {
            try {
                Object object = password.mapOrElse((char[] plainTextPassword) -> mapper.apply(plainText, plainTextPassword), () -> mapper.apply(plainText, null));
                return (T)object;
            }
            finally {
                BinarySecret.erase(plainText);
            }
        }
        return null;
    }

    @Override
    public <T> T mapOrElse(BinarySecret.Mapper<T> mapper, Callable<T> action) {
        byte[] plainText = this.decrypt();
        if (plainText == null) {
            try {
                return action.call();
            }
            catch (Exception e) {
                throw SecretException.of(e);
            }
        }
        try {
            T e = mapper.apply(plainText);
            return e;
        }
        catch (Exception e) {
            throw SecretException.of(e);
        }
        finally {
            BinarySecret.erase(plainText);
        }
    }

    static enum State {
        NONE,
        VALUE,
        ERASED;

    }
}

