/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.jdbc.wallet;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.sql.SQLException;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.net.ssl.SSLContext;
import oracle.dbtools.core.io.InputOutputStreams;
import oracle.dbtools.core.jdbc.DataSourceBuilder;
import oracle.dbtools.core.jdbc.DataSourceBuilderBase;
import oracle.dbtools.core.jdbc.DataSourceConfigurator;
import oracle.dbtools.core.jdbc.tns.TNSEntry;
import oracle.dbtools.core.jdbc.tns.TNSNames;
import oracle.dbtools.core.jdbc.wallet.AutoLoginWallet;
import oracle.dbtools.core.jdbc.wallet.DatabaseToolsProperties;
import oracle.dbtools.core.jdbc.wallet.ServiceCredentials;
import oracle.dbtools.core.secrets.TextSecret;
import oracle.dbtools.core.zip.ZipArchive;
import oracle.jdbc.datasource.OracleDataSource;

public class OracleWalletArchive
implements DataSourceConfigurator {
    private static final OracleWalletArchive EMPTY = OracleWalletArchive.builder().build();
    public static final String AUTO_LOGIN_WALLET = "cwallet.sso";
    public static final String DBTOOLS_PROPERTIES = "dbtools.properties";
    public static final String TNSNAMES_ORA = "tnsnames.ora";
    private static final InputOutputStreams STREAMS = InputOutputStreams.instance();
    private final DatabaseToolsProperties databaseToolsProperties;
    private final TNSNames tnsNames;
    private final AutoLoginWallet wallet;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(InputStream content) throws IOException {
        Builder b = new Builder();
        ZipArchive archive = ZipArchive.from(content);
        try (ZipInputStream zip = archive.toZipInputStream();){
            ZipEntry entry = zip.getNextEntry();
            while (entry != null) {
                InputStream entryContent = STREAMS.uncloseable(zip);
                String name = entry.getName();
                if (AUTO_LOGIN_WALLET.equalsIgnoreCase(name)) {
                    b.autoLoginWallet(AutoLoginWallet.read(entryContent));
                } else if (DBTOOLS_PROPERTIES.equalsIgnoreCase(name)) {
                    b.databaseToolsProperties(DatabaseToolsProperties.read(entryContent));
                } else if (TNSNAMES_ORA.equalsIgnoreCase(name)) {
                    b.tnsNames(TNSNames.read(entryContent));
                } else {
                    STREAMS.copy(entryContent, STREAMS.nullOutputStream());
                }
                entry = zip.getNextEntry();
            }
        }
        return b;
    }

    public static OracleWalletArchive read(InputStream content) throws IOException {
        return OracleWalletArchive.builder(content).build();
    }

    OracleWalletArchive(AutoLoginWallet wallet, DatabaseToolsProperties databaseToolsProperties, TNSNames tnsNames) {
        this.wallet = wallet;
        this.databaseToolsProperties = databaseToolsProperties;
        this.tnsNames = tnsNames;
    }

    @Override
    public void configure(DataSourceBuilder<?> dataSourceBuilder) throws SQLException, IOException {
        URI httpsProxy;
        String serviceAlias = dataSourceBuilder.serviceAlias() != null ? dataSourceBuilder.serviceAlias() : this.databaseToolsProperties.serviceAlias();
        URI uRI = httpsProxy = dataSourceBuilder.httpsProxy() != null ? dataSourceBuilder.httpsProxy() : this.databaseToolsProperties.httpsProxy();
        if (serviceAlias != null) {
            TNSEntry tnsEntry;
            ServiceCredentials credentials = this.wallet.credentials(serviceAlias);
            if (credentials != null) {
                credentials.configure(dataSourceBuilder);
            }
            if ((tnsEntry = this.tnsNames.getTNSEntry(serviceAlias)) != null) {
                if (httpsProxy == null) {
                    tnsEntry.configure(dataSourceBuilder);
                } else {
                    tnsEntry.withHttpsProxy(httpsProxy).configure(dataSourceBuilder);
                }
            }
            dataSourceBuilder.serviceAlias(serviceAlias);
        }
        if (httpsProxy != null) {
            dataSourceBuilder.httpsProxy(httpsProxy);
        }
        this.wallet.configure(dataSourceBuilder);
    }

    public static OracleWalletArchive empty() {
        return EMPTY;
    }

    public final AutoLoginWallet getAutoLoginWallet() {
        return this.wallet;
    }

    public final DatabaseToolsProperties getDatabaseToolsProperties() {
        return this.databaseToolsProperties;
    }

    public final TNSNames getTNSNames() {
        return this.tnsNames;
    }

    public boolean isConfigurable() throws SQLException, IOException {
        if (this.getAutoLoginWallet().secrets().isEmpty() && this.getDatabaseToolsProperties().isEmpty() && this.getTNSNames().isEmpty()) {
            ValidatingDataSourceBuilder b = new ValidatingDataSourceBuilder();
            this.configure(b);
            if (b.sslContext == null) {
                return false;
            }
        }
        return true;
    }

    public Builder modify() {
        Builder b = OracleWalletArchive.builder();
        b.autoLoginWallet(this.wallet);
        b.databaseToolsProperties(this.databaseToolsProperties);
        b.tnsNames(this.tnsNames);
        return b;
    }

    public OracleWalletArchive merge(OracleWalletArchive overrides) throws IOException {
        if (this == overrides || overrides == null) {
            return this;
        }
        return this.modify().merge(overrides).build();
    }

    public static class Builder {
        private AutoLoginWallet wallet;
        private DatabaseToolsProperties databaseToolsProperties;
        private TNSNames tnsNames;

        private Builder() {
            this.autoLoginWallet(null);
            this.databaseToolsProperties(null);
            this.tnsNames(null);
        }

        public Builder autoLoginWallet(AutoLoginWallet wallet) {
            this.wallet = wallet != null ? wallet : AutoLoginWallet.empty();
            return this;
        }

        public Builder databaseToolsProperties(DatabaseToolsProperties databaseToolsProperties) {
            this.databaseToolsProperties = databaseToolsProperties != null ? databaseToolsProperties : DatabaseToolsProperties.empty();
            return this;
        }

        public Builder tnsNames(TNSNames tnsNames) {
            this.tnsNames = tnsNames != null ? tnsNames : TNSNames.empty();
            return this;
        }

        public Builder merge(OracleWalletArchive overrides) throws IOException {
            if (overrides != null) {
                this.autoLoginWallet(this.wallet.modify().merge(overrides.wallet).build());
                this.databaseToolsProperties(this.databaseToolsProperties.isEmpty() ? overrides.databaseToolsProperties : this.databaseToolsProperties);
                this.tnsNames(this.tnsNames.isEmpty() ? overrides.tnsNames : this.tnsNames);
            }
            return this;
        }

        public OracleWalletArchive build() {
            return new OracleWalletArchive(this.wallet, this.databaseToolsProperties, this.tnsNames);
        }
    }

    private static final class ValidatingDataSourceBuilder
    extends DataSourceBuilderBase<OracleDataSource> {
        SSLContext sslContext;

        private ValidatingDataSourceBuilder() {
        }

        @Override
        public ValidatingDataSourceBuilder sslContext(SSLContext sslContext) {
            super.sslContext(sslContext);
            this.sslContext = sslContext;
            return this;
        }

        @Override
        protected void configure(OracleDataSource ds, String url, String user, TextSecret passwordSecret, Properties connectionProperties, SSLContext sslContext, Boolean fastConnectionFailover, String onsConfiguration, Boolean createConnectionInBorrowThread) throws SQLException {
            this.sslContext = sslContext;
        }

        @Override
        protected OracleDataSource createDataSource() throws SQLException {
            throw new UnsupportedOperationException();
        }
    }
}

