/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.connections.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Properties;
import oracle.dbtools.core.collections.ConfigurationProperties;
import oracle.dbtools.core.connections.ConnectionIdentifiers;
import oracle.dbtools.core.connections.storage.ConnectionDefinition;
import oracle.dbtools.core.connections.storage.ConnectionStorage;
import oracle.dbtools.core.connections.storage.StoreException;
import oracle.dbtools.core.connections.storage.UnicodeSafeWalletSecrets;
import oracle.dbtools.core.io.file.HomeFolder;
import oracle.dbtools.core.secrets.Secrets;
import oracle.dbtools.core.secrets.TextSecret;
import oracle.security.pki.OracleSecretStore;
import oracle.security.pki.OracleSecretStoreException;
import oracle.security.pki.OracleWallet;

public final class ConnectionTestSupport {
    public static final String DEFAULT_CONNECTIONS_PROPERTIES = "connections.properties";
    private final Properties properties;
    private final ConnectionStorage storage = ConnectionStorage.instance();

    public static ConnectionTestSupport of(Class refClass, String propertiesFile) throws Exception {
        Properties properties = new Properties();
        try (InputStream is = refClass.getResourceAsStream(propertiesFile);){
            properties.load(is);
        }
        return new ConnectionTestSupport(properties);
    }

    public static ConnectionTestSupport of(Properties properties) {
        return new ConnectionTestSupport(properties);
    }

    private ConnectionTestSupport(Properties properties) {
        this.properties = properties;
    }

    private static void delete(Path path) {
        try {
            if (Files.isDirectory(path, new LinkOption[0])) {
                Files.list(path).forEach(ConnectionTestSupport::delete);
            }
            Files.deleteIfExists(path);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static String formatKeyName(String connName, String propertyName) {
        return connName + "." + propertyName;
    }

    public ConnectionDefinition createConnection(String connName, String ... additionalProperties) {
        ConnectionDefinition.Builder defBuilder = ConnectionDefinition.builder(ConnectionIdentifiers.createUniqueIdentifier());
        ConfigurationProperties.Builder configurationPropertiesBuilder = ConfigurationProperties.builder();
        ConfigurationProperties.Builder advancedBuilder = ConfigurationProperties.builder();
        configurationPropertiesBuilder.set("name", connName).set("type", this.properties.getProperty(ConnectionTestSupport.formatKeyName(connName, "type"), "ORACLE_DATABASE"));
        String userName = this.properties.getProperty(ConnectionTestSupport.formatKeyName(connName, "userName"));
        if (userName != null) {
            configurationPropertiesBuilder.set("userName", userName);
        }
        if (additionalProperties != null) {
            for (String key : additionalProperties) {
                String propValue = this.properties.getProperty(ConnectionTestSupport.formatKeyName(connName, key));
                if (key.startsWith("advanced.")) {
                    String advancedKey = key.substring("advanced.".length());
                    advancedBuilder.set(advancedKey, propValue);
                    continue;
                }
                configurationPropertiesBuilder.set(key, propValue);
            }
        }
        defBuilder.dbtoolsProperties(configurationPropertiesBuilder.build());
        defBuilder.ojdbcProperties(advancedBuilder.build());
        String pwdValue = this.properties.getProperty(ConnectionTestSupport.formatKeyName(connName, "userPassword"));
        TextSecret password = pwdValue != null ? Secrets.instance().of(pwdValue.toCharArray(), true) : TextSecret.none();
        try {
            if (password.isPresent()) {
                OracleWallet wallet = new OracleWallet();
                wallet.createSSO();
                OracleSecretStore store = wallet.getSecretStore();
                UnicodeSafeWalletSecrets secrets = UnicodeSafeWalletSecrets.of(store);
                secrets.write((CharSequence)"dbtools.database.password.base64", password);
                wallet.setSecretStore(store);
                defBuilder.wallet(wallet);
            }
        }
        catch (IOException | OracleSecretStoreException e) {
            throw new StoreException((Exception)e);
        }
        return defBuilder.build();
    }

    public void addConnection(ConnectionDefinition connectionDefinition) {
        this.storage.storeDefinition(connectionDefinition);
    }

    static {
        String userDir = System.getProperty("user.dir");
        HomeFolder home = HomeFolder.builder().explicit(Path.of(userDir, "target", ".dbtools")).build();
        ConnectionStorage.configureDBToolsHome(home);
        Path dest = home.connectionsPath();
        if (!Files.exists(dest, new LinkOption[0])) {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> ConnectionTestSupport.delete(dest), "Delete Thread"));
        }
    }
}

