/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.connections.helpers;

import oracle.dbtools.core.connections.storage.ConnectionDefinition;
import oracle.dbtools.core.util.MessageLogger;

public final class ConnectionHelperContext {
    private final ConnectionDefinition definition;
    private final MessageLogger logger;

    public static Builder builder(ConnectionDefinition definition) {
        return new Builder(definition);
    }

    public static ConnectionHelperContext of(ConnectionDefinition definition, MessageLogger logger) {
        return new Builder(definition).logger(logger).build();
    }

    private ConnectionHelperContext(Builder builder) {
        this.definition = builder.definition;
        this.logger = builder.logger == null ? MessageLogger.builder().interactiveLogger(System.out::println).build() : builder.logger;
    }

    public ConnectionDefinition getDefinition() {
        return this.definition;
    }

    public MessageLogger getLogger() {
        return this.logger;
    }

    public static final class Builder {
        private ConnectionDefinition definition;
        private MessageLogger logger;

        private Builder(ConnectionDefinition definition) {
            this.definition = definition;
        }

        public Builder logger(MessageLogger logger) {
            this.logger = logger;
            return this;
        }

        public ConnectionHelperContext build() {
            return new ConnectionHelperContext(this);
        }
    }
}

