/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sqlcl.commands.blockchain;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import oracle.dbtools.common.utils.StringUtils;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import oracle.dbtools.raptor.query.Bind;
import oracle.dbtools.sqlcl.commands.blockchain.BICException;
import oracle.dbtools.sqlcl.commands.blockchain.BICModel;
import oracle.dbtools.sqlcl.commands.blockchain.BICOptions;
import oracle.dbtools.sqlcl.commands.blockchain.BICStubs;
import oracle.dbtools.sqlcl.commands.blockchain.Messages;

public class DDLProcessor {
    public static void descTable(BICModel model, ParsedCommand parsedCommand) throws BICException {
        String schema_name;
        String table_name;
        String query1 = BICStubs.getQuery("DESC", model.getConnection(), "oracle/dbtools/sqlcl/commands/blockchain/DDL.xml");
        String query2 = null;
        String query3 = null;
        Boolean isIT = Boolean.FALSE;
        String optVal = null;
        String tableName = null;
        String[] queryType = model.getCommand().getSql().toUpperCase().split(" ");
        String type = null;
        Id tableNameID = null;
        if (queryType[0].equalsIgnoreCase("Immutable_table") || queryType[0].equalsIgnoreCase("im")) {
            type = "IMMUTABLE";
            tableNameID = BICOptions.tableName_immutable_req.getId();
            query2 = BICStubs.getQuery("DESC_SELECT_IT", model.getConnection(), "oracle/dbtools/sqlcl/commands/blockchain/DDL.xml");
            isIT = Boolean.TRUE;
        } else if (queryType[0].equalsIgnoreCase("Blockchain_Table") || queryType[0].equalsIgnoreCase("bl")) {
            type = "BLOCKCHAIN";
            tableNameID = BICOptions.tableName_blockchain_req.getId();
            query2 = BICStubs.getQuery("DESC_SELECT_BT", model.getConnection(), "oracle/dbtools/sqlcl/commands/blockchain/DDL.xml");
        }
        if (parsedCommand.getOptionValue(tableNameID) != null && parsedCommand.getOptionValue(tableNameID).toString().startsWith(":")) {
            try {
                optVal = ((Bind)model.getContext().getVarMap().get(parsedCommand.getOptionValue(tableNameID).toString().substring(1).toUpperCase())).getValue();
                if (optVal == null) {
                    throw new BICException(new String[]{String.format(Messages.getString("BICEXP.EMPTY_BIND_VARIABLE"), parsedCommand.getOptionValue(tableNameID).toString(), BICOptions.tableName_blockchain_req.getName())});
                }
            }
            catch (NullPointerException e) {
                throw new BICException(new String[]{String.format(Messages.getString("BICEXP.EMPTY_BIND_VARIABLE"), parsedCommand.getOptionValue(tableNameID).toString(), BICOptions.tableName_blockchain_req.getName())});
            }
        }
        if (type != null && !BICStubs.validateTable(model, parsedCommand, tableNameID, type, optVal).booleanValue()) {
            try {
                tableName = optVal == null ? (String)parsedCommand.getOptionValue(tableNameID) : optVal;
                int dotIndex = BICStubs.findUnquotedPeriod(tableName);
                if (type.equals("IMMUTABLE")) {
                    if (dotIndex == -1) {
                        throw new BICException(new String[]{String.format(Messages.getString("BICEXP.IT.ERROR"), model.getConnection().getSchema() + "." + tableName)});
                    }
                    throw new BICException(new String[]{String.format(Messages.getString("BICEXP.IT.ERROR"), tableName)});
                }
                if (dotIndex == -1) {
                    throw new BICException(new String[]{String.format(Messages.getString("BICEXP.BT.ERROR"), model.getConnection().getSchema() + "." + tableName)});
                }
                throw new BICException(new String[]{String.format(Messages.getString("BICEXP.BT.ERROR"), tableName)});
            }
            catch (SQLException e) {
                throw new BICException(new String[]{String.format(e.getMessage(), new Object[0])});
            }
        }
        tableName = optVal == null ? (String)parsedCommand.getOptionValue(tableNameID) : optVal;
        if (model.getDbMajorVersion() >= 23) {
            query3 = isIT != false ? BICStubs.getQuery("DESC_SELECT_IT_ROW_VER", model.getConnection(), "oracle/dbtools/sqlcl/commands/blockchain/DDL.xml") : BICStubs.getQuery("DESC_SELECT_BT_ROW_VER", model.getConnection(), "oracle/dbtools/sqlcl/commands/blockchain/DDL.xml");
        }
        try {
            ArrayList<String> temp = BICStubs.modifyTableName(tableName);
            table_name = temp.get(0);
            schema_name = temp.size() > 1 ? temp.get(1) : model.getConnection().getSchema();
        }
        catch (SQLException e) {
            throw new BICException(new String[]{String.format(e.getMessage(), new Object[0])});
        }
        if (query1 != null) {
            query1 = String.format(query1, table_name, schema_name);
        }
        if (query2 != null) {
            query2 = String.format(query2, table_name, schema_name);
        }
        if (query3 != null) {
            query3 = String.format(query3, table_name, schema_name);
        }
        ResultSet response3 = null;
        ScriptRunnerContext ctx = model.getContext();
        try (Statement stmt1 = model.getConnection().createStatement(1004, 1007);
             Statement stmt2 = model.getConnection().createStatement();
             Statement stmt3 = model.getConnection().createStatement();){
            ResultSet response1 = stmt1.executeQuery(query1);
            ResultSet response2 = stmt2.executeQuery(query2);
            String sep = "-";
            if (query3 != null) {
                response3 = stmt3.executeQuery(query3);
            }
            if (type != null) {
                String heading = String.valueOf(StringUtils.initCapSingle((String)type.toLowerCase())) + " table '" + tableName + "'";
                ctx.writeln(heading);
                ctx.writeln(sep.repeat(heading.length()));
                ctx.writeln("\n");
            }
            ResultSetMetaData rsmd = response1.getMetaData();
            int totalCols = rsmd.getColumnCount();
            int[] colSize = new int[totalCols];
            StringBuilder sb = new StringBuilder();
            boolean isEmpty = Boolean.TRUE;
            while (response1.next()) {
                colSize[0] = Integer.max(colSize[0], Integer.max(response1.getString("COLUMN_NAME") != null ? response1.getString("COLUMN_NAME").length() : rsmd.getColumnLabel(1).length(), rsmd.getColumnLabel(1).length()));
                colSize[1] = Integer.max(colSize[1], Integer.max(response1.getString("NULL?") != null ? response1.getString("NULL?").length() : rsmd.getColumnLabel(2).length(), rsmd.getColumnLabel(2).length()));
                colSize[2] = Integer.max(colSize[2], Integer.max(response1.getString("DATA_TYPE") != null ? response1.getString("DATA_TYPE").length() : rsmd.getColumnLabel(3).length(), rsmd.getColumnLabel(3).length()));
                isEmpty = Boolean.FALSE;
            }
            if (!isEmpty) {
                int i;
                for (i = 0; i < totalCols; ++i) {
                    sb.append(String.format("%-" + colSize[i] + "s\t", rsmd.getColumnLabel(i + 1)));
                }
                sb.append("\n");
                response1.beforeFirst();
                for (i = 0; i < totalCols; ++i) {
                    sb.append(String.format(sep.repeat(colSize[i]) + "\t", new Object[0]));
                }
                sb.append("\n");
                response1.beforeFirst();
                while (response1.next()) {
                    sb.append(String.format("%-" + colSize[0] + "s\t", response1.getString("COLUMN_NAME")));
                    sb.append(String.format("%-" + colSize[1] + "s\t", response1.getString("NULL?")));
                    sb.append(String.format("%-" + colSize[2] + "s\t", response1.getString("DATA_TYPE")));
                    sb.append("\n");
                }
                ctx.writeln(sb.toString());
                while (response2.next()) {
                    ctx.writeln("Other Attributes: ");
                    ctx.writeln("------------------");
                    ctx.writeln("ROW RETENTION (DAYS)              : " + response2.getString("row_retention"));
                    ctx.writeln("ROW RETENTION LOCKED              : " + response2.getString("row_retention_locked"));
                    ctx.writeln("TABLE INACTIVITY RETENTION (DAYS) : " + response2.getString("table_inactivity_retention"));
                    if (!isIT.booleanValue()) {
                        ctx.writeln("HASHING ALGORITHM                 : " + response2.getString("hash_algorithm"));
                    }
                    if (model.getDbMajorVersion() >= 23) {
                        ctx.writeln("TABLE VERSION                     : " + response2.getString("table_version"));
                        continue;
                    }
                    ctx.writeln("TABLE VERSION                     : V1");
                }
                if (query3 != null) {
                    while (response3.next()) {
                        ctx.writeln("ROW_VERSION_NAME                  : " + response3.getString("ROW_VERSION_NAME"));
                        if (!isIT.booleanValue()) {
                            ctx.writeln("USER_CHAIN                        : " + response3.getString("USER_CHAIN"));
                        }
                        if (response3.getString("USER_CHAIN") == null) continue;
                        if (response3.getString("KEYCOL1_NAME") != null) {
                            ctx.writeln("  -> KEYCOL1_NAME                      : " + response3.getString("KEYCOL1_NAME"));
                        }
                        if (response3.getString("KEYCOL2_NAME") != null) {
                            ctx.writeln("  -> KEYCOL2_NAME                      : " + response3.getString("KEYCOL2_NAME"));
                        }
                        if (response3.getString("KEYCOL3_NAME") == null) continue;
                        ctx.writeln("  -> KEYCOL3_NAME                      : " + response3.getString("KEYCOL3_NAME"));
                    }
                }
            } else {
                ctx.writeln(String.format(Messages.getString("DESCRIPTION.NOT_AVAILABLE"), new Object[0]));
            }
        }
        catch (SQLException e) {
            throw new BICException(new String[]{String.format(e.getMessage(), new Object[0])});
        }
    }
}

