/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sqlcl.commands.blockchain;

import jakarta.json.Json;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonValue;
import jakarta.json.JsonWriter;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import oracle.dbtools.sqlcl.commands.blockchain.BICException;
import oracle.dbtools.sqlcl.commands.blockchain.BICModel;
import oracle.dbtools.sqlcl.commands.blockchain.BICOptions;
import oracle.dbtools.sqlcl.commands.blockchain.BICStubs;
import oracle.dbtools.sqlcl.commands.blockchain.Messages;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleType;
import oracle.sql.ARRAY;
import oracle.sql.BLOB;
import oracle.sql.NUMBER;
import oracle.sql.RAW;
import oracle.sql.STRUCT;

public class BlockchainProcessor {
    public static void verifyRows(BICModel model, ParsedCommand parsedCommand) throws BICException, SQLException {
        LinkedHashMap<Id, Object> binds = new LinkedHashMap<Id, Object>();
        LinkedHashSet<Id> InVar = new LinkedHashSet<Id>();
        LinkedHashSet<Id> OutBinds = new LinkedHashSet<Id>();
        InVar.add(BICOptions.tableName_blockchain_req.getId());
        InVar.add(BICOptions.low_timestamp.getId());
        InVar.add(BICOptions.high_timestamp.getId());
        InVar.add(BICOptions.instance_id.getId());
        InVar.add(BICOptions.chain_id.getId());
        OutBinds.add(BICOptions.verified_rows_count.getId());
        InVar.add(BICOptions.skip_user_signature_23C.getId());
        InVar.add(BICOptions.skip_delegate_signature.getId());
        InVar.add(BICOptions.skip_countersignature.getId());
        InVar.add(BICOptions.pdb_guid.getId());
        binds = BICStubs.collectOptionValue(model, parsedCommand, binds, InVar, OutBinds, null);
        BICStubs.booleanBinds.clear();
        String query = BICStubs.getQuery("VERIFY_ROWS", model.getConnection(), "oracle/dbtools/sqlcl/commands/blockchain/blockchainQueries.xml");
        if (model.getDbMajorVersion() >= 23) {
            if (!binds.get(BICOptions.pdb_guid.getId()).equals("")) {
                binds.put(BICOptions.pdb_guid.getId(), BICStubs.hexToRaw((String)binds.get(BICOptions.pdb_guid.getId())));
            }
            if (parsedCommand.getOptionValue(BICOptions.skip_user_signature_23C.getId()).toString().equalsIgnoreCase(Boolean.TRUE.toString())) {
                BICStubs.booleanBinds.put(BICOptions.skip_user_signature_23C.getId(), Boolean.FALSE.toString());
            } else {
                BICStubs.booleanBinds.put(BICOptions.skip_user_signature_23C.getId(), Boolean.TRUE.toString());
            }
            if (parsedCommand.getOptionValue(BICOptions.skip_delegate_signature.getId()).toString().equalsIgnoreCase(Boolean.TRUE.toString())) {
                BICStubs.booleanBinds.put(BICOptions.skip_delegate_signature.getId(), Boolean.FALSE.toString());
            } else {
                BICStubs.booleanBinds.put(BICOptions.skip_delegate_signature.getId(), Boolean.TRUE.toString());
            }
            if (parsedCommand.getOptionValue(BICOptions.skip_countersignature.getId()).toString().equalsIgnoreCase(Boolean.TRUE.toString())) {
                BICStubs.booleanBinds.put(BICOptions.skip_countersignature.getId(), Boolean.FALSE.toString());
            } else {
                BICStubs.booleanBinds.put(BICOptions.skip_countersignature.getId(), Boolean.TRUE.toString());
            }
        } else {
            if (!binds.get(BICOptions.pdb_guid.getId()).equals("")) {
                throw new BICException(new String[]{String.format(Messages.getString("BICEXP.UNSUPPORTED_OPTION"), BICOptions.pdb_guid.getName(), model.getCommand().getSql().toLowerCase().trim(), model.getDbVersion())});
            }
            if (parsedCommand.getOptionValue(BICOptions.skip_delegate_signature.getId()).toString().equals(Boolean.TRUE.toString())) {
                throw new BICException(new String[]{String.format(Messages.getString("BICEXP.UNSUPPORTED_OPTION"), BICOptions.skip_delegate_signature.getName(), model.getCommand().getSql().toLowerCase().trim(), model.getDbVersion())});
            }
            if (parsedCommand.getOptionValue(BICOptions.skip_countersignature.getId()).toString().equals(Boolean.TRUE.toString())) {
                throw new BICException(new String[]{String.format(Messages.getString("BICEXP.UNSUPPORTED_OPTION"), BICOptions.skip_countersignature.getName(), model.getCommand().getSql().toLowerCase().trim(), model.getDbVersion())});
            }
            BICStubs.booleanBinds.remove(BICOptions.skip_delegate_signature.getId());
            BICStubs.booleanBinds.remove(BICOptions.skip_countersignature.getId());
            binds.remove(BICOptions.pdb_guid.getId());
            if (parsedCommand.getOptionValue(BICOptions.skip_user_signature_23C.getId()).toString().equalsIgnoreCase(Boolean.TRUE.toString())) {
                BICStubs.booleanBinds.put(BICOptions.skip_user_signature_23C.getId(), Boolean.FALSE.toString());
            } else {
                BICStubs.booleanBinds.put(BICOptions.skip_user_signature_23C.getId(), Boolean.TRUE.toString());
            }
        }
        if (query != null) {
            query = String.format(query, new ArrayList<String>(BICStubs.booleanBinds.values()).toArray());
        }
        BICStubs.booleanBinds.clear();
        OracleCallableStatement returnStatement = null;
        if (LockManager.lock((Connection)model.getConnection())) {
            try {
                returnStatement = (OracleCallableStatement)BICStubs.bind(model.getConnection().prepareCall(query), new ArrayList<Object>(binds.values()));
                returnStatement.registerOutParameter(binds.size() + 1, (SQLType)OracleType.NUMBER);
                returnStatement.executeUpdate();
                NUMBER num_of_rows_verified = returnStatement.getNUMBER(binds.size() + 1);
                model.getContext().writeln("Command executed successfully.");
                model.getContext().writeln("Verified " + num_of_rows_verified.stringValue() + " rows from '" + String.valueOf(binds.get(BICOptions.schema.getId())) + "." + String.valueOf(binds.get(BICOptions.tableName_blockchain_req.getId())) + "' table.");
                BICStubs.populateBindVariableStringValue(model, BICOptions.verified_rows_count, num_of_rows_verified.stringValue());
            }
            catch (SQLException e) {
                throw new BICException(new String[]{String.format(e.getMessage(), new Object[0])});
            }
            finally {
                if (returnStatement != null) {
                    returnStatement.close();
                }
                LockManager.unlock((Connection)model.getConnection());
            }
        }
    }

    public static void getBytForRowHash(BICModel model, ParsedCommand parsedCommand) throws BICException, SQLException {
        String query;
        LinkedHashMap<Id, Object> binds = new LinkedHashMap<Id, Object>();
        LinkedHashSet<Id> InVar = new LinkedHashSet<Id>();
        LinkedHashSet<Id> OutFiles = new LinkedHashSet<Id>();
        InVar.add(BICOptions.tableName_blockchain_req.getId());
        InVar.add(BICOptions.instance_id.getId());
        InVar.add(BICOptions.chain_id.getId());
        InVar.add(BICOptions.sequence_id.getId());
        InVar.add(BICOptions.data_format_hash.getId());
        InVar.add(BICOptions.row_data_bytes.getId());
        OutFiles.add(BICOptions.row_data_file.getId());
        InVar.add(BICOptions.user_chain.getId());
        InVar.add(BICOptions.keycol1_name.getId());
        InVar.add(BICOptions.keycol1_value.getId());
        InVar.add(BICOptions.keycol2_name.getId());
        InVar.add(BICOptions.keycol2_value.getId());
        InVar.add(BICOptions.keycol3_name.getId());
        InVar.add(BICOptions.keycol3_value.getId());
        InVar.add(BICOptions.pdb_guid.getId());
        binds = BICStubs.collectOptionValue(model, parsedCommand, binds, InVar, null, OutFiles);
        binds = BICStubs.positionOrKeyCol(binds, parsedCommand, model.getDbMajorVersion());
        if (model.getDbMajorVersion() >= 23) {
            if (!binds.get(BICOptions.pdb_guid.getId()).equals("")) {
                binds.put(BICOptions.pdb_guid.getId(), BICStubs.hexToRaw((String)binds.get(BICOptions.pdb_guid.getId())));
            }
            query = binds.containsKey(BICOptions.keycol1_name.getId()) && binds.containsKey(BICOptions.keycol1_value.getId()) ? BICStubs.getQuery("GET_BYTES_FOR_ROW_HASH_SPECIFIED_BY_KEY_COLUMNS", model.getConnection(), "oracle/dbtools/sqlcl/commands/blockchain/blockchainQueriesP2.xml") : BICStubs.getQuery("GET_BYTES_FOR_ROW_HASH", model.getConnection(), "oracle/dbtools/sqlcl/commands/blockchain/blockchainQueries.xml");
        } else {
            if (!binds.get(BICOptions.user_chain.getId()).equals("")) {
                throw new BICException(new String[]{String.format(Messages.getString("BICEXP.UNSUPPORTED_OPTION"), BICOptions.user_chain.getName(), model.getCommand().getSql().toLowerCase().trim(), model.getDbVersion())});
            }
            if (!binds.get(BICOptions.pdb_guid.getId()).equals("")) {
                throw new BICException(new String[]{String.format(Messages.getString("BICEXP.UNSUPPORTED_OPTION"), BICOptions.pdb_guid.getName(), model.getCommand().getSql().toLowerCase().trim(), model.getDbVersion())});
            }
            binds.remove(BICOptions.user_chain.getId());
            binds.remove(BICOptions.pdb_guid.getId());
            if (binds.containsKey(BICOptions.keycol1_name.getId()) && binds.containsKey(BICOptions.keycol1_value.getId())) {
                binds = BICStubs.findPosition(binds, model, parsedCommand);
                binds.remove(BICOptions.keycol1_name.getId());
                binds.remove(BICOptions.keycol1_value.getId());
                binds.remove(BICOptions.keycol2_name.getId());
                binds.remove(BICOptions.keycol2_value.getId());
                binds.remove(BICOptions.keycol3_name.getId());
                binds.remove(BICOptions.keycol3_value.getId());
            }
            query = BICStubs.getQuery("GET_BYTES_FOR_ROW_HASH", model.getConnection(), "oracle/dbtools/sqlcl/commands/blockchain/blockchainQueries.xml");
        }
        if (binds.get(BICOptions.row_data_bytes.getId()).equals("")) {
            try {
                binds.put(BICOptions.row_data_bytes.getId(), model.getConnection().createBlob());
            }
            catch (SQLException e) {
                throw new BICException(new String[]{String.format(e.getMessage(), new Object[0])});
            }
        }
        OracleCallableStatement returnStatement = null;
        if (LockManager.lock((Connection)model.getConnection())) {
            try {
                returnStatement = (OracleCallableStatement)BICStubs.bind(model.getConnection().prepareCall(query), new ArrayList<Object>(binds.values()));
                returnStatement.registerOutParameter(binds.size() + 1, (SQLType)OracleType.BLOB);
                returnStatement.executeUpdate();
                BLOB hashBytes = returnStatement.getBLOB(binds.size() + 1);
                model.getContext().writeln("Command executed successfully.");
                if (BICStubs.outputBindsAndFiles.get(BICOptions.row_data_file.getId()) != null) {
                    BICStubs.writeBlobToFile((Blob)hashBytes, BICStubs.outputBindsAndFiles.get(BICOptions.row_data_file.getId()), BICOptions.row_data_file.getName());
                }
            }
            catch (SQLException e) {
                throw new BICException(new String[]{String.format(e.getMessage(), new Object[0])});
            }
            finally {
                if (returnStatement != null) {
                    returnStatement.close();
                }
                LockManager.unlock((Connection)model.getConnection());
            }
        }
    }

    public static void getSigBloDigest(BICModel model, ParsedCommand parsedCommand) throws BICException, SQLException {
        OracleCallableStatement returnStatement;
        LinkedHashMap<Id, Object> binds = new LinkedHashMap<Id, Object>();
        LinkedHashSet<Id> InVar = new LinkedHashSet<Id>();
        LinkedHashSet<Id> OutBinds = new LinkedHashSet<Id>();
        LinkedHashSet<Id> OutFiles = new LinkedHashSet<Id>();
        InVar.add(BICOptions.tableName_blockchain_req.getId());
        InVar.add(BICOptions.row_selector.getId());
        InVar.add(BICOptions.row_selector_file.getId());
        InVar.add(BICOptions.signed_bytes.getId());
        InVar.add(BICOptions.row_data_bytes.getId());
        OutFiles.add(BICOptions.signed_bytes_file.getId());
        OutBinds.add(BICOptions.signed_digest.getId());
        OutFiles.add(BICOptions.signed_digest_file.getId());
        OutFiles.add(BICOptions.row_data_file.getId());
        OutFiles.add(BICOptions.signed_row_index_file.getId());
        OutBinds.add(BICOptions.cert_guid.getId());
        InVar.add(BICOptions.signed_digest_algorithm.getId());
        binds = BICStubs.collectOptionValue(model, parsedCommand, binds, InVar, OutBinds, OutFiles);
        BICStubs.isSelectorPresent = binds.get(BICOptions.row_selector.getId()) != null || binds.get(BICOptions.row_selector_file.getId()) != null;
        if (model.getDbMajorVersion() < 23) {
            if (BICStubs.isSelectorPresent.booleanValue()) {
                throw new BICException(new String[]{String.format(Messages.getString("BICEXP.UNSUPPORTED_OPTION"), BICOptions.row_selector.getName() + "' or '" + BICOptions.row_selector_file.getName(), model.getCommand().getSql().toLowerCase().trim(), model.getDbVersion())});
            }
            if (!binds.get(BICOptions.row_data_bytes.getId()).equals("")) {
                throw new BICException(new String[]{String.format(Messages.getString("BICEXP.UNSUPPORTED_OPTION"), BICOptions.row_data_bytes.getName(), model.getCommand().getSql().toLowerCase().trim(), model.getDbVersion())});
            }
            if (BICStubs.outputBindsAndFiles.get(BICOptions.row_data_file.getId()) != null) {
                throw new BICException(new String[]{String.format(Messages.getString("BICEXP.UNSUPPORTED_OPTION"), BICOptions.row_data_file.getName(), model.getCommand().getSql().toLowerCase().trim(), model.getDbVersion())});
            }
        }
        Object row_selector = "";
        if (binds.get(BICOptions.row_selector.getId()) != null && binds.get(BICOptions.row_selector_file.getId()) != null) {
            throw new BICException(new String[]{String.format(Messages.getString("BICEXP.CONFLICTING_OPTION"), BICOptions.row_selector.getName(), BICOptions.row_selector_file.getName())});
        }
        if (binds.get(BICOptions.row_selector_file.getId()) != null) {
            row_selector = BICStubs.parseStringFromFile((String)binds.get(BICOptions.row_selector_file.getId()), BICOptions.row_selector_file.getName());
        } else if (binds.get(BICOptions.row_selector.getId()) != null) {
            row_selector = (String)binds.get(BICOptions.row_selector.getId());
        }
        row_selector = "'" + (String)row_selector + "'";
        binds.remove(BICOptions.row_selector.getId());
        binds.remove(BICOptions.row_selector_file.getId());
        if (binds.get(BICOptions.signed_bytes.getId()).equals("")) {
            try {
                binds.put(BICOptions.signed_bytes.getId(), model.getConnection().createBlob());
            }
            catch (SQLException e) {
                throw new BICException(new String[]{String.format(e.getMessage(), new Object[0])});
            }
        }
        if (!BICStubs.isSelectorPresent.booleanValue()) {
            binds.remove(BICOptions.row_data_bytes.getId());
        } else if (binds.get(BICOptions.row_data_bytes.getId()).equals("")) {
            try {
                binds.put(BICOptions.row_data_bytes.getId(), model.getConnection().createBlob());
            }
            catch (SQLException e) {
                throw new BICException(new String[]{String.format(e.getMessage(), new Object[0])});
            }
        }
        if (BICStubs.outputBindsAndFiles.get(BICOptions.signed_digest.getId()) == null && BICStubs.outputBindsAndFiles.get(BICOptions.signed_digest_file.getId()) == null) {
            throw new BICException(new String[]{String.format(Messages.getString("BICEXP.MISSING_COMPULSORY_PARAMETER"), BICOptions.signed_digest.getName() + "' or '" + BICOptions.signed_digest_file.getName())});
        }
        String algoVal = null;
        if (binds.containsKey(BICOptions.signed_digest_algorithm.getId())) {
            String algoEntry = (String)binds.get(BICOptions.signed_digest_algorithm.getId());
            algoVal = algoEntry.equalsIgnoreCase("RSA_SHA2_512") ? "dbms_blockchain_table.SIGN_ALGO_RSA_SHA2_512" : (algoEntry.equalsIgnoreCase("RSA_SHA2_256") ? "dbms_blockchain_table.SIGN_ALGO_RSA_SHA2_256" : (algoEntry.equalsIgnoreCase("RSA_SHA2_384") ? "dbms_blockchain_table.SIGN_ALGO_RSA_SHA2_384" : algoEntry));
            binds.remove(BICOptions.signed_digest_algorithm.getId());
        }
        String query = BICStubs.isSelectorPresent != false ? BICStubs.getQuery("GET_SIGNED_DIGEST_FOR_SELECTED_ROWS", model.getConnection(), "oracle/dbtools/sqlcl/commands/blockchain/blockchainQueries.xml") : BICStubs.getQuery("GET_SIGNED_DIGEST", model.getConnection(), "oracle/dbtools/sqlcl/commands/blockchain/blockchainQueries.xml");
        if (model.getDbMajorVersion() >= 23 && BICStubs.isSelectorPresent.booleanValue()) {
            if (query != null) {
                query = String.format(query, row_selector, algoVal);
            }
            try {
                returnStatement = (OracleCallableStatement)BICStubs.bind(model.getConnection().prepareCall(query), new ArrayList<Object>(binds.values()));
                returnStatement.registerOutParameter(binds.size() + 1, (SQLType)OracleType.BLOB);
                returnStatement.registerOutParameter(binds.size() + 2, (SQLType)OracleType.BLOB);
                returnStatement.registerOutParameter(binds.size() + 3, 2003, "SYS.ORABCTAB_ROW_ARRAY_T");
                returnStatement.registerOutParameter(binds.size() + 4, (SQLType)OracleType.RAW);
                returnStatement.registerOutParameter(binds.size() + 5, (SQLType)OracleType.RAW);
            }
            catch (SQLException e) {
                throw new BICException(new String[]{String.format(e.getMessage(), new Object[0])});
            }
        }
        if (query != null) {
            query = String.format(query, algoVal);
        }
        try {
            returnStatement = (OracleCallableStatement)BICStubs.bind(model.getConnection().prepareCall(query), new ArrayList<Object>(binds.values()));
            returnStatement.registerOutParameter(binds.size() + 1, (SQLType)OracleType.BLOB);
            returnStatement.registerOutParameter(binds.size() + 2, 2003, "SYS.ORABCTAB_ROW_ARRAY_T");
            returnStatement.registerOutParameter(binds.size() + 3, (SQLType)OracleType.RAW);
            returnStatement.registerOutParameter(binds.size() + 4, (SQLType)OracleType.RAW);
        }
        catch (SQLException e) {
            throw new BICException(new String[]{String.format(e.getMessage(), new Object[0])});
        }
        if (LockManager.lock((Connection)model.getConnection())) {
            try {
                RAW signed_digest;
                returnStatement.executeUpdate();
                BLOB signed_bytes = returnStatement.getBLOB(binds.size() + 1);
                Blob row_data_bytes = BICStubs.isSelectorPresent != false ? returnStatement.getBLOB(binds.size() + 2) : model.getConnection().createBlob();
                ARRAY signed_row_indexes_array = BICStubs.isSelectorPresent != false ? returnStatement.getARRAY(binds.size() + 3) : returnStatement.getARRAY(binds.size() + 2);
                RAW schema_certificate_guid = BICStubs.isSelectorPresent != false ? returnStatement.getRAW(binds.size() + 4) : returnStatement.getRAW(binds.size() + 3);
                RAW rAW = signed_digest = BICStubs.isSelectorPresent != false ? returnStatement.getRAW(binds.size() + 5) : returnStatement.getRAW(binds.size() + 4);
                if (BICStubs.outputBindsAndFiles.get(BICOptions.signed_bytes_file.getId()) != null) {
                    BICStubs.writeBlobToFile((Blob)signed_bytes, BICStubs.outputBindsAndFiles.get(BICOptions.signed_bytes_file.getId()), BICOptions.signed_bytes_file.getName());
                }
                BICStubs.populateBindVariableStringValue(model, BICOptions.signed_digest, signed_digest.stringValue());
                if (BICStubs.outputBindsAndFiles.get(BICOptions.signed_digest_file.getId()) != null) {
                    BICStubs.writeRAWToFile(signed_digest, BICStubs.outputBindsAndFiles.get(BICOptions.signed_digest_file.getId()), BICOptions.signed_digest_file.getName());
                }
                if (BICStubs.outputBindsAndFiles.get(BICOptions.row_data_file.getId()) != null) {
                    BICStubs.writeBlobToFile(row_data_bytes, BICStubs.outputBindsAndFiles.get(BICOptions.row_data_file.getId()), BICOptions.row_data_file.getName());
                }
                if (BICStubs.outputBindsAndFiles.get(BICOptions.signed_row_index_file.getId()) != null) {
                    Object[] arrayElements = (Object[])signed_row_indexes_array.getArray();
                    JsonArrayBuilder jsonArrayBuilder = Json.createArrayBuilder();
                    for (Object element : arrayElements) {
                        jsonArrayBuilder.add((JsonValue)BICStubs.convertOracleSQLStructToJson((STRUCT)element));
                    }
                    StringWriter stringWriter = new StringWriter();
                    try (JsonWriter jsonWriter = Json.createWriter((Writer)stringWriter);){
                        jsonWriter.writeArray(jsonArrayBuilder.build());
                    }
                    BICStubs.writeStringToFile(stringWriter.toString(), BICStubs.outputBindsAndFiles.get(BICOptions.signed_row_index_file.getId()), BICOptions.signed_row_index_file.getName());
                }
                BICStubs.populateBindVariableStringValue(model, BICOptions.cert_guid, schema_certificate_guid.stringValue());
            }
            catch (SQLException e) {
                throw new BICException(new String[]{String.format(e.getMessage(), new Object[0])});
            }
            finally {
                returnStatement.close();
                LockManager.unlock((Connection)model.getConnection());
            }
        }
        model.getContext().writeln("Command executed successfully.");
    }

    public static void verTabBlockchain(BICModel model, ParsedCommand parsedCommand) throws BICException, SQLException {
        LinkedHashMap<Id, Object> binds = new LinkedHashMap<Id, Object>();
        LinkedHashSet<Id> InVar = new LinkedHashSet<Id>();
        LinkedHashSet<Id> OutBinds = new LinkedHashSet<Id>();
        InVar.add(BICOptions.end_bytes_file.getId());
        InVar.add(BICOptions.begin_bytes_file.getId());
        OutBinds.add(BICOptions.verified_rows_count.getId());
        InVar.add(BICOptions.skip_user_signature.getId());
        InVar.add(BICOptions.skip_delegate_signature.getId());
        InVar.add(BICOptions.skip_countersignature.getId());
        binds = BICStubs.collectOptionValue(model, parsedCommand, binds, InVar, OutBinds, null);
        BICStubs.booleanBinds.clear();
        String query = BICStubs.getQuery("VERIFY_TABLE", model.getConnection(), "oracle/dbtools/sqlcl/commands/blockchain/blockchainQueries.xml");
        if (model.getDbMajorVersion() >= 23) {
            if (parsedCommand.getOptionValue(BICOptions.skip_user_signature.getId()).toString().equalsIgnoreCase(Boolean.TRUE.toString())) {
                BICStubs.booleanBinds.put(BICOptions.skip_user_signature.getId(), Boolean.FALSE.toString());
            } else {
                BICStubs.booleanBinds.put(BICOptions.skip_user_signature.getId(), Boolean.TRUE.toString());
            }
            if (parsedCommand.getOptionValue(BICOptions.skip_delegate_signature.getId()).toString().equals(Boolean.TRUE.toString())) {
                BICStubs.booleanBinds.put(BICOptions.skip_delegate_signature.getId(), Boolean.FALSE.toString());
            } else {
                BICStubs.booleanBinds.put(BICOptions.skip_delegate_signature.getId(), Boolean.TRUE.toString());
            }
            if (parsedCommand.getOptionValue(BICOptions.skip_countersignature.getId()).toString().equals(Boolean.TRUE.toString())) {
                BICStubs.booleanBinds.put(BICOptions.skip_countersignature.getId(), Boolean.FALSE.toString());
            } else {
                BICStubs.booleanBinds.put(BICOptions.skip_countersignature.getId(), Boolean.TRUE.toString());
            }
            if (query != null) {
                query = String.format(query, new ArrayList<String>(BICStubs.booleanBinds.values()).toArray());
            }
            BICStubs.booleanBinds.clear();
        } else {
            if (parsedCommand.getOptionValue(BICOptions.skip_user_signature.getId()).toString().equals(Boolean.TRUE.toString())) {
                throw new BICException(new String[]{String.format(Messages.getString("BICEXP.UNSUPPORTED_OPTION"), BICOptions.skip_user_signature.getName(), model.getCommand().getSql().toLowerCase().trim(), model.getDbVersion())});
            }
            if (parsedCommand.getOptionValue(BICOptions.skip_delegate_signature.getId()).toString().equals(Boolean.TRUE.toString())) {
                throw new BICException(new String[]{String.format(Messages.getString("BICEXP.UNSUPPORTED_OPTION"), BICOptions.skip_delegate_signature.getName(), model.getCommand().getSql().toLowerCase().trim(), model.getDbVersion())});
            }
            if (parsedCommand.getOptionValue(BICOptions.skip_countersignature.getId()).toString().equals(Boolean.TRUE.toString())) {
                throw new BICException(new String[]{String.format(Messages.getString("BICEXP.UNSUPPORTED_OPTION"), BICOptions.skip_countersignature.getName(), model.getCommand().getSql().toLowerCase().trim(), model.getDbVersion())});
            }
            BICStubs.booleanBinds.remove(BICOptions.skip_user_signature.getId());
            BICStubs.booleanBinds.remove(BICOptions.skip_delegate_signature.getId());
            BICStubs.booleanBinds.remove(BICOptions.skip_countersignature.getId());
        }
        if (binds.get(BICOptions.end_bytes_file.getId()) != null) {
            binds.put(BICOptions.end_bytes_file.getId(), BICStubs.parseBlobFromFile(model, (String)binds.get(BICOptions.end_bytes_file.getId()), BICOptions.end_bytes_file.getName()));
        } else {
            try {
                binds.put(BICOptions.end_bytes_file.getId(), model.getConnection().createBlob());
            }
            catch (SQLException e) {
                throw new BICException(new String[]{String.format(e.getMessage(), new Object[0])});
            }
        }
        if (binds.get(BICOptions.begin_bytes_file.getId()) != null) {
            binds.put(BICOptions.begin_bytes_file.getId(), BICStubs.parseBlobFromFile(model, (String)binds.get(BICOptions.begin_bytes_file.getId()), BICOptions.begin_bytes_file.getName()));
        } else {
            try {
                binds.put(BICOptions.begin_bytes_file.getId(), model.getConnection().createBlob());
            }
            catch (SQLException e) {
                throw new BICException(new String[]{String.format(e.getMessage(), new Object[0])});
            }
        }
        OracleCallableStatement returnStatement = null;
        if (LockManager.lock((Connection)model.getConnection())) {
            try {
                returnStatement = (OracleCallableStatement)BICStubs.bind(model.getConnection().prepareCall(query), new ArrayList<Object>(binds.values()));
                returnStatement.registerOutParameter(binds.size() + 1, (SQLType)OracleType.NUMBER);
                returnStatement.executeUpdate();
                NUMBER num_of_rows_verified = returnStatement.getNUMBER(binds.size() + 1);
                model.getContext().writeln("Command executed successfully.");
                model.getContext().writeln("Verified " + num_of_rows_verified.stringValue() + " rows.");
                BICStubs.populateBindVariableStringValue(model, BICOptions.verified_rows_count, num_of_rows_verified.stringValue());
            }
            catch (SQLException e) {
                throw new BICException(new String[]{String.format(e.getMessage(), new Object[0])});
            }
            finally {
                if (returnStatement != null) {
                    returnStatement.close();
                }
                LockManager.unlock((Connection)model.getConnection());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void signRow(BICModel model, ParsedCommand parsedCommand) throws BICException, SQLException {
        File file;
        ArrayList<String> errors;
        String generatedsignatureFileName;
        block54: {
            boolean is23KC = Boolean.FALSE;
            boolean isUserKC = Boolean.FALSE;
            LinkedHashMap<Id, Object> binds = new LinkedHashMap<Id, Object>();
            LinkedHashSet<Id> InVar = new LinkedHashSet<Id>();
            InVar.add(BICOptions.tableName_blockchain_req.getId());
            InVar.add(BICOptions.instance_id.getId());
            InVar.add(BICOptions.chain_id.getId());
            InVar.add(BICOptions.sequence_id.getId());
            InVar.add(BICOptions.data_format_hash.getId());
            InVar.add(BICOptions.row_data_bytes.getId());
            InVar.add(BICOptions.keycol1_name.getId());
            InVar.add(BICOptions.keycol1_value.getId());
            InVar.add(BICOptions.keycol2_name.getId());
            InVar.add(BICOptions.keycol2_value.getId());
            InVar.add(BICOptions.keycol3_name.getId());
            InVar.add(BICOptions.keycol3_value.getId());
            InVar.add(BICOptions.pdb_guid.getId());
            InVar.add(BICOptions.signature_type_sign.getId());
            InVar.add(BICOptions.private_key_for_signature.getId());
            InVar.add(BICOptions.wallet_path.getId());
            InVar.add(BICOptions.wallet_private_key_alias.getId());
            binds = BICStubs.collectOptionValue(model, parsedCommand, binds, InVar, null, null);
            binds = BICStubs.positionOrKeyCol(binds, parsedCommand, model.getDbMajorVersion());
            String signatureAlgo = null;
            String walletSignatureAlgo = null;
            String privateKeyPath = null;
            String signatureBytesFileName = null;
            generatedsignatureFileName = null;
            String walletPath = null;
            Blob signatureBytes = null;
            String pvtKeyAlias = null;
            LinkedHashMap<Id, String> tempMap = new LinkedHashMap<Id, String>();
            String signature_type_sign = (String)binds.get(BICOptions.signature_type_sign.getId());
            if (parsedCommand.getOptionValue(BICOptions.signature_file.getId()).equals("") && parsedCommand.getOptionValue(BICOptions.signature.getId()).equals("") && parsedCommand.getOptionValue(BICOptions.private_key_for_signature.getId()).equals("") && parsedCommand.getOptionValue(BICOptions.wallet_path.getId()).equals("")) {
                throw new BICException(new String[]{String.format(Messages.getString("BICEXP.MISSING_COMPULSORY_PARAMETER"), BICOptions.signature_file.getName() + "' or '" + BICOptions.signature.getName() + "' or '" + BICOptions.private_key_for_signature.getName() + "' or '" + BICOptions.wallet_path.getName())});
            }
            if (!(parsedCommand.getOptionValue(BICOptions.signature_file.getId()).equals("") || parsedCommand.getOptionValue(BICOptions.signature.getId()).equals("") || parsedCommand.getOptionValue(BICOptions.private_key_for_signature.getId()).equals("") || parsedCommand.getOptionValue(BICOptions.wallet_path.getId()).equals(""))) {
                throw new BICException(new String[]{String.format(Messages.getString("BICEXP.CONFLICTING_OPTIONS_4"), BICOptions.signature.getName(), BICOptions.signature_file.getName(), BICOptions.private_key_for_signature.getName(), BICOptions.wallet_path.getName())});
            }
            if (!parsedCommand.getOptionValue(BICOptions.signature_file.getId()).equals("") && !parsedCommand.getOptionValue(BICOptions.signature.getId()).equals("") && !parsedCommand.getOptionValue(BICOptions.private_key_for_signature.getId()).equals("") && parsedCommand.getOptionValue(BICOptions.wallet_path.getId()).equals("")) {
                throw new BICException(new String[]{String.format(Messages.getString("BICEXP.CONFLICTING_OPTIONS"), BICOptions.signature.getName(), BICOptions.signature_file.getName(), BICOptions.private_key_for_signature.getName())});
            }
            if (!parsedCommand.getOptionValue(BICOptions.signature_file.getId()).equals("") && parsedCommand.getOptionValue(BICOptions.signature.getId()).equals("") && !parsedCommand.getOptionValue(BICOptions.private_key_for_signature.getId()).equals("") && !parsedCommand.getOptionValue(BICOptions.wallet_path.getId()).equals("")) {
                throw new BICException(new String[]{String.format(Messages.getString("BICEXP.CONFLICTING_OPTIONS"), BICOptions.signature_file.getName(), BICOptions.private_key_for_signature.getName(), BICOptions.wallet_path.getName())});
            }
            if (!parsedCommand.getOptionValue(BICOptions.signature_file.getId()).equals("") && !parsedCommand.getOptionValue(BICOptions.signature.getId()).equals("") && parsedCommand.getOptionValue(BICOptions.private_key_for_signature.getId()).equals("") && !parsedCommand.getOptionValue(BICOptions.wallet_path.getId()).equals("")) {
                throw new BICException(new String[]{String.format(Messages.getString("BICEXP.CONFLICTING_OPTIONS"), BICOptions.signature.getName(), BICOptions.signature_file.getName(), BICOptions.wallet_path.getName())});
            }
            if (parsedCommand.getOptionValue(BICOptions.signature_file.getId()).equals("") && !parsedCommand.getOptionValue(BICOptions.signature.getId()).equals("") && !parsedCommand.getOptionValue(BICOptions.private_key_for_signature.getId()).equals("") && !parsedCommand.getOptionValue(BICOptions.wallet_path.getId()).equals("")) {
                throw new BICException(new String[]{String.format(Messages.getString("BICEXP.CONFLICTING_OPTIONS"), BICOptions.signature.getName(), BICOptions.private_key_for_signature.getName(), BICOptions.wallet_path.getName())});
            }
            if (!parsedCommand.getOptionValue(BICOptions.signature_file.getId()).equals("") && !parsedCommand.getOptionValue(BICOptions.signature.getId()).equals("")) {
                throw new BICException(new String[]{String.format(Messages.getString("BICEXP.CONFLICTING_OPTION"), BICOptions.signature.getName(), BICOptions.signature_file.getName())});
            }
            if (!parsedCommand.getOptionValue(BICOptions.signature_file.getId()).equals("") && !parsedCommand.getOptionValue(BICOptions.private_key_for_signature.getId()).equals("")) {
                throw new BICException(new String[]{String.format(Messages.getString("BICEXP.CONFLICTING_OPTION"), BICOptions.private_key_for_signature.getName(), BICOptions.signature_file.getName())});
            }
            if (!parsedCommand.getOptionValue(BICOptions.signature_file.getId()).equals("") && !parsedCommand.getOptionValue(BICOptions.wallet_path.getId()).equals("")) {
                throw new BICException(new String[]{String.format(Messages.getString("BICEXP.CONFLICTING_OPTION"), BICOptions.wallet_path.getName(), BICOptions.signature_file.getName())});
            }
            if (!parsedCommand.getOptionValue(BICOptions.private_key_for_signature.getId()).equals("") && !parsedCommand.getOptionValue(BICOptions.signature.getId()).equals("")) {
                throw new BICException(new String[]{String.format(Messages.getString("BICEXP.CONFLICTING_OPTION"), BICOptions.private_key_for_signature.getName(), BICOptions.signature.getName())});
            }
            if (!parsedCommand.getOptionValue(BICOptions.wallet_path.getId()).equals("") && !parsedCommand.getOptionValue(BICOptions.signature.getId()).equals("")) {
                throw new BICException(new String[]{String.format(Messages.getString("BICEXP.CONFLICTING_OPTION"), BICOptions.wallet_path.getName(), BICOptions.signature.getName())});
            }
            if (!parsedCommand.getOptionValue(BICOptions.private_key_for_signature.getId()).equals("") && !parsedCommand.getOptionValue(BICOptions.wallet_path.getId()).equals("")) {
                throw new BICException(new String[]{String.format(Messages.getString("BICEXP.CONFLICTING_OPTION"), BICOptions.private_key_for_signature.getName(), BICOptions.wallet_path.getName())});
            }
            if (!(parsedCommand.getOptionValue(BICOptions.signature.getId()).equals("") && parsedCommand.getOptionValue(BICOptions.signature_file.getId()).equals("") && parsedCommand.getOptionValue(BICOptions.private_key_for_signature.getId()).equals("") || parsedCommand.getOptionValue(BICOptions.wallet_password.getId()).equals("") && parsedCommand.getOptionValue(BICOptions.wallet_private_key_password.getId()).equals("") && parsedCommand.getOptionValue(BICOptions.wallet_private_key_alias.getId()).equals(""))) {
                throw new BICException(new String[]{Messages.getString("BICEXP.WALLET_PARAMS_ERROR")});
            }
            if (binds.containsKey(BICOptions.keycol1_name.getId()) && binds.containsKey(BICOptions.keycol1_value.getId())) {
                isUserKC = true;
            }
            if (model.getDbMajorVersion() < 23) {
                if (!binds.get(BICOptions.pdb_guid.getId()).equals("")) {
                    throw new BICException(new String[]{String.format(Messages.getString("BICEXP.UNSUPPORTED_OPTION"), BICOptions.pdb_guid.getName(), model.getCommand().getSql().toLowerCase().trim(), model.getDbVersion())});
                }
                if (!binds.get(BICOptions.signature_type_sign.getId()).equals(BICOptions.SIGNATURE_TYPE_DEFAULT) || model.getCommand().getSql().contains(" -type \"" + String.valueOf(BICOptions.SIGNATURE_TYPE_DEFAULT) + "\"")) {
                    throw new BICException(new String[]{String.format(Messages.getString("BICEXP.UNSUPPORTED_OPTION"), BICOptions.signature_type.getName(), model.getCommand().getSql().toLowerCase().trim(), model.getDbVersion())});
                }
                if (binds.containsKey(BICOptions.keycol1_name.getId()) && binds.containsKey(BICOptions.keycol1_value.getId())) {
                    binds = BICStubs.findPosition(binds, model, parsedCommand);
                    binds.remove(BICOptions.keycol1_name.getId());
                    binds.remove(BICOptions.keycol1_value.getId());
                    binds.remove(BICOptions.keycol2_name.getId());
                    binds.remove(BICOptions.keycol2_value.getId());
                    binds.remove(BICOptions.keycol3_name.getId());
                    binds.remove(BICOptions.keycol3_value.getId());
                }
            }
            if (!parsedCommand.getOptionValue(BICOptions.private_key_for_signature.getId()).equals("") || !parsedCommand.getOptionValue(BICOptions.wallet_path.getId()).equals("")) {
                if (!parsedCommand.getOptionValue(BICOptions.wallet_path.getId()).equals("")) {
                    walletPath = (String)binds.get(BICOptions.wallet_path.getId());
                    pvtKeyAlias = (String)binds.get(BICOptions.wallet_private_key_alias.getId());
                }
                if (!parsedCommand.getOptionValue(BICOptions.private_key_for_signature.getId()).equals("")) {
                    privateKeyPath = (String)binds.get(BICOptions.private_key_for_signature.getId());
                }
                binds.remove(BICOptions.private_key_for_signature.getId());
                binds.remove(BICOptions.wallet_path.getId());
                binds.remove(BICOptions.wallet_private_key_alias.getId());
                signatureBytes = BlockchainProcessor.getBytForRowSigExtension(model, parsedCommand, binds);
                if (signatureBytes != null && !parsedCommand.getOptionValue(BICOptions.private_key_for_signature.getId()).equals("")) {
                    signatureBytesFileName = BICStubs.generateUniqueName("sigBytes") + ".dat";
                    BICStubs.writeSignatureBytesToFile(signatureBytes, signatureBytesFileName);
                }
            } else if (!binds.get(BICOptions.pdb_guid.getId()).equals("")) {
                throw new BICException(new String[]{String.format(Messages.getString("BICEXP.UNSUPPORTED_OPTION_PDB_GUID"), BICOptions.pdb_guid.getName(), model.getCommand().getSql().toLowerCase().trim(), BICOptions.private_key_for_signature.getName())});
            }
            binds.remove(BICOptions.private_key_for_signature.getId());
            binds.remove(BICOptions.wallet_path.getId());
            binds.remove(BICOptions.wallet_private_key_alias.getId());
            try {
                RAW signatureInput;
                String querySign;
                binds.remove(BICOptions.data_format_hash.getId());
                binds.remove(BICOptions.row_data_bytes.getId());
                binds.remove(BICOptions.signature_type_sign.getId());
                binds.remove(BICOptions.pdb_guid.getId());
                if (binds.containsKey(BICOptions.keycol1_name.getId()) && binds.containsKey(BICOptions.keycol1_value.getId())) {
                    is23KC = true;
                    binds.remove(BICOptions.keycol1_name.getId());
                    binds.remove(BICOptions.keycol1_value.getId());
                    binds.remove(BICOptions.keycol2_name.getId());
                    binds.remove(BICOptions.keycol2_value.getId());
                    binds.remove(BICOptions.keycol3_name.getId());
                    binds.remove(BICOptions.keycol3_value.getId());
                }
                InVar.clear();
                InVar.add(BICOptions.row_hash.getId());
                InVar.add(BICOptions.signature.getId());
                InVar.add(BICOptions.signature_file.getId());
                InVar.add(BICOptions.cert_guid_req.getId());
                InVar.add(BICOptions.algorithm_req.getId());
                if (is23KC) {
                    InVar.add(BICOptions.keycol1_name.getId());
                    InVar.add(BICOptions.keycol1_value.getId());
                    InVar.add(BICOptions.keycol2_name.getId());
                    InVar.add(BICOptions.keycol2_value.getId());
                    InVar.add(BICOptions.keycol3_name.getId());
                    InVar.add(BICOptions.keycol3_value.getId());
                }
                if ((binds = BICStubs.collectOptionValue(model, parsedCommand, binds, InVar, null, null)).containsKey(BICOptions.algorithm_req.getId())) {
                    String algoEntry = (String)binds.get(BICOptions.algorithm_req.getId());
                    if (algoEntry.equalsIgnoreCase("RSA_SHA2_512")) {
                        signatureAlgo = "sha512";
                        walletSignatureAlgo = "SHA512withRSA";
                        tempMap.put(BICOptions.algorithm_req.getId(), "dbms_blockchain_table.SIGN_ALGO_RSA_SHA2_512");
                    } else if (algoEntry.equalsIgnoreCase("RSA_SHA2_256")) {
                        signatureAlgo = "sha256";
                        walletSignatureAlgo = "SHA256withRSA";
                        tempMap.put(BICOptions.algorithm_req.getId(), "dbms_blockchain_table.SIGN_ALGO_RSA_SHA2_256");
                    } else if (algoEntry.equalsIgnoreCase("RSA_SHA2_384")) {
                        signatureAlgo = "sha384";
                        walletSignatureAlgo = "SHA384withRSA";
                        tempMap.put(BICOptions.algorithm_req.getId(), "dbms_blockchain_table.SIGN_ALGO_RSA_SHA2_384");
                    } else {
                        throw new BICException(new String[]{String.format(Messages.getString("BICEXP.INVALID_ALGORITHM"), algoEntry, model.getCommand().getSql().toLowerCase())});
                    }
                    binds.remove(BICOptions.algorithm_req.getId());
                }
                if (model.getDbMajorVersion() >= 23) {
                    if (signature_type_sign.equalsIgnoreCase("DELEGATE")) {
                        tempMap.put(BICOptions.delegate_flag.getId(), Boolean.TRUE.toString());
                    } else {
                        tempMap.put(BICOptions.delegate_flag.getId(), Boolean.FALSE.toString());
                    }
                }
                if ((querySign = is23KC ? BICStubs.getQuery("SIGN_ROW_SPECIFIED_BY_KEY_COLUMNS", model.getConnection(), "oracle/dbtools/sqlcl/commands/blockchain/blockchainQueriesP2.xml") : BICStubs.getQuery("SIGN_ROW", model.getConnection(), "oracle/dbtools/sqlcl/commands/blockchain/blockchainQueries.xml")) != null) {
                    querySign = String.format(querySign, new ArrayList(tempMap.values()).toArray());
                }
                if (!binds.get(BICOptions.row_hash.getId()).equals("")) {
                    binds.put(BICOptions.row_hash.getId(), BICStubs.hexToRaw((String)binds.get(BICOptions.row_hash.getId())));
                }
                if (!parsedCommand.getOptionValue(BICOptions.signature_file.getId()).equals("")) {
                    signatureInput = BICStubs.binaryFileToRaw((String)binds.get(BICOptions.signature_file.getId()), BICOptions.signature_file.getName());
                    binds.put(BICOptions.signature_file.getId(), signatureInput);
                    binds.remove(BICOptions.signature.getId());
                } else if (!parsedCommand.getOptionValue(BICOptions.signature.getId()).equals("")) {
                    signatureInput = BICStubs.hexToRaw((String)binds.get(BICOptions.signature.getId()));
                    binds.put(BICOptions.signature.getId(), signatureInput);
                    binds.remove(BICOptions.signature_file.getId());
                } else if (!parsedCommand.getOptionValue(BICOptions.private_key_for_signature.getId()).equals("")) {
                    generatedsignatureFileName = BICStubs.generateSignatureForSignRow(signatureAlgo, privateKeyPath, signatureBytesFileName);
                    binds.put(BICOptions.signature.getId(), BICStubs.signatureFileToRaw(generatedsignatureFileName));
                    binds.remove(BICOptions.signature_file.getId());
                } else {
                    String walletPassword = (String)parsedCommand.getOptionValue(BICOptions.wallet_password.getId());
                    String prvtKeyPassword = (String)parsedCommand.getOptionValue(BICOptions.wallet_private_key_password.getId());
                    String certificateId = (String)binds.get(BICOptions.cert_guid_req.getId());
                    signatureInput = walletPassword.equals("") && prvtKeyPassword.equals("") ? BICStubs.generateSignatureUsingWallet(model, walletPath, null, null, pvtKeyAlias, certificateId, signatureBytes, walletSignatureAlgo) : (walletPassword.equals("") && !prvtKeyPassword.equals("") ? BICStubs.generateSignatureUsingWallet(model, walletPath, null, prvtKeyPassword.toCharArray(), pvtKeyAlias, certificateId, signatureBytes, walletSignatureAlgo) : (!walletPassword.equals("") && prvtKeyPassword.equals("") ? BICStubs.generateSignatureUsingWallet(model, walletPath, walletPassword.toCharArray(), null, pvtKeyAlias, certificateId, signatureBytes, walletSignatureAlgo) : BICStubs.generateSignatureUsingWallet(model, walletPath, walletPassword.toCharArray(), prvtKeyPassword.toCharArray(), pvtKeyAlias, certificateId, signatureBytes, walletSignatureAlgo)));
                    binds.put(BICOptions.signature.getId(), signatureInput);
                    binds.remove(BICOptions.signature_file.getId());
                    walletPassword = null;
                    prvtKeyPassword = null;
                    parsedCommand.clearOptionValue(BICOptions.wallet_private_key_password.getId());
                    parsedCommand.clearOptionValue(BICOptions.wallet_password.getId());
                }
                DBUtil dBUtil = DBUtil.getInstance((Connection)model.getConnection());
                dBUtil.execute(querySign, new ArrayList<Object>(binds.values()));
                SQLException e = dBUtil.getLastException();
                if (e != null) {
                    throw new BICException(new String[]{String.format(e.getMessage(), new Object[0])});
                }
                model.getContext().writeln("Command executed successfully.");
                if (isUserKC) {
                    model.getContext().writeln("Successfully signed row identified by key columns " + BICStubs.whereClauseForKC(parsedCommand) + " in table '" + String.valueOf(binds.get(BICOptions.schema.getId())) + "." + String.valueOf(binds.get(BICOptions.tableName_immutable_req.getId())) + "'.");
                } else {
                    model.getContext().writeln("Successfully signed row at instance id '" + String.valueOf(binds.get(BICOptions.instance_id.getId())) + "',  chain id '" + String.valueOf(binds.get(BICOptions.chain_id.getId())) + "' and  sequence id '" + String.valueOf(binds.get(BICOptions.sequence_id.getId())) + "' in table '" + String.valueOf(binds.get(BICOptions.schema.getId())) + "." + String.valueOf(binds.get(BICOptions.tableName_immutable_req.getId())) + "'.");
                }
                errors = new ArrayList<String>();
                if (signatureBytesFileName == null || !(file = new File(signatureBytesFileName)).exists() || file.delete()) break block54;
                errors.add(String.format(Messages.getString("BICEXP.FILE_DELETION_ERROR"), new Object[0]));
            }
            catch (Throwable throwable) {
                File file2;
                ArrayList<String> errors2 = new ArrayList<String>();
                if (signatureBytesFileName != null && (file2 = new File(signatureBytesFileName)).exists() && !file2.delete()) {
                    errors2.add(String.format(Messages.getString("BICEXP.FILE_DELETION_ERROR"), new Object[0]));
                }
                if (generatedsignatureFileName != null && (file2 = new File(generatedsignatureFileName)).exists() && !file2.delete()) {
                    errors2.add(String.format(Messages.getString("BICEXP.FILE_DELETION_ERROR"), new Object[0]));
                }
                if (errors2.size() != 0) {
                    throw new BICException(errors2.toArray(new String[0]));
                }
                throw throwable;
            }
        }
        if (generatedsignatureFileName != null && (file = new File(generatedsignatureFileName)).exists() && !file.delete()) {
            errors.add(String.format(Messages.getString("BICEXP.FILE_DELETION_ERROR"), new Object[0]));
        }
        if (errors.size() != 0) {
            throw new BICException(errors.toArray(new String[0]));
        }
    }

    public static void getBytForRowSig(BICModel model, ParsedCommand parsedCommand) throws BICException, SQLException {
        LinkedHashMap<Id, Object> binds = new LinkedHashMap<Id, Object>();
        LinkedHashSet<Id> InVar = new LinkedHashSet<Id>();
        LinkedHashSet<Id> OutFiles = new LinkedHashSet<Id>();
        InVar.add(BICOptions.tableName_blockchain_req.getId());
        InVar.add(BICOptions.instance_id.getId());
        InVar.add(BICOptions.chain_id.getId());
        InVar.add(BICOptions.sequence_id.getId());
        InVar.add(BICOptions.data_format_hash.getId());
        InVar.add(BICOptions.row_data_bytes.getId());
        OutFiles.add(BICOptions.row_data_file.getId());
        InVar.add(BICOptions.keycol1_name.getId());
        InVar.add(BICOptions.keycol1_value.getId());
        InVar.add(BICOptions.keycol2_name.getId());
        InVar.add(BICOptions.keycol2_value.getId());
        InVar.add(BICOptions.keycol3_name.getId());
        InVar.add(BICOptions.keycol3_value.getId());
        InVar.add(BICOptions.pdb_guid.getId());
        InVar.add(BICOptions.signature_type.getId());
        binds = BICStubs.collectOptionValue(model, parsedCommand, binds, InVar, null, OutFiles);
        binds = BICStubs.positionOrKeyCol(binds, parsedCommand, model.getDbMajorVersion());
        Blob signatureBytes = BlockchainProcessor.getBytForRowSigExtension(model, parsedCommand, binds);
        if (signatureBytes != null) {
            model.getContext().writeln("Command executed successfully.");
            if (BICStubs.outputBindsAndFiles.get(BICOptions.row_data_file.getId()) != null) {
                BICStubs.writeBlobToFile(signatureBytes, BICStubs.outputBindsAndFiles.get(BICOptions.row_data_file.getId()), BICOptions.row_data_file.getName());
            }
        }
    }

    public static Blob getBytForRowSigExtension(BICModel model, ParsedCommand parsedCommand, LinkedHashMap<Id, Object> binds) throws BICException, SQLException {
        String query;
        if (model.getDbMajorVersion() >= 23) {
            if (!binds.get(BICOptions.pdb_guid.getId()).equals("")) {
                binds.put(BICOptions.pdb_guid.getId(), BICStubs.hexToRaw((String)binds.get(BICOptions.pdb_guid.getId())));
            }
            query = binds.containsKey(BICOptions.keycol1_name.getId()) && binds.containsKey(BICOptions.keycol1_value.getId()) ? BICStubs.getQuery("GET_BYTES_FOR_ROW_SIGNATURE_SPECIFIED_BY_KEY_COLUMNS", model.getConnection(), "oracle/dbtools/sqlcl/commands/blockchain/blockchainQueriesP2.xml") : BICStubs.getQuery("GET_BYTES_FOR_ROW_SIGNATURE", model.getConnection(), "oracle/dbtools/sqlcl/commands/blockchain/blockchainQueries.xml");
            if (binds.get(BICOptions.signature_type.getId()).toString().charAt(0) == '\'') {
                if (query != null) {
                    query = String.format(query, binds.get(BICOptions.signature_type.getId()));
                }
            } else if (query != null) {
                query = String.format(query, "'" + String.valueOf(binds.get(BICOptions.signature_type.getId())) + "'");
            }
            binds.remove(BICOptions.signature_type.getId());
        } else {
            if (!binds.get(BICOptions.pdb_guid.getId()).equals("")) {
                throw new BICException(new String[]{String.format(Messages.getString("BICEXP.UNSUPPORTED_OPTION"), BICOptions.pdb_guid.getName(), model.getCommand().getSql().toLowerCase().trim(), model.getDbVersion())});
            }
            if (!binds.get(BICOptions.signature_type.getId()).equals(BICOptions.SIGNATURE_TYPE_DEFAULT) || model.getCommand().getSql().contains(" -type \"" + String.valueOf(BICOptions.SIGNATURE_TYPE_DEFAULT) + "\"")) {
                throw new BICException(new String[]{String.format(Messages.getString("BICEXP.UNSUPPORTED_OPTION"), BICOptions.signature_type.getName(), model.getCommand().getSql().toLowerCase().trim(), model.getDbVersion())});
            }
            binds.remove(BICOptions.signature_type.getId());
            binds.remove(BICOptions.pdb_guid.getId());
            if (binds.containsKey(BICOptions.keycol1_name.getId()) && binds.containsKey(BICOptions.keycol1_value.getId())) {
                binds = BICStubs.findPosition(binds, model, parsedCommand);
                binds.remove(BICOptions.keycol1_name.getId());
                binds.remove(BICOptions.keycol1_value.getId());
                binds.remove(BICOptions.keycol2_name.getId());
                binds.remove(BICOptions.keycol2_value.getId());
                binds.remove(BICOptions.keycol3_name.getId());
                binds.remove(BICOptions.keycol3_value.getId());
            }
            query = BICStubs.getQuery("GET_BYTES_FOR_ROW_SIGNATURE", model.getConnection(), "oracle/dbtools/sqlcl/commands/blockchain/blockchainQueries.xml");
        }
        if (binds.get(BICOptions.row_data_bytes.getId()).equals("")) {
            try {
                binds.put(BICOptions.row_data_bytes.getId(), model.getConnection().createBlob());
            }
            catch (SQLException e) {
                throw new BICException(new String[]{String.format(e.getMessage(), new Object[0])});
            }
        }
        OracleCallableStatement returnStatement = null;
        BLOB signatureBytes = null;
        if (LockManager.lock((Connection)model.getConnection())) {
            try {
                returnStatement = (OracleCallableStatement)BICStubs.bind(model.getConnection().prepareCall(query), new ArrayList<Object>(binds.values()));
                returnStatement.registerOutParameter(binds.size() + 1, (SQLType)OracleType.BLOB);
                returnStatement.executeUpdate();
                signatureBytes = returnStatement.getBLOB(binds.size() + 1);
            }
            catch (SQLException e) {
                throw new BICException(new String[]{String.format(e.getMessage(), new Object[0])});
            }
            finally {
                if (returnStatement != null) {
                    returnStatement.close();
                }
                LockManager.unlock((Connection)model.getConnection());
            }
        }
        return signatureBytes;
    }

    public static void countersignRow(BICModel model, ParsedCommand parsedCommand) throws BICException, SQLException {
        String query;
        boolean isKC = Boolean.FALSE;
        LinkedHashMap<Id, Object> binds = new LinkedHashMap<Id, Object>();
        LinkedHashSet<Id> InVar = new LinkedHashSet<Id>();
        LinkedHashSet<Id> OutBinds = new LinkedHashSet<Id>();
        LinkedHashSet<Id> OutFiles = new LinkedHashSet<Id>();
        InVar.add(BICOptions.tableName_blockchain_req.getId());
        InVar.add(BICOptions.instance_id.getId());
        InVar.add(BICOptions.chain_id.getId());
        InVar.add(BICOptions.sequence_id.getId());
        InVar.add(BICOptions.keycol1_name.getId());
        InVar.add(BICOptions.keycol1_value.getId());
        InVar.add(BICOptions.keycol2_name.getId());
        InVar.add(BICOptions.keycol2_value.getId());
        InVar.add(BICOptions.keycol3_name.getId());
        InVar.add(BICOptions.keycol3_value.getId());
        InVar.add(BICOptions.countersignature_algo.getId());
        InVar.add(BICOptions.countersignature_signed_bytes.getId());
        OutFiles.add(BICOptions.countersign_bytes_file.getId());
        OutBinds.add(BICOptions.countersignature.getId());
        OutBinds.add(BICOptions.countersignature_cert_guid.getId());
        InVar.add(BICOptions.countersignature_content_version.getId());
        if (model.getDbMajorVersion() < 23) {
            throw new BICException(new String[]{String.format(Messages.getString("BICEXP.UNSUPPORTED_DB_VERSION"), "COUNTERSIGN_ROW' or 'countersign", model.getDbVersion())});
        }
        binds = BICStubs.collectOptionValue(model, parsedCommand, binds, InVar, OutBinds, OutFiles);
        if ((binds = BICStubs.positionOrKeyCol(binds, parsedCommand, model.getDbMajorVersion())).containsKey(BICOptions.keycol1_name.getId()) && binds.containsKey(BICOptions.keycol1_value.getId())) {
            isKC = true;
            query = BICStubs.getQuery("COUNTERSIGN_ROW_SPECIFIED_BY_KEY_COLUMNS", model.getConnection(), "oracle/dbtools/sqlcl/commands/blockchain/blockchainQueriesP2.xml");
        } else {
            query = BICStubs.getQuery("COUNTERSIGN_ROW", model.getConnection(), "oracle/dbtools/sqlcl/commands/blockchain/blockchainQueriesP2.xml");
        }
        if (binds.get(BICOptions.countersignature_signed_bytes.getId()).equals("")) {
            try {
                binds.put(BICOptions.countersignature_signed_bytes.getId(), model.getConnection().createBlob());
            }
            catch (SQLException e) {
                throw new BICException(new String[]{String.format(e.getMessage(), new Object[0])});
            }
        }
        String algoVal = null;
        if (binds.containsKey(BICOptions.countersignature_algo.getId())) {
            String algoEntry = (String)binds.get(BICOptions.countersignature_algo.getId());
            algoVal = algoEntry.equalsIgnoreCase("RSA_SHA2_512") ? "dbms_blockchain_table.SIGN_ALGO_RSA_SHA2_512" : (algoEntry.equalsIgnoreCase("RSA_SHA2_256") ? "dbms_blockchain_table.SIGN_ALGO_RSA_SHA2_256" : (algoEntry.equalsIgnoreCase("RSA_SHA2_384") ? "dbms_blockchain_table.SIGN_ALGO_RSA_SHA2_384" : algoEntry));
            binds.remove(BICOptions.countersignature_algo.getId());
        }
        Object contentVersion = binds.get(BICOptions.countersignature_content_version.getId()).toString().charAt(0) == '\'' ? binds.get(BICOptions.countersignature_content_version.getId()).toString() : "'" + String.valueOf(binds.get(BICOptions.countersignature_content_version.getId())) + "'";
        binds.remove(BICOptions.countersignature_content_version.getId());
        if (query != null) {
            query = String.format(query, algoVal, contentVersion);
        }
        OracleCallableStatement returnStatement = null;
        if (LockManager.lock((Connection)model.getConnection())) {
            try {
                returnStatement = (OracleCallableStatement)BICStubs.bind(model.getConnection().prepareCall(query), new ArrayList<Object>(binds.values()));
                returnStatement.registerOutParameter(binds.size() + 1, (SQLType)OracleType.BLOB);
                returnStatement.registerOutParameter(binds.size() + 2, (SQLType)OracleType.RAW);
                returnStatement.registerOutParameter(binds.size() + 3, (SQLType)OracleType.RAW);
                returnStatement.executeUpdate();
                BLOB countersignatureSignedBytes = returnStatement.getBLOB(binds.size() + 1);
                RAW countersignature = returnStatement.getRAW(binds.size() + 2);
                RAW countersignature_cert_id = returnStatement.getRAW(binds.size() + 3);
                model.getContext().writeln("Command executed successfully.");
                if (isKC) {
                    model.getContext().writeln("Successfully countersigned row identified by key columns " + BICStubs.whereClauseForKC(parsedCommand) + " in table '" + String.valueOf(binds.get(BICOptions.schema.getId())) + "." + String.valueOf(binds.get(BICOptions.tableName_immutable_req.getId())) + "'.");
                } else {
                    model.getContext().writeln("Successfully countersigned row at instance id '" + String.valueOf(binds.get(BICOptions.instance_id.getId())) + "',  chain id '" + String.valueOf(binds.get(BICOptions.chain_id.getId())) + "' and  sequence id '" + String.valueOf(binds.get(BICOptions.sequence_id.getId())) + "' in table '" + String.valueOf(binds.get(BICOptions.schema.getId())) + "." + String.valueOf(binds.get(BICOptions.tableName_immutable_req.getId())) + "'.");
                }
                if (BICStubs.outputBindsAndFiles.get(BICOptions.countersign_bytes_file.getId()) != null) {
                    BICStubs.writeBlobToFile((Blob)countersignatureSignedBytes, BICStubs.outputBindsAndFiles.get(BICOptions.countersign_bytes_file.getId()), BICOptions.countersign_bytes_file.getName());
                }
                BICStubs.populateBindVariableStringValue(model, BICOptions.countersignature, countersignature.stringValue());
                BICStubs.populateBindVariableStringValue(model, BICOptions.countersignature_cert_guid, countersignature_cert_id.stringValue());
            }
            catch (SQLException e) {
                throw new BICException(new String[]{String.format(e.getMessage(), new Object[0])});
            }
            finally {
                if (returnStatement != null) {
                    returnStatement.close();
                }
                LockManager.unlock((Connection)model.getConnection());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void signRowWithCountersignature(BICModel model, ParsedCommand parsedCommand) throws BICException, SQLException {
        File file;
        ArrayList<String> errors;
        String generatedsignatureFileName;
        block61: {
            boolean isKC = Boolean.FALSE;
            LinkedHashMap<Id, Object> binds = new LinkedHashMap<Id, Object>();
            LinkedHashSet<Id> InVar = new LinkedHashSet<Id>();
            LinkedHashSet<Id> OutBinds = new LinkedHashSet<Id>();
            LinkedHashSet<Id> OutFiles = new LinkedHashSet<Id>();
            InVar.add(BICOptions.tableName_blockchain_req.getId());
            InVar.add(BICOptions.instance_id.getId());
            InVar.add(BICOptions.chain_id.getId());
            InVar.add(BICOptions.sequence_id.getId());
            InVar.add(BICOptions.data_format_hash.getId());
            InVar.add(BICOptions.row_data_bytes.getId());
            InVar.add(BICOptions.keycol1_name.getId());
            InVar.add(BICOptions.keycol1_value.getId());
            InVar.add(BICOptions.keycol2_name.getId());
            InVar.add(BICOptions.keycol2_value.getId());
            InVar.add(BICOptions.keycol3_name.getId());
            InVar.add(BICOptions.keycol3_value.getId());
            InVar.add(BICOptions.pdb_guid.getId());
            InVar.add(BICOptions.signature_type_sign_23C.getId());
            InVar.add(BICOptions.private_key_for_signature.getId());
            InVar.add(BICOptions.wallet_path.getId());
            InVar.add(BICOptions.wallet_private_key_alias.getId());
            if (model.getDbMajorVersion() < 23) {
                throw new BICException(new String[]{String.format(Messages.getString("BICEXP.UNSUPPORTED_DB_VERSION"), "SIGN_ROW_WITH_COUNTERSIGNATURE' or 'signAndCountersign", model.getDbVersion())});
            }
            binds = BICStubs.collectOptionValue(model, parsedCommand, binds, InVar, null, null);
            binds = BICStubs.positionOrKeyCol(binds, parsedCommand, model.getDbMajorVersion());
            String signatureAlgo = null;
            String walletSignatureAlgo = null;
            String privateKeyPath = null;
            String signatureBytesFileName = null;
            generatedsignatureFileName = null;
            String walletPath = null;
            Blob signatureBytes = null;
            String pvtKeyAlias = null;
            LinkedHashMap<Id, Object> tempMap = new LinkedHashMap<Id, Object>();
            String signature_type_sign = (String)binds.get(BICOptions.signature_type_sign_23C.getId());
            try {
                String query;
                if (parsedCommand.getOptionValue(BICOptions.signature_file.getId()).equals("") && parsedCommand.getOptionValue(BICOptions.signature.getId()).equals("") && parsedCommand.getOptionValue(BICOptions.private_key_for_signature.getId()).equals("") && parsedCommand.getOptionValue(BICOptions.wallet_path.getId()).equals("")) {
                    throw new BICException(new String[]{String.format(Messages.getString("BICEXP.MISSING_COMPULSORY_PARAMETER"), BICOptions.signature_file.getName() + "' or '" + BICOptions.signature.getName() + "' or '" + BICOptions.private_key_for_signature.getName() + "' or '" + BICOptions.wallet_path.getName())});
                }
                if (!(parsedCommand.getOptionValue(BICOptions.signature_file.getId()).equals("") || parsedCommand.getOptionValue(BICOptions.signature.getId()).equals("") || parsedCommand.getOptionValue(BICOptions.private_key_for_signature.getId()).equals("") || parsedCommand.getOptionValue(BICOptions.wallet_path.getId()).equals(""))) {
                    throw new BICException(new String[]{String.format(Messages.getString("BICEXP.CONFLICTING_OPTIONS_4"), BICOptions.signature.getName(), BICOptions.signature_file.getName(), BICOptions.private_key_for_signature.getName(), BICOptions.wallet_path.getName())});
                }
                if (!parsedCommand.getOptionValue(BICOptions.signature_file.getId()).equals("") && !parsedCommand.getOptionValue(BICOptions.signature.getId()).equals("") && !parsedCommand.getOptionValue(BICOptions.private_key_for_signature.getId()).equals("") && parsedCommand.getOptionValue(BICOptions.wallet_path.getId()).equals("")) {
                    throw new BICException(new String[]{String.format(Messages.getString("BICEXP.CONFLICTING_OPTIONS"), BICOptions.signature.getName(), BICOptions.signature_file.getName(), BICOptions.private_key_for_signature.getName())});
                }
                if (!parsedCommand.getOptionValue(BICOptions.signature_file.getId()).equals("") && parsedCommand.getOptionValue(BICOptions.signature.getId()).equals("") && !parsedCommand.getOptionValue(BICOptions.private_key_for_signature.getId()).equals("") && !parsedCommand.getOptionValue(BICOptions.wallet_path.getId()).equals("")) {
                    throw new BICException(new String[]{String.format(Messages.getString("BICEXP.CONFLICTING_OPTIONS"), BICOptions.signature_file.getName(), BICOptions.private_key_for_signature.getName(), BICOptions.wallet_path.getName())});
                }
                if (!parsedCommand.getOptionValue(BICOptions.signature_file.getId()).equals("") && !parsedCommand.getOptionValue(BICOptions.signature.getId()).equals("") && parsedCommand.getOptionValue(BICOptions.private_key_for_signature.getId()).equals("") && !parsedCommand.getOptionValue(BICOptions.wallet_path.getId()).equals("")) {
                    throw new BICException(new String[]{String.format(Messages.getString("BICEXP.CONFLICTING_OPTIONS"), BICOptions.signature.getName(), BICOptions.signature_file.getName(), BICOptions.wallet_path.getName())});
                }
                if (parsedCommand.getOptionValue(BICOptions.signature_file.getId()).equals("") && !parsedCommand.getOptionValue(BICOptions.signature.getId()).equals("") && !parsedCommand.getOptionValue(BICOptions.private_key_for_signature.getId()).equals("") && !parsedCommand.getOptionValue(BICOptions.wallet_path.getId()).equals("")) {
                    throw new BICException(new String[]{String.format(Messages.getString("BICEXP.CONFLICTING_OPTIONS"), BICOptions.signature.getName(), BICOptions.private_key_for_signature.getName(), BICOptions.wallet_path.getName())});
                }
                if (!parsedCommand.getOptionValue(BICOptions.signature_file.getId()).equals("") && !parsedCommand.getOptionValue(BICOptions.signature.getId()).equals("")) {
                    throw new BICException(new String[]{String.format(Messages.getString("BICEXP.CONFLICTING_OPTION"), BICOptions.signature.getName(), BICOptions.signature_file.getName())});
                }
                if (!parsedCommand.getOptionValue(BICOptions.signature_file.getId()).equals("") && !parsedCommand.getOptionValue(BICOptions.private_key_for_signature.getId()).equals("")) {
                    throw new BICException(new String[]{String.format(Messages.getString("BICEXP.CONFLICTING_OPTION"), BICOptions.private_key_for_signature.getName(), BICOptions.signature_file.getName())});
                }
                if (!parsedCommand.getOptionValue(BICOptions.signature_file.getId()).equals("") && !parsedCommand.getOptionValue(BICOptions.wallet_path.getId()).equals("")) {
                    throw new BICException(new String[]{String.format(Messages.getString("BICEXP.CONFLICTING_OPTION"), BICOptions.wallet_path.getName(), BICOptions.signature_file.getName())});
                }
                if (!parsedCommand.getOptionValue(BICOptions.private_key_for_signature.getId()).equals("") && !parsedCommand.getOptionValue(BICOptions.signature.getId()).equals("")) {
                    throw new BICException(new String[]{String.format(Messages.getString("BICEXP.CONFLICTING_OPTION"), BICOptions.private_key_for_signature.getName(), BICOptions.signature_file.getName())});
                }
                if (!parsedCommand.getOptionValue(BICOptions.wallet_path.getId()).equals("") && !parsedCommand.getOptionValue(BICOptions.signature.getId()).equals("")) {
                    throw new BICException(new String[]{String.format(Messages.getString("BICEXP.CONFLICTING_OPTION"), BICOptions.wallet_path.getName(), BICOptions.signature_file.getName())});
                }
                if (!parsedCommand.getOptionValue(BICOptions.private_key_for_signature.getId()).equals("") && !parsedCommand.getOptionValue(BICOptions.wallet_path.getId()).equals("")) {
                    throw new BICException(new String[]{String.format(Messages.getString("BICEXP.CONFLICTING_OPTION"), BICOptions.private_key_for_signature.getName(), BICOptions.wallet_path.getName())});
                }
                if (!(parsedCommand.getOptionValue(BICOptions.signature.getId()).equals("") && parsedCommand.getOptionValue(BICOptions.signature_file.getId()).equals("") && parsedCommand.getOptionValue(BICOptions.private_key_for_signature.getId()).equals("") || parsedCommand.getOptionValue(BICOptions.wallet_password.getId()).equals("") && parsedCommand.getOptionValue(BICOptions.wallet_private_key_password.getId()).equals("") && parsedCommand.getOptionValue(BICOptions.wallet_private_key_alias.getId()).equals(""))) {
                    throw new BICException(new String[]{Messages.getString("BICEXP.WALLET_PARAMS_ERROR")});
                }
                if (!parsedCommand.getOptionValue(BICOptions.private_key_for_signature.getId()).equals("") || !parsedCommand.getOptionValue(BICOptions.wallet_path.getId()).equals("")) {
                    if (!parsedCommand.getOptionValue(BICOptions.wallet_path.getId()).equals("")) {
                        walletPath = (String)binds.get(BICOptions.wallet_path.getId());
                        pvtKeyAlias = (String)binds.get(BICOptions.wallet_private_key_alias.getId());
                    }
                    if (!parsedCommand.getOptionValue(BICOptions.private_key_for_signature.getId()).equals("")) {
                        privateKeyPath = (String)binds.get(BICOptions.private_key_for_signature.getId());
                    }
                    binds.remove(BICOptions.private_key_for_signature.getId());
                    binds.remove(BICOptions.wallet_path.getId());
                    binds.remove(BICOptions.wallet_private_key_alias.getId());
                    signatureBytes = BlockchainProcessor.getBytForRowSigExtension(model, parsedCommand, binds);
                    if (signatureBytes != null && !parsedCommand.getOptionValue(BICOptions.private_key_for_signature.getId()).equals("")) {
                        signatureBytesFileName = BICStubs.generateUniqueName("sigBytes") + ".dat";
                        BICStubs.writeSignatureBytesToFile(signatureBytes, signatureBytesFileName);
                    }
                } else if (!binds.get(BICOptions.pdb_guid.getId()).equals("")) {
                    throw new BICException(new String[]{String.format(Messages.getString("BICEXP.UNSUPPORTED_OPTION_PDB_GUID"), BICOptions.pdb_guid.getName(), model.getCommand().getSql().toLowerCase().trim(), BICOptions.private_key_for_signature.getName())});
                }
                binds.remove(BICOptions.private_key_for_signature.getId());
                binds.remove(BICOptions.wallet_path.getId());
                binds.remove(BICOptions.wallet_private_key_alias.getId());
                binds.remove(BICOptions.data_format_hash.getId());
                binds.remove(BICOptions.row_data_bytes.getId());
                binds.remove(BICOptions.signature_type_sign_23C.getId());
                binds.remove(BICOptions.pdb_guid.getId());
                if (binds.containsKey(BICOptions.keycol1_name.getId()) && binds.containsKey(BICOptions.keycol1_value.getId())) {
                    isKC = true;
                    binds.remove(BICOptions.keycol1_name.getId());
                    binds.remove(BICOptions.keycol1_value.getId());
                    binds.remove(BICOptions.keycol2_name.getId());
                    binds.remove(BICOptions.keycol2_value.getId());
                    binds.remove(BICOptions.keycol3_name.getId());
                    binds.remove(BICOptions.keycol3_value.getId());
                }
                InVar.clear();
                InVar.add(BICOptions.row_hash.getId());
                InVar.add(BICOptions.signature.getId());
                InVar.add(BICOptions.signature_file.getId());
                InVar.add(BICOptions.cert_guid_req.getId());
                InVar.add(BICOptions.algorithm_req.getId());
                if (isKC) {
                    InVar.add(BICOptions.keycol1_name.getId());
                    InVar.add(BICOptions.keycol1_value.getId());
                    InVar.add(BICOptions.keycol2_name.getId());
                    InVar.add(BICOptions.keycol2_value.getId());
                    InVar.add(BICOptions.keycol3_name.getId());
                    InVar.add(BICOptions.keycol3_value.getId());
                }
                InVar.add(BICOptions.countersignature_algo.getId());
                InVar.add(BICOptions.countersignature_signed_bytes.getId());
                OutFiles.add(BICOptions.countersign_bytes_file.getId());
                OutBinds.add(BICOptions.countersignature.getId());
                OutBinds.add(BICOptions.countersignature_cert_guid.getId());
                InVar.add(BICOptions.countersignature_content_version.getId());
                binds = BICStubs.collectOptionValue(model, parsedCommand, binds, InVar, OutBinds, OutFiles);
                if (binds.containsKey(BICOptions.algorithm_req.getId())) {
                    String algoEntry = (String)binds.get(BICOptions.algorithm_req.getId());
                    if (algoEntry.equalsIgnoreCase("RSA_SHA2_512")) {
                        signatureAlgo = "sha512";
                        walletSignatureAlgo = "SHA512withRSA";
                        tempMap.put(BICOptions.algorithm_req.getId(), "dbms_blockchain_table.SIGN_ALGO_RSA_SHA2_512");
                    } else if (algoEntry.equalsIgnoreCase("RSA_SHA2_256")) {
                        signatureAlgo = "sha256";
                        walletSignatureAlgo = "SHA256withRSA";
                        tempMap.put(BICOptions.algorithm_req.getId(), "dbms_blockchain_table.SIGN_ALGO_RSA_SHA2_256");
                    } else if (algoEntry.equalsIgnoreCase("RSA_SHA2_384")) {
                        signatureAlgo = "sha384";
                        walletSignatureAlgo = "SHA384withRSA";
                        tempMap.put(BICOptions.algorithm_req.getId(), "dbms_blockchain_table.SIGN_ALGO_RSA_SHA2_384");
                    } else {
                        throw new BICException(new String[]{String.format(Messages.getString("BICEXP.INVALID_ALGORITHM"), algoEntry, model.getCommand().getSql().toLowerCase())});
                    }
                    binds.remove(BICOptions.algorithm_req.getId());
                }
                if (signature_type_sign.equalsIgnoreCase("DELEGATE")) {
                    tempMap.put(BICOptions.delegate_flag.getId(), Boolean.TRUE.toString());
                } else {
                    tempMap.put(BICOptions.delegate_flag.getId(), Boolean.FALSE.toString());
                }
                if (binds.containsKey(BICOptions.countersignature_algo.getId())) {
                    String algoEntry = (String)binds.get(BICOptions.countersignature_algo.getId());
                    String countersignatureAlgo = algoEntry.equalsIgnoreCase("RSA_SHA2_512") ? "dbms_blockchain_table.SIGN_ALGO_RSA_SHA2_512" : (algoEntry.equalsIgnoreCase("RSA_SHA2_256") ? "dbms_blockchain_table.SIGN_ALGO_RSA_SHA2_256" : (algoEntry.equalsIgnoreCase("RSA_SHA2_384") ? "dbms_blockchain_table.SIGN_ALGO_RSA_SHA2_384" : algoEntry));
                    tempMap.put(BICOptions.countersignature_algo.getId(), countersignatureAlgo);
                    binds.remove(BICOptions.countersignature_algo.getId());
                }
                Object contentVersion = binds.get(BICOptions.countersignature_content_version.getId()).toString().charAt(0) == '\'' ? binds.get(BICOptions.countersignature_content_version.getId()).toString() : "'" + String.valueOf(binds.get(BICOptions.countersignature_content_version.getId())) + "'";
                tempMap.put(BICOptions.countersignature_content_version.getId(), contentVersion);
                binds.remove(BICOptions.countersignature_content_version.getId());
                if (binds.get(BICOptions.countersignature_signed_bytes.getId()).equals("")) {
                    try {
                        binds.put(BICOptions.countersignature_signed_bytes.getId(), model.getConnection().createBlob());
                    }
                    catch (SQLException e) {
                        throw new BICException(new String[]{String.format(e.getMessage(), new Object[0])});
                    }
                }
                if (!binds.get(BICOptions.row_hash.getId()).equals("")) {
                    binds.put(BICOptions.row_hash.getId(), BICStubs.hexToRaw((String)binds.get(BICOptions.row_hash.getId())));
                }
                if ((query = isKC ? BICStubs.getQuery("SIGN_ROW_SPECIFIED_BY_KEY_COLUMNS_WITH_COUNTERSIGNATURE", model.getConnection(), "oracle/dbtools/sqlcl/commands/blockchain/blockchainQueriesP2.xml") : BICStubs.getQuery("SIGN_ROW_WITH_COUNTERSIGNATURE", model.getConnection(), "oracle/dbtools/sqlcl/commands/blockchain/blockchainQueriesP2.xml")) != null) {
                    query = String.format(query, new ArrayList(tempMap.values()).toArray());
                }
                if (!parsedCommand.getOptionValue(BICOptions.signature_file.getId()).equals("")) {
                    RAW signatureInput = BICStubs.binaryFileToRaw((String)binds.get(BICOptions.signature_file.getId()), BICOptions.signature_file.getName());
                    binds.put(BICOptions.signature_file.getId(), signatureInput);
                    binds.remove(BICOptions.signature.getId());
                } else if (!parsedCommand.getOptionValue(BICOptions.signature.getId()).equals("")) {
                    RAW signatureInput = BICStubs.hexToRaw((String)binds.get(BICOptions.signature.getId()));
                    binds.put(BICOptions.signature.getId(), signatureInput);
                    binds.remove(BICOptions.signature_file.getId());
                } else if (!parsedCommand.getOptionValue(BICOptions.private_key_for_signature.getId()).equals("")) {
                    generatedsignatureFileName = BICStubs.generateSignatureForSignRow(signatureAlgo, privateKeyPath, signatureBytesFileName);
                    binds.put(BICOptions.signature.getId(), BICStubs.signatureFileToRaw(generatedsignatureFileName));
                    binds.remove(BICOptions.signature_file.getId());
                } else {
                    String walletPassword = (String)parsedCommand.getOptionValue(BICOptions.wallet_password.getId());
                    String prvtKeyPassword = (String)parsedCommand.getOptionValue(BICOptions.wallet_private_key_password.getId());
                    String certificateId = (String)binds.get(BICOptions.cert_guid_req.getId());
                    RAW signatureInput = walletPassword.equals("") && prvtKeyPassword.equals("") ? BICStubs.generateSignatureUsingWallet(model, walletPath, null, null, pvtKeyAlias, certificateId, signatureBytes, walletSignatureAlgo) : (walletPassword.equals("") && !prvtKeyPassword.equals("") ? BICStubs.generateSignatureUsingWallet(model, walletPath, null, prvtKeyPassword.toCharArray(), pvtKeyAlias, certificateId, signatureBytes, walletSignatureAlgo) : (!walletPassword.equals("") && prvtKeyPassword.equals("") ? BICStubs.generateSignatureUsingWallet(model, walletPath, walletPassword.toCharArray(), null, pvtKeyAlias, certificateId, signatureBytes, walletSignatureAlgo) : BICStubs.generateSignatureUsingWallet(model, walletPath, walletPassword.toCharArray(), prvtKeyPassword.toCharArray(), pvtKeyAlias, certificateId, signatureBytes, walletSignatureAlgo)));
                    binds.put(BICOptions.signature.getId(), signatureInput);
                    binds.remove(BICOptions.signature_file.getId());
                    walletPassword = null;
                    prvtKeyPassword = null;
                    parsedCommand.clearOptionValue(BICOptions.wallet_private_key_password.getId());
                    parsedCommand.clearOptionValue(BICOptions.wallet_password.getId());
                }
                OracleCallableStatement returnStatement = null;
                if (LockManager.lock((Connection)model.getConnection())) {
                    try {
                        returnStatement = (OracleCallableStatement)BICStubs.bind(model.getConnection().prepareCall(query), new ArrayList<Object>(binds.values()));
                        returnStatement.registerOutParameter(binds.size() + 1, (SQLType)OracleType.BLOB);
                        returnStatement.registerOutParameter(binds.size() + 2, (SQLType)OracleType.RAW);
                        returnStatement.registerOutParameter(binds.size() + 3, (SQLType)OracleType.RAW);
                        returnStatement.executeUpdate();
                        BLOB countersignatureSignedBytes = returnStatement.getBLOB(binds.size() + 1);
                        RAW countersignature = returnStatement.getRAW(binds.size() + 2);
                        RAW countersignature_cert_id = returnStatement.getRAW(binds.size() + 3);
                        model.getContext().writeln("Command executed successfully.");
                        if (isKC) {
                            model.getContext().writeln("Successfully signed and countersigned row identified by key columns " + BICStubs.whereClauseForKC(parsedCommand) + " in table '" + String.valueOf(binds.get(BICOptions.schema.getId())) + "." + String.valueOf(binds.get(BICOptions.tableName_immutable_req.getId())) + "'.");
                        } else {
                            model.getContext().writeln("Successfully signed and countersigned row at instance id '" + String.valueOf(binds.get(BICOptions.instance_id.getId())) + "',  chain id '" + String.valueOf(binds.get(BICOptions.chain_id.getId())) + "' and  sequence id '" + String.valueOf(binds.get(BICOptions.sequence_id.getId())) + "' in table '" + String.valueOf(binds.get(BICOptions.schema.getId())) + "." + String.valueOf(binds.get(BICOptions.tableName_immutable_req.getId())) + "'.");
                        }
                        if (BICStubs.outputBindsAndFiles.get(BICOptions.countersign_bytes_file.getId()) != null) {
                            BICStubs.writeBlobToFile((Blob)countersignatureSignedBytes, BICStubs.outputBindsAndFiles.get(BICOptions.countersign_bytes_file.getId()), BICOptions.countersign_bytes_file.getName());
                        }
                        BICStubs.populateBindVariableStringValue(model, BICOptions.countersignature, countersignature.stringValue());
                        BICStubs.populateBindVariableStringValue(model, BICOptions.countersignature_cert_guid, countersignature_cert_id.stringValue());
                    }
                    catch (SQLException e) {
                        throw new BICException(new String[]{String.format(e.getMessage(), new Object[0])});
                    }
                    finally {
                        if (returnStatement != null) {
                            returnStatement.close();
                        }
                        LockManager.unlock((Connection)model.getConnection());
                    }
                }
                errors = new ArrayList<String>();
                if (signatureBytesFileName == null || !(file = new File(signatureBytesFileName)).exists() || file.delete()) break block61;
                errors.add(String.format(Messages.getString("BICEXP.FILE_DELETION_ERROR"), new Object[0]));
            }
            catch (Throwable throwable) {
                File file2;
                ArrayList<String> errors2 = new ArrayList<String>();
                if (signatureBytesFileName != null && (file2 = new File(signatureBytesFileName)).exists() && !file2.delete()) {
                    errors2.add(String.format(Messages.getString("BICEXP.FILE_DELETION_ERROR"), new Object[0]));
                }
                if (generatedsignatureFileName != null && (file2 = new File(generatedsignatureFileName)).exists() && !file2.delete()) {
                    errors2.add(String.format(Messages.getString("BICEXP.FILE_DELETION_ERROR"), new Object[0]));
                }
                if (errors2.size() != 0) {
                    throw new BICException(errors2.toArray(new String[0]));
                }
                throw throwable;
            }
        }
        if (generatedsignatureFileName != null && (file = new File(generatedsignatureFileName)).exists() && !file.delete()) {
            errors.add(String.format(Messages.getString("BICEXP.FILE_DELETION_ERROR"), new Object[0]));
        }
        if (errors.size() != 0) {
            throw new BICException(errors.toArray(new String[0]));
        }
    }

    public static void getBloDigest(BICModel model, ParsedCommand parsedCommand) throws BICException, SQLException {
        block38: {
            OracleCallableStatement returnStatement;
            LinkedHashMap<Id, Object> binds = new LinkedHashMap<Id, Object>();
            LinkedHashSet<Id> InVar = new LinkedHashSet<Id>();
            LinkedHashSet<Id> OutBinds = new LinkedHashSet<Id>();
            LinkedHashSet<Id> OutFiles = new LinkedHashSet<Id>();
            InVar.add(BICOptions.tableName_blockchain_req.getId());
            InVar.add(BICOptions.row_selector_23C.getId());
            InVar.add(BICOptions.row_selector_file_23C.getId());
            InVar.add(BICOptions.digest_bytes.getId());
            InVar.add(BICOptions.row_data_bytes.getId());
            OutFiles.add(BICOptions.digest_bytes_file.getId());
            OutBinds.add(BICOptions.digest.getId());
            OutFiles.add(BICOptions.digest_file.getId());
            OutFiles.add(BICOptions.row_data_file.getId());
            OutFiles.add(BICOptions.digest_row_index_file.getId());
            InVar.add(BICOptions.digest_algorithm.getId());
            binds = BICStubs.collectOptionValue(model, parsedCommand, binds, InVar, OutBinds, OutFiles);
            if (model.getDbMajorVersion() < 23) {
                throw new BICException(new String[]{String.format(Messages.getString("BICEXP.UNSUPPORTED_DB_VERSION"), "GET_DIGEST", model.getDbVersion())});
            }
            if (BICStubs.outputBindsAndFiles.get(BICOptions.digest.getId()) == null && BICStubs.outputBindsAndFiles.get(BICOptions.digest_file.getId()) == null) {
                throw new BICException(new String[]{String.format(Messages.getString("BICEXP.MISSING_COMPULSORY_PARAMETER"), BICOptions.digest.getName() + "' or '" + BICOptions.digest_file.getName())});
            }
            BICStubs.isSelectorPresent = binds.get(BICOptions.row_selector_23C.getId()) != null || binds.get(BICOptions.row_selector_file_23C.getId()) != null;
            Object row_selector = "";
            if (binds.get(BICOptions.row_selector_23C.getId()) != null && binds.get(BICOptions.row_selector_file_23C.getId()) != null) {
                throw new BICException(new String[]{String.format(Messages.getString("BICEXP.CONFLICTING_OPTION"), BICOptions.row_selector_23C.getName(), BICOptions.row_selector_file_23C.getName())});
            }
            if (binds.get(BICOptions.row_selector_file_23C.getId()) != null) {
                row_selector = BICStubs.parseStringFromFile((String)binds.get(BICOptions.row_selector_file_23C.getId()), BICOptions.row_selector_file_23C.getName());
            } else if (binds.get(BICOptions.row_selector_23C.getId()) != null) {
                row_selector = (String)binds.get(BICOptions.row_selector_23C.getId());
            }
            row_selector = "'" + (String)row_selector + "'";
            binds.remove(BICOptions.row_selector_23C.getId());
            binds.remove(BICOptions.row_selector_file_23C.getId());
            if (binds.get(BICOptions.digest_bytes.getId()).equals("")) {
                try {
                    binds.put(BICOptions.digest_bytes.getId(), model.getConnection().createBlob());
                }
                catch (SQLException e) {
                    throw new BICException(new String[]{String.format(e.getMessage(), new Object[0])});
                }
            }
            if (BICStubs.isSelectorPresent.booleanValue()) {
                if (binds.get(BICOptions.row_data_bytes.getId()).equals("")) {
                    try {
                        binds.put(BICOptions.row_data_bytes.getId(), model.getConnection().createBlob());
                    }
                    catch (SQLException e) {
                        throw new BICException(new String[]{String.format(e.getMessage(), new Object[0])});
                    }
                }
            } else {
                binds.remove(BICOptions.row_data_bytes.getId());
            }
            String algoVal = null;
            if (binds.containsKey(BICOptions.digest_algorithm.getId())) {
                String algoEntry = (String)binds.get(BICOptions.digest_algorithm.getId());
                algoVal = algoEntry.equalsIgnoreCase("SHA2_512") ? "dbms_blockchain_table.HASH_ALGO_SHA2_512" : (algoEntry.equalsIgnoreCase("SHA2_256") ? "dbms_blockchain_table.HASH_ALGO_SHA2_256" : (algoEntry.equalsIgnoreCase("SHA2_384") ? "dbms_blockchain_table.HASH_ALGO_SHA2_384" : algoEntry));
                binds.remove(BICOptions.digest_algorithm.getId());
            }
            String query = BICStubs.isSelectorPresent != false ? BICStubs.getQuery("GET_DIGEST_FOR_SELECTED_ROWS", model.getConnection(), "oracle/dbtools/sqlcl/commands/blockchain/blockchainQueriesP2.xml") : BICStubs.getQuery("GET_DIGEST", model.getConnection(), "oracle/dbtools/sqlcl/commands/blockchain/blockchainQueriesP2.xml");
            if (BICStubs.isSelectorPresent.booleanValue()) {
                if (query != null) {
                    query = String.format(query, row_selector, algoVal);
                }
                try {
                    returnStatement = (OracleCallableStatement)BICStubs.bind(model.getConnection().prepareCall(query), new ArrayList<Object>(binds.values()));
                    returnStatement.registerOutParameter(binds.size() + 1, (SQLType)OracleType.BLOB);
                    returnStatement.registerOutParameter(binds.size() + 2, (SQLType)OracleType.BLOB);
                    returnStatement.registerOutParameter(binds.size() + 3, 2003, "SYS.ORABCTAB_ROW_ARRAY_T");
                    returnStatement.registerOutParameter(binds.size() + 4, (SQLType)OracleType.RAW);
                }
                catch (SQLException e) {
                    throw new BICException(new String[]{String.format(e.getMessage(), new Object[0])});
                }
            }
            if (query != null) {
                query = String.format(query, algoVal);
            }
            try {
                returnStatement = (OracleCallableStatement)BICStubs.bind(model.getConnection().prepareCall(query), new ArrayList<Object>(binds.values()));
                returnStatement.registerOutParameter(binds.size() + 1, (SQLType)OracleType.BLOB);
                returnStatement.registerOutParameter(binds.size() + 2, 2003, "SYS.ORABCTAB_ROW_ARRAY_T");
                returnStatement.registerOutParameter(binds.size() + 3, (SQLType)OracleType.RAW);
            }
            catch (SQLException e) {
                throw new BICException(new String[]{String.format(e.getMessage(), new Object[0])});
            }
            if (LockManager.lock((Connection)model.getConnection())) {
                try {
                    RAW digest;
                    returnStatement.executeUpdate();
                    BLOB digest_bytes = returnStatement.getBLOB(binds.size() + 1);
                    Blob row_data_bytes = BICStubs.isSelectorPresent != false ? returnStatement.getBLOB(binds.size() + 2) : model.getConnection().createBlob();
                    ARRAY digest_row_indexes_array = BICStubs.isSelectorPresent != false ? returnStatement.getARRAY(binds.size() + 3) : returnStatement.getARRAY(binds.size() + 2);
                    RAW rAW = digest = BICStubs.isSelectorPresent != false ? returnStatement.getRAW(binds.size() + 4) : returnStatement.getRAW(binds.size() + 3);
                    if (BICStubs.outputBindsAndFiles.get(BICOptions.digest_bytes_file.getId()) != null) {
                        BICStubs.writeBlobToFile((Blob)digest_bytes, BICStubs.outputBindsAndFiles.get(BICOptions.digest_bytes_file.getId()), BICOptions.digest_bytes_file.getName());
                    }
                    BICStubs.populateBindVariableStringValue(model, BICOptions.digest, digest.stringValue());
                    if (BICStubs.outputBindsAndFiles.get(BICOptions.digest_file.getId()) != null) {
                        BICStubs.writeRAWToFile(digest, BICStubs.outputBindsAndFiles.get(BICOptions.digest_file.getId()), BICOptions.digest_file.getName());
                    }
                    if (BICStubs.outputBindsAndFiles.get(BICOptions.row_data_file.getId()) != null) {
                        BICStubs.writeBlobToFile(row_data_bytes, BICStubs.outputBindsAndFiles.get(BICOptions.row_data_file.getId()), BICOptions.row_data_file.getName());
                    }
                    if (BICStubs.outputBindsAndFiles.get(BICOptions.digest_row_index_file.getId()) == null) break block38;
                    Object[] arrayElements = (Object[])digest_row_indexes_array.getArray();
                    JsonArrayBuilder jsonArrayBuilder = Json.createArrayBuilder();
                    for (Object element : arrayElements) {
                        jsonArrayBuilder.add((JsonValue)BICStubs.convertOracleSQLStructToJson((STRUCT)element));
                    }
                    StringWriter stringWriter = new StringWriter();
                    try (JsonWriter jsonWriter = Json.createWriter((Writer)stringWriter);){
                        jsonWriter.writeArray(jsonArrayBuilder.build());
                    }
                    BICStubs.writeStringToFile(stringWriter.toString(), BICStubs.outputBindsAndFiles.get(BICOptions.digest_row_index_file.getId()), BICOptions.digest_row_index_file.getName());
                }
                catch (SQLException e) {
                    throw new BICException(new String[]{String.format(e.getMessage(), new Object[0])});
                }
                finally {
                    returnStatement.close();
                    LockManager.unlock((Connection)model.getConnection());
                }
            }
        }
        model.getContext().writeln("Command executed successfully.");
    }

    public static void verifyUserChains(BICModel model, ParsedCommand parsedCommand) throws BICException, SQLException {
        LinkedHashMap<Id, Object> binds = new LinkedHashMap<Id, Object>();
        LinkedHashSet<Id> InVar = new LinkedHashSet<Id>();
        LinkedHashSet<Id> OutBinds = new LinkedHashSet<Id>();
        InVar.add(BICOptions.tableName_blockchain_req.getId());
        InVar.add(BICOptions.user_chain_verify.getId());
        OutBinds.add(BICOptions.verified_rows_count.getId());
        InVar.add(BICOptions.keycol1_value_user_chain.getId());
        InVar.add(BICOptions.keycol2_value_user_chain.getId());
        InVar.add(BICOptions.keycol3_value_user_chain.getId());
        InVar.add(BICOptions.low_timestamp.getId());
        InVar.add(BICOptions.high_timestamp.getId());
        InVar.add(BICOptions.skip_user_signature_23C.getId());
        InVar.add(BICOptions.skip_delegate_signature_23C.getId());
        InVar.add(BICOptions.skip_countersignature_23C.getId());
        InVar.add(BICOptions.pdb_guid_23C.getId());
        binds = BICStubs.collectOptionValue(model, parsedCommand, binds, InVar, OutBinds, null);
        BICStubs.booleanBinds.clear();
        if (model.getDbMajorVersion() < 23) {
            throw new BICException(new String[]{String.format(Messages.getString("BICEXP.UNSUPPORTED_DB_VERSION"), "VERIFY_USER_CHAINS", model.getDbVersion())});
        }
        String query = BICStubs.getQuery("VERIFY_USER_CHAINS", model.getConnection(), "oracle/dbtools/sqlcl/commands/blockchain/blockchainQueriesP2.xml");
        if (!binds.get(BICOptions.pdb_guid_23C.getId()).equals("")) {
            binds.put(BICOptions.pdb_guid_23C.getId(), BICStubs.hexToRaw((String)binds.get(BICOptions.pdb_guid_23C.getId())));
        }
        if (parsedCommand.getOptionValue(BICOptions.skip_user_signature_23C.getId()).toString().equals(Boolean.TRUE.toString())) {
            BICStubs.booleanBinds.put(BICOptions.skip_user_signature_23C.getId(), Boolean.FALSE.toString());
        } else {
            BICStubs.booleanBinds.put(BICOptions.skip_user_signature_23C.getId(), Boolean.TRUE.toString());
        }
        if (parsedCommand.getOptionValue(BICOptions.skip_delegate_signature_23C.getId()).toString().equals(Boolean.TRUE.toString())) {
            BICStubs.booleanBinds.put(BICOptions.skip_delegate_signature_23C.getId(), Boolean.FALSE.toString());
        } else {
            BICStubs.booleanBinds.put(BICOptions.skip_delegate_signature_23C.getId(), Boolean.TRUE.toString());
        }
        if (parsedCommand.getOptionValue(BICOptions.skip_countersignature_23C.getId()).toString().equals(Boolean.TRUE.toString())) {
            BICStubs.booleanBinds.put(BICOptions.skip_countersignature_23C.getId(), Boolean.FALSE.toString());
        } else {
            BICStubs.booleanBinds.put(BICOptions.skip_countersignature_23C.getId(), Boolean.TRUE.toString());
        }
        if (query != null) {
            query = String.format(query, new ArrayList<String>(BICStubs.booleanBinds.values()).toArray());
        }
        BICStubs.booleanBinds.clear();
        OracleCallableStatement returnStatement = null;
        if (LockManager.lock((Connection)model.getConnection())) {
            try {
                returnStatement = (OracleCallableStatement)BICStubs.bind(model.getConnection().prepareCall(query), new ArrayList<Object>(binds.values()));
                returnStatement.registerOutParameter(binds.size() + 1, (SQLType)OracleType.NUMBER);
                returnStatement.executeUpdate();
                NUMBER num_of_rows_verified = returnStatement.getNUMBER(binds.size() + 1);
                model.getContext().writeln("Command executed successfully.");
                model.getContext().writeln("Verified " + num_of_rows_verified.stringValue() + " rows from '" + String.valueOf(binds.get(BICOptions.schema.getId())) + "." + String.valueOf(binds.get(BICOptions.tableName_blockchain_req.getId())) + "' table.");
                BICStubs.populateBindVariableStringValue(model, BICOptions.verified_rows_count, num_of_rows_verified.stringValue());
            }
            catch (SQLException e) {
                throw new BICException(new String[]{String.format(e.getMessage(), new Object[0])});
            }
            finally {
                if (returnStatement != null) {
                    returnStatement.close();
                }
                LockManager.unlock((Connection)model.getConnection());
            }
        }
    }
}

