/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.jdbc;

import com.healthmarketscience.jackcess.Database;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.function.BiConsumer;
import net.ucanaccess.converters.LoadJet;
import net.ucanaccess.converters.Metadata;
import net.ucanaccess.converters.SQLConverter;
import net.ucanaccess.jdbc.DBReference;
import net.ucanaccess.jdbc.DBReferenceSingleton;
import net.ucanaccess.jdbc.DefaultJackcessOpener;
import net.ucanaccess.jdbc.IJackcessOpenerInterface;
import net.ucanaccess.jdbc.Session;
import net.ucanaccess.jdbc.UcanaccessConnection;
import net.ucanaccess.jdbc.UcanaccessSQLException;
import net.ucanaccess.log.Logger;
import net.ucanaccess.log.LoggerMessageEnum;
import net.ucanaccess.type.ColumnOrder;
import net.ucanaccess.util.Try;
import net.ucanaccess.util.UcanaccessRuntimeException;

public final class UcanaccessDriver
implements Driver {
    public static final String URL_PREFIX = "jdbc:ucanaccess://";

    static {
        try {
            DriverManager.registerDriver(new UcanaccessDriver());
            Class.forName("org.hsqldb.jdbc.JDBCDriver");
            System.setProperty("hsqldb.method_class_names", "net.ucanaccess.converters.*");
        }
        catch (ClassNotFoundException _ex) {
            Logger.logWarning(LoggerMessageEnum.HSQLDB_DRIVER_NOT_FOUND, new String[0]);
            throw new UcanaccessRuntimeException(_ex.getMessage());
        }
        catch (SQLException _ex) {
            throw new UcanaccessRuntimeException(_ex.getMessage());
        }
    }

    @Override
    public boolean acceptsURL(String _url) {
        return _url != null && _url.startsWith(URL_PREFIX) && _url.length() > URL_PREFIX.length();
    }

    @Override
    public Connection connect(String _url, Properties _props) throws SQLException {
        if (!this.acceptsURL(_url)) {
            return null;
        }
        LinkedHashMap unknownProps = new LinkedHashMap();
        Map<Metadata.Property, String> props = UcanaccessDriver.readProperties(_props, _url, (k, v) -> {
            unknownProps.put(k, v);
            Logger.logWarning(LoggerMessageEnum.UNKNOWN_DRIVER_PROPERTY, k, v);
        });
        int idxSemicolon = _url.indexOf(59);
        String fileDbPath = idxSemicolon > 0 ? _url.substring(URL_PREFIX.length(), idxSemicolon) : _url.substring(URL_PREFIX.length());
        File fileDb = new File(fileDbPath);
        DBReferenceSingleton as = DBReferenceSingleton.getInstance();
        Class<UcanaccessDriver> clazz = UcanaccessDriver.class;
        synchronized (UcanaccessDriver.class) {
            try {
                String pwd;
                DBReference dbRef;
                boolean useCustomOpener;
                Session session = new Session();
                boolean alreadyLoaded = as.loaded(fileDb);
                Database.FileFormat ff = null;
                if (props.containsKey((Object)Metadata.Property.newDatabaseVersion) && !fileDb.exists()) {
                    ff = Database.FileFormat.valueOf((String)props.get((Object)Metadata.Property.newDatabaseVersion).toUpperCase());
                }
                DefaultJackcessOpener jko = (useCustomOpener = props.containsKey((Object)Metadata.Property.jackcessOpener)) ? this.newJackcessOpenerInstance(props.get((Object)Metadata.Property.jackcessOpener)) : new DefaultJackcessOpener();
                DBReference dBReference = dbRef = alreadyLoaded ? as.getReference(fileDb) : as.loadReference(fileDb, ff, jko, props.get((Object)Metadata.Property.password));
                if (!alreadyLoaded) {
                    if ((useCustomOpener || props.containsKey((Object)Metadata.Property.encrypt) && Boolean.parseBoolean(props.get((Object)Metadata.Property.encrypt))) && (props.containsKey((Object)Metadata.Property.memory) && !Boolean.parseBoolean(props.get((Object)Metadata.Property.memory)) || props.containsKey((Object)Metadata.Property.keepMirror))) {
                        dbRef.setEncryptHSQLDB(true);
                    }
                    if (props.containsKey((Object)Metadata.Property.memory)) {
                        dbRef.setInMemory(Boolean.parseBoolean(props.get((Object)Metadata.Property.memory)));
                    }
                    if (props.containsKey((Object)Metadata.Property.lobScale)) {
                        Integer vl = this.validateLobScale(props.get((Object)Metadata.Property.lobScale));
                        dbRef.setLobScale(vl);
                    }
                    if (props.containsKey((Object)Metadata.Property.keepMirror)) {
                        dbRef.setInMemory(false);
                        if (dbRef.isEncryptHSQLDB()) {
                            Logger.logWarning(LoggerMessageEnum.KEEP_MIRROR_AND_OTHERS, new String[0]);
                        } else {
                            File dbMirror = new File(props.get((Object)Metadata.Property.keepMirror) + fileDb.getName().toUpperCase().hashCode());
                            dbRef.setToKeepHsql(dbMirror);
                            if (props.containsKey((Object)Metadata.Property.readOnlyMirror)) {
                                dbRef.setMirrorReadOnly(Boolean.parseBoolean(props.get((Object)Metadata.Property.readOnlyMirror)));
                            }
                        }
                    }
                    if (props.containsKey((Object)Metadata.Property.showSchema)) {
                        dbRef.setShowSchema(Boolean.parseBoolean(props.get((Object)Metadata.Property.showSchema)));
                    }
                    if (props.containsKey((Object)Metadata.Property.inactivityTimeout)) {
                        int millis = 60000 * Integer.parseInt(props.get((Object)Metadata.Property.inactivityTimeout));
                        dbRef.setInactivityTimeout(millis);
                    }
                    if (props.containsKey((Object)Metadata.Property.singleConnection)) {
                        dbRef.setImmediatelyReleaseResources(Boolean.parseBoolean(props.get((Object)Metadata.Property.singleConnection)));
                    }
                    if (props.containsKey((Object)Metadata.Property.immediatelyReleaseResources)) {
                        dbRef.setImmediatelyReleaseResources(Boolean.parseBoolean(props.get((Object)Metadata.Property.immediatelyReleaseResources)));
                    }
                    if (props.containsKey((Object)Metadata.Property.lockMdb)) {
                        dbRef.setOpenExclusive(Boolean.parseBoolean(props.get((Object)Metadata.Property.lockMdb)));
                    }
                    if (props.containsKey((Object)Metadata.Property.openExclusive)) {
                        dbRef.setOpenExclusive(Boolean.parseBoolean(props.get((Object)Metadata.Property.openExclusive)));
                    }
                    if (props.containsKey((Object)Metadata.Property.concatNulls)) {
                        dbRef.setConcatNulls(Boolean.parseBoolean(props.get((Object)Metadata.Property.concatNulls)));
                    }
                    if (props.containsKey((Object)Metadata.Property.preventReloading)) {
                        dbRef.setPreventReloading(Boolean.parseBoolean(props.get((Object)Metadata.Property.preventReloading)));
                    }
                    if (props.containsKey((Object)Metadata.Property.reMap)) {
                        dbRef.setExternalResourcesMapping(this.toMap(props.get((Object)Metadata.Property.reMap)));
                    }
                    if (props.containsKey((Object)Metadata.Property.supportsAccessLike)) {
                        SQLConverter.setSupportsAccessLike(Boolean.parseBoolean(props.get((Object)Metadata.Property.supportsAccessLike)));
                    }
                    if (props.containsKey((Object)Metadata.Property.columnOrder) && ColumnOrder.DISPLAY == ColumnOrder.parse(props.get((Object)Metadata.Property.columnOrder))) {
                        dbRef.setColumnOrderDisplay();
                    }
                    if (props.containsKey((Object)Metadata.Property.mirrorFolder) && dbRef.getToKeepHsql() == null) {
                        dbRef.setInMemory(false);
                        String fd = props.get((Object)Metadata.Property.mirrorFolder);
                        if ("java.io.tmpdir".equals(fd)) {
                            fd = System.getProperty("java.io.tmpdir");
                        }
                        dbRef.setMirrorFolder(new File(fd));
                    }
                    if (props.containsKey((Object)Metadata.Property.ignoreCase)) {
                        dbRef.setIgnoreCase(Boolean.parseBoolean(props.get((Object)Metadata.Property.ignoreCase)));
                    }
                    dbRef.getDbIO().setErrorHandler((cl, bt, location, ex) -> {
                        if (cl.getType().isTextual()) {
                            Logger.logWarning(LoggerMessageEnum.INVALID_CHARACTER_SEQUENCE, cl.getTable().getName(), cl.getName(), new String(bt));
                        }
                        throw new IOException(ex.getMessage());
                    });
                }
                if ((pwd = dbRef.getDbIO().getDatabasePassword()) != null && !props.containsKey((Object)Metadata.Property.jackcessOpener)) {
                    if (!pwd.equals(props.get((Object)Metadata.Property.password))) {
                        throw new UcanaccessSQLException(UcanaccessSQLException.ExceptionMessages.NOT_A_VALID_PASSWORD);
                    }
                } else if (props.containsKey((Object)Metadata.Property.jackcessOpener)) {
                    String mpwd = props.get((Object)Metadata.Property.password);
                    session.setPassword(mpwd);
                }
                Optional.ofNullable(props.get((Object)Metadata.Property.user)).ifPresent(session::setUser);
                SQLWarning sqlw = null;
                if (!alreadyLoaded) {
                    boolean val;
                    boolean toBeLoaded = !dbRef.loadedFromKeptMirror(session);
                    Connection conn = dbRef.getHSQLDBConnection(session);
                    Try.withResources(conn::createStatement, st -> st.executeQuery("SET TIME ZONE 'UTC'")).orThrow();
                    LoadJet la = new LoadJet(conn, dbRef.getDbIO());
                    Logger.turnOffJackcessLog();
                    if (props.containsKey((Object)Metadata.Property.sysSchema)) {
                        val = Boolean.parseBoolean(props.get((Object)Metadata.Property.sysSchema));
                        dbRef.setSysSchema(val);
                        la.setSysSchema(val);
                    }
                    if (props.containsKey((Object)Metadata.Property.skipIndexes)) {
                        val = Boolean.parseBoolean(props.get((Object)Metadata.Property.skipIndexes));
                        dbRef.setSkipIndexes(val);
                        la.setSkipIndexes(val);
                    }
                    if (toBeLoaded) {
                        la.loadDB();
                    } else {
                        la.resetFunctionsDefault();
                    }
                    as.put(fileDb.getAbsolutePath(), dbRef);
                    sqlw = la.getLoadingWarnings();
                }
                Properties newProps = new Properties();
                props.entrySet().stream().forEach(e -> {
                    Object object = newProps.put(((Metadata.Property)((Object)((Object)e.getKey()))).name(), e.getValue());
                });
                newProps.putAll((Map<?, ?>)unknownProps);
                UcanaccessConnection uc = new UcanaccessConnection(as.getReference(fileDb), newProps, session);
                uc.addWarnings(sqlw);
                uc.setUrl(_url);
                // ** MonitorExit[var9_9] (shouldn't be in output)
                return uc;
            }
            catch (Exception _ex) {
                throw new UcanaccessSQLException(_ex);
            }
        }
    }

    private Integer validateLobScale(String _property) {
        try {
            Integer i = Integer.parseInt(_property);
            if (i == 1 || i == 2 || i == 4 || i == 8 || i == 16 || i == 32) {
                return i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Logger.logWarning(LoggerMessageEnum.LOBSCALE, new String[0]);
        return null;
    }

    private Map<String, String> toMap(String property) {
        HashMap<String, String> hm = new HashMap<String, String>();
        StringTokenizer st = new StringTokenizer(property, "&");
        while (st.hasMoreTokens()) {
            String entry = st.nextToken();
            if (!entry.contains("|")) continue;
            hm.put(entry.substring(0, entry.indexOf(124)).toLowerCase(), entry.substring(entry.indexOf(124) + 1));
        }
        return hm;
    }

    @Override
    public int getMajorVersion() {
        return 0;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties arg1) {
        return new DriverPropertyInfo[0];
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    private IJackcessOpenerInterface newJackcessOpenerInstance(String className) throws InstantiationException, IllegalAccessException, ClassNotFoundException, UcanaccessSQLException, InvocationTargetException, NoSuchMethodException, SecurityException {
        Object newInstance = Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0]);
        if (!IJackcessOpenerInterface.class.isInstance(newInstance)) {
            throw new UcanaccessSQLException(UcanaccessSQLException.ExceptionMessages.INVALID_JACKCESS_OPENER);
        }
        return (IJackcessOpenerInterface)newInstance;
    }

    static Map<Metadata.Property, String> readProperties(Properties _input, String _url, BiConsumer<String, String> _unknownConsumer) {
        Objects.requireNonNull(_input, "Properties required");
        Objects.requireNonNull(_url, "URL required");
        EnumMap<Metadata.Property, String> props = new EnumMap<Metadata.Property, String>(Metadata.Property.class);
        for (String key : _input.stringPropertyNames()) {
            Metadata.Property prop = Metadata.Property.parse(key);
            String val = _input.getProperty(key);
            if (prop == null) {
                _unknownConsumer.accept(key, val);
                continue;
            }
            props.put(prop, val);
        }
        Arrays.stream(_url.split(";")).skip(1L).map(s -> s.split("=")).forEach(arr -> {
            String val;
            Metadata.Property prop = Metadata.Property.parse(arr[0]);
            String string = val = ((String[])arr).length > 1 ? arr[1].strip() : null;
            if (prop == null) {
                _unknownConsumer.accept(arr[0], val);
            } else {
                props.put(prop, val);
            }
        });
        return props;
    }
}

