/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.ucanaccess.converters.SQLConverter;
import net.ucanaccess.jdbc.UcanaccessConnection;
import net.ucanaccess.jdbc.UcanaccessSQLException;
import net.ucanaccess.util.Try;
import net.ucanaccess.util.UcanaccessRuntimeException;

public class UcanaccessDatabaseMetadata
implements DatabaseMetaData {
    private static final String SELECT_BASE = "SELECT * FROM INFORMATION_SCHEMA.";
    private static final String NATIVE_ALIAS = " l.";
    private static final String CUSTOM_ALIAS = " r.";
    private static final String CAST_EXPR = "CAST(null AS VARCHAR(50)) AS ";
    private UcanaccessConnection connection;
    private DatabaseMetaData wrapped;

    public UcanaccessDatabaseMetadata(DatabaseMetaData _wrapped, UcanaccessConnection _connection) {
        this.wrapped = _wrapped;
        this.connection = _connection;
    }

    private String from(String left, String right) {
        return " FROM INFORMATION_SCHEMA." + left + " l INNER JOIN UCA_METADATA." + right + " r ";
    }

    private String in(String prefix, String field, Object[] options) {
        if (options == null || options.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(" AND ").append(prefix).append(field).append(" IN ").append("(");
        String comma = "";
        Object[] objectArray = options;
        int n = options.length;
        int n2 = 0;
        while (n2 < n) {
            Object norm = objectArray[n2];
            String val = norm instanceof String ? "'" + norm.toString().toUpperCase() + "'" : norm.toString();
            sb.append(comma).append(val);
            comma = ",";
            ++n2;
        }
        sb.append(")");
        return sb.toString();
    }

    private String nAlias(String s) {
        return NATIVE_ALIAS + s;
    }

    private String cAlias(String s) {
        return CUSTOM_ALIAS + s;
    }

    private String on(List<String> left, List<String> right) {
        StringBuilder sb = new StringBuilder(" ON(");
        Iterator<String> il = left.iterator();
        Iterator<String> ir = right.iterator();
        String and = "";
        while (il.hasNext() && ir.hasNext()) {
            sb.append(and).append(NATIVE_ALIAS).append(il.next()).append("=").append(CUSTOM_ALIAS).append(ir.next());
            and = " AND ";
        }
        sb.append(") ");
        return sb.toString();
    }

    private static String and(String left, String op, String right) {
        return UcanaccessDatabaseMetadata.and(left, op, right, " AND ");
    }

    private static String and(String left, String op, String right, String and) {
        return UcanaccessDatabaseMetadata.and(left, op, right, and, true);
    }

    private static String and(String left, String op, String right, boolean apos) {
        return UcanaccessDatabaseMetadata.and(left, op, right, " AND ", apos);
    }

    private static String and(String left, String op, String right, String and, boolean apos) {
        if (right == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(and);
        if (right.length() == 0) {
            return sb.append(left).append(" IS NULL ").toString();
        }
        Object exp = apos ? "'" + right + "'" : right;
        sb.append(left).append(" ");
        if ("LIKE".equals(op)) {
            if (((String)exp).indexOf(95) < 0 && ((String)exp).indexOf(37) < 0) {
                sb.append(" = ").append((String)exp);
            } else {
                sb.append(" LIKE ").append((String)exp).append(" ESCAPE '\\'");
            }
        } else {
            sb.append(op).append(' ').append((String)exp);
        }
        return sb.toString();
    }

    private String select(String htableName, List<String> exclude, List<String> replace) throws SQLException {
        ResultSetMetaData rsmd = this.executeQuery(SELECT_BASE + htableName + " WHERE 1=0").getMetaData();
        String comma = "";
        StringBuilder sb = new StringBuilder("SELECT ");
        int i = 1;
        while (i <= rsmd.getColumnCount()) {
            String cn = rsmd.getColumnName(i);
            if (exclude.contains(cn)) {
                String es = replace.get(exclude.indexOf(cn));
                sb.append(comma);
                if (es == null) {
                    sb.append(CAST_EXPR).append(cn);
                } else if ("PUBLIC".equals(es)) {
                    sb.append("'PUBLIC' AS ").append(cn);
                } else if (es.startsWith(CAST_EXPR)) {
                    sb.append(es);
                } else {
                    String suffix = es.indexOf(46) > 0 ? "" : "r.";
                    sb.append(suffix).append(es).append(" AS ").append(cn);
                }
            } else {
                sb.append(comma).append("l.").append(cn);
            }
            comma = ",";
            ++i;
        }
        return sb.toString();
    }

    private ResultSet executeQuery(String _sql) throws SQLException {
        this.connection.checkLastModified();
        return Try.withResources(() -> this.connection.getHSQLDBConnection().createStatement(), st -> st.executeQuery(_sql)).orThrow();
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        try {
            return this.wrapped.allProceduresAreCallable();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        try {
            return this.wrapped.allTablesAreSelectable();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        try {
            return this.wrapped.autoCommitFailureClosesAllResultSets();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        try {
            return this.wrapped.dataDefinitionCausesTransactionCommit();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        try {
            return this.wrapped.dataDefinitionIgnoredInTransactions();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean deletesAreDetected(int type) throws SQLException {
        try {
            return this.wrapped.deletesAreDetected(type);
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        try {
            return this.wrapped.doesMaxRowSizeIncludeBlobs();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean generatedKeyAlwaysReturned() {
        return true;
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        try {
            return this.wrapped.getAttributes(catalog, schemaPattern, typeNamePattern, attributeNamePattern);
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        table = SQLConverter.escapeIdentifier(table).toUpperCase();
        try {
            Object[] scopeArr = new Integer[]{0, 1, 2};
            String nullableS = nullable ? null : String.valueOf(0);
            StringBuilder sql = new StringBuilder(this.select("SYSTEM_BESTROWIDENTIFIER", List.of("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME"), Arrays.asList(null, null, "TABLE_NAME", "COLUMN_NAME"))).append(this.from("SYSTEM_BESTROWIDENTIFIER", "COLUMNS_VIEW")).append(this.on(List.of("TABLE_NAME", "COLUMN_NAME"), List.of("ESCAPED_TABLE_NAME", "ESCAPED_COLUMN_NAME"))).append(UcanaccessDatabaseMetadata.and("TABLE_CAT", "=", "PUBLIC", " WHERE ")).append(UcanaccessDatabaseMetadata.and("TABLE_SCHEM", "=", schema)).append(UcanaccessDatabaseMetadata.and("TABLE_NAME", "=", table)).append(UcanaccessDatabaseMetadata.and("NULLABLE", "=", nullableS, false)).append(this.in(NATIVE_ALIAS, "SCOPE", scopeArr));
            return this.executeQuery(sql.toString());
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        if (this.connection.isShowSchema()) {
            try {
                return this.wrapped.getCatalogs();
            }
            catch (SQLException _ex) {
                throw new UcanaccessSQLException(_ex);
            }
        }
        throw UcanaccessRuntimeException.featureNotSupported();
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        try {
            return this.wrapped.getCatalogSeparator();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        try {
            return this.wrapped.getCatalogTerm();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        try {
            return this.executeQuery("SELECT * FROM UCA_METADATA.PROP");
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        try {
            if (table == null) {
                throw new UcanaccessSQLException(UcanaccessSQLException.ExceptionMessages.PARAMETER_NULL, "table");
            }
            columnNamePattern = UcanaccessDatabaseMetadata.normalizeName(columnNamePattern);
            table = UcanaccessDatabaseMetadata.normalizeName(table);
            if (this.invokeWrapper(catalog, schema)) {
                return this.wrapped.getColumnPrivileges(catalog, schema, table, columnNamePattern);
            }
            String cat = this.connection.isShowSchema() ? "PUBLIC" : null;
            String schem = this.connection.isShowSchema() ? "PUBLIC" : null;
            String s = "SELECT " + cat + " TABLE_CAT, " + schem + " TABLE_SCHEM,";
            StringBuilder select = new StringBuilder(s).append(this.cAlias("TABLE_NAME")).append(",").append(this.cAlias("COLUMN_NAME")).append(",").append(this.nAlias("GRANTOR")).append(",").append(this.nAlias("GRANTEE")).append(",").append(this.nAlias("PRIVILEGE_TYPE PRIVILEGE")).append(",").append(this.nAlias("IS_GRANTABLE")).append(this.from("COLUMN_PRIVILEGES", "COLUMNS_VIEW")).append(this.on(List.of("TABLE_NAME", "COLUMN_NAME"), List.of("ESCAPED_TABLE_NAME", "ESCAPED_COLUMN_NAME"))).append(UcanaccessDatabaseMetadata.and("TABLE_CATALOG", "=", "PUBLIC", " WHERE ")).append(UcanaccessDatabaseMetadata.and("TABLE_SCHEMA", "=", "PUBLIC")).append(UcanaccessDatabaseMetadata.and("TABLE_NAME", "=", table)).append(UcanaccessDatabaseMetadata.and("COLUMN_NAME", "LIKE", columnNamePattern));
            return this.executeQuery(select.toString());
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        try {
            columnNamePattern = UcanaccessDatabaseMetadata.normalizeName(columnNamePattern);
            tableNamePattern = UcanaccessDatabaseMetadata.normalizeName(tableNamePattern);
            if (this.invokeWrapper(catalog, schemaPattern)) {
                return this.wrapped.getColumns(catalog, schemaPattern, tableNamePattern, columnNamePattern);
            }
            String cat = this.connection.isShowSchema() ? "PUBLIC" : null;
            String schem = this.connection.isShowSchema() ? "PUBLIC" : null;
            StringBuilder select = new StringBuilder(this.select("SYSTEM_COLUMNS", List.of("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "COLUMN_DEF", "IS_AUTOINCREMENT", "IS_GENERATEDCOLUMN"), Arrays.asList(cat, schem, "TABLE_NAME", "COLUMN_NAME", "COLUMN_DEF", "IS_AUTOINCREMENT", "IS_GENERATEDCOLUMN"))).append(",").append(this.cAlias("ORIGINAL_TYPE")).append(this.from("SYSTEM_COLUMNS", "COLUMNS_VIEW")).append(this.on(List.of("TABLE_NAME", "COLUMN_NAME"), List.of("ESCAPED_TABLE_NAME", "ESCAPED_COLUMN_NAME"))).append(UcanaccessDatabaseMetadata.and("TABLE_CAT", "=", "PUBLIC", " WHERE ")).append(UcanaccessDatabaseMetadata.and("TABLE_SCHEM", "=", "PUBLIC")).append(UcanaccessDatabaseMetadata.and("TABLE_NAME", "LIKE", tableNamePattern)).append(UcanaccessDatabaseMetadata.and("COLUMN_NAME", "LIKE", columnNamePattern));
            return this.executeQuery(select.toString());
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        try {
            if (parentTable == null) {
                throw new UcanaccessSQLException(UcanaccessSQLException.ExceptionMessages.PARAMETER_NULL, "parentTable");
            }
            if (foreignTable == null) {
                throw new UcanaccessSQLException(UcanaccessSQLException.ExceptionMessages.PARAMETER_NULL, "foreignTable");
            }
            parentTable = UcanaccessDatabaseMetadata.normalizeName(parentTable);
            foreignTable = UcanaccessDatabaseMetadata.normalizeName(foreignTable);
            if (this.invokeWrapper(parentCatalog, parentSchema)) {
                return this.wrapped.getCrossReference(parentCatalog, parentSchema, parentTable, foreignCatalog, foreignSchema, foreignTable);
            }
            String cat = this.connection.isShowSchema() ? "PUBLIC" : null;
            String schem = this.connection.isShowSchema() ? "PUBLIC" : null;
            StringBuilder select = new StringBuilder(this.select("SYSTEM_CROSSREFERENCE", List.of("PKTABLE_CAT", "PKTABLE_SCHEM", "PKTABLE_NAME", "PKCOLUMN_NAME", "FKTABLE_CAT", "FKTABLE_SCHEM", "FKTABLE_NAME", "FKCOLUMN_NAME"), Arrays.asList(cat, schem, "TABLE_NAME", "COLUMN_NAME", cat, schem, "v.TABLE_NAME", "v.COLUMN_NAME"))).append(this.from("SYSTEM_CROSSREFERENCE", "COLUMNS_VIEW")).append(this.on(List.of("PKTABLE_NAME", "PKCOLUMN_NAME"), List.of("ESCAPED_TABLE_NAME", "ESCAPED_COLUMN_NAME"))).append(" INNER JOIN UCA_METADATA.COLUMNS_VIEW v ON( l.FKTABLE_NAME= v.ESCAPED_TABLE_NAME AND l.FKCOLUMN_NAME= v.ESCAPED_COLUMN_NAME)").append(UcanaccessDatabaseMetadata.and("PKTABLE_CAT", "=", "PUBLIC", " WHERE ")).append(UcanaccessDatabaseMetadata.and("PKTABLE_SCHEM", "=", "PUBLIC")).append(UcanaccessDatabaseMetadata.and("PKTABLE_NAME", "=", parentTable)).append(UcanaccessDatabaseMetadata.and("FKTABLE_CAT", "=", "PUBLIC")).append(UcanaccessDatabaseMetadata.and("FKTABLE_SCHEM", "=", "PUBLIC")).append(UcanaccessDatabaseMetadata.and("FKTABLE_NAME", "=", foreignTable)).append(" ORDER BY FKTABLE_CAT, FKTABLE_SCHEM, FKTABLE_NAME, KEY_SEQ");
            return this.executeQuery(select.toString());
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        try {
            return this.wrapped.getDatabaseMajorVersion();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        try {
            return this.wrapped.getDatabaseMinorVersion();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public String getDatabaseProductName() {
        return "UCanAccess driver for Microsoft Access databases using HSQLDB";
    }

    @Override
    public String getDatabaseProductVersion() {
        try {
            return this.connection.getDbIO().getFileFormat().toString();
        }
        catch (IOException _ex) {
            return "";
        }
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        try {
            return this.wrapped.getDefaultTransactionIsolation();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public int getDriverMajorVersion() {
        return 0;
    }

    @Override
    public int getDriverMinorVersion() {
        return 0;
    }

    @Override
    public String getDriverName() {
        return "Ucanaccess";
    }

    @Override
    public String getDriverVersion() {
        try {
            String version = this.getClass().getPackage().getImplementationVersion();
            return version == null ? "3.x.x" : version;
        }
        catch (Exception _ex) {
            return "2.x.x";
        }
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        try {
            if (table == null) {
                throw new UcanaccessSQLException(UcanaccessSQLException.ExceptionMessages.PARAMETER_NULL, "table");
            }
            table = UcanaccessDatabaseMetadata.normalizeName(table);
            if (this.invokeWrapper(catalog, schema)) {
                return this.wrapped.getExportedKeys(catalog, schema, table);
            }
            String cat = this.connection.isShowSchema() ? "PUBLIC" : null;
            String schem = this.connection.isShowSchema() ? "PUBLIC" : null;
            StringBuilder select = new StringBuilder(this.select("SYSTEM_CROSSREFERENCE", List.of("PKTABLE_CAT", "PKTABLE_SCHEM", "PKTABLE_NAME", "PKCOLUMN_NAME", "FKTABLE_CAT", "FKTABLE_SCHEM", "FKTABLE_NAME", "FKCOLUMN_NAME"), Arrays.asList(cat, schem, "TABLE_NAME", "COLUMN_NAME", cat, schem, "v.TABLE_NAME", "v.COLUMN_NAME"))).append(this.from("SYSTEM_CROSSREFERENCE", "COLUMNS_VIEW")).append(this.on(List.of("PKTABLE_NAME", "PKCOLUMN_NAME"), List.of("ESCAPED_TABLE_NAME", "ESCAPED_COLUMN_NAME"))).append(" INNER JOIN UCA_METADATA.COLUMNS_VIEW v ON( l.FKTABLE_NAME= v.ESCAPED_TABLE_NAME AND l.FKCOLUMN_NAME= v.ESCAPED_COLUMN_NAME)").append(UcanaccessDatabaseMetadata.and("PKTABLE_CAT", "=", "PUBLIC", " WHERE ")).append(UcanaccessDatabaseMetadata.and("PKTABLE_SCHEM", "=", "PUBLIC")).append(UcanaccessDatabaseMetadata.and("PKTABLE_NAME", "=", table)).append(" ORDER BY FKTABLE_CAT, FKTABLE_SCHEM, FKTABLE_NAME, KEY_SEQ");
            return this.executeQuery(select.toString());
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        try {
            return this.wrapped.getExtraNameCharacters();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public ResultSet getFunctionColumns(String _catalog, String _schemaPattern, String _functionNamePattern, String _columnNamePattern) throws SQLException {
        try {
            _columnNamePattern = UcanaccessDatabaseMetadata.normalizeName(_columnNamePattern);
            return this.wrapped.getFunctionColumns(_catalog, _schemaPattern, _functionNamePattern, _columnNamePattern);
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        try {
            return this.wrapped.getFunctions(catalog, schemaPattern, functionNamePattern);
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public String getIdentifierQuoteString() {
        return "`";
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        try {
            if (table == null) {
                throw new UcanaccessSQLException(UcanaccessSQLException.ExceptionMessages.PARAMETER_NULL, "table");
            }
            table = UcanaccessDatabaseMetadata.normalizeName(table);
            if (this.invokeWrapper(catalog, schema)) {
                return this.wrapped.getImportedKeys(catalog, schema, table);
            }
            String cat = this.connection.isShowSchema() ? "PUBLIC" : null;
            String schem = this.connection.isShowSchema() ? "PUBLIC" : null;
            StringBuilder select = new StringBuilder(this.select("SYSTEM_CROSSREFERENCE", List.of("FKTABLE_CAT", "FKTABLE_SCHEM", "FKTABLE_NAME", "FKCOLUMN_NAME", "PKTABLE_CAT", "PKTABLE_SCHEM", "PKTABLE_NAME", "PKCOLUMN_NAME"), Arrays.asList(cat, schem, "TABLE_NAME", "COLUMN_NAME", cat, schem, "v.TABLE_NAME", "v.COLUMN_NAME"))).append(this.from("SYSTEM_CROSSREFERENCE", "COLUMNS_VIEW")).append(this.on(List.of("FKTABLE_NAME", "FKCOLUMN_NAME"), List.of("ESCAPED_TABLE_NAME", "ESCAPED_COLUMN_NAME"))).append(" INNER JOIN UCA_METADATA.COLUMNS_VIEW v ON( l.PKTABLE_NAME= v.ESCAPED_TABLE_NAME AND l.PKCOLUMN_NAME= v.ESCAPED_COLUMN_NAME)").append(UcanaccessDatabaseMetadata.and("FKTABLE_CAT", "=", "PUBLIC", " WHERE ")).append(UcanaccessDatabaseMetadata.and("FKTABLE_SCHEM", "=", "PUBLIC")).append(UcanaccessDatabaseMetadata.and("FKTABLE_NAME", "=", table)).append(" ORDER BY PKTABLE_CAT, PKTABLE_SCHEM, PKTABLE_NAME, KEY_SEQ");
            return this.executeQuery(select.toString());
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        try {
            if (table == null) {
                throw new UcanaccessSQLException(UcanaccessSQLException.ExceptionMessages.PARAMETER_NULL, "table");
            }
            table = UcanaccessDatabaseMetadata.normalizeName(table);
            String cat = this.connection.isShowSchema() ? "PUBLIC" : null;
            String schem = this.connection.isShowSchema() ? "PUBLIC" : null;
            String nuS = unique ? "AND NON_UNIQUE IS FALSE" : "";
            StringBuilder select = new StringBuilder(this.select("SYSTEM_INDEXINFO", List.of("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME"), Arrays.asList(cat, schem, "TABLE_NAME", "COLUMN_NAME"))).append(this.from("SYSTEM_INDEXINFO", "COLUMNS_VIEW")).append(this.on(List.of("TABLE_NAME", "COLUMN_NAME"), List.of("ESCAPED_TABLE_NAME", "ESCAPED_COLUMN_NAME"))).append(UcanaccessDatabaseMetadata.and("TABLE_CAT", "=", "PUBLIC")).append(UcanaccessDatabaseMetadata.and("TABLE_SCHEM", "=", "PUBLIC", " WHERE ")).append(UcanaccessDatabaseMetadata.and("TABLE_NAME", "=", table)).append(nuS);
            return this.executeQuery(select.toString());
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        try {
            return this.wrapped.getJDBCMajorVersion();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        try {
            return this.wrapped.getJDBCMinorVersion();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        try {
            return this.wrapped.getMaxBinaryLiteralLength();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        try {
            return this.wrapped.getMaxCatalogNameLength();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        try {
            return this.wrapped.getMaxCharLiteralLength();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        try {
            return this.wrapped.getMaxColumnNameLength();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        try {
            return this.wrapped.getMaxColumnsInGroupBy();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        try {
            return this.wrapped.getMaxColumnsInIndex();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        try {
            return this.wrapped.getMaxColumnsInOrderBy();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        try {
            return this.wrapped.getMaxColumnsInSelect();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        try {
            return this.wrapped.getMaxColumnsInTable();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public int getMaxConnections() throws SQLException {
        try {
            return this.wrapped.getMaxConnections();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        try {
            return this.wrapped.getMaxCursorNameLength();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        try {
            return this.wrapped.getMaxIndexLength();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        try {
            return this.wrapped.getMaxProcedureNameLength();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        try {
            return this.wrapped.getMaxRowSize();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        try {
            return this.wrapped.getMaxSchemaNameLength();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        try {
            return this.wrapped.getMaxStatementLength();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public int getMaxStatements() throws SQLException {
        try {
            return this.wrapped.getMaxStatements();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        try {
            return this.wrapped.getMaxTableNameLength();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        try {
            return this.wrapped.getMaxTablesInSelect();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        try {
            return this.wrapped.getMaxUserNameLength();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        try {
            return this.wrapped.getNumericFunctions();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    private boolean invokeWrapper(String catalog, String schema) {
        return !(!this.connection.isShowSchema() || catalog == null && schema == null || "PUBLIC".equals(catalog) && "PUBLIC".equals(schema));
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        try {
            if (table == null) {
                throw new UcanaccessSQLException(UcanaccessSQLException.ExceptionMessages.PARAMETER_NULL, "table");
            }
            table = UcanaccessDatabaseMetadata.normalizeName(table);
            if (this.invokeWrapper(catalog, schema)) {
                return this.wrapped.getPrimaryKeys(catalog, schema, table);
            }
            String cat = this.connection.isShowSchema() ? "PUBLIC" : null;
            String schem = this.connection.isShowSchema() ? "PUBLIC" : null;
            StringBuilder select = new StringBuilder(this.select("SYSTEM_PRIMARYKEYS", List.of("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME"), Arrays.asList(cat, schem, "TABLE_NAME", "COLUMN_NAME"))).append(this.from("SYSTEM_PRIMARYKEYS", "COLUMNS_VIEW")).append(this.on(List.of("TABLE_NAME", "COLUMN_NAME"), List.of("ESCAPED_TABLE_NAME", "ESCAPED_COLUMN_NAME"))).append(UcanaccessDatabaseMetadata.and("TABLE_CAT", "=", "PUBLIC", " WHERE ")).append(UcanaccessDatabaseMetadata.and("TABLE_SCHEM", "=", "PUBLIC")).append(UcanaccessDatabaseMetadata.and("TABLE_NAME", "=", table));
            return this.executeQuery(select.toString());
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        try {
            columnNamePattern = UcanaccessDatabaseMetadata.normalizeName(columnNamePattern);
            return this.wrapped.getProcedureColumns(catalog, schemaPattern, procedureNamePattern, columnNamePattern);
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        try {
            return this.wrapped.getProcedures(catalog, schemaPattern, procedureNamePattern);
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        try {
            return this.wrapped.getProcedureTerm();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        try {
            return this.wrapped.getPseudoColumns(catalog, schemaPattern, tableNamePattern, columnNamePattern);
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        try {
            return this.wrapped.getResultSetHoldability();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        throw UcanaccessRuntimeException.featureNotSupported();
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        if (this.connection.isShowSchema()) {
            try {
                return this.wrapped.getSchemas();
            }
            catch (SQLException _ex) {
                throw new UcanaccessSQLException(_ex);
            }
        }
        throw UcanaccessRuntimeException.featureNotSupported();
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        if (this.connection.isShowSchema()) {
            try {
                return this.wrapped.getSchemas(catalog, schemaPattern);
            }
            catch (SQLException _ex) {
                throw new UcanaccessSQLException(_ex);
            }
        }
        throw UcanaccessRuntimeException.featureNotSupported();
    }

    @Override
    public String getSchemaTerm() {
        return null;
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        try {
            return this.wrapped.getSearchStringEscape();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        try {
            return this.wrapped.getSQLKeywords();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public int getSQLStateType() throws SQLException {
        try {
            return this.wrapped.getSQLStateType();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public String getStringFunctions() throws SQLException {
        try {
            return this.wrapped.getStringFunctions();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        try {
            tableNamePattern = UcanaccessDatabaseMetadata.normalizeName(tableNamePattern);
            return this.wrapped.getSuperTables(catalog, schemaPattern, tableNamePattern);
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        try {
            return this.wrapped.getSuperTypes(catalog, schemaPattern, typeNamePattern);
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        try {
            return this.wrapped.getSystemFunctions();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        try {
            tableNamePattern = UcanaccessDatabaseMetadata.normalizeName(tableNamePattern);
            StringBuilder select = new StringBuilder(this.select("TABLE_PRIVILEGES", List.of("TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME"), List.of("CAST(null AS VARCHAR(50)) AS  TABLE_CAT ", "CAST(null AS VARCHAR(50)) AS  TABLE_SCHEM", "TABLE_NAME"))).append(this.from("TABLE_PRIVILEGES", "TABLES")).append(this.on(List.of("TABLE_NAME"), List.of("ESCAPED_TABLE_NAME"))).append(UcanaccessDatabaseMetadata.and("TABLE_CATALOG", "=", "PUBLIC", " WHERE ")).append(UcanaccessDatabaseMetadata.and("TABLE_SCHEMA", "=", "PUBLIC")).append(UcanaccessDatabaseMetadata.and("TABLE_NAME", "LIKE", tableNamePattern));
            return this.executeQuery(select.toString());
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        try {
            tableNamePattern = UcanaccessDatabaseMetadata.normalizeName(tableNamePattern);
            if (this.invokeWrapper(catalog, schemaPattern)) {
                return this.wrapped.getTables(catalog, schemaPattern, tableNamePattern, types);
            }
            String cat = this.connection.isShowSchema() ? "PUBLIC" : null;
            String schem = this.connection.isShowSchema() ? "PUBLIC" : null;
            StringBuilder select = new StringBuilder(this.select("SYSTEM_TABLES", List.of("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME"), Arrays.asList(cat, schem, "TABLE_NAME"))).append(this.from("SYSTEM_TABLES", "TABLES")).append(this.on(List.of("TABLE_NAME"), List.of("ESCAPED_TABLE_NAME"))).append(UcanaccessDatabaseMetadata.and("TABLE_CAT", "=", "PUBLIC", " WHERE ")).append(UcanaccessDatabaseMetadata.and("TABLE_SCHEM", "=", "PUBLIC")).append(UcanaccessDatabaseMetadata.and("TABLE_NAME", "LIKE", tableNamePattern)).append(this.in(CUSTOM_ALIAS, "TYPE", types));
            return this.executeQuery(select.toString());
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        try {
            return this.wrapped.getTableTypes();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        try {
            return this.wrapped.getTimeDateFunctions();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        try {
            return this.wrapped.getTypeInfo();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        try {
            return this.wrapped.getUDTs(catalog, schemaPattern, typeNamePattern, types);
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public String getURL() {
        return this.connection.getUrl();
    }

    @Override
    public String getUserName() throws SQLException {
        try {
            return this.wrapped.getUserName();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        try {
            return this.wrapped.getVersionColumns(catalog, schema, table);
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        try {
            return this.wrapped.insertsAreDetected(type);
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        try {
            return this.wrapped.isCatalogAtStart();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        try {
            return this.wrapped.isReadOnly();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        try {
            return this.wrapped.isWrapperFor(iface);
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        try {
            return this.wrapped.locatorsUpdateCopy();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    public static String normalizeName(String name) {
        String stb;
        if (name == null || name.isBlank()) {
            return name;
        }
        if (name.contains("%")) {
            return name.toUpperCase();
        }
        if (name.startsWith("\"") && name.endsWith("\"") && SQLConverter.isListedAsKeyword(stb = name.substring(1, name.length() - 1).toUpperCase())) {
            return stb;
        }
        if (SQLConverter.isListedAsKeyword(name)) {
            return name;
        }
        return SQLConverter.preEscapingIdentifier(name);
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        try {
            return this.wrapped.nullPlusNonNullIsNull();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        try {
            return this.wrapped.nullsAreSortedAtEnd();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        try {
            return this.wrapped.nullsAreSortedAtStart();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        try {
            return this.wrapped.nullsAreSortedHigh();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        try {
            return this.wrapped.nullsAreSortedLow();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        try {
            return this.wrapped.othersDeletesAreVisible(type);
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        try {
            return this.wrapped.othersInsertsAreVisible(type);
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        try {
            return this.wrapped.othersUpdatesAreVisible(type);
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        try {
            return this.wrapped.ownDeletesAreVisible(type);
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        try {
            return this.wrapped.ownInsertsAreVisible(type);
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        try {
            return this.wrapped.ownUpdatesAreVisible(type);
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        try {
            return this.wrapped.storesLowerCaseIdentifiers();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        try {
            return this.wrapped.storesLowerCaseQuotedIdentifiers();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        try {
            return this.wrapped.storesMixedCaseIdentifiers();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        try {
            return this.wrapped.storesMixedCaseQuotedIdentifiers();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        try {
            return this.wrapped.storesUpperCaseIdentifiers();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        try {
            return this.wrapped.storesUpperCaseQuotedIdentifiers();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        try {
            return this.wrapped.supportsAlterTableWithAddColumn();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        try {
            return this.wrapped.supportsAlterTableWithDropColumn();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        try {
            return this.wrapped.supportsANSI92EntryLevelSQL();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        try {
            return this.wrapped.supportsANSI92FullSQL();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        try {
            return this.wrapped.supportsANSI92IntermediateSQL();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        try {
            return this.wrapped.supportsBatchUpdates();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        try {
            return this.wrapped.supportsCatalogsInDataManipulation();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        try {
            return this.wrapped.supportsCatalogsInIndexDefinitions();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        try {
            return this.wrapped.supportsCatalogsInPrivilegeDefinitions();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        try {
            return this.wrapped.supportsCatalogsInProcedureCalls();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        try {
            return this.wrapped.supportsCatalogsInTableDefinitions();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        try {
            return this.wrapped.supportsColumnAliasing();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        try {
            return this.wrapped.supportsConvert();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        try {
            return this.wrapped.supportsConvert(fromType, toType);
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        try {
            return this.wrapped.supportsCoreSQLGrammar();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        try {
            return this.wrapped.supportsCorrelatedSubqueries();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        try {
            return this.wrapped.supportsDataDefinitionAndDataManipulationTransactions();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        try {
            return this.wrapped.supportsDataManipulationTransactionsOnly();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        try {
            return this.wrapped.supportsDifferentTableCorrelationNames();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        try {
            return this.wrapped.supportsExpressionsInOrderBy();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        try {
            return this.wrapped.supportsExtendedSQLGrammar();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        try {
            return this.wrapped.supportsFullOuterJoins();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        try {
            return this.wrapped.supportsGetGeneratedKeys();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        try {
            return this.wrapped.supportsGroupBy();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        try {
            return this.wrapped.supportsGroupByBeyondSelect();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        try {
            return this.wrapped.supportsGroupByUnrelated();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        try {
            return this.wrapped.supportsIntegrityEnhancementFacility();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        try {
            return this.wrapped.supportsLikeEscapeClause();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        try {
            return this.wrapped.supportsLimitedOuterJoins();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        try {
            return this.wrapped.supportsMinimumSQLGrammar();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        try {
            return this.wrapped.supportsMixedCaseIdentifiers();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        try {
            return this.wrapped.supportsMixedCaseQuotedIdentifiers();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        try {
            return this.wrapped.supportsMultipleOpenResults();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        try {
            return this.wrapped.supportsMultipleResultSets();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        try {
            return this.wrapped.supportsMultipleTransactions();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        try {
            return this.wrapped.supportsNamedParameters();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        try {
            return this.wrapped.supportsNonNullableColumns();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        try {
            return this.wrapped.supportsOpenCursorsAcrossCommit();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        try {
            return this.wrapped.supportsOpenCursorsAcrossRollback();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        try {
            return this.wrapped.supportsOpenStatementsAcrossCommit();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        try {
            return this.wrapped.supportsOpenStatementsAcrossRollback();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        try {
            return this.wrapped.supportsOrderByUnrelated();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        try {
            return this.wrapped.supportsOuterJoins();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        try {
            return this.wrapped.supportsPositionedDelete();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        try {
            return this.wrapped.supportsPositionedUpdate();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        try {
            return this.wrapped.supportsResultSetConcurrency(type, concurrency);
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        try {
            return this.wrapped.supportsResultSetHoldability(holdability);
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        try {
            return this.wrapped.supportsResultSetType(type);
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        try {
            return this.wrapped.supportsSavepoints();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        try {
            return this.wrapped.supportsSchemasInDataManipulation();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        try {
            return this.wrapped.supportsSchemasInIndexDefinitions();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        try {
            return this.wrapped.supportsSchemasInPrivilegeDefinitions();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        try {
            return this.wrapped.supportsSchemasInProcedureCalls();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        try {
            return this.wrapped.supportsSchemasInTableDefinitions();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        try {
            return this.wrapped.supportsSelectForUpdate();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        try {
            return this.wrapped.supportsStatementPooling();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        try {
            return this.wrapped.supportsStoredFunctionsUsingCallSyntax();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        try {
            return this.wrapped.supportsStoredProcedures();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        try {
            return this.wrapped.supportsSubqueriesInComparisons();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        try {
            return this.wrapped.supportsSubqueriesInExists();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        try {
            return this.wrapped.supportsSubqueriesInIns();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        try {
            return this.wrapped.supportsSubqueriesInQuantifieds();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        try {
            return this.wrapped.supportsTableCorrelationNames();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        try {
            return this.wrapped.supportsTransactionIsolationLevel(level);
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        try {
            return this.wrapped.supportsTransactions();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        try {
            return this.wrapped.supportsUnion();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        try {
            return this.wrapped.supportsUnionAll();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            return this.wrapped.unwrap(iface);
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        try {
            return this.wrapped.updatesAreDetected(type);
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        try {
            return this.wrapped.usesLocalFilePerTable();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        try {
            return this.wrapped.usesLocalFiles();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }
}

