/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.converters;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.ucanaccess.converters.Metadata;
import net.ucanaccess.converters.SQLConverter;
import net.ucanaccess.jdbc.NormalizedSQL;
import net.ucanaccess.jdbc.UcanaccessConnection;
import net.ucanaccess.log.Logger;
import net.ucanaccess.util.Try;

public class Pivot {
    private static final Pattern PIVOT_PATT = Pattern.compile("(?i)TRANSFORM(.*\\W)(?i)SELECT(.*\\W)(?i)FROM(.*\\W)(?i)PIVOT(.*)");
    private static final Pattern PIVOT_EXPR_PATT = Pattern.compile("(.*)(?i)IN\\s*\\((.*)\\)");
    private static final Pattern PIVOT_AGGR_PATT = Pattern.compile("((?i)SUM|MAX|MIN|FIRST|LAST|AVG|COUNT|STDEV|VAR)\\s*\\((.*)\\)");
    private static final Pattern PIVOT_CN_PATT = Pattern.compile("[\"'#](.*)[\"'#]");
    private static final String PIVOT_GROUP_BY = "(?i)GROUP\\s*(?i)BY";
    private static final Map<String, String> PIVOT_MAP = new HashMap<String, String>();
    private static final Map<String, List<String>> PREPARE_MAP = new HashMap<String, List<String>>();
    private String transform;
    private String select;
    private String from;
    private String expression;
    private String pivot;
    private List<String> pivotIn;
    private String aggregateFun;
    private Connection conn;
    private boolean pivotInCondition = true;
    private String originalQuery;

    public Pivot(Connection _conn) {
        this.conn = _conn;
    }

    private void cachePrepare(String _name) {
        Optional.ofNullable(this.pivotIn).ifPresent(p -> {
            List<String> list = PREPARE_MAP.put(_name, (List<String>)p);
        });
    }

    public static void clearPrepared() {
        PREPARE_MAP.clear();
    }

    private void prepareGetFromCache(String _name) {
        this.pivotIn = PREPARE_MAP.getOrDefault(_name, this.pivotIn);
    }

    public void registerPivot(String _name) {
        if (!this.pivotInCondition) {
            PIVOT_MAP.put(_name, this.originalQuery);
        }
    }

    public static void checkAndRefreshPivot(String _currSql, UcanaccessConnection _conn) {
        for (String name : PIVOT_MAP.keySet()) {
            Pattern ptrn = Pattern.compile("(\\W)(?i)" + name + "(\\W)");
            Matcher mtc = ptrn.matcher(_currSql);
            if (!mtc.find()) continue;
            try {
                if (_conn == null && UcanaccessConnection.hasContext()) {
                    _conn = UcanaccessConnection.getCtxConnection();
                }
                if (_conn == null) {
                    return;
                }
                Connection connHsql = _conn.getHSQLDBConnection();
                Pivot pivot = new Pivot(connHsql);
                if (!pivot.parsePivot(PIVOT_MAP.get(name))) {
                    return;
                }
                String sqlh = pivot.toSQL(null);
                if (sqlh == null) {
                    return;
                }
                Throwable throwable = null;
                Object var10_12 = null;
                try (Statement st = connHsql.createStatement();){
                    String escqn = SQLConverter.completeEscaping(name, false);
                    st.executeUpdate(SQLConverter.convertSQL("DROP VIEW " + escqn, true).getSql());
                    NormalizedSQL nsql = SQLConverter.convertSQL("CREATE VIEW " + escqn + " AS " + sqlh, true);
                    Metadata mt = new Metadata(connHsql);
                    String eqn = SQLConverter.preEscapingIdentifier(name);
                    Integer idTable = mt.getTableId(eqn);
                    if (idTable != null) {
                        for (Map.Entry<String, String> entry : nsql.getAliases().entrySet()) {
                            if (mt.getColumnName(eqn, entry.getKey()) != null) continue;
                            mt.newColumn(entry.getValue(), entry.getKey(), null, idTable);
                        }
                    }
                    String v = nsql.getSql();
                    st.executeUpdate(v);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception _ex) {
                Logger.logWarning(_ex.getMessage());
            }
        }
    }

    public boolean parsePivot(String _originalQuery) {
        Matcher mtc;
        this.originalQuery = _originalQuery;
        if ((_originalQuery = _originalQuery.replace('\n', ' ').replace('\r', ' ').replaceAll("(?i)(\\[PIVOT\\])", "XPIVOT").trim()).endsWith(";")) {
            _originalQuery = _originalQuery.substring(0, _originalQuery.length() - 1);
        }
        if ((mtc = PIVOT_PATT.matcher(_originalQuery)).groupCount() < 4) {
            return false;
        }
        if (mtc.matches()) {
            this.transform = mtc.group(1);
            Matcher aggr = PIVOT_AGGR_PATT.matcher(this.transform);
            if (aggr.find()) {
                if (aggr.groupCount() < 2) {
                    return false;
                }
            } else {
                return false;
            }
            this.aggregateFun = aggr.group(1);
            this.expression = aggr.group(2);
            this.select = mtc.group(2);
            this.from = mtc.group(3);
            String pe = mtc.group(4);
            Matcher mtcExpr = PIVOT_EXPR_PATT.matcher(pe);
            if (mtcExpr.find()) {
                if (mtcExpr.groupCount() < 2) {
                    return false;
                }
                this.pivot = mtcExpr.group(1);
                this.pivotIn = Arrays.asList(mtcExpr.group(2).split(","));
            } else {
                this.pivot = pe;
            }
            return true;
        }
        return false;
    }

    private void appendCaseWhen(StringBuilder _sb, String _condition, String _cn) {
        _sb.append(this.aggregateFun).append("(CASE WHEN ").append(_condition).append(" THEN ").append(this.expression).append(" END) AS ").append(_cn);
    }

    public String verifySQL() {
        StringBuilder sb = new StringBuilder();
        String[] fromS = this.from.split(PIVOT_GROUP_BY);
        sb.append("SELECT DISTINCT ").append(this.pivot).append(" AS PIVOT ").append(" FROM ").append(fromS[0]).append(" GROUP BY ").append(this.pivot).append(",").append(fromS[1]);
        return SQLConverter.convertSQL(sb.toString()).getSql();
    }

    public boolean prepare() {
        if (this.pivotInCondition) {
            this.pivotIn = new ArrayList<String>();
        }
        return Try.withResources(this.conn::createStatement, st -> {
            ResultSet rs = st.executeQuery(this.verifySQL());
            int i = 0;
            while (rs.next()) {
                String frm = this.format(rs.getObject("PIVOT"));
                if (frm != null) {
                    this.pivotIn.add(frm);
                }
                if (++i <= 1000) continue;
                return false;
            }
            return true;
        }).orElse(false);
    }

    private String format(Object cln) {
        if (cln == null) {
            return null;
        }
        if (cln instanceof Date) {
            SimpleDateFormat sdf = new SimpleDateFormat("#MM/dd/yyyy HH:mm:ss#");
            String clns = sdf.format((Date)cln);
            if (clns.endsWith(" 00:00:00#")) {
                clns = clns.replaceAll(" 00:00:00", "");
            }
            return clns;
        }
        if (cln instanceof String) {
            return "'" + cln.toString().replaceAll("'", "''") + "'";
        }
        return cln.toString();
    }

    private String replaceQuotation(String cn) {
        Matcher dcm = PIVOT_CN_PATT.matcher(cn = cn.replaceAll("\n", " ").replaceAll("\r", " "));
        if (dcm.matches()) {
            cn = dcm.group(1);
        }
        cn = cn.replaceAll("'", "").replaceAll("\"", "");
        return "[" + cn + "]";
    }

    public String toSQL(String name) {
        if (this.pivotIn == null) {
            if (name != null && PREPARE_MAP.containsKey(name)) {
                this.prepareGetFromCache(name);
            } else if (this.prepare()) {
                this.cachePrepare(name);
            } else {
                return null;
            }
            this.pivotInCondition = false;
        }
        StringBuilder sb = new StringBuilder().append("SELECT ").append(this.select);
        for (String s : this.pivotIn) {
            sb.append(",");
            this.appendCaseWhen(sb, this.pivot + "=" + s, this.replaceQuotation(s));
        }
        sb.append(" FROM ").append(this.from);
        return sb.toString();
    }
}

