/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.converters;

import com.healthmarketscience.jackcess.impl.query.AppendQueryImpl;
import com.healthmarketscience.jackcess.impl.query.QueryImpl;
import com.healthmarketscience.jackcess.query.Query;
import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import net.ucanaccess.converters.AppendQueryTemp;
import net.ucanaccess.converters.SQLConverter;
import net.ucanaccess.converters.TypesMap;

public class ParametricQuery {
    private Connection hsqldb;
    private QueryImpl qi;
    private boolean loaded;
    private PreparedStatement ps;
    private String parameters;
    private String defaultParameterValues;
    private boolean conversionOk;
    private boolean issueWithParameterName;
    private Map<String, String> aposMap;
    private List<String> parameterList;
    private Exception exception;
    private boolean isProcedure;
    private String sqlContent;
    private String signature;
    private StringBuilder originalParameters = new StringBuilder();

    public ParametricQuery(Connection _hsqldb, QueryImpl _qi) {
        this.hsqldb = _hsqldb;
        this.qi = _qi.getType() == Query.Type.APPEND ? new AppendQueryTemp((AppendQueryImpl)_qi) : _qi;
    }

    public boolean isIssueWithParameterName() {
        return this.issueWithParameterName;
    }

    public void setIssueWithParameterName(boolean _issueWithParameterName) {
        this.issueWithParameterName = _issueWithParameterName;
    }

    private List<String> queryParameters() {
        List l = this.qi.getParameters();
        if (this.aposMap != null) {
            return this.parameterList;
        }
        this.aposMap = new HashMap<String, String>();
        int i = 0;
        this.parameterList = new ArrayList<String>();
        this.parameterList.addAll(l);
        for (String par : this.parameterList) {
            if (par.contains("'") || par.contains("\"")) {
                int index = Math.max(Math.max(par.lastIndexOf(32), par.lastIndexOf(10)), par.lastIndexOf(13));
                String decl = par.substring(0, index).trim();
                if (decl.startsWith("[")) {
                    decl = decl.substring(1, decl.length() - 1);
                }
                String h = this.treatApos(decl);
                this.aposMap.put(h, decl);
                this.parameterList.set(i, this.treatApos(par));
            }
            ++i;
        }
        return this.parameterList;
    }

    public void createProcedure() {
        this.isProcedure = true;
        String sql = null;
        try {
            String procedureName;
            String procedure;
            List<String> l = this.queryParameters();
            sql = this.getSQL();
            if (l == null || l.isEmpty()) {
                this.parametersEmpiric();
            } else {
                sql = SQLConverter.removeParameters(sql);
                this.parametersDeclared();
                if (!this.conversionOk) {
                    this.parametersEmpiric(true);
                }
            }
            if (!this.conversionOk) {
                return;
            }
            this.exception = null;
            Object inside = this.convertSQL(this.convertApos(sql)).trim();
            if (!((String)inside).endsWith(";")) {
                inside = (String)inside + ";";
            }
            if (this.exec(procedure = "CREATE PROCEDURE " + (procedureName = SQLConverter.escapeIdentifier(this.qi.getName(), this.hsqldb)) + "(" + this.parameters + ") MODIFIES SQL DATA \n BEGIN ATOMIC " + (String)inside + "\n END")) {
                this.signature = this.qi.getName() + "(" + String.valueOf(this.originalParameters) + ")";
                this.loaded = true;
            }
        }
        catch (Exception _ex) {
            this.exception = _ex;
        }
    }

    public void createSelect() {
        String qnn = null;
        String sql = null;
        try {
            String funName;
            String function;
            List<String> l = this.queryParameters();
            qnn = SQLConverter.escapeIdentifier(this.qi.getName(), this.hsqldb);
            sql = this.getSQL();
            if (l == null || l.isEmpty()) {
                this.parametersEmpiric();
            } else {
                sql = SQLConverter.removeParameters(sql);
                this.parametersDeclared();
                if (!this.conversionOk) {
                    this.parametersEmpiric();
                }
            }
            if (!this.conversionOk) {
                return;
            }
            this.exception = null;
            String inside = this.convertSQL(this.convertApos(sql)).trim();
            if (inside.endsWith(";")) {
                inside = inside.substring(0, inside.length() - 1);
            }
            if (!this.exec(function = "CREATE FUNCTION " + (funName = qnn) + "(" + this.parameters + ") RETURNS TABLE (" + this.getTableDefinition() + ") READS SQL DATA \n RETURN (TABLE(" + inside + "));")) {
                return;
            }
            String createView = "CREATE VIEW " + qnn + " AS SELECT * FROM TABLE(" + funName + "(" + this.defaultParameterValues + "))";
            if (!this.exec(createView)) {
                return;
            }
            this.loaded = true;
        }
        catch (Exception _ex) {
            this.exception = _ex;
        }
    }

    private String convertApos(String sql) {
        if (this.aposMap != null) {
            for (Map.Entry<String, String> me : this.aposMap.entrySet()) {
                sql = sql.replaceAll("(?i)" + Pattern.quote("[" + me.getValue() + "]"), "[" + me.getKey() + "]");
            }
        }
        return sql;
    }

    private String getTableDefinition() throws SQLException {
        ResultSet rs = this.ps.executeQuery();
        ResultSetMetaData rsmd = rs.getMetaData();
        StringBuilder sb = new StringBuilder();
        String comma = "";
        int i = 1;
        while (i <= rsmd.getColumnCount()) {
            String type = this.completeTypeName(rsmd.getColumnTypeName(i), rsmd.getPrecision(i), rsmd.getScale(i), false);
            sb.append(comma).append(SQLConverter.escapeIdentifier(rsmd.getColumnLabel(i), this.hsqldb)).append(" ").append(type);
            comma = ",";
            ++i;
        }
        return sb.toString();
    }

    private String completeTypeName(String type, int i, int j, boolean useDefault) {
        if ("VARCHAR".equals(type)) {
            type = (String)type + "(" + i + ")";
        }
        if ("NUMERIC".equals(type)) {
            type = useDefault ? (String)type + "(100,10)" : (String)type + "(" + i + "," + j + ")";
        }
        return type;
    }

    private String treatApos(String _s) {
        return _s.replace("'", "").replace("\"", "").toUpperCase();
    }

    private boolean exec(String expression) {
        block12: {
            Throwable throwable = null;
            Object var3_5 = null;
            Statement st = this.hsqldb.createStatement();
            try {
                st.execute(expression);
                if (st == null) break block12;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        if (st != null) {
                            st.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                catch (SQLException _ex) {
                    this.exception = _ex;
                    return false;
                }
            }
            st.close();
        }
        return true;
    }

    private String getSQL() {
        if (this.sqlContent == null) {
            this.sqlContent = ParametricQuery.transalteFormFields(this.qi.toSQLString());
        }
        return this.sqlContent;
    }

    private static String transalteFormFields(String sqlString) {
        return sqlString.replaceAll("\\[([^\\]]*)\\]\\!\\[([^\\]]*)\\]\\!\\[([^\\]]*)\\]", "[$1_$2_$3]").replaceAll("\\[(\\w*)\\]\\!\\[(\\w*)\\]\\!\\[(\\w*)\\]", "[$1_$2_$3]").replaceAll("((?i)FORMS)\\.(\\w*)\\.(\\w*)", "[$1_$2_$3]");
    }

    private void parametersEmpiric() {
        this.parametersEmpiric(false);
    }

    private void parametersEmpiric(boolean partialParDecl) {
        this.aposMap = new HashMap<String, String>();
        LinkedHashMap<String, Integer> hm = new LinkedHashMap<String, Integer>();
        String s = this.getSQL();
        if (partialParDecl) {
            s = SQLConverter.removeParameters(s);
        }
        List<String> params = SQLConverter.getParameters(s);
        HashMap<String, String> parem = new HashMap<String, String>();
        this.doParametersEmpiric(hm, params, parem, s);
    }

    public Exception getException() {
        return this.exception;
    }

    private void parametersDeclared() {
        List<String> ls = this.queryParameters();
        StringBuilder args = new StringBuilder();
        String comma = "";
        ArrayList<String> ar = new ArrayList<String>();
        for (String par : ls) {
            par = par.trim();
            int index = Math.max(Math.max(par.lastIndexOf(32), par.lastIndexOf(10)), par.lastIndexOf(13));
            Object decl = par.substring(0, index).trim();
            Object type = par.substring(index).trim();
            if (!((String)decl).startsWith("[")) {
                decl = "[" + (String)decl + "]";
            }
            ar.add((String)decl);
            String type0 = ((String)type).indexOf(40) > 0 ? ((String)type).substring(0, ((String)type).indexOf(40)) : type;
            String typeS = ((String)type).indexOf(40) > 0 ? ((String)type).substring(((String)type).indexOf(40)) : "";
            Map<String, String> hm = TypesMap.getAccess2HsqlTypesMap();
            type = hm.get(type0.toUpperCase()) + typeS;
            if ("VARCHAR".equalsIgnoreCase((String)type)) {
                type = (String)type + "(255)";
            }
            args.append(comma).append((String)decl).append(" ").append((String)type);
            comma = ",";
        }
        String sql = this.getSQL();
        sql = this.convertApos(SQLConverter.removeParameters(sql));
        for (String var : ar) {
            sql = sql.replaceAll("(?i)" + Pattern.quote(var), "?");
        }
        try {
            this.ps = this.hsqldb.prepareStatement(this.convertSQL(sql));
            if (!this.isProcedure) {
                ParameterMetaData pmd = this.ps.getParameterMetaData();
                StringBuilder defPar = new StringBuilder();
                comma = "";
                int i = 1;
                while (i <= pmd.getParameterCount()) {
                    if (!this.isProcedure) {
                        this.ps.setNull(i, pmd.getParameterType(i));
                    }
                    defPar.append(comma).append("NULL");
                    comma = ",";
                    ++i;
                }
                this.defaultParameterValues = defPar.toString();
            }
            this.originalParameters = args;
            this.parameters = SQLConverter.convertSQL(args.toString()).getSql();
            this.conversionOk = true;
        }
        catch (SQLException _ex) {
            this.exception = _ex;
        }
    }

    private List<Integer> parIndexes(String s) {
        ArrayList<Integer> ar = new ArrayList<Integer>();
        char character = '?';
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) == character) {
                ar.add(i);
            }
            ++i;
        }
        return ar;
    }

    private String convertSQL(String sql) {
        return SQLConverter.convertSQL(sql, true).getSql();
    }

    private String convertSQL(String sql, List<String> parameters2) {
        for (String s : parameters2) {
            if (s.indexOf(39) <= 0 && s.indexOf(34) <= 0) continue;
            String src = Pattern.quote(s);
            String target = this.treatApos(s);
            sql = sql.replaceAll(src, target);
            this.aposMap.put(target.substring(1, target.length() - 1), s.substring(1, s.length() - 1));
        }
        return this.convertSQL(sql);
    }

    /*
     * Unable to fully structure code
     */
    private void doParametersEmpiric(Map<String, Integer> _psmp, List<String> _parameters, Map<String, String> parem, String sql) {
        block10: {
            psTxt = null;
            try {
                psTxt = this.convertSQL(sql, _parameters);
                l = SQLConverter.getParameters(psTxt);
                for (String s : l) {
                    h = this.treatApos(s);
                    for (String modf : _parameters) {
                        if (!this.convertSQL(modf).equals(s) || this.aposMap.containsKey(h = this.treatApos(modf))) continue;
                        _parameters.set(_parameters.indexOf(modf), h);
                        psTxt = psTxt.replaceAll("(?i)" + Pattern.quote(s), this.convertSQL(h));
                        sql = sql.replaceAll("(?i)" + Pattern.quote(modf), h);
                        h = h.substring(1, h.length() - 1);
                        this.aposMap.put(h, modf.substring(1, modf.length() - 1));
                    }
                }
                this.ps = this.hsqldb.prepareStatement(psTxt);
                pmd = this.ps.getParameterMetaData();
                _psmp = this.reorderIndexes(_psmp, parem);
                ar = new ArrayList<String>(_psmp.keySet());
                pI = this.parIndexes(sql);
                parS = new StringBuilder();
                defPar = new StringBuilder();
                j = 0;
                comma = "";
                i = 1;
                while (i <= pmd.getParameterCount()) {
                    if (!this.isProcedure) {
                        this.ps.setNull(i, pmd.getParameterType(i));
                    }
                    if (j <= ar.size() - 1 && (index = _psmp.get(key = (String)ar.get(j)).intValue()) == pI.get(i - 1)) {
                        defPar.append(comma).append("NULL");
                        type = this.completeTypeName(pmd.getParameterTypeName(i), pmd.getPrecision(i), pmd.getScale(i), true);
                        parS.append(comma).append(SQLConverter.escapeIdentifier(key, this.hsqldb)).append(" ").append(type);
                        comma = ",";
                        ++j;
                    }
                    ++i;
                }
                this.parameters = parS.toString();
                this.defaultParameterValues = defPar.toString();
                this.conversionOk = true;
                break block10;
            }
            catch (SQLException _ex) {
                ** for (par : _parameters)
            }
lbl-1000:
            // 1 sources

            {
                par1 = SQLConverter.preEscapingIdentifier(par.substring(1, par.length() - 1));
                index = sql.toUpperCase().indexOf(par.toUpperCase());
                if (index >= 0 && _ex.getMessage() != null && (_ex.getMessage().toUpperCase().endsWith(": " + par1) || _ex.getMessage().toUpperCase().contains(": " + par1 + " IN STATEMENT "))) {
                    sql = sql.replaceAll("(?i)" + Pattern.quote(par), "?");
                    _psmp.put(par1, index);
                    parem.put(par1, par);
                    parname = this.originalParameters.length() == 0 ? par : "," + par;
                    this.originalParameters.append((String)parname);
                    this.doParametersEmpiric(_psmp, _parameters, parem, sql);
                    continue;
                }
                this.exception = _ex;
                continue;
            }
lbl62:
            // 1 sources

            if (this.exception == null) {
                this.exception = _ex;
            }
        }
    }

    private Map<String, Integer> reorderIndexes(Map<String, Integer> psmp, Map<String, String> parem) {
        TreeMap<Integer, String> tm = new TreeMap<Integer, String>();
        Integer[] nI = new Integer[psmp.size()];
        String[] sI = new String[psmp.size()];
        HashMap<String, Integer> dI = new HashMap<String, Integer>();
        int j = 0;
        for (Map.Entry<String, Integer> me : psmp.entrySet()) {
            tm.put(me.getValue(), me.getKey());
            nI[j] = me.getValue();
            sI[j] = me.getKey();
            dI.put(sI[j], 0);
            ++j;
        }
        boolean changedSignature = false;
        int i = 0;
        while (i < tm.size() - 1) {
            j = i + 1;
            while (j < tm.size()) {
                if (nI[j] < nI[i]) {
                    changedSignature = true;
                    dI.put(sI[i], (Integer)dI.get(sI[i]) - parem.get(sI[j]).length() + 1);
                }
                ++j;
            }
            ++i;
        }
        LinkedHashMap<String, Integer> rlhm = new LinkedHashMap<String, Integer>();
        for (Map.Entry me : tm.entrySet()) {
            rlhm.put((String)me.getValue(), (Integer)me.getKey() + (Integer)dI.get(me.getValue()));
        }
        if (changedSignature) {
            StringBuilder sb = new StringBuilder();
            String comma = "";
            for (String key : rlhm.keySet()) {
                sb.append(comma).append(parem.get(key));
                comma = ",";
            }
            this.originalParameters = sb;
        }
        return rlhm;
    }

    public boolean loaded() {
        return this.loaded;
    }

    public String getSignature() {
        return this.signature;
    }
}

