/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.cpat.commands;

import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.ReportFormat;
import com.oracle.premigration.commons.enums.TargetCloud;
import java.util.List;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Factory;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.OptionBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Type;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.Transformer;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.basic.StringEnum;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.basic.StringList;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.database.DbSchemaTransformer;

public class MigrateAdvisorOptions {
    public static final String CMD_PARMS = "migrateadvisor.parms";
    public static final String BASE_COMMAND = "MigrateAdvisor";
    public static final String BASE_COMMAND_S = "ma";
    public static final String ADVISE = "advise";
    public static final String ADVISE_S = "ad";
    public static final String VERSION = "version";
    public static final String VERSION_S = "ve";
    public static final String PROPERTIES = "properties";
    public static final String PROPERTIES_S = "pr";
    public static final String ANALYSISPROPS = "analysisprops";
    public static final String ANALYSISPROPS_S = "a";
    public static final String DEBUG = "debug";
    public static final String DEBUG_S = "de";
    public static final String EXCLUDESCHEMAS = "excludeschemas";
    public static final String EXCLUDESCHEMAS_S = "x";
    public static final String FULL = "full";
    public static final String FULL_S = "f";
    public static final String MAXRELEVANTOBJECTS = "maxrelevantobjects";
    public static final String MAXRELEVANTOBJECTS_S = "m";
    public static final String MAXTEXTDATAROWS = "maxtextdatarows";
    public static final String MAXTEXTDATAROWS_S = "d";
    public static final String MIGRATIONMETHOD = "migrationmethod";
    public static final String MIGRATIONMETHOD_S = "mm";
    public static final String NOEXEC = "noexec";
    public static final String NOEXEC_S = "ne";
    public static final String OUTDIR = "outdir";
    public static final String OUTDIR_S = "o";
    public static final String OUTFILEPREFIX = "outfileprefix";
    public static final String OUTFILEPREFIX_S = "p";
    public static final String REPORTFORMAT = "reportformat";
    public static final String HTML = "html";
    public static final String REPORTFORMAT_S = "r";
    public static final String SCHEMAS = "schemas";
    public static final String SCHEMAS_S = "s";
    public static final String SQLTEXT = "sqltext";
    public static final String SQLTEXT_S = "q";
    public static final String TARGETTYPE = "targettype";
    public static final String TARGETTYPE_S = "t";
    public static final String VERBOSE = "verbose";
    public static final String VERBOSE_S = "ve";
    private static final Type adviceSubcommand = Factory.type((Id)Symbol.ADVISE).abbrevs(new String[]{"ad"}).add(((OptionBuilder)((OptionBuilder)((OptionBuilder)Factory.option((Id)Symbol.TARGETTYPE).abbrevs(new String[]{"t"}).dataType(String.class)).transformer(new Transformer[]{new StringEnum(false, MigrateAdvisorOptions.getTargetTypeVV())})).required()).build()).add(((OptionBuilder)Factory.option((Id)Symbol.ANALYSISPROPS).abbrevs(new String[]{"a"}).dataType(String.class)).build()).add(((OptionBuilder)((OptionBuilder)Factory.option((Id)Symbol.EXCLUDESCHEMAS).abbrevs(new String[]{"x"}).dataType(List.class)).transformer(new Transformer[]{new StringList((Transformer)new DbSchemaTransformer())})).build()).add(((OptionBuilder)Factory.option((Id)Symbol.FULL).flag().abbrevs(new String[]{"f"}).defaultValue((Object)Boolean.FALSE)).build()).add(((OptionBuilder)Factory.option((Id)Symbol.MAXRELEVANTOBJECTS).abbrevs(new String[]{"m"}).dataType(String.class)).build()).add(((OptionBuilder)Factory.option((Id)Symbol.MAXTEXTDATAROWS).abbrevs(new String[]{"d"}).dataType(String.class)).build()).add(((OptionBuilder)((OptionBuilder)((OptionBuilder)Factory.option((Id)Symbol.MIGRATIONMETHOD).abbrevs(new String[]{"mm"}).dataType(List.class)).defaultValue(List.of("DATAPUMP"))).transformer(new Transformer[]{new StringList((Transformer)new StringEnum(MigrateAdvisorOptions.getMigrationMethodVV()))})).build()).add(((OptionBuilder)Factory.option((Id)Symbol.OUTDIR).abbrevs(new String[]{"o"}).dataType(String.class)).build()).add(((OptionBuilder)Factory.option((Id)Symbol.OUTFILEPREFIX).abbrevs(new String[]{"p"}).dataType(String.class)).build()).add(((OptionBuilder)((OptionBuilder)((OptionBuilder)Factory.option((Id)Symbol.REPORTFORMAT).abbrevs(new String[]{"r"}).dataType(List.class)).defaultValue(List.of("HTML"))).transformer(new Transformer[]{new StringList((Transformer)new StringEnum(MigrateAdvisorOptions.getReportFormatVV()))})).build()).add(((OptionBuilder)((OptionBuilder)Factory.option((Id)Symbol.SCHEMAS).abbrevs(new String[]{"s"}).dataType(List.class)).transformer(new Transformer[]{new StringList((Transformer)new DbSchemaTransformer())})).build()).add(((OptionBuilder)Factory.option((Id)Symbol.SQLTEXT).flag().abbrevs(new String[]{"q"}).defaultValue((Object)Boolean.FALSE)).build()).add(((OptionBuilder)Factory.option((Id)Symbol.VERBOSE).flag().abbrevs(new String[]{"ve"}).defaultValue((Object)Boolean.FALSE)).build()).build();
    private static final Type propertiesSubcommand = Factory.type((Id)Symbol.PROPERTIES).abbrevs(new String[]{"pr"}).add(((OptionBuilder)Factory.option((Id)Symbol.OUTDIR).abbrevs(new String[]{"o"}).dataType(String.class)).build()).add(((OptionBuilder)Factory.option((Id)Symbol.OUTFILEPREFIX).abbrevs(new String[]{"p"}).dataType(String.class)).build()).add(((OptionBuilder)((OptionBuilder)Factory.option((Id)Symbol.VERBOSE).abbrevs(new String[]{"ve"}).dataType(Boolean.class)).defaultValue((Object)Boolean.FALSE)).build()).build();
    private static final Type versionSubcommand = Factory.type((Id)Symbol.VERSION).abbrevs(new String[]{"ve"}).build();

    public static Type typeCommand() {
        return Factory.type((Id)Symbol.MIGRATEADVISOR).base().abbrevs(new String[]{BASE_COMMAND_S}).add(adviceSubcommand).add(propertiesSubcommand).add(versionSubcommand).build();
    }

    private static String[] getMigrationMethodVV() {
        Object mm = "";
        for (MigrationMethod v : MigrationMethod.values()) {
            mm = (String)mm + v.toString().toLowerCase() + ",";
        }
        return ((String)mm).substring(0, ((String)mm).length() - 1).split(",");
    }

    private static final String[] getReportFormatVV() {
        Object rf = "";
        boolean hasHtmlAlready = false;
        for (ReportFormat v : ReportFormat.values()) {
            String candidate = v.toString().toLowerCase();
            if (HTML.equalsIgnoreCase(candidate)) {
                hasHtmlAlready = true;
            }
            rf = (String)rf + candidate + ",";
        }
        if (!hasHtmlAlready) {
            rf = (String)rf + HTML;
        }
        return ((String)rf).split(",");
    }

    private static final String[] getTargetTypeVV() {
        Object tt = "";
        for (TargetCloud v : TargetCloud.values()) {
            tt = (String)tt + v.toString().toLowerCase() + ",";
        }
        return ((String)tt).substring(0, ((String)tt).length() - 1).split(",");
    }

    public static enum Symbol implements Id
    {
        MIGRATEADVISOR,
        ADVISE,
        PROPERTIES,
        VERSION,
        TARGETTYPE,
        ANALYSISPROPS,
        EXCLUDESCHEMAS,
        FULL,
        MAXRELEVANTOBJECTS,
        MAXTEXTDATAROWS,
        MIGRATIONMETHOD,
        OUTDIR,
        OUTFILEPREFIX,
        REPORTFORMAT,
        SCHEMAS,
        SQLTEXT,
        VERBOSE;

    }
}

