/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.recovery.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class FetchProtectedDatabaseConfigurationDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="configurationType")
    private final ConfigurationType configurationType;

    @Deprecated
    @ConstructorProperties(value={"configurationType"})
    public FetchProtectedDatabaseConfigurationDetails(ConfigurationType configurationType) {
        this.configurationType = configurationType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public ConfigurationType getConfigurationType() {
        return this.configurationType;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("FetchProtectedDatabaseConfigurationDetails(");
        sb.append("super=").append(super.toString());
        sb.append("configurationType=").append(String.valueOf((Object)this.configurationType));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FetchProtectedDatabaseConfigurationDetails)) {
            return false;
        }
        FetchProtectedDatabaseConfigurationDetails other = (FetchProtectedDatabaseConfigurationDetails)((Object)o);
        return Objects.equals((Object)this.configurationType, (Object)other.configurationType) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.configurationType == null ? 43 : this.configurationType.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ConfigurationType implements BmcEnum
    {
        Cabundle("CABUNDLE"),
        Tnsnames("TNSNAMES"),
        Hosts("HOSTS"),
        Rcvconf("RCVCONF"),
        All("ALL");

        private final String value;
        private static Map<String, ConfigurationType> map;

        private ConfigurationType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ConfigurationType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid ConfigurationType: " + key);
        }

        static {
            map = new HashMap<String, ConfigurationType>();
            for (ConfigurationType v : ConfigurationType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="configurationType")
        private ConfigurationType configurationType;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder configurationType(ConfigurationType configurationType) {
            this.configurationType = configurationType;
            this.__explicitlySet__.add("configurationType");
            return this;
        }

        public FetchProtectedDatabaseConfigurationDetails build() {
            FetchProtectedDatabaseConfigurationDetails model = new FetchProtectedDatabaseConfigurationDetails(this.configurationType);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(FetchProtectedDatabaseConfigurationDetails model) {
            if (model.wasPropertyExplicitlySet("configurationType")) {
                this.configurationType(model.getConfigurationType());
            }
            return this;
        }
    }
}

