/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.importer.readers;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import oracle.dbtools.data.readservice.DataFormatException;
import oracle.dbtools.datatools.BaseDataFormat;
import oracle.dbtools.datatools.DataToolsResources;
import oracle.dbtools.importer.ImportResources;
import oracle.dbtools.importer.core.DataType;
import oracle.dbtools.importer.core.ImportDataFormatConfig;
import oracle.dbtools.importer.readers.DataReader;
import oracle.dbtools.importer.readers.DataReaderException;
import oracle.dbtools.raptor.utils.MessageHandler;
import oracle.dbtools.util.Logger;

public class DelimitedReader
extends DataReader {
    public static final String NAME = "Delimited";
    public static final String FORMAT;
    public static final String EXT = "dsv";
    public static final int BUFFER_SIZE = 1024;
    public static final int BUFFER_KSIZE = 1;
    public static final String KEY_HEADER = "IMPORT_DLM_HEADER";
    public static final String KEY_DELIMITER = "IMPORT_DLM_DELIMITER";
    public static final String KEY_REC_TERM = "IMPORT_DLM_REC_TERM";
    public static final String KEY_ENCL_LEFT = "IMPORT_DLM_ENCL_LEFT";
    public static final String KEY_ENCL_RIGHT = "IMPORT_DLM_ENCL_RIGHT";
    public static final String KEY_ENCL_RIGHT_DOUBLE = "IMPORT_DLM_ENCL_RIGHT_DOUBLE";
    private BufferedReader m_csvFileReader;
    private BufferedReader m_previewReader;
    private FileInputStream m_previewFileInputStream;
    private InputStreamReader m_previewStreamReader;
    private boolean m_previewFileEOF;
    private int m_previewToReadCount;
    private int m_previewFileSize;
    private int m_previewMaxLength;
    private char[] m_previewReadAheadBuffer;
    private int m_previewReadAheadNumRead = -1;
    private int m_bufferSize;
    private boolean m_terminatorFound;
    private String m_terminatorValue;
    private String m_encoding;
    private List<Object[]> m_previewRows = null;
    private List<byte[]> m_previewBuffers;
    private List<String> m_recTermList = new ArrayList<String>();
    private int m_currentPreviewBuffer;
    private boolean m_previewTruncate = false;
    private Integer[] m_columnWidths = null;
    private ArrayList<Integer> m_columnWidthsList = new ArrayList();
    private int m_columnCount = -1;
    private String m_currentRow = null;
    private String[] m_firstRow = null;
    private boolean m_isCheckTerminator = true;
    private boolean m_isStandardTerm;
    private DataFormatException m_dataFormatException = null;
    private String m_saveTerminator;
    private int m_dataFormatExceptionRow;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getType() {
        return EXT;
    }

    @Override
    public String getFormat() {
        return FORMAT;
    }

    @Override
    public String[] getColumnNames() {
        if (!this.dataFormat.isHeader()) {
            if (this.isUserDefaultColumnNames()) {
                return this.getUserDefaultColumnNames();
            }
            return this.getDefaultColumnNames();
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        ArrayList<Object> names = new ArrayList<Object>();
        if (this.m_firstRow == null) {
            this.getPreviewRows();
        }
        if (this.m_firstRow != null && this.m_firstRow.length > 0) {
            for (int i = 0; i < this.m_firstRow.length; ++i) {
                if (this.m_firstRow[i] != null) {
                    if (map.containsKey(this.m_firstRow[i])) {
                        map.put(this.m_firstRow[i], (Integer)map.get(this.m_firstRow[i]) + 1);
                        names.add(this.m_firstRow[i].toString() + String.valueOf(map.get(this.m_firstRow[i])));
                        continue;
                    }
                    map.put(this.m_firstRow[i], 1);
                    names.add(this.m_firstRow[i]);
                    continue;
                }
                names.add(this.getDefColumn() + (i + 1));
            }
            this.m_headerRowColumnNames = names.toArray(new String[names.size()]);
        }
        return this.m_headerRowColumnNames;
    }

    private String[] splitRow(String line) throws DataFormatException {
        ArrayList<Object> columns = new ArrayList<Object>();
        String delimValue = this.dataFormat.getDelimiterValue();
        int delimValueLength = delimValue.length();
        int errorOffset = -1;
        if (delimValueLength != 0) {
            int col = 0;
            int state = 0;
            StringBuilder token = new StringBuilder();
            if (BaseDataFormat.isDelimiterWhiteSpace(this.dataFormat.getDelimiterValue())) {
                delimValue = "\t";
                delimValueLength = 1;
            }
            String eLeftValue = this.dataFormat.getEnclosureLeftValue();
            String eRightValue = this.dataFormat.getEnclosureRightValue();
            boolean isEnclosed = this.dataFormat.getEnclosures();
            if (state == 2) {
                state = 0;
            }
            int lineIndex = 0;
            while (lineIndex < line.length()) {
                char c = line.charAt(lineIndex);
                switch (state) {
                    case 0: {
                        if (isEnclosed && line.startsWith(eLeftValue, lineIndex)) {
                            lineIndex += eLeftValue.length();
                            state = 1;
                            break;
                        }
                        if (this.isThisDelimiter(line, lineIndex, delimValue)) {
                            columns.add(token.toString());
                            ++col;
                            token = new StringBuilder();
                            lineIndex += delimValueLength;
                            if (!BaseDataFormat.isDelimiterWhiteSpace(this.dataFormat.getDelimiterValue())) break;
                            state = 2;
                            break;
                        }
                        token.append(c);
                        ++lineIndex;
                        break;
                    }
                    case 1: {
                        if (isEnclosed && line.startsWith(eRightValue, lineIndex)) {
                            lineIndex += eRightValue.length();
                            state = this.dataFormat.isEnclosureRightDouble() ? 3 : 4;
                            break;
                        }
                        token.append(c);
                        ++lineIndex;
                        break;
                    }
                    case 2: {
                        if (!this.isThisDelimiter(line, lineIndex, delimValue)) {
                            if (isEnclosed && line.startsWith(eLeftValue, lineIndex)) {
                                state = 1;
                                token = new StringBuilder();
                                lineIndex += eLeftValue.length();
                                break;
                            }
                            state = 0;
                            ++lineIndex;
                            token.append(c);
                            break;
                        }
                        lineIndex += delimValueLength;
                        break;
                    }
                    case 3: {
                        if (this.isThisDelimiter(line, lineIndex, delimValue)) {
                            columns.add(token.toString());
                            ++col;
                            token = new StringBuilder();
                            lineIndex += delimValueLength;
                            if (BaseDataFormat.isDelimiterWhiteSpace(this.dataFormat.getDelimiterValue())) {
                                state = 2;
                                break;
                            }
                            state = 0;
                            break;
                        }
                        if (line.startsWith(eRightValue, lineIndex)) {
                            token.append(c);
                            ++lineIndex;
                            state = 1;
                            break;
                        }
                        if (errorOffset == -1) {
                            errorOffset = lineIndex;
                        }
                        token.append(eRightValue + c);
                        ++lineIndex;
                        state = 5;
                        break;
                    }
                    case 4: {
                        if (this.isThisDelimiter(line, lineIndex, delimValue)) {
                            columns.add(token.toString());
                            ++col;
                            token = new StringBuilder();
                            lineIndex += delimValueLength;
                            if (BaseDataFormat.isDelimiterWhiteSpace(this.dataFormat.getDelimiterValue())) {
                                state = 2;
                                break;
                            }
                            state = 0;
                            break;
                        }
                        if (line.startsWith(eRightValue, lineIndex)) {
                            token.append(eRightValue);
                            ++lineIndex;
                            break;
                        }
                        token.append(eRightValue + c);
                        ++lineIndex;
                        state = 1;
                        break;
                    }
                    case 5: {
                        token.append(c);
                        ++lineIndex;
                    }
                }
            }
            if (state == 0) {
                columns.add(token.toString());
                col = 0;
                token = new StringBuilder();
            } else if (state == 1) {
                columns.add(eLeftValue + token.toString());
                if (errorOffset == -1) {
                    errorOffset = line.length() - 1;
                }
            } else if (state != 0) {
                columns.add(token.toString());
            }
        } else {
            columns.add(line);
        }
        if (errorOffset != -1) {
            String msg = ImportResources.format("DATA_FORMAT_EXCEPTION", errorOffset + 1);
            throw new DataFormatException(msg, errorOffset + 1, line, columns.toArray(new String[columns.size()]));
        }
        return columns.toArray(new String[columns.size()]);
    }

    private boolean isThisDelimiter(String record, int lineIndex, String delimValue) {
        if (BaseDataFormat.isDelimiterWhiteSpace(this.dataFormat.getDelimiterValue())) {
            return record.startsWith(delimValue, lineIndex) || record.startsWith(" ", lineIndex);
        }
        return record.startsWith(delimValue, lineIndex);
    }

    @Override
    public boolean hasMoreRows() {
        try {
            this.m_currentRow = this.readLine(this.m_csvFileReader);
            if (this.m_currentRow != null) {
                return true;
            }
        }
        catch (IOException e) {
            Logger.warn(this.getClass(), (Throwable)e);
            this.m_currentRow = null;
        }
        return false;
    }

    @Override
    public String readCurrentLine() throws DataFormatException {
        return this.m_currentRow;
    }

    @Override
    public void openFile(String filename) throws DataReaderException {
        try {
            if (this.m_csvFileReader != null) {
                this.m_csvFileReader.close();
            }
            this.m_csvFileReader = this.openDataFile(filename);
        }
        catch (Throwable e) {
            Logger.warn(this.getClass(), (Throwable)e);
            throw new DataReaderException(e.getMessage());
        }
        this.m_currentRow = null;
    }

    @Override
    public void closeFile() {
        this.closeCsvFile();
        this.closePreviewFile();
    }

    public void closeCsvFile() {
        try {
            if (this.m_csvFileReader != null) {
                this.m_csvFileReader.close();
            }
        }
        catch (IOException e) {
            Logger.warn(this.getClass(), (Throwable)e);
        }
        this.m_currentRow = null;
        this.m_csvFileReader = null;
    }

    @Override
    public void start() throws DataReaderException {
        try {
            if (this.m_csvFileReader != null) {
                this.m_csvFileReader.close();
            }
            this.m_csvFileReader = this.openDataFile(this.getFileName());
        }
        catch (Throwable e) {
            this.m_currentRow = null;
            Logger.warn(this.getClass(), (Throwable)e);
            throw new DataReaderException(e.getMessage());
        }
        this.m_currentRow = null;
    }

    public BufferedReader openDataFile(String filename) {
        BufferedReader tmpReader = null;
        FileInputStream fis = null;
        InputStreamReader isr = null;
        this.m_currentRow = null;
        try {
            fis = new FileInputStream(filename);
            isr = new InputStreamReader((InputStream)fis, this.dataFormat.getEncoding());
            tmpReader = new BufferedReader(isr);
        }
        catch (FileNotFoundException e) {
            this.fireSimpleEvent(ImportResources.getString("CSVREADER_FILE_NOT_FOUND"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tmpReader;
    }

    public void setDelimiter(String delimiter) {
    }

    private void setColumnWidths(String[] row) {
        if (row.length > this.m_columnCount) {
            this.m_columnCount = row.length;
        }
        for (int j = 0; j < row.length; ++j) {
            try {
                int size = row[j].length();
                if (j + 1 > this.m_columnWidthsList.size()) {
                    this.m_columnWidthsList.add(new Integer(size));
                    continue;
                }
                if (size <= this.m_columnWidthsList.get(j)) continue;
                this.m_columnWidthsList.set(j, new Integer(size));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void refreshPreview(boolean refresh) {
        super.refreshPreview(refresh);
        this.m_columnCount = -1;
        this.m_columnWidths = null;
        this.m_previewRows = null;
    }

    @Override
    public int getColumnCount() {
        if (this.m_columnCount < 0 || this.m_refreshPreview) {
            this.getPreviewRows();
            if (this.m_columnCount < 0) {
                return 0;
            }
        }
        return this.m_columnCount;
    }

    @Override
    public String getType(int columnPosition) {
        ArrayList<DataType> list = new ArrayList<DataType>();
        List<Object[]> rows = this.getPreviewRows();
        for (Object[] row : rows) {
            list.add(this.parse(row[columnPosition].toString()));
        }
        return this.mostLikelyDatatype(list);
    }

    private String mostLikelyDatatype(ArrayList<DataType> list) {
        HashMap<DataType, Integer> potentials = new HashMap<DataType, Integer>();
        DataType potentialType = null;
        for (int i = 0; i < DataType.values().length; ++i) {
            potentials.put(DataType.values()[i], 0);
        }
        for (DataType type : list) {
            potentials.put(type, (Integer)potentials.get((Object)type) + 1);
        }
        int tops = 0;
        for (Map.Entry entry : potentials.entrySet()) {
            DataType tempType = (DataType)((Object)entry.getKey());
            if (potentialType == null) {
                potentialType = tempType;
                tops = (Integer)potentials.get((Object)tempType);
                continue;
            }
            if ((Integer)potentials.get((Object)tempType) <= tops) continue;
            potentialType = tempType;
            tops = (Integer)potentials.get((Object)tempType);
        }
        return potentialType.toString();
    }

    public DataType parse(String field) {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        Object result = null;
        try {
            result = new Integer(field);
            return DataType.NUMBER;
        }
        catch (NumberFormatException e1) {
            try {
                result = new Double(field);
                return DataType.NUMBER;
            }
            catch (NumberFormatException e2) {
                try {
                    result = sdf.parse(field);
                    return DataType.DATE;
                }
                catch (ParseException e3) {
                    result = field;
                    return DataType.VARCHAR2;
                }
            }
        }
    }

    @Override
    public int getWidth(int columnPosition) {
        if (this.m_columnWidths == null) {
            this.getPreviewRows();
        }
        if (columnPosition > this.m_columnWidths.length - 1) {
            return 0;
        }
        return this.m_columnWidths[columnPosition];
    }

    @Override
    public int getNosPages() {
        return 1;
    }

    @Override
    public String[] getPageNames() {
        return null;
    }

    @Override
    public String getPageLabel() {
        return null;
    }

    @Override
    public void setPage(int pageid) {
    }

    @Override
    public Object[] readline() throws DataFormatException {
        return this.splitRow(this.m_currentRow);
    }

    private String readLine(BufferedReader reader) throws IOException {
        String recordTerminator = this.dataFormat.getRecordTerminatorValue(this.dataFormat.getRecordTerminator());
        if (!(recordTerminator.equalsIgnoreCase("\r\n") || recordTerminator.equals("\n") || recordTerminator.equals("\r"))) {
            StringBuffer phys_record;
            block3: {
                char[] buffer = new char[1];
                int num_read = reader.read(buffer);
                if (num_read == -1) {
                    return null;
                }
                int totalChars = num_read;
                phys_record = new StringBuffer();
                String phys_record_end = "";
                phys_record.append(buffer);
                do {
                    num_read = reader.read(buffer);
                    totalChars += num_read;
                    if (num_read == -1) break block3;
                    phys_record.append(buffer);
                } while (phys_record.length() < recordTerminator.length() || recordTerminator.length() <= 0 || !(phys_record_end = phys_record.substring(phys_record.length() - recordTerminator.length(), phys_record.length())).equals(recordTerminator));
                return phys_record.substring(0, phys_record.length() - recordTerminator.length());
            }
            return phys_record.length() == 0 ? null : phys_record.toString();
        }
        return reader.readLine();
    }

    public BufferedReader openPreviewFile() {
        try {
            if (this.m_previewBuffers == null) {
                this.m_previewFileEOF = false;
                this.m_previewBuffers = new ArrayList<byte[]>();
                File previewFile = new File(this.getFileName());
                this.m_previewFileSize = (int)previewFile.length();
                this.m_previewFileInputStream = new FileInputStream(previewFile);
                int prefLimit = this.dataFormat.getPreviewCharactersLimit();
                int n = this.m_previewMaxLength = prefLimit != 0 ? prefLimit : 1024;
                if (previewFile.length() < (long)this.m_previewMaxLength || !this.dataFormat.getUseMaxLength()) {
                    this.m_previewMaxLength = this.m_previewFileSize;
                }
                this.m_previewToReadCount = this.m_previewMaxLength;
                int n2 = this.m_bufferSize = prefLimit > 0 && prefLimit < 1024 ? prefLimit : 1024;
                if (previewFile.length() < (long)this.m_bufferSize) {
                    this.m_bufferSize = (int)previewFile.length();
                }
                this.m_currentPreviewBuffer = -1;
                this.readPreviewFile(this.m_bufferSize);
            }
            if (!this.m_previewBuffers.isEmpty()) {
                return this.getPreviewReader(0);
            }
        }
        catch (FileNotFoundException e) {
            this.fireSimpleEvent(ImportResources.getString("CSVREADER_FILE_NOT_FOUND"));
        }
        return null;
    }

    public void restartPreview() {
        if (this.m_previewBuffers == null) {
            this.m_previewReader = this.openPreviewFile();
        } else if (!this.m_previewBuffers.isEmpty()) {
            this.m_currentPreviewBuffer = 0;
            this.m_previewReader = this.getPreviewReader(0);
        }
    }

    private BufferedReader getNextPreviewBuffer() {
        if (this.m_previewBuffers.size() > this.m_currentPreviewBuffer + 1) {
            return this.getPreviewReader(++this.m_currentPreviewBuffer);
        }
        if (!this.m_previewFileEOF && this.m_previewToReadCount > 0) {
            int bufferSize = this.m_previewToReadCount > this.m_bufferSize ? this.m_bufferSize : this.m_previewToReadCount;
            this.readPreviewFile(bufferSize);
            return !this.m_previewFileEOF ? this.getPreviewReader(this.m_currentPreviewBuffer) : null;
        }
        this.m_previewFileEOF = true;
        return null;
    }

    private BufferedReader getPreviewReader(int buffer) {
        try {
            ByteArrayInputStream baInputStream = new ByteArrayInputStream(this.m_previewBuffers.get(buffer));
            this.m_encoding = this.dataFormat.getEncoding();
            this.m_previewStreamReader = new InputStreamReader((InputStream)baInputStream, this.m_encoding);
            return new BufferedReader(this.m_previewStreamReader);
        }
        catch (UnsupportedEncodingException uee) {
            String msg = ImportResources.format("ENCODING_ERROR", this.m_encoding);
            MessageHandler.information(null, (String)msg, (String)ImportResources.getString("TASK_SHORT_NAME"), null);
        }
        catch (Exception e) {
            String msg = ImportResources.format("ENCODING_ERROR", this.m_encoding);
            MessageHandler.information(null, (String)msg, (String)ImportResources.getString("TASK_SHORT_NAME"), null);
        }
        return null;
    }

    private boolean readPreviewFile(int bufferSize) {
        int previewReadCount = 0;
        try {
            byte[] buffer = new byte[bufferSize];
            if (this.m_previewFileInputStream != null) {
                previewReadCount = this.m_previewFileInputStream.read(buffer);
            }
            if (previewReadCount > 0) {
                this.m_previewToReadCount -= previewReadCount;
                this.m_previewBuffers.add(buffer);
                ++this.m_currentPreviewBuffer;
                return this.m_previewFileEOF;
            }
        }
        catch (IOException e) {
            Logger.warn(this.getClass(), (Throwable)e);
        }
        this.m_previewFileEOF = true;
        this.closePreviewFile();
        return this.m_previewFileEOF;
    }

    public void closePreviewFile() {
        try {
            if (this.m_previewFileInputStream != null) {
                this.m_previewFileInputStream.close();
                this.m_previewFileInputStream = null;
            }
        }
        catch (IOException e) {
            Logger.warn(this.getClass(), (Throwable)e);
        }
        try {
            if (this.m_previewReader != null) {
                this.m_previewReader.close();
                this.m_previewReader = null;
            }
        }
        catch (IOException e) {
            Logger.warn(this.getClass(), (Throwable)e);
        }
        try {
            if (this.m_previewStreamReader != null) {
                this.m_previewStreamReader.close();
                this.m_previewStreamReader = null;
            }
        }
        catch (IOException e) {
            Logger.warn(this.getClass(), (Throwable)e);
        }
    }

    @Override
    public List<Object[]> getPreviewRows() {
        this.m_currentRow = null;
        this.m_previewReadAheadBuffer = new char[1];
        this.m_previewReadAheadNumRead = -1;
        this.m_terminatorFound = false;
        this.m_terminatorValue = this.dataFormat.getRecordTerminatorValue();
        this.m_isCheckTerminator = true;
        this.m_isStandardTerm = BaseDataFormat.isRecordTerminatorStandard(this.dataFormat.getRecordTerminator());
        this.m_previewTruncate = false;
        if (!this.m_refreshPreview && this.m_previewRows != null && this.dataFormat.getUsePreviewLimit()) {
            return this.m_previewRows;
        }
        String line = null;
        String[] row = null;
        this.m_dataFormatException = null;
        this.m_dataFormatExceptionRow = -1;
        ArrayList<Object[]> previewRows = new ArrayList<Object[]>();
        if (this.m_previewBuffers == null) {
            this.m_previewReader = this.openPreviewFile();
        } else {
            this.restartPreview();
        }
        try {
            this.m_firstRow = null;
            this.m_columnWidthsList = new ArrayList();
            if (this.dataFormat.getSkipRows() != 0) {
                int skipRows = this.dataFormat.isHeader() ? this.dataFormat.getSkipRows() + 1 : this.dataFormat.getSkipRows();
                for (int i = 0; i < skipRows && (line = this.readPreviewLine(previewRows.isEmpty())) != null; ++i) {
                    block25: {
                        if (!this.dataFormat.isHeader() || (this.dataFormat.isHeaderAfter() || i != 0) && (!this.dataFormat.isHeaderAfter() || i != skipRows - 1)) continue;
                        try {
                            row = this.splitRow(line);
                        }
                        catch (DataFormatException e) {
                            if (this.m_dataFormatException != null) break block25;
                            this.m_dataFormatException = e;
                            this.m_dataFormatExceptionRow = 1;
                            row = this.m_dataFormatException.getColumns();
                        }
                    }
                    previewRows.add(row);
                }
            }
            for (int i = 0; !((line = this.readPreviewLine(previewRows.isEmpty())) == null || this.dataFormat.getUsePreviewLimit() && i >= this.dataFormat.getPreviewLimit()); ++i) {
                try {
                    row = this.splitRow(line);
                }
                catch (DataFormatException e) {
                    if (this.m_dataFormatException == null) {
                        this.m_dataFormatException = e;
                        this.m_dataFormatExceptionRow = i + 1;
                    }
                    row = e.getColumns();
                }
                previewRows.add(row);
                if (!this.m_refreshPreview || this.dataFormat.isHeader() && i == 0) continue;
                this.setColumnWidths(row);
            }
        }
        catch (IOException e) {
            Logger.warn(this.getClass(), (Throwable)e);
        }
        if (!previewRows.isEmpty()) {
            this.m_firstRow = (String[])previewRows.get(0);
        }
        if (this.m_refreshPreview) {
            this.m_columnWidths = this.m_columnWidthsList.toArray(new Integer[this.m_columnWidthsList.size()]);
            this.m_refreshPreview = false;
        }
        if (this.dataFormat.getUsePreviewLimit()) {
            this.m_previewRows = previewRows;
        }
        if (this.m_showPreviewMessages && this.m_dataFormatException != null) {
            SwingUtilities.invokeLater(new Runnable(){
                String msg;
                {
                    this.msg = ImportResources.format("DATA_FORMAT_EXCEPTION_FILE", DelimitedReader.this.m_dataFormatExceptionRow) + DelimitedReader.this.m_dataFormatException.getMessage() + "\n" + ImportResources.getString("DATA_FORMAT_EXCEPTION_LINE") + "\n" + DelimitedReader.this.m_dataFormatException.getLine() + "\n";
                }

                @Override
                public void run() {
                    MessageHandler.information(null, (String)this.msg, (String)ImportResources.getString("DATA_FORMAT_TITLE"), null);
                }
            });
        }
        if (this.m_isStandardTerm || !this.m_terminatorValue.equals(this.dataFormat.getRecordTerminatorValue())) {
            this.m_saveTerminator = this.dataFormat.getRecordTerminator();
            if (this.m_terminatorValue.equals("\n")) {
                this.dataFormat.setRecordTerminator(DataToolsResources.getString("LF"));
            } else if (this.m_terminatorValue.equals("\r\n")) {
                this.dataFormat.setRecordTerminator(DataToolsResources.getString("CRLF"));
            } else if (this.m_terminatorValue.equals("\r")) {
                this.dataFormat.setRecordTerminator(DataToolsResources.getString("CR"));
            }
            if (this.m_showPreviewMessages && !this.m_isStandardTerm) {
                SwingUtilities.invokeLater(new Runnable(){
                    String msg;
                    {
                        this.msg = ImportResources.format("RECORD_TERM_INFO", DelimitedReader.this.dataFormat.getRecordTerminator(), DelimitedReader.this.m_saveTerminator);
                    }

                    @Override
                    public void run() {
                        MessageHandler.information(null, (String)this.msg, (String)ImportResources.getString("RECORD_TERM_TITLE"), null);
                    }
                });
            }
        }
        if (!this.dataFormat.getUsePreviewLimit()) {
            return previewRows;
        }
        return this.m_previewRows;
    }

    private String readPreviewLine(boolean isPreviewEmpty) throws IOException {
        StringBuilder phys_record;
        block14: {
            if (this.m_previewReader == null) {
                return null;
            }
            phys_record = new StringBuilder();
            StringBuilder termCompare = new StringBuilder(this.m_terminatorValue.length());
            char[] buffer = new char[1];
            int totalChars = 0;
            int numRead = -1;
            while (termCompare.length() < this.m_terminatorValue.length()) {
                if (this.m_previewReadAheadNumRead != -1) {
                    numRead = this.m_previewReadAheadNumRead;
                    buffer = this.m_previewReadAheadBuffer;
                    this.m_previewReadAheadNumRead = -1;
                } else {
                    numRead = this.readPreviewChars(buffer);
                }
                if (numRead == -1) {
                    if (this.dataFormat.getIsFileFragment() && !isPreviewEmpty) {
                        return null;
                    }
                    return phys_record.length() == 0 ? null : phys_record.toString();
                }
                totalChars += numRead;
                phys_record.append(buffer);
                termCompare.append(buffer);
                if (termCompare.lastIndexOf(this.m_terminatorValue) == -1) continue;
                phys_record = new StringBuilder();
                termCompare = new StringBuilder(this.m_terminatorValue.length());
                totalChars = 0;
            }
            do {
                if (this.m_previewReadAheadNumRead != -1) {
                    numRead = this.m_previewReadAheadNumRead;
                    buffer = this.m_previewReadAheadBuffer;
                    this.m_previewReadAheadNumRead = -1;
                } else {
                    numRead = this.readPreviewChars(buffer);
                }
                totalChars += numRead;
                if (numRead == -1) break block14;
                if (this.m_isCheckTerminator) {
                    if (buffer[0] == "\r".charAt(0)) {
                        this.m_previewReadAheadNumRead = this.readPreviewChars(this.m_previewReadAheadBuffer);
                        if (this.m_previewReadAheadNumRead != -1 && this.m_previewReadAheadBuffer[0] == "\n".charAt(0)) {
                            this.m_terminatorValue = "\r\n";
                            termCompare = new StringBuilder(2);
                            termCompare.append(buffer);
                            termCompare.append(this.m_previewReadAheadBuffer);
                            this.m_previewReadAheadNumRead = -1;
                            phys_record.append(buffer);
                            phys_record.append(this.m_previewReadAheadBuffer);
                            continue;
                        }
                        this.m_terminatorValue = "\r";
                        termCompare = new StringBuilder(1);
                        termCompare.append(buffer);
                        phys_record.append(buffer);
                        continue;
                    }
                    if (buffer[0] == "\n".charAt(0)) {
                        this.m_terminatorValue = "\n";
                        termCompare = new StringBuilder(1);
                        termCompare.append(buffer);
                        phys_record.append(buffer);
                        continue;
                    }
                    phys_record.append(buffer);
                    termCompare.deleteCharAt(0);
                    termCompare.append(buffer);
                    continue;
                }
                phys_record.append(buffer);
                termCompare.deleteCharAt(0);
                termCompare.append(buffer);
            } while (termCompare.lastIndexOf(this.m_terminatorValue) == -1);
            this.m_isCheckTerminator = false;
            this.m_terminatorFound = true;
            return phys_record.substring(0, phys_record.length() - this.m_terminatorValue.length());
        }
        if (this.dataFormat.getIsFileFragment() && !isPreviewEmpty) {
            return null;
        }
        return phys_record.length() == 0 ? null : phys_record.toString();
    }

    private int readPreviewChars(char[] buffer) {
        try {
            int numRead = this.m_previewReader.read(buffer);
            if (numRead != -1) {
                return numRead;
            }
            if (!this.m_terminatorFound && !this.m_recTermList.contains(this.dataFormat.getRecordTerminator()) && this.m_currentPreviewBuffer == 49) {
                this.m_recTermList.add(this.dataFormat.getRecordTerminator());
                String maxSizeMsg = this.dataFormat.getUseMaxLength() ? ImportResources.format("MAX_SIZE_SET", Integer.valueOf(this.dataFormat.getMaxLength()).toString()) : ImportResources.getString("MAX_SIZE_NOT_SET");
                String msg = ImportResources.format("PREVIEW_ERROR", this.dataFormat.getRecordTerminator(), 50, maxSizeMsg, this.m_previewFileSize);
                if (!this.confirm(msg)) {
                    this.m_previewTruncate = true;
                    return numRead;
                }
            }
            if (!this.m_previewTruncate) {
                this.m_previewReader = this.getNextPreviewBuffer();
                if (this.m_previewReader != null) {
                    return this.m_previewReader.read(buffer);
                }
            }
            return numRead;
        }
        catch (IOException e) {
            Logger.warn(this.getClass(), (Throwable)e);
            return -1;
        }
    }

    private boolean confirm(String msg) {
        return MessageHandler.confirm(null, (String)msg, (String)ImportResources.getString("TASK_SHORT_NAME"), null);
    }

    @Override
    public boolean isLineTerminatorSupported() {
        return true;
    }

    @Override
    public boolean isDelimiterSupported() {
        return true;
    }

    @Override
    public boolean isDelimiterConfigurable() {
        return true;
    }

    @Override
    public boolean isEnclosuresSupported() {
        return true;
    }

    public String getHeaderConfigKey() {
        return KEY_HEADER;
    }

    @Override
    public String getDelimiterConfigKey() {
        return KEY_DELIMITER;
    }

    @Override
    public String getLineTerminatorConfigKey() {
        return KEY_REC_TERM;
    }

    @Override
    public String getEnclosureLeftConfigKey() {
        return KEY_ENCL_LEFT;
    }

    @Override
    public String getEnclosureRightConfigKey() {
        return KEY_ENCL_RIGHT;
    }

    @Override
    public String getEnclosureRightDoubleConfigKey() {
        return KEY_ENCL_RIGHT_DOUBLE;
    }

    static {
        ImportDataFormatConfig.DefaultInitializer.init();
        FORMAT = BaseDataFormat.DELIMITED;
    }
}

