/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.importer.readers;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import oracle.dbtools.data.model.LoadField;
import oracle.dbtools.data.model.LoadFile;
import oracle.dbtools.data.readservice.DataFormatException;
import oracle.dbtools.importer.ImportResources;
import oracle.dbtools.importer.core.ImportDataFormat;
import oracle.dbtools.importer.readers.DataReaderEvent;
import oracle.dbtools.importer.readers.DataReaderException;
import oracle.dbtools.importer.readers.DataReaderListener;
import oracle.dbtools.importer.readers.IDataReadable;

public abstract class DataReader
implements IDataReadable {
    public static String NAME;
    public static String EXT;
    private String m_filename;
    private ArrayList<DataReaderListener> m_listeners = new ArrayList();
    private String defColumn = ImportResources.getString("DEFAULT_COLUMN_PREFIX");
    protected String[] m_defaultColumnNames;
    protected String[] m_headerRowColumnNames;
    private String[] m_userDefaultColumnNames;
    private boolean m_isUserDefaultColumnNames = false;
    protected boolean m_refreshPreview = true;
    protected boolean m_showPreviewMessages = true;
    protected ImportDataFormat dataFormat;
    private int m_headerLocation = 0;

    @Override
    public abstract List<Object[]> getPreviewRows();

    @Override
    public void setDataFormat(ImportDataFormat importDataFormat) {
        this.dataFormat = importDataFormat;
    }

    @Override
    public void setFileName(String filename) throws DataReaderException {
        this.m_filename = filename;
        this.openFile(filename);
    }

    @Override
    public String getFileName() {
        return this.m_filename;
    }

    @Override
    public void fireListeners(DataReaderEvent event) {
        for (DataReaderListener listener : this.getListeners()) {
            listener.raiseEvent(event);
        }
    }

    @Override
    public void fireSimpleEvent(String message) {
        DataReaderEvent event = new DataReaderEvent(message);
        this.fireListeners(event);
    }

    @Override
    public ArrayList<DataReaderListener> getListeners() {
        if (this.m_listeners == null) {
            this.m_listeners = new ArrayList();
        }
        return this.m_listeners;
    }

    @Override
    public void addListener(DataReaderListener listener) {
        this.getListeners().add(listener);
    }

    @Override
    public TableModel getTableModel() {
        DefaultTableModel model = new DefaultTableModel();
        List<Object[]> list = null;
        list = this.getPreviewRows();
        Iterator<Object[]> it = list.iterator();
        if (it.hasNext()) {
            if (this.dataFormat.isHeader()) {
                it.next();
            }
            String[] colNames = this.getColumnNames();
            for (int i = 0; i < colNames.length; ++i) {
                model.addColumn(colNames[i]);
            }
        }
        while (it.hasNext()) {
            model.addRow(it.next());
        }
        return model;
    }

    @Override
    public void createFields(LoadFile file) {
        List<Object[]> list = null;
        file.removeFields();
        list = this.getPreviewRows();
        Iterator<Object[]> it = list.iterator();
        if (it.hasNext()) {
            if (this.dataFormat.isHeader()) {
                it.next();
            }
            String[] colNames = this.getColumnNames();
            for (int i = 0; i < colNames.length; ++i) {
                LoadField field = new LoadField();
                field.setName(colNames[i]);
                field.setFormat("");
                field.setLength(this.getWidth(i));
                field.isLoad(true);
                field.isCompatible(false);
                field.isChecked(false);
                file.addField(field);
            }
        }
    }

    @Override
    public void refreshPreview(boolean reset) {
        this.m_refreshPreview = reset;
    }

    @Override
    public boolean refreshPreview() {
        return this.m_refreshPreview;
    }

    @Override
    public void showPreviewMessages(boolean show) {
        this.m_showPreviewMessages = show;
    }

    @Override
    public void setDefaultColumnNames(String[] columnNames) {
        this.m_userDefaultColumnNames = columnNames;
        this.m_isUserDefaultColumnNames = true;
    }

    public boolean isUserDefaultColumnNames() {
        return this.m_isUserDefaultColumnNames;
    }

    public String[] getUserDefaultColumnNames() {
        return this.m_userDefaultColumnNames;
    }

    @Override
    public String[] getDefaultColumnNames() {
        ArrayList<CallSite> names = new ArrayList<CallSite>();
        for (int i = 0; i < this.getColumnCount(); ++i) {
            names.add((CallSite)((Object)(this.getDefColumn() + (i + 1))));
        }
        this.m_defaultColumnNames = names.toArray(new String[names.size()]);
        return this.m_defaultColumnNames;
    }

    public String getDefColumn() {
        return this.defColumn.toUpperCase();
    }

    public void setDefColumn(String defColumn) {
        this.defColumn = defColumn;
    }

    @Override
    public abstract Object[] readline() throws DataFormatException;

    @Override
    public String readCurrentLine() throws DataFormatException {
        return "";
    }

    @Override
    public boolean isOracleLoaderReadable() {
        return true;
    }

    @Override
    public boolean isEncodingAllowed() {
        return true;
    }

    public boolean isHeaderOptionSupported() {
        return true;
    }

    public boolean isHeader() {
        return this.dataFormat != null ? this.dataFormat.isHeader() : false;
    }

    @Override
    public boolean isSkipSupported() {
        return true;
    }

    @Override
    public boolean isPreviewLimitSupported() {
        return true;
    }

    @Override
    public boolean isHeaderLocationSupported() {
        return true;
    }

    @Override
    public int getHeaderLocation() {
        return this.m_headerLocation;
    }

    @Override
    public void setHeaderLocation(int headerLocation) {
        this.m_headerLocation = headerLocation;
    }

    public boolean isLineTerminatorSupported() {
        return false;
    }

    public String getLineTerminator() {
        return this.dataFormat != null ? this.dataFormat.getRecordTerminator() : "";
    }

    public String getLineTerminatorConfigKey() {
        return "";
    }

    public boolean isDelimiterSupported() {
        return false;
    }

    public boolean isDelimiterConfigurable() {
        return false;
    }

    public String getDefaultDelimiter() {
        return "";
    }

    public String getDelimiter() {
        return this.dataFormat != null ? this.dataFormat.getDelimiter() : "";
    }

    public String getDelimiterConfigKey() {
        return "";
    }

    public boolean isEnclosuresSupported() {
        return false;
    }

    public boolean isEnclosed() {
        return this.dataFormat != null ? this.dataFormat.getEnclosures() : false;
    }

    public String getEnclosureLeft() {
        return this.dataFormat != null ? this.dataFormat.getEnclosureLeft() : "";
    }

    public String getEnclosureRight() {
        return this.dataFormat != null ? this.dataFormat.getEnclosureRight() : "";
    }

    public String getEnclosuresConfigKey() {
        return "";
    }

    public String getEnclosureLeftConfigKey() {
        return "";
    }

    public String getEnclosureRightConfigKey() {
        return "";
    }

    public String getEnclosureRightDoubleConfigKey() {
        return "";
    }

    public boolean isEnclosureRightDoubleConfigurable() {
        return true;
    }
}

