/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extract.models;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.dbtools.common.utils.BasicDBObject;
import oracle.dbtools.db.ConnectionResolver;
import oracle.dbtools.extract.models.ExtractConnectionAccess;
import oracle.dbtools.extract.models.ExtractObject;

public class ExtractConnectionAccessCatalog {
    ArrayList<ExtractConnectionAccess> _connAccessCatalog = new ArrayList();

    public ExtractConnectionAccessCatalog(List<ExtractObject> objects) {
        this(objects, true);
    }

    public ExtractConnectionAccessCatalog(List<ExtractObject> objects, boolean setSpatial) {
        for (ExtractObject EO : objects) {
            BasicDBObject dbo = EO.getDBObject();
            if (this.contains(dbo)) continue;
            ExtractConnectionAccess connAccess = new ExtractConnectionAccess(dbo);
            if (setSpatial && ConnectionResolver.isOracle((Connection)connAccess.getConnection())) {
                connAccess.setSchemaSpatial();
            }
            this._connAccessCatalog.add(connAccess);
        }
    }

    public Collection<ExtractConnectionAccess> getExtractConnectionAccessCatalog() {
        return this._connAccessCatalog;
    }

    public List<Connection> getConnections() {
        ArrayList<Connection> conns = new ArrayList<Connection>();
        for (ExtractConnectionAccess ecs : this._connAccessCatalog) {
            if (conns.contains(ecs.getConnection())) continue;
            conns.add(ecs.getConnection());
        }
        return conns;
    }

    public int size() {
        return this._connAccessCatalog.size();
    }

    public boolean contains(BasicDBObject dbo) {
        for (ExtractConnectionAccess connAccess : this._connAccessCatalog) {
            if (!connAccess.getConnectionName().equals(dbo.getConnectionName()) || !connAccess.getDbName().equals(dbo.getCatalog()) || !connAccess.getSchemaName().equals(dbo.getSchemaName())) continue;
            return true;
        }
        return false;
    }

    public boolean isSchemaSpatial(BasicDBObject dbo) {
        for (ExtractConnectionAccess connAccess : this._connAccessCatalog) {
            if (!connAccess.getConnectionName().equals(dbo.getConnectionName()) || !connAccess.getDbName().equals(dbo.getCatalog()) || !connAccess.getSchemaName().equals(dbo.getSchemaName())) continue;
            return connAccess.isSchemaSpatial();
        }
        return false;
    }
}

