/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extract;

import java.io.File;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;
import oracle.dbtools.common.ddl.DDLFormat;
import oracle.dbtools.common.ddl.DDLGenerator;
import oracle.dbtools.common.ddl.DDLTypes;
import oracle.dbtools.common.utils.BasicDBObject;
import oracle.dbtools.db.ConnectionResolver;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.extract.ExtractResources;
import oracle.dbtools.extract.models.ExtractDataFormat;
import oracle.dbtools.extract.models.ExtractListModel;
import oracle.dbtools.extract.models.ExtractObject;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskProgressUpdater;

public class ExtractReconciler {
    ExtractListModel _listModel;
    private static final Logger LOGGER = Logger.getLogger(ExtractReconciler.class.getName());

    public ExtractReconciler(ExtractListModel listModel) {
        this._listModel = listModel;
    }

    public void reconcileTypesAndObjects(int opt) {
        try {
            this.reconcileTypesAndObjects(opt, null);
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    /*
     * Could not resolve type clashes
     */
    public void reconcileTypesAndObjects(int opt, IRaptorTaskProgressUpdater progressUpdater) throws ExecutionException {
        DDLTypes ddlTypes = this._listModel.getDDLTypes();
        DDLFormat ddlFormat = this._listModel.getDDLFormat();
        boolean _cancel = false;
        Map<String, String> types = ddlTypes.getTypes(this._listModel.isDataEnabled());
        ArrayList metaObjects = (ArrayList)this._listModel.getListURLs(0, new int[]{108});
        ArrayList dataObjects = (ArrayList)this._listModel.getListURLs(0, new int[]{109});
        ArrayList metaTableObjects = (ArrayList)this._listModel.getURLListForType(metaObjects, "TABLE");
        ArrayList metaViewObjects = (ArrayList)this._listModel.getURLListForType(metaObjects, "VIEW");
        String dbName = null;
        Connection conn = null;
        String user = null;
        if (opt == 103) {
            dbName = this._listModel.getSourceConnName();
            conn = this._listModel.getSourceConn();
            user = this._listModel.getSourceConnUser();
        } else if (opt == 104 && this._listModel.getDestConn() != null) {
            dbName = this._listModel.getDestConnName();
            conn = this._listModel.getDestConn();
            user = this._listModel.getDestConnUser();
        } else {
            return;
        }
        String[] schemas = new String[]{""};
        if (this._listModel.getSchemas().length > 0 || this._listModel.getTablespaces() != null && this._listModel.getTablespaces().length > 0) {
            schemas = this._listModel.getSchemas();
        } else {
            schemas[0] = user;
        }
        for (String schema : schemas) {
            for (String key : types.keySet()) {
                List<URL> list;
                this.taskProgress(progressUpdater);
                String tKey = types.get(key);
                String progressMsg = ExtractResources.format("RECONCILE_PROGRESS", DDLTypes.getFolderName(key));
                if (key.equals("DATA")) {
                    Object newKey = key;
                    String[] exportDataTypes = new String[DDLTypes.DATA_OBJECT_TYPES.length];
                    int i = 0;
                    if (ddlTypes.getTable()) {
                        exportDataTypes[i++] = "TABLE";
                    }
                    if (ddlTypes.getView() && this.isExportViews(dataObjects, "VIEW")) {
                        exportDataTypes[i++] = "VIEW";
                    }
                    if (ddlTypes.getMatView() && this.isExportViews(dataObjects, "MATERIALIZED VIEW")) {
                        exportDataTypes[i++] = "MATERIALIZED VIEW";
                    }
                    boolean isTaskProgress = true;
                    for (i = 0; i < exportDataTypes.length && exportDataTypes[i] != null; ++i) {
                        List<URL> list2;
                        newKey = "TABLE";
                        tKey = types.get("TABLE");
                        if (exportDataTypes[i].equals("VIEW")) {
                            newKey = "VIEW";
                            tKey = types.get("VIEW");
                        } else if (exportDataTypes[i].equals("MATERIALIZED VIEW")) {
                            newKey = "MATERIALIZED VIEW";
                            tKey = types.get("MATERIALIZED VIEW");
                        }
                        if (isTaskProgress) {
                            isTaskProgress = false;
                            this.taskProgress(progressMsg, progressUpdater);
                        } else {
                            this.taskProgress(progressUpdater);
                        }
                        if (this._listModel.isExistsForType(dataObjects, exportDataTypes[i])) {
                            list2 = this._listModel.getURLListForType(dataObjects, exportDataTypes[i]);
                            for (URL u : list2) {
                                BasicDBObject x = this.getDBObject(u);
                                this._listModel.getOrAddExtractObject(x, new int[]{101, opt});
                            }
                            continue;
                        }
                        list2 = null;
                        list2 = this._listModel.getTablespaces() == null ? DDLGenerator.getInstance().getSchemaObjects(conn, schema, (String)newKey, tKey) : this.getTablespaceScemaObjects(conn, schema, (String)newKey);
                        if (list2 == null) continue;
                        for (BasicDBObject o : list2) {
                            this._listModel.getOrAddExtractObject(o, new int[]{101, opt});
                        }
                    }
                    continue;
                }
                if (ddlFormat.isExtractEnabled() && (key.equals("CONSTRAINT") || key.equals("REFCONSTRAINT")) && metaTableObjects.size() > 0) {
                    this.taskProgress(progressMsg, progressUpdater);
                    for (URL u : metaTableObjects) {
                        this.taskProgress(progressUpdater);
                        BasicDBObject x = this.getDBObject(u);
                        BasicDBObject o = BasicDBObject.builder().connName(dbName).schema(x.getSchemaName()).objectType(key).objectName(x.getObjectName()).build();
                        this._listModel.getOrAddExtractObject(o, new int[]{100, opt});
                    }
                    continue;
                }
                if (ddlFormat.isExtractEnabled() && key.equals("TRIGGER") && metaTableObjects.size() > 0) {
                    this.taskProgress(progressMsg, progressUpdater);
                    for (URL u : metaTableObjects) {
                        this.taskProgress(progressUpdater);
                        BasicDBObject x = this.getDBObject(u);
                        List<BasicDBObject> trigs = this.getTriggerFilter(conn, x.getSchemaName(), x.getObjectName());
                        for (BasicDBObject o : trigs) {
                            this._listModel.getOrAddExtractObject(o, new int[]{100, opt});
                            this.addDependents(o, opt);
                        }
                    }
                    continue;
                }
                if (ddlFormat.isExtractEnabled() && key.equals("TRIGGER") && metaViewObjects.size() > 0) {
                    this.taskProgress(progressMsg, progressUpdater);
                    for (URL u : metaViewObjects) {
                        this.taskProgress(progressUpdater);
                        BasicDBObject x = this.getDBObject(u);
                        List<BasicDBObject> trigs = this.getTriggerFilter(conn, x.getSchemaName(), x.getObjectName());
                        for (BasicDBObject o : trigs) {
                            this._listModel.getOrAddExtractObject(o, new int[]{100, opt});
                            this.addDependents(o, opt);
                        }
                    }
                    continue;
                }
                if (ddlFormat.isExtractEnabled() && key.equals("INDEX") && metaTableObjects.size() > 0) {
                    this.taskProgress(progressMsg, progressUpdater);
                    for (URL u : metaTableObjects) {
                        this.taskProgress(progressUpdater);
                        BasicDBObject x = this.getDBObject(u);
                        List<BasicDBObject> trigs = this.getIndexFilter(conn, x.getSchemaName(), x.getObjectName());
                        for (BasicDBObject o : trigs) {
                            this._listModel.getOrAddExtractObject(o, new int[]{100, opt});
                            this.addDependents(o, opt);
                        }
                    }
                    continue;
                }
                if (this._listModel.isExistsForType(metaObjects, key) && ddlFormat.isExtractEnabled()) {
                    this.taskProgress(progressMsg, progressUpdater);
                    list = this._listModel.getURLListForType(metaObjects, key);
                    for (URL u : list) {
                        this.taskProgress(progressUpdater);
                        BasicDBObject o = this.getDBObject(u);
                        this._listModel.getOrAddExtractObject(o, new int[]{100, opt});
                        this.addDependents(o, opt);
                    }
                    continue;
                }
                if (!ddlFormat.isExtractEnabled()) continue;
                this.taskProgress(progressMsg, progressUpdater);
                list = this._listModel.getTablespaces() == null ? DDLGenerator.getInstance().getSchemaObjects(conn, schema, key, tKey) : this.getTablespaceScemaObjects(conn, schema, key);
                if (list == null) continue;
                for (BasicDBObject o : list) {
                    this.taskProgress(progressUpdater);
                    this._listModel.getOrAddExtractObject(o, new int[]{100, opt});
                    this.addDependents(o, opt);
                }
            }
        }
    }

    public void reconcileObjects(int opt) {
        try {
            this.reconcileObjects(opt, -1, null);
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    public void reconcileObjects(int opt, IRaptorTaskProgressUpdater progressUpdater) throws ExecutionException {
        this.reconcileObjects(opt, -1, progressUpdater);
    }

    public void reconcileObjects(int optSrcDest, int optRestrictList, IRaptorTaskProgressUpdater progressUpdater) throws ExecutionException {
        DDLTypes ddlTypes = this._listModel.getDDLTypes();
        DDLFormat ddlFormat = this._listModel.getDDLFormat();
        boolean _cancel = false;
        Map<String, String> types = ddlTypes.getTypes(this._listModel.isDataEnabled());
        ArrayList metaTableEOs = optRestrictList < 0 ? (ArrayList)this._listModel.getListForType(this._listModel.getList(0, new int[]{100}), "TABLE") : (ArrayList)this._listModel.getListForType(ExtractListModel.getList(this._listModel.getList(0, new int[]{optRestrictList}), new int[]{100}), "TABLE");
        String dbName = null;
        Connection conn = null;
        for (String key : types.keySet()) {
            List<BasicDBObject> trigs;
            BasicDBObject x;
            this.taskProgress(progressUpdater);
            String progressMsg = ExtractResources.format("RECONCILE_PROGRESS", DDLTypes.getFolderName(key));
            if (ddlFormat.isExtractEnabled() && (key.equals("CONSTRAINT") || key.equals("REFCONSTRAINT")) && metaTableEOs.size() > 0) {
                this.taskProgress(progressMsg, progressUpdater);
                for (ExtractObject EO : metaTableEOs) {
                    if (!EO.isTypeDBO() && (!EO.isTypeDataFile() || EO.getDBObject() == null) || (dbName = EO.getSourceConnName()) == null || dbName.isEmpty()) continue;
                    x = this.getDBObject(EO.getUrl());
                    BasicDBObject o = BasicDBObject.builder().connName(dbName).schema(x.getSchemaName()).objectType(key).objectName(x.getObjectName()).build();
                    this._listModel.getOrAddExtractObject(o, new int[]{100, optSrcDest});
                }
                continue;
            }
            if (ddlFormat.isExtractEnabled() && ddlFormat.getTrigger() && key.equals("TRIGGER") && metaTableEOs.size() > 0) {
                this.taskProgress(progressMsg, progressUpdater);
                for (ExtractObject EO : metaTableEOs) {
                    if (!EO.isTypeDBO() && (!EO.isTypeDataFile() || EO.getDBObject() == null) || (conn = EO.getSourceConn()) == null) continue;
                    x = this.getDBObject(EO.getUrl());
                    trigs = this.getTriggerFilter(conn, x.getSchemaName(), x.getObjectName());
                    for (BasicDBObject o : trigs) {
                        this._listModel.getOrAddExtractObject(o, new int[]{100, optSrcDest});
                    }
                }
                continue;
            }
            if (!ddlFormat.isExtractEnabled() || !key.equals("INDEX") || metaTableEOs.size() <= 0) continue;
            this.taskProgress(progressMsg, progressUpdater);
            for (ExtractObject EO : metaTableEOs) {
                this.taskProgress(progressUpdater);
                if (!EO.isTypeDBO() && (!EO.isTypeDataFile() || EO.getDBObject() == null) || (conn = EO.getSourceConn()) == null) continue;
                x = this.getDBObject(EO.getUrl());
                trigs = this.getIndexFilter(conn, x.getSchemaName(), x.getObjectName());
                for (BasicDBObject o : trigs) {
                    this.taskProgress(progressUpdater);
                    this._listModel.getOrAddExtractObject(o, new int[]{100, optSrcDest});
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private List<BasicDBObject> getTablespaceScemaObjects(Connection conn, String owner, String type) {
        String[] tablespaces;
        ArrayList<BasicDBObject> objects = new ArrayList<BasicDBObject>();
        String SQL_QUERY = "select o.owner,o.object_name,o.object_type from dba_segments s, dba_objects o where s.segment_type = o.object_type and s.segment_name = o.object_name and s.tablespace_name = :TABLESPACE and o.owner = :OWNER and o.object_type = :TYPE ";
        for (String ts : tablespaces = this._listModel.getTablespaces()) {
            HashMap<String, String> binds = new HashMap<String, String>();
            Object url = null;
            ResultSet rset = null;
            binds.put("OWNER", owner);
            binds.put("TABLESPACE", ts);
            binds.put("TYPE", type);
            if (!LockManager.lock((Connection)conn)) continue;
            try {
                rset = DBUtil.getInstance((Connection)conn).executeQuery(SQL_QUERY, binds);
                String dbName = ConnectionResolver.getConnectionName((Connection)conn);
                while (rset.next()) {
                    BasicDBObject dbo = BasicDBObject.builder().connName(dbName).schema(rset.getString(1)).objectType(rset.getString(3)).objectName(rset.getString(2)).build();
                    objects.add(dbo);
                }
            }
            catch (Exception exception) {
                DBUtil.closeResultSet(rset);
                LockManager.unlock((Connection)conn);
                continue;
                catch (Throwable throwable) {
                    DBUtil.closeResultSet(rset);
                    LockManager.unlock((Connection)conn);
                    throw throwable;
                }
            }
            DBUtil.closeResultSet((ResultSet)rset);
            LockManager.unlock((Connection)conn);
        }
        return objects;
    }

    public boolean reconcileExistence(List<ExtractObject> sourceEOs) throws Exception {
        return this.reconcileExistence(sourceEOs, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reconcileExistence(List<ExtractObject> sourceEOs, IRaptorTaskProgressUpdater progressUpdater) throws Exception {
        HashMap connMap = new HashMap();
        boolean isAllExist = true;
        for (ExtractObject EO : sourceEOs) {
            if (EO.isTypeDBO()) {
                String connName = EO.getSourceConnName();
                if (!connMap.containsKey(connName)) {
                    connMap.put(connName, new ArrayList());
                }
                ((ArrayList)connMap.get(connName)).add(EO);
                continue;
            }
            if (EO.isTypeDataFile()) {
                if (EO.isTypeDataFileLocal()) {
                    File file = new File(EO.getUrl().toURI());
                    if (file == null || !file.isFile() || file.isDirectory()) {
                        isAllExist = false;
                        EO.isExistsSource(false);
                        continue;
                    }
                    EO.isExistsSource(true);
                    continue;
                }
                EO.isExistsSource(true);
                continue;
            }
            if (EO.isScriptError()) {
                isAllExist = false;
                EO.isExistsSource(false);
                continue;
            }
            EO.isExistsSource(true);
        }
        for (String connName : connMap.keySet()) {
            ArrayList connEOs = (ArrayList)connMap.get(connName);
            boolean lockAcquired = false;
            Connection conn = null;
            try {
                conn = ConnectionResolver.getConnection((String)connName);
                if (conn != null && (lockAcquired = LockManager.lock((Connection)conn))) {
                    boolean isDba = ExtractReconciler.isConnDba(conn);
                    for (ExtractObject EO : connEOs) {
                        BasicDBObject dbo = EO.getDBObject();
                        String progressMsg = ExtractResources.format("EXISTS_PROGRESS", dbo.getObjectName());
                        this.taskProgress(progressMsg, progressUpdater);
                        EO.isExistsSource(ExtractReconciler.isExistsObject(conn, isDba, dbo));
                        if (!EO.isExistsSource()) {
                            isAllExist = false;
                            continue;
                        }
                        if (!EO.isScriptError()) continue;
                        isAllExist = false;
                    }
                    continue;
                }
                for (ExtractObject EO : connEOs) {
                    EO.isExistsSource(false);
                }
                isAllExist = false;
            }
            finally {
                if (conn == null || !lockAcquired) continue;
                LockManager.unlock((Connection)conn);
            }
        }
        return isAllExist;
    }

    public static boolean reconcileExistence(ExtractObject EO) {
        boolean exists;
        block9: {
            exists = true;
            if (EO.isTypeDBO()) {
                BasicDBObject dbo = EO.getDBObject();
                boolean isDba = ExtractReconciler.isConnDba(EO.getSourceConn());
                EO.isExistsSource(EO.getSourceConn() == null ? false : ExtractReconciler.isExistsObject(EO.getSourceConn(), isDba, dbo));
                exists = EO.isExistsSource();
            } else if (EO.isTypeDataFile()) {
                try {
                    if (EO.isTypeDataFileLocal()) {
                        File file = new File(EO.getUrl().toURI());
                        if (file == null || !file.isFile() || file.isDirectory()) {
                            exists = false;
                        }
                        EO.isExistsSource(exists);
                        break block9;
                    }
                    EO.isExistsSource(true);
                }
                catch (Exception e) {
                    exists = false;
                }
            } else {
                if (EO.isScriptError()) {
                    exists = false;
                }
                EO.isExistsSource(exists);
            }
        }
        return exists;
    }

    public void reconcileDestFromSource() throws ExecutionException {
        this.reconcileDestFromSource(null);
    }

    public void reconcileDestFromSource(IRaptorTaskProgressUpdater progressUpdater) throws ExecutionException {
        if (this._listModel.getDestConn() == null) {
            return;
        }
        List<ExtractObject> sourceEOs = this._listModel.getList(0);
        for (ExtractObject EO : sourceEOs) {
            BasicDBObject dbo = EO.getDBObject();
            String progressMsg = ExtractResources.format("EXISTS_PROGRESS", dbo.getObjectName());
            this.taskProgress(progressMsg, progressUpdater);
            boolean isDba = ExtractReconciler.isConnDba(this._listModel.getDestConn());
            Map dict = dbo.getDictionary();
            Object workspace = null;
            Object applicationName = null;
            String objectName = dbo.getObjectName();
            if (dict != null) {
                workspace = dict.get("WORKSPACE");
                applicationName = dict.get("APPLICATION_NAME");
                if (dbo.getObjectType().equals("APEX")) {
                    objectName = applicationName;
                }
            }
            if (this._listModel.getSchemas() != null && this._listModel.getDDLFormat() != null && this._listModel.getDDLFormat().getSchema()) {
                if (EO.isReconciledDest()) continue;
                EO.isExistsDest(ExtractReconciler.isExistsObject(this._listModel.getDestConn(), isDba, EO.getDBObject().getSchemaName(), objectName, dbo.getObjectType(), workspace != null ? (String)workspace : ""));
                EO.isReconciledDest(true);
                continue;
            }
            if (this._listModel.getDDLFormat().getIgnoreSchema()) {
                if (EO.isReconciledDest()) continue;
                EO.isExistsDest(ExtractReconciler.isExistsObject(this._listModel.getDestConn(), isDba, this._listModel.getDestConnUser(), objectName, dbo.getObjectType(), workspace != null ? (String)workspace : ""));
                EO.isReconciledDest(true);
                continue;
            }
            if (this._listModel.getDDLFormat().getUseOtherSchema() && this._listModel.getSchemas() != null && this._listModel.getSchemas().length > 0) {
                if (EO.isReconciledDest()) continue;
                EO.isExistsDest(ExtractReconciler.isExistsObject(this._listModel.getDestConn(), isDba, this._listModel.getSchemas()[0], objectName, dbo.getObjectType(), workspace != null ? (String)workspace : ""));
                EO.isReconciledDest(true);
                continue;
            }
            if (EO.isReconciledDest()) continue;
            EO.isExistsDest(ExtractReconciler.isExistsObject(this._listModel.getDestConn(), isDba, dbo.getSchemaName(), objectName, dbo.getObjectType(), workspace != null ? (String)workspace : ""));
            EO.isReconciledDest(true);
        }
    }

    public void reconcileDestListFromSource() throws ExecutionException {
        this.reconcileDestListFromSource(null);
    }

    public void reconcileDestListFromSource(IRaptorTaskProgressUpdater progressUpdater) throws ExecutionException {
        if (this._listModel.getDestExtractObjects() == null) {
            return;
        }
        List<ExtractObject> sourceEOs = this._listModel.getList(0);
        for (ExtractObject EO : sourceEOs) {
            ExtractObject destEO;
            BasicDBObject dbo = EO.getDBObject();
            String progressMsg = ExtractResources.format("EXISTS_PROGRESS", dbo.getObjectName());
            this.taskProgress(progressMsg, progressUpdater);
            if (this._listModel.getDDLFormat().getIgnoreSchema()) {
                destEO = this._listModel.getExtractObject(this._listModel.getDestExtractObjects(), dbo.getObjectType(), dbo.getObjectName());
                if (destEO == null) continue;
                EO.isExistsDest(true);
                EO.setDestConnName(destEO.getDestConnName());
                EO.setDestConnUserName();
                continue;
            }
            destEO = this._listModel.getExtractObject(this._listModel.getDestExtractObjects(), dbo.getSchemaName(), dbo.getObjectType(), dbo.getObjectName());
            if (destEO == null) continue;
            EO.isExistsDest(true);
            EO.setDestConnName(destEO.getDestConnName());
            EO.setDestConnUserName();
        }
    }

    public void expandFolders(int listType, int[] eoOpts) throws ExecutionException {
        this.expandFolders(listType, eoOpts, null);
    }

    public void expandFolders(int listType, int[] eoOpts, IRaptorTaskProgressUpdater progressUpdater) throws ExecutionException {
        DDLTypes ddlTypes = this._listModel.getDDLTypes();
        List<ExtractObject> sourceEOs = this._listModel.getList(listType);
        for (ExtractObject EO : sourceEOs) {
            BasicDBObject dbo = EO.getDBObject();
            Map dict = dbo.getDictionary();
            Object workspace = null;
            Object applicationName = null;
            String objectName = dbo.getObjectName();
            if (objectName != null && !objectName.isEmpty()) continue;
            String progressMsg = ExtractResources.format("EXPANDING_PROGRESS", ConnectionResolver.getDisplayName((String)dbo.getConnectionName()) + "." + dbo.getSchemaName() + "." + dbo.getObjectFolderType());
            this.taskProgress(progressMsg, progressUpdater);
            if (dict != null) {
                workspace = dict.get("WORKSPACE");
                applicationName = dict.get("APPLICATION_NAME");
            }
            this._listModel.removeExtractObject(EO);
            ArrayList<BasicDBObject> list = DDLGenerator.getInstance().getSchemaObjects(dbo.getConnection(), dbo.getSchemaName(), dbo.getObjectFolderType(), ddlTypes.getTypeKey(dbo.getObjectFolderType()));
            if (list == null) continue;
            for (BasicDBObject o : list) {
                this._listModel.getOrAddExtractObject(o, eoOpts);
            }
        }
    }

    private BasicDBObject getDBObject(URL u) {
        BasicDBObject dbo = this._listModel.getDBObject(u);
        return dbo != null ? dbo : new BasicDBObject(u);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isConnDba(Connection conn) {
        String sql = "select 1 from DBA_OBJECTS where 1=2";
        Statement stmt = null;
        boolean isDba = false;
        try {
            if (conn != null) {
                stmt = conn.createStatement();
                stmt.execute(sql);
            }
            isDba = true;
        }
        catch (SQLException e) {
            if (e.getErrorCode() != 942) {
                LOGGER.severe(e.getMessage());
            }
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
        }
        return isDba;
    }

    public static boolean isExistsObject(Connection conn, BasicDBObject dbo) {
        return ExtractReconciler.isExistsObject(conn, ExtractReconciler.isConnDba(conn), dbo);
    }

    public static boolean isExistsObject(Connection conn, boolean isDba, BasicDBObject dbo) {
        Map dict = dbo.getDictionary();
        Object workspace = null;
        Object applicationName = null;
        String objectName = dbo.getObjectName();
        if (dict != null) {
            workspace = dict.get("WORKSPACE");
            applicationName = dict.get("APPLICATION_NAME");
            if (dbo.getObjectType().equals("APEX")) {
                objectName = applicationName;
            }
        }
        return ExtractReconciler.isExistsObject(conn, isDba, dbo.getSchemaName(), objectName, dbo.getObjectType(), workspace);
    }

    public static boolean isExistsObject(Connection conn, String owner, String name, String type) {
        return ExtractReconciler.isExistsObject(conn, ExtractReconciler.isConnDba(conn), owner, name, type, "");
    }

    public static boolean isExistsObject(Connection conn, boolean isDba, String owner, String name, String type) {
        return ExtractReconciler.isExistsObject(conn, isDba, owner, name, type, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean isExistsObject(Connection conn, boolean isDba, String owner, String name, String type, String workspace) {
        if (conn == null) {
            return false;
        }
        Object EXIST_OBJECT = "";
        EXIST_OBJECT = type.equals("QUEUE TABLE") ? "select 1 from all_queue_tables where owner = :OWNER  and queue_table = :NAME " : (type.equals("MATERIALIZED VIEW LOG") ? "select 1 from all_snapshot_logs where log_owner = :OWNER  and master = :NAME" : (type.equals("APEX") ? " select 1 from apex_applications where owner = :OWNER  and application_name = :NAME  and workspace = :WORKSPACE" : " select 1 from " + (isDba ? "dba_objects" : "all_objects") + " where owner = :OWNER  and object_type = :TYPE  and object_name = :NAME "));
        HashMap<String, String> binds = new HashMap<String, String>();
        ResultSet rset = null;
        binds.put("OWNER", owner);
        binds.put("NAME", name);
        binds.put("TYPE", type);
        binds.put("WORKSPACE", workspace);
        if (LockManager.lock((Connection)conn)) {
            block6: {
                boolean bl;
                try {
                    rset = DBUtil.getInstance((Connection)conn).executeQuery((String)EXIST_OBJECT, binds);
                    if (!rset.next()) break block6;
                    bl = true;
                }
                catch (Exception exception) {
                    DBUtil.closeResultSet(rset);
                    LockManager.unlock((Connection)conn);
                    catch (Throwable throwable) {
                        DBUtil.closeResultSet(rset);
                        LockManager.unlock((Connection)conn);
                        throw throwable;
                    }
                }
                DBUtil.closeResultSet((ResultSet)rset);
                LockManager.unlock((Connection)conn);
                return bl;
            }
            DBUtil.closeResultSet((ResultSet)rset);
            LockManager.unlock((Connection)conn);
        }
        return false;
    }

    public static boolean isExistsSchema(Connection conn, String schema) {
        return ExtractReconciler.isExistsSchema(conn, ExtractReconciler.isConnDba(conn), schema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean isExistsSchema(Connection conn, boolean isDba, String schema) {
        if (conn == null) {
            return false;
        }
        String EXIST_OBJECT = " select 1 from " + (isDba ? "dba_users" : "all_users") + " where username = :USER ";
        HashMap<String, String> binds = new HashMap<String, String>();
        ResultSet rset = null;
        binds.put("USER", schema);
        if (LockManager.lock((Connection)conn)) {
            block6: {
                boolean bl;
                try {
                    rset = DBUtil.getInstance((Connection)conn).executeQuery(EXIST_OBJECT, binds);
                    if (!rset.next()) break block6;
                    bl = true;
                }
                catch (Exception exception) {
                    DBUtil.closeResultSet(rset);
                    LockManager.unlock((Connection)conn);
                    catch (Throwable throwable) {
                        DBUtil.closeResultSet(rset);
                        LockManager.unlock((Connection)conn);
                        throw throwable;
                    }
                }
                DBUtil.closeResultSet((ResultSet)rset);
                LockManager.unlock((Connection)conn);
                return bl;
            }
            DBUtil.closeResultSet((ResultSet)rset);
            LockManager.unlock((Connection)conn);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private List<BasicDBObject> getObjectDeps(Connection conn, String owner, String name, String type) {
        String LIST_OBJECTS = "\tselect referenced_owner, referenced_name, referenced_type from ALL_DEPENDENCIES where owner = :OWNER and name = :NAME and type = decode(:TYPE,'QUEUE','UNDEFINED',:TYPE) and referenced_owner != 'SYS'  union  select b.owner, b.table_name,'TABLE' type from ALL_CONSTRAINTS a, all_constraints b  where a.owner = :OWNER  and a.table_name = :NAME  and a.constraint_type = 'R'  and a.r_constraint_name = b.constraint_name  and a.owner = b.owner  and :TYPE='TABLE'  union  select log_owner,master,'TABLE' from all_snapshot_logs where master = :NAME and :TYPE='MATERIALIZED VIEW LOG'  union  select table_owner owner,table_name name,  case (select count(*) from all_objects where object_name = table_name and owner = :OWNER \t) when 1 then 'TABLE'  when 2 then 'MATERIALIZED VIEW'  else 'UNKNOWN'  end as type  from all_indexes where index_name = :NAME and owner = :OWNER and :TYPE = 'INDEX' ";
        ArrayList<BasicDBObject> objects = new ArrayList<BasicDBObject>();
        HashMap<String, String> binds = new HashMap<String, String>();
        Object url = null;
        ResultSet rset = null;
        binds.put("OWNER", owner);
        binds.put("NAME", name);
        binds.put("TYPE", type);
        if (LockManager.lock((Connection)conn)) {
            try {
                rset = DBUtil.getInstance((Connection)conn).executeQuery(LIST_OBJECTS, binds);
                String dbName = ConnectionResolver.getConnectionName((Connection)conn);
                while (rset.next()) {
                    BasicDBObject dbo = BasicDBObject.builder().connName(dbName).schema(rset.getString(1)).objectType(rset.getString(3)).objectName(rset.getString(2)).build();
                    objects.add(dbo);
                }
            }
            catch (Exception exception) {
                DBUtil.closeResultSet(rset);
                LockManager.unlock((Connection)conn);
                catch (Throwable throwable) {
                    DBUtil.closeResultSet(rset);
                    LockManager.unlock((Connection)conn);
                    throw throwable;
                }
            }
            DBUtil.closeResultSet((ResultSet)rset);
            LockManager.unlock((Connection)conn);
        }
        return objects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<BasicDBObject> getTriggerFilter(Connection conn, String schema, String table) {
        String LIST_OBJECTS = "Select trigger_name from all_triggers where table_owner = :OWNER and table_name = :NAME";
        ArrayList<BasicDBObject> objects = new ArrayList<BasicDBObject>();
        HashMap<String, String> binds = new HashMap<String, String>();
        Object url = null;
        ResultSet rset = null;
        binds.put("OWNER", schema);
        binds.put("NAME", table);
        if (LockManager.lock((Connection)conn)) {
            rset = DBUtil.getInstance((Connection)conn).executeQuery(LIST_OBJECTS, binds);
            String dbName = ConnectionResolver.getConnectionName((Connection)conn);
            try {
                while (rset.next()) {
                    BasicDBObject dbo = BasicDBObject.builder().connName(dbName).schema(schema).objectType("TRIGGER").objectName(rset.getString(1)).build();
                    objects.add(dbo);
                }
            }
            catch (Exception exception) {
            }
            finally {
                DBUtil.closeResultSet((ResultSet)rset);
                LockManager.unlock((Connection)conn);
            }
        }
        return objects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<BasicDBObject> getIndexFilter(Connection conn, String schema, String table) {
        String LIST_OBJECTS = "Select index_name from all_indexes where table_owner = :OWNER and table_name = :NAME";
        ArrayList<BasicDBObject> objects = new ArrayList<BasicDBObject>();
        HashMap<String, String> binds = new HashMap<String, String>();
        Object url = null;
        ResultSet rset = null;
        binds.put("OWNER", schema);
        binds.put("NAME", table);
        if (LockManager.lock((Connection)conn)) {
            rset = DBUtil.getInstance((Connection)conn).executeQuery(LIST_OBJECTS, binds);
            String dbName = ConnectionResolver.getConnectionName((Connection)conn);
            try {
                while (rset.next()) {
                    BasicDBObject dbo = BasicDBObject.builder().connName(dbName).schema(schema).objectType("INDEX").objectName(rset.getString(1)).build();
                    objects.add(dbo);
                }
            }
            catch (Exception exception) {
            }
            finally {
                DBUtil.closeResultSet((ResultSet)rset);
                LockManager.unlock((Connection)conn);
            }
        }
        return objects;
    }

    private void addDependents(BasicDBObject x, int opt) {
        if (this._listModel.getDDLFormat() == null || !this._listModel.getDDLFormat().getDep()) {
            return;
        }
        if (!this._listModel.isSelectedData() && !this._listModel.isSelectedMetaData()) {
            return;
        }
        List<BasicDBObject> objs = this.getObjectDeps(this._listModel.getSourceConn(), x.getSchemaName(), x.getObjectName(), x.getObjectType());
        for (BasicDBObject o : objs) {
            this._listModel.getOrAddExtractObject(o, new int[]{100, opt});
        }
    }

    private boolean isExportViews(ArrayList<URL> dataObjects, String objectType) {
        if (ExtractDataFormat.isLoader(this._listModel.getDataFormat().getFormat())) {
            return false;
        }
        if (!ExtractDataFormat.isInsert(this._listModel.getDataFormat().getFormat())) {
            return true;
        }
        return this._listModel.isExistsForType(dataObjects, objectType);
    }

    private void taskProgress(IRaptorTaskProgressUpdater raptorTaskProgressUpdater) throws ExecutionException {
        this.taskProgress(null, raptorTaskProgressUpdater);
    }

    private void taskProgress(String msg, IRaptorTaskProgressUpdater raptorTaskProgressUpdater) throws ExecutionException {
        if (raptorTaskProgressUpdater != null) {
            raptorTaskProgressUpdater.checkCanProceed();
            if (msg != null) {
                raptorTaskProgressUpdater.getDescriptor().setMessage(msg);
            }
        }
    }

    public static enum ReconcileType {
        NONE(0),
        OBJECTS(1),
        TYPES_AND_OBJECTS(2);

        private int _type;

        private ReconcileType(int type) {
            this._type = type;
        }

        public int getType() {
            return this._type;
        }

        public boolean isNone() {
            return this == NONE;
        }

        public boolean isObjects() {
            return this == OBJECTS;
        }

        public boolean isTypesAndObjects() {
            return this == TYPES_AND_OBJECTS;
        }
    }
}

