/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.datatools;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.util.List;
import java.util.Vector;
import oracle.dbtools.common.config.IEnvironmentConfig;
import oracle.dbtools.common.config.IStorage;
import oracle.dbtools.datatools.DataToolsResources;
import oracle.dbtools.importer.readers.DataReaderRegistry;
import oracle.dbtools.raptor.format.CopyFormatter;
import oracle.dbtools.raptor.format.DataPumpFormatter;
import oracle.dbtools.raptor.format.FormatRegistry;
import oracle.dbtools.raptor.format.IFormatOptions;
import oracle.dbtools.raptor.format.IResultFormatter;

public abstract class BaseDataFormat {
    public static int EXPORT_PREFERENCES = 0;
    public static int EXPORT_WIZARD = 1;
    public static int CART = 3;
    public static int IMPORT_PREFERENCES = 4;
    public static int IMPORT_WIZARD = 5;
    public static int HADOOP_OLH_IMPORT_WIZARD = 6;
    public static int HADOOP_OSCH_IMPORT_WIZARD = 7;
    public static String DELIMITED = "Delimited".toLowerCase();
    public static String CSV = "CSV".toLowerCase();
    public static String TEXT = "TEXT".toLowerCase();
    public static String TXT = "txt";
    public static String FIXED = "fixed".toLowerCase();
    public static String LOADER = "LOADER".toLowerCase();
    public static String INSERT = "INSERT".toLowerCase();
    public static String JSON = "JSON".toLowerCase();
    public static String COPY = "COPY".toLowerCase();
    public static String DATAPUMP = "DATAPUMP".toLowerCase();
    public static String DELIMITER = ",";
    public static String ENCLOSURE_LEFT = "\"";
    public static String ENCLOSURE_RIGHT = "\"";
    public static String LINE_TERMINATOR = "ENV_DEFAULT";
    public static final String LDR_LINE_TERMINATOR = "TERM_OTHER";
    protected Vector<String> _delimiters;
    private Vector<String> _enclosuresLeft;
    private Vector<String> _enclosuresRight;
    protected Vector<String> _recordTerminators;
    protected int _usage = EXPORT_WIZARD;
    protected boolean _header = true;
    protected String _format;
    private boolean _schema = false;
    private boolean _showSchema = false;
    protected IResultFormatter _formatter;
    protected String _encoding;
    protected String _delimiter;
    protected boolean _enclosures = true;
    protected String _enclosureLeft;
    protected String _enclosureRight;
    protected boolean _enclosureRightDouble;
    protected String _recTerm = System.getProperty("line.separator");
    protected String _termChars;
    protected String _envChars;
    protected IFormatOptions _options;

    public BaseDataFormat(int usage) {
        this._usage = usage;
        this.initFormat();
    }

    public BaseDataFormat(int usage, String format) {
        this._usage = usage;
        this.setFormat(format);
        this.initFormat();
    }

    public int getUsage() {
        return this._usage;
    }

    public IFormatOptions getOptions() {
        return this._options;
    }

    public boolean allowsLobs() {
        return this._formatter != null && this._formatter.allowsLobs();
    }

    public boolean allowsVirtual() {
        return this._formatter != null && this._formatter.allowsVirtual();
    }

    public static boolean isDelimited(String format) {
        return format != null && (format.equals(DELIMITED) || format.equals("dsv".toLowerCase()));
    }

    public static boolean isCsv(String format) {
        return format != null && (format.equals(CSV) || format.equals("csv".toLowerCase()));
    }

    public static boolean isText(String format) {
        return format != null && (format.equals(TEXT) || format.equals("tsv".toLowerCase()) || format.equals(TXT));
    }

    public static boolean isFixed(String format) {
        return format != null && (format.equals(FIXED) || format.equals("txt".toLowerCase()));
    }

    public static boolean isInsert(String format) {
        return format != null && (format.equals(INSERT) || format.equals("sql".toLowerCase()));
    }

    public static boolean isLoader(String format) {
        return format != null && (format.equals(LOADER) || format.equals("ctl".toLowerCase()));
    }

    public String getFormat() {
        return this._format;
    }

    public static String[] getExportFormats() {
        List types = FormatRegistry.getTypes();
        String[] exportFormats = new String[types.size()];
        int i = 0;
        for (String t : types) {
            exportFormats[i++] = t;
        }
        return exportFormats;
    }

    public void setFormat(String value) {
        if (value != null) {
            this._format = value;
            if (this._usage < IMPORT_PREFERENCES) {
                try {
                    this._formatter = null;
                    this._formatter = FormatRegistry.getFormatter((String)this._format);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this._formatter == null) {
                    this._formatter = this._format.equals(DATAPUMP) ? new DataPumpFormatter() : new CopyFormatter();
                }
                this._options = this._formatter;
            } else {
                this._options = DataReaderRegistry.getReaderUsingFormat(this._format);
            }
        }
    }

    public boolean isHeaderOptionSupported() {
        return this._options.isHeaderOptionSupported();
    }

    public boolean isHeader() {
        if (this._options == null || !this._options.isHeaderOptionSupported()) {
            return false;
        }
        return this._header;
    }

    public void isHeader(boolean value) {
        if (this._options == null || !this._options.isHeaderOptionSupported()) {
            return;
        }
        this._header = value;
    }

    public boolean getShowSchema() {
        return this._showSchema;
    }

    public void setShowSchema(boolean value) {
        this._showSchema = value;
    }

    public boolean getSchema() {
        return this._schema;
    }

    public void setSchema(boolean value) {
        this._schema = value;
    }

    public String getEncoding() {
        return this._encoding;
    }

    public void setEncoding(String value) {
        this._encoding = value;
    }

    public Vector<String> getEnclosuresLeft() {
        this._enclosuresLeft = new Vector();
        this._enclosuresLeft.add("\"");
        this._enclosuresLeft.add("'");
        this._enclosuresLeft.add("(");
        this._enclosuresLeft.add("[");
        this._enclosuresLeft.add("<");
        this._enclosuresLeft.add(DataToolsResources.getString("NONE"));
        if (this._enclosuresLeft.contains(this.getEnclosureLeft())) {
            return this._enclosuresLeft;
        }
        this._enclosuresLeft.add(this.getEnclosureLeft());
        return this._enclosuresLeft;
    }

    public Vector<String> getEnclosuresRight() {
        this._enclosuresRight = new Vector();
        this._enclosuresRight.add("\"");
        this._enclosuresRight.add("'");
        this._enclosuresRight.add(")");
        this._enclosuresRight.add("]");
        this._enclosuresRight.add(">");
        this._enclosuresRight.add(DataToolsResources.getString("NONE"));
        if (this._enclosuresRight.contains(this.getEnclosureRight())) {
            return this._enclosuresRight;
        }
        this._enclosuresRight.add(this.getEnclosureRight());
        return this._enclosuresRight;
    }

    public Vector<String> getRecordTerminators() {
        this._recordTerminators = new Vector();
        this._recordTerminators.add(DataToolsResources.getString("PLATFORM_DEFAULT"));
        this._recordTerminators.add(DataToolsResources.getString("ENV_DEFAULT"));
        this._recordTerminators.add(DataToolsResources.getString("LF"));
        this._recordTerminators.add(DataToolsResources.getString("CRLF"));
        this._recordTerminators.add(DataToolsResources.getString("CR"));
        this._recordTerminators.add(DataToolsResources.getString(LDR_LINE_TERMINATOR));
        if (this._recordTerminators.contains(this._recTerm)) {
            return this._recordTerminators;
        }
        this._recordTerminators.add(this._recTerm);
        return this._recordTerminators;
    }

    public Vector<String> getDelimiters() {
        this._delimiters = new Vector();
        this._delimiters.add(",");
        this._delimiters.add("|");
        this._delimiters.add(";");
        this._delimiters.add(":");
        this._delimiters.add(DataToolsResources.getString("TAB"));
        this._delimiters.add(DataToolsResources.getString("WHITESPACE"));
        this._delimiters.add(DataToolsResources.getString("SPACE"));
        if (this._delimiters.contains(this.getDelimiter())) {
            return this._delimiters;
        }
        this._delimiters.add(this.getDelimiter());
        return this._delimiters;
    }

    public String getDelimiter() {
        if (this._options == null || !this._options.isDelimiterSupported()) {
            return "";
        }
        return this._delimiter;
    }

    public String getTranslatedDelimiter() {
        if (this._delimiter != null && this._delimiter.length() > 0) {
            if (this._delimiter == "\t") {
                return DataToolsResources.getString("TAB");
            }
            if (this._delimiter.equals("  ")) {
                return DataToolsResources.getString("WHITESPACE");
            }
            if (this._delimiter.equals(" ")) {
                return DataToolsResources.getString("SPACE");
            }
        }
        return this._delimiter;
    }

    public String getDelimiterValue() {
        String delimChars = this.getDelimiter();
        if (delimChars != null && delimChars.length() > 0) {
            delimChars = delimChars.equals(DataToolsResources.getString("TAB")) ? "\t" : (delimChars.equals(DataToolsResources.getString("WHITESPACE")) ? "  " : (delimChars.equals(DataToolsResources.getString("SPACE")) ? " " : BaseDataFormat.convertHex(delimChars, this.getEncoding())));
        }
        return delimChars;
    }

    public static String getDelimiterString(String delim) {
        String delimChars = delim;
        if (delimChars.equals(DataToolsResources.getString("TAB"))) {
            delimChars = "X'09'";
        } else if (delimChars.equals(DataToolsResources.getString("WHITESPACE"))) {
            delimChars = "WHITESPACE";
        } else if (delimChars.equals(DataToolsResources.getString("SPACE"))) {
            delimChars = " ";
        }
        if (delimChars.equals("\t")) {
            return "\\t";
        }
        return delimChars;
    }

    public static boolean isDelimiterWhiteSpace(String delimiter) {
        return delimiter.length() > 1 && delimiter.equals("  ");
    }

    public void setDelimiter(String value) {
        if (this._options == null || !this._options.isDelimiterSupported()) {
            return;
        }
        this._delimiter = value;
    }

    public boolean getEnclosures() {
        if (this._options == null || !this._options.isEnclosuresSupported()) {
            return false;
        }
        return this.getEnclosureLeftValue().length() != 0 && this.getEnclosureRightValue().length() != 0;
    }

    public String getEnclosureLeft() {
        if (this._options == null || !this._options.isEnclosuresSupported()) {
            return "";
        }
        return this._enclosureLeft;
    }

    public String getEnclosureLeftValue() {
        String encl = this.getEnclosureLeft();
        if (encl == null || encl.equals(DataToolsResources.getString("NONE"))) {
            return "";
        }
        return BaseDataFormat.convertHex(this.getEnclosureLeft(), this.getEncoding());
    }

    public void setEnclosureLeft(String value) {
        if (this._options == null || !this._options.isEnclosuresSupported()) {
            return;
        }
        this._enclosureLeft = value;
    }

    public String getEnclosureRight() {
        if (this._options == null || !this._options.isEnclosuresSupported()) {
            return "";
        }
        return this._enclosureRight;
    }

    public String getEnclosureRightFromLeft(String value) {
        for (int i = 0; i < this._enclosuresLeft.size(); ++i) {
            String left = this._enclosuresLeft.elementAt(i);
            if (!left.equals(value)) continue;
            return this._enclosuresRight.elementAt(i);
        }
        return null;
    }

    public String getEnclosureRightValue() {
        String encl = this.getEnclosureRight();
        if (encl != null && encl.equals(DataToolsResources.getString("NONE"))) {
            return this.getEnclosureLeftValue();
        }
        return encl != null && encl.length() > 0 ? BaseDataFormat.convertHex(encl, this.getEncoding()) : this.getEnclosureLeftValue();
    }

    public void setEnclosureRight(String value) {
        if (this._options == null || !this._options.isEnclosuresSupported()) {
            return;
        }
        this._enclosureRight = value;
    }

    public boolean isEnclosureRightDouble() {
        if (this._options == null || !this._options.isEnclosuresSupported()) {
            return false;
        }
        return this._enclosureRightDouble;
    }

    public void isEnclosureRightDouble(boolean value) {
        if (this._options == null || !this._options.isEnclosuresSupported()) {
            return;
        }
        this._enclosureRightDouble = value;
    }

    public void setRecordTerminator(String value) {
        if (this._options == null || !this._options.isLineTerminatorSupported()) {
            return;
        }
        this._recTerm = value;
    }

    public String getRecordTerminator() {
        if (this._options == null || !this._options.isLineTerminatorSupported()) {
            return "";
        }
        return this._recTerm;
    }

    public static String getRecordTerminatorString(String term) {
        String termChars = BaseDataFormat.isRecordTerminatorPlatform(term) ? System.getProperty("line.separator") : (BaseDataFormat.isRecordTerminatorEnvironment(term) ? BaseDataFormat.getEnvTerminatorValue() : (BaseDataFormat.isRecordTerminatorStandard(term) ? System.getProperty("line.separator") : (BaseDataFormat.isRecordTerminatorCRLF(term) ? "\r\n" : (BaseDataFormat.isRecordTerminatorLF(term) ? "\n" : (BaseDataFormat.isRecordTerminatorCR(term) ? "\r" : term)))));
        if (termChars.equals("\r")) {
            return "\\r";
        }
        if (termChars.equals("\r\n")) {
            return "\\r\\n";
        }
        if (termChars.equals("\n")) {
            return "\\n";
        }
        return termChars;
    }

    public String getRecordTerminatorValue() {
        return this.getRecordTerminatorValue(this.getRecordTerminator());
    }

    public String getRecordTerminatorValue(String term) {
        String termChars = BaseDataFormat.isRecordTerminatorPlatform(term) ? System.getProperty("line.separator") : (BaseDataFormat.isRecordTerminatorEnvironment(term) ? BaseDataFormat.getEnvTerminatorValue() : (BaseDataFormat.isRecordTerminatorStandard(term) ? "\r\n" : (BaseDataFormat.isRecordTerminatorCRLF(term) ? "\r\n" : (BaseDataFormat.isRecordTerminatorLF(term) ? "\n" : (BaseDataFormat.isRecordTerminatorCR(term) ? "\r" : term)))));
        return BaseDataFormat.convertHex(termChars, this.getEncoding());
    }

    private static String convertHex(String hexString, String encoding) {
        Object hexValue = "";
        if (hexString != null && hexString.length() > 3 && (hexString.substring(0, 2).equals("X'") || hexString.substring(0, 2).equals("x'"))) {
            try {
                int hexSize = (hexString.length() - 3) / 2;
                byte[] bytes = new byte[hexSize];
                int i = 2;
                int j = 0;
                while (i < hexString.length() - 1) {
                    Object temp = "";
                    temp = (String)temp + hexString.charAt(i);
                    temp = (String)temp + hexString.charAt(i + 1);
                    BigInteger x = new BigInteger((String)temp, 16);
                    int val = x.intValue();
                    hexValue = (String)hexValue + new Character((char)val).toString();
                    bytes[j] = x.byteValue();
                    i += 2;
                    ++j;
                }
                ByteArrayInputStream baInputStream = new ByteArrayInputStream(bytes);
                InputStreamReader charReader = new InputStreamReader((InputStream)baInputStream, encoding != null ? encoding : "UTF8");
                char[] chars = new char[hexSize];
                int converted = charReader.read(chars, 0, hexSize);
                return converted != -1 ? new String(chars) : hexValue;
            }
            catch (Exception e) {
                if (hexValue == "") {
                    return hexString;
                }
            }
        } else {
            return hexString;
        }
        return hexValue;
    }

    private static boolean isHexFormat(String str) {
        return str.length() > 3 && (str.substring(0, 2).equals("X'") || str.substring(0, 2).equals("x'"));
    }

    public static String getEnvTerminatorValue() {
        return IEnvironmentConfig.Storage.getInstance().getString("ENV_LINE_TERMINATOR");
    }

    public static boolean isRecordTerminatorStandard(String term) {
        if (term == null) {
            return false;
        }
        return term.equals(DataToolsResources.getString("STANDARD"));
    }

    public static boolean isRecordTerminatorPlatform(String term) {
        if (term == null) {
            return false;
        }
        return term.equals(DataToolsResources.getString("PLATFORM_DEFAULT"));
    }

    public static boolean isRecordTerminatorEnvironment(String term) {
        if (term == null) {
            return false;
        }
        return term.equals(DataToolsResources.getString("ENV_DEFAULT"));
    }

    public static boolean isRecordTerminatorOther(String term) {
        if (term == null) {
            return false;
        }
        return term.equals(DataToolsResources.getString(LDR_LINE_TERMINATOR));
    }

    public static boolean isRecordTerminatorImportDefault(String term) {
        if (term == null) {
            return false;
        }
        return term.equals(DataToolsResources.getString("FILE_FORMAT_DEFAULT"));
    }

    public static boolean isRecordTerminatorImportFile(String term) {
        if (term == null) {
            return false;
        }
        return term.equals(DataToolsResources.getString("IMPORT_FILE"));
    }

    public static boolean isRecordTerminatorLF(String term) {
        if (term == null) {
            return false;
        }
        if (term.equals(DataToolsResources.getString("LF"))) {
            return true;
        }
        return term.equals("\\n");
    }

    public static boolean isRecordTerminatorCRLF(String term) {
        if (term == null) {
            return false;
        }
        if (term.equals(DataToolsResources.getString("CRLF"))) {
            return true;
        }
        return term.equals("\\r\\n");
    }

    public static boolean isRecordTerminatorCR(String term) {
        if (term == null) {
            return false;
        }
        if (term.equals(DataToolsResources.getString("CR"))) {
            return true;
        }
        return term.equals("\\r");
    }

    public static String getDelimiterForConfigValue(String delimiter) {
        if (delimiter == null) {
            return ",";
        }
        if (delimiter.equals(DataToolsResources.getString("TAB"))) {
            return "TAB";
        }
        if (delimiter.equals(DataToolsResources.getString("SPACE"))) {
            return "SPACE";
        }
        if (delimiter.equals(DataToolsResources.getString("WHITESPACE"))) {
            return "WHITESPACE";
        }
        return delimiter;
    }

    public static String getDelimiterFromConfigValue(String delimiter) {
        if (delimiter == null) {
            return DataToolsResources.getString(",");
        }
        if (delimiter.equals("TAB")) {
            return DataToolsResources.getString("TAB");
        }
        if (delimiter.equals("SPACE")) {
            return DataToolsResources.getString("SPACE");
        }
        if (delimiter.equals("WHITESPACE")) {
            return DataToolsResources.getString("WHITESPACE");
        }
        return delimiter;
    }

    public static String getEnclosureForConfigValue(String enclosure) {
        if (enclosure == null) {
            return "NONE";
        }
        if (enclosure.equals(DataToolsResources.getString("NONE"))) {
            return "NONE";
        }
        return enclosure;
    }

    public static String getEnclosureFromConfigValue(String enclosure) {
        if (enclosure == null) {
            return DataToolsResources.getString("NONE");
        }
        if (enclosure.equals("NONE")) {
            return DataToolsResources.getString("NONE");
        }
        return enclosure;
    }

    public static String getRecordTerminatorForConfigValue(String term) {
        if (term == null) {
            return "PLATFORM_DEFAULT";
        }
        if (BaseDataFormat.isRecordTerminatorPlatform(term)) {
            return "PLATFORM_DEFAULT";
        }
        if (BaseDataFormat.isRecordTerminatorEnvironment(term)) {
            return "ENV_DEFAULT";
        }
        if (BaseDataFormat.isRecordTerminatorStandard(term)) {
            return "STANDARD";
        }
        if (BaseDataFormat.isRecordTerminatorEnvironment(term)) {
            return "FILE_FORMAT_DEFAULT";
        }
        if (BaseDataFormat.isRecordTerminatorEnvironment(term)) {
            return "IMPORT_FILE";
        }
        if (BaseDataFormat.isRecordTerminatorLF(term)) {
            return "LF";
        }
        if (BaseDataFormat.isRecordTerminatorCRLF(term)) {
            return "CRLF";
        }
        if (BaseDataFormat.isRecordTerminatorCR(term)) {
            return "CR";
        }
        if (BaseDataFormat.isRecordTerminatorOther(term)) {
            return LDR_LINE_TERMINATOR;
        }
        return term;
    }

    public static String getRecordTerminatorFromConfigValue(String term) {
        if (term == null) {
            return DataToolsResources.getString("PLATFORM_DEFAULT");
        }
        if (term.equals("PLATFORM_DEFAULT")) {
            return DataToolsResources.getString("PLATFORM_DEFAULT");
        }
        if (term.equals("ENV_DEFAULT")) {
            return DataToolsResources.getString("ENV_DEFAULT");
        }
        if (term.equals("STANDARD")) {
            return DataToolsResources.getString("STANDARD");
        }
        if (term.equals("FILE_FORMAT_DEFAULT")) {
            return DataToolsResources.getString("FILE_FORMAT_DEFAULT");
        }
        if (term.equals("IMPORT_FILE")) {
            return DataToolsResources.getString("IMPORT_FILE");
        }
        if (term.equals("LF")) {
            return DataToolsResources.getString("LF");
        }
        if (term.equals("CRLF")) {
            return DataToolsResources.getString("CRLF");
        }
        if (term.equals("CR")) {
            return DataToolsResources.getString("CR");
        }
        if (term.equals(LDR_LINE_TERMINATOR)) {
            return DataToolsResources.getString(LDR_LINE_TERMINATOR);
        }
        return term;
    }

    public static String singleQuote(String str) {
        return BaseDataFormat.isHexFormat(str) ? str : "'" + str + "'";
    }

    protected void initConfigOptions(IStorage config) {
        Boolean x;
        if (this._options.isHeaderOptionSupported()) {
            x = config.getBoolean(this._options.getHeaderConfigKey());
            this.isHeader(x != null ? x : true);
        }
        if (this._options.isDelimiterSupported()) {
            this._delimiter = this._options.isDelimiterConfigurable() ? BaseDataFormat.getDelimiterFromConfigValue(config.getString(this._options.getDelimiterConfigKey())) : this._options.getDefaultDelimiter();
        }
        if (this._options.isEnclosuresSupported()) {
            x = config.getBoolean(this._options.getEnclosuresConfigKey());
            this._enclosures = x != null ? x : false;
            this._enclosureLeft = BaseDataFormat.getEnclosureFromConfigValue(config.getString(this._options.getEnclosureLeftConfigKey()));
            this._enclosureRight = BaseDataFormat.getEnclosureFromConfigValue(config.getString(this._options.getEnclosureRightConfigKey()));
            x = config.getBoolean(this._options.getEnclosureRightDoubleConfigKey());
            this.isEnclosureRightDouble(x != null ? x : true);
        }
        if (this._options.isLineTerminatorSupported()) {
            this._recTerm = BaseDataFormat.getRecordTerminatorFromConfigValue(config.getString(this._options.getLineTerminatorConfigKey()));
            if (this._usage == IMPORT_WIZARD || this._usage == IMPORT_PREFERENCES) {
                if (this._recTerm == null || this._recTerm.length() == 0 || this._recTerm == DataToolsResources.getString("ENV_DEFAULT") || this._recTerm == DataToolsResources.getString("PLATFORM_DEFAULT")) {
                    this._recTerm = DataToolsResources.getString("STANDARD");
                }
            } else if (this._recTerm == null || this._recTerm.length() == 0) {
                this._recTerm = DataToolsResources.getString("ENV_DEFAULT");
            }
        }
    }

    public void saveFormatPreferences(IStorage config) {
        if (this._options.isHeaderOptionSupported()) {
            config.putBoolean(this._options.getHeaderConfigKey(), this._header);
        }
        if (this._options.isDelimiterSupported() && this._options.isDelimiterConfigurable()) {
            config.putString(this._options.getDelimiterConfigKey(), BaseDataFormat.getDelimiterForConfigValue(this._delimiter));
        }
        if (this._options.isEnclosuresSupported()) {
            config.putBoolean(this._options.getEnclosuresConfigKey(), this._enclosures);
            config.putString(this._options.getEnclosureLeftConfigKey(), BaseDataFormat.getEnclosureForConfigValue(this._enclosureLeft));
            config.putString(this._options.getEnclosureRightConfigKey(), BaseDataFormat.getEnclosureForConfigValue(this._enclosureRight));
            config.putBoolean(this._options.getEnclosureRightDoubleConfigKey(), this._enclosureRightDouble);
        }
        if (this._options.isLineTerminatorSupported()) {
            config.putString(this._options.getLineTerminatorConfigKey(), BaseDataFormat.getRecordTerminatorForConfigValue(this._recTerm));
        }
    }

    protected abstract void initFormat();
}

