/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.ddl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.common.ddl.IObjectDDL;
import oracle.dbtools.common.ddl.oracle.OracleConstraintDDL;
import oracle.dbtools.common.ddl.oracle.OracleDbLinkDDL;
import oracle.dbtools.common.ddl.oracle.OracleFunctionDDL;
import oracle.dbtools.common.ddl.oracle.OracleIndexDDL;
import oracle.dbtools.common.ddl.oracle.OracleMatViewDDL;
import oracle.dbtools.common.ddl.oracle.OracleOperatorDDL;
import oracle.dbtools.common.ddl.oracle.OraclePackageBodyDDL;
import oracle.dbtools.common.ddl.oracle.OraclePackageDDL;
import oracle.dbtools.common.ddl.oracle.OracleProcedureDDL;
import oracle.dbtools.common.ddl.oracle.OracleQueueDDL;
import oracle.dbtools.common.ddl.oracle.OracleQueueTableDDL;
import oracle.dbtools.common.ddl.oracle.OracleRefConstraintDDL;
import oracle.dbtools.common.ddl.oracle.OracleSequenceDDL;
import oracle.dbtools.common.ddl.oracle.OracleSynonymnDDL;
import oracle.dbtools.common.ddl.oracle.OracleTableDDL;
import oracle.dbtools.common.ddl.oracle.OracleTriggerDDL;
import oracle.dbtools.common.ddl.oracle.OracleTypeDDL;
import oracle.dbtools.common.ddl.oracle.OracleViewDDL;
import oracle.dbtools.common.utils.BasicDBObject;
import oracle.dbtools.util.Logger;

public class DDLRegistry {
    private static Map<String, Class<? extends IObjectDDL>> _registry = new HashMap<String, Class<? extends IObjectDDL>>();

    public static synchronized ArrayList<String> getTypes() {
        ArrayList<String> types = new ArrayList<String>();
        for (String key : _registry.keySet()) {
            String[] type = key.split("#");
            types.add(type[1]);
        }
        return types;
    }

    public static synchronized void registerHandler(String connType, String objType, Class<? extends IObjectDDL> clazz) {
        if (!IObjectDDL.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Class must be instance of IDdlGenerator");
        }
        _registry.put(BasicDBObject.getKey((String)connType, (String)objType), clazz);
    }

    public static synchronized void unregisterHandler(String key) {
        _registry.remove(key);
    }

    public static synchronized IObjectDDL getInstanceFor(String key) {
        if (_registry.get(key) != null) {
            try {
                return _registry.get(key).newInstance();
            }
            catch (Exception e) {
                Logger.warn(DDLRegistry.class, (Throwable)e);
                return null;
            }
        }
        return null;
    }

    public static synchronized boolean isSupported(String key) {
        if (_registry.get(key) != null) {
            return true;
        }
        String tempKey = key.replace(" ", "_");
        return _registry.get(tempKey) != null;
    }

    static {
        DDLRegistry.registerHandler("Oracle", "TABLE", OracleTableDDL.class);
        DDLRegistry.registerHandler("Oracle", "CONSTRAINT", OracleConstraintDDL.class);
        DDLRegistry.registerHandler("Oracle", "REFCONSTRAINT", OracleRefConstraintDDL.class);
        DDLRegistry.registerHandler("Oracle", "INDEX", OracleIndexDDL.class);
        DDLRegistry.registerHandler("Oracle", "TRIGGER", OracleTriggerDDL.class);
        DDLRegistry.registerHandler("Oracle", "MATERIALIZED_VIEW", OracleMatViewDDL.class);
        DDLRegistry.registerHandler("Oracle", "VIEW", OracleViewDDL.class);
        DDLRegistry.registerHandler("Oracle", "FUNCTION", OracleFunctionDDL.class);
        DDLRegistry.registerHandler("Oracle", "OPERATOR", OracleOperatorDDL.class);
        DDLRegistry.registerHandler("Oracle", "PACKAGE", OraclePackageDDL.class);
        DDLRegistry.registerHandler("Oracle", "PACKAGE_BODY", OraclePackageBodyDDL.class);
        DDLRegistry.registerHandler("Oracle", "PACKAGE BODY", OraclePackageBodyDDL.class);
        DDLRegistry.registerHandler("Oracle", "PROCEDURE", OracleProcedureDDL.class);
        DDLRegistry.registerHandler("Oracle", "DATABASE_LINK", OracleDbLinkDDL.class);
        DDLRegistry.registerHandler("Oracle", "SEQUENCE", OracleSequenceDDL.class);
        DDLRegistry.registerHandler("Oracle", "TYPE", OracleTypeDDL.class);
        DDLRegistry.registerHandler("Oracle", "SYNONYM", OracleSynonymnDDL.class);
        DDLRegistry.registerHandler("Oracle", "QUEUE_TABLE", OracleQueueTableDDL.class);
        DDLRegistry.registerHandler("Oracle", "QUEUE", OracleQueueDDL.class);
    }
}

